Ext.define('B3p.planmonitor.Viewer', {

    viewerController: null,
    legend: null,
    layers: null,
    config: {
        kaartlagen: '',
        mapserverUrl: '',
        bouwplanByCoordAjaxurl:null,
        host: '',
        querylagen: '',
        sldkey_eenvoudig: '',
        httpRequestParams: '',
        mapDiv:null
    },

    constructor: function(config) {
        this.initConfig(config);
        this.layers = new Array();
        var viewerType = "openlayers";
        var queryParams = Ext.urlDecode(window.location.search.substring(1));
        var flamingo = queryParams.flamingo;
        if(flamingo) {
            viewerType = "flamingo";
        }
        this.config.mapDiv = this.config.mapDiv ? this.config.mapDiv : "map";
        this.viewerController = new viewer.viewercontroller.ViewerController(viewerType, this.config.mapDiv, viewer_config, {});
        // add viewerController to global scope, required by some code, preferably this should be changed
        window.viewerController = this.viewerController;
        this.legend = Ext.create('RWBPLegend', {
            viewerController: this.viewerController,
            mapDiv: this.config.mapDiv
        });
    },

    getViewerController: function() {
        return this.viewerController;
    },

    getLegend: function() {
        return this.legend;
    },

    getUrlAnchor: function(){
        var loc = window.location;
        var anchor = loc.hash;
        if (anchor === ""){
            return null;
        }
        anchor= anchor.substr(1);
        return anchor;
    },

    naarBbox: function(bbox){
        if(!bbox) {
            return;
        }
        this.viewerController.mapComponent.getMap().zoomToExtent(
                Ext.create("viewer.viewercontroller.controller.Extent",Ext.isDefined(bbox.minx) ? bbox.minx : bbox,bbox.miny,bbox.maxx,bbox.maxy));
    },

    select_bouwplannen :function(geom){
        document.getElementById("geom").value=geom;
        document.getElementById("searchForm").submit();
        return;
    },

    getParameter: function(url,param,paramAddition,endChar){
        var beginIndex=0;
        var endIndex=url.length;
        beginIndex=url.indexOf(param+paramAddition)+param.length+paramAddition.length;
        if (beginIndex < 0)
            beginIndex=0;
        endIndex=url.indexOf(endChar,beginIndex);
        if (endIndex < 0)
            endIndex=url.length;
        return url.substring(beginIndex,endIndex);
    },

    voegLayersToe: function(querylayers, layers, httpParams, geavanceerd){
        var lyrs = this.getSeparatedLayers(layers);
        var qlyrs = this.getSeparatedLayers(querylayers);
        for (var key in lyrs) if(lyrs.hasOwnProperty(key)) {
            var layer = lyrs[key];
            var queryLayer = qlyrs[key];
            var url = this.config.mapserverUrl;
            url += (url.indexOf("?") === -1 ? "?" : "&");
            url += httpParams + "&";

            this.voegLayerToe(url,layer,queryLayer, key);
        }
    },

    voegLayerToe: function(url,layers,querylayers, id,visible){
        var layerUrl = url;
        var naam = "Plannen";
        var titel = "Plannen " + layers.substring(layers.indexOf("_")+1);
        if(id){
            naam += " " + id;
        }
        if(!Ext.isDefined(visible)){
            visible = true;
        }
        var options={
            ratio: 1,
            title: titel,
            name: naam,
            id: naam,
            visible: visible
        };
        var ogcOptions={
            exceptions: "application/vnd.ogc.se_inimage",
            srs: "EPSG:28992",
            version: "1.1.1",
            layers:layers,
            styles: "",
            format: "image/png",
            transparent: true,
            noCache: true,
            query_layers: querylayers
        };
        var layer = this.viewerController.mapComponent.createWMSLayer(naam,layerUrl , ogcOptions, options,this);
        this.layers.push({
            layer: layer,
            key:id
        });
        this.viewerController.mapComponent.getMap().addLayer(layer);
        this.legend.addLayer(layer, "Plannen");
    },

    addSLD : function (sldKey){
        var sldstring = this.config.host;
        sldstring += "/SldFilter.action?";
        // bouw de sld string op
        sldstring += "sldkey=" + sldKey;
        for ( var i = 0 ; i< this.layers.length;i++){
            var layerObj = this.layers[i];

            var sldUrl = sldstring + "&mode=" + layerObj.key;
            var layer = layerObj.layer;
            layer.setOGCParams({"SLD": sldUrl});
            layer.reload();
        }
    },

    voegGrenzenToe: function(layerUrl){
        var naam = "Grenzen";
        var options={
            ratio: 1,
            id: -2,
            visible: true
        };
        var ogcOptions={
            exceptions: "application/vnd.ogc.se_inimage",
            srs: "EPSG:28992",
            version: "1.1.1",
            //layers:layers,
            styles: "",
            format: "image/png",
            transparent: true,
            noCache: true
        };
       // options.id="provincie_grenzen";
        options.appLayerId=options.id;
        options.name="Provincie grenzen";
        options.title="Provincie grenzen";
        ogcOptions.layers="provincie_grenzen";
        var provLayer = this.viewerController.mapComponent.createWMSLayer(-3,layerUrl , ogcOptions, options,this);
        this.viewerController.mapComponent.getMap().addLayer(provLayer);
        this.legend.addLayer(provLayer, "Grenzen");

      //  options.id="gemeente_grenzen";
        options.id = -3;
        options.appLayerId= options.id;
        options.name="Gemeente grenzen";
        options.title="Gemeente grenzen";
        ogcOptions.layers="gemeente_grenzen";
        var gemLayer = this.viewerController.mapComponent.createWMSLayer(-2,layerUrl , ogcOptions, options,this);
        this.viewerController.mapComponent.getMap().addLayer(gemLayer);
        this.legend.addLayer(gemLayer, "Grenzen");

    },
    initViewer: function(){
        var me = this;
        if(!this.viewerController.layersInitialized) {
            this.viewerController.addListener(viewer.viewercontroller.controller.Event.ON_LAYERS_INITIALIZED, me.initViewer, me);
        }
        this.voegGrenzenToe(this.config.mapserverUrl);
        loadBackgroundLayers(this.getViewerController(), this.getLegend());
        this.voegLayersToe(this.config.querylagen, this.config.kaartlagen, this.config.httpRequestParams, false);
        this.getViewerController().mapComponent.getMap().addListener(viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO, this.handleIdentifyClick, me);
    },
     getSeparatedLayers: function(layers){
        var layersArray = layers.split(",");
        return layersArray;
    },

    handleIdentifyClick: function(map, options){
        var x= options.coord.x;
        var y= options.coord.y;
        var me = this;
        $.ajax({
            type: "POST",
            url: this.config.bouwplanByCoordAjaxurl,
            data: "x="+x+"&y="+y,
            success: me.handleBouwplanByCoord
        });
    },
    handleBouwplanByCoord: function(ids){
        if (ids.length > 1) {
            alert("Er is meer dan 1 bouwplan gevonden, de eerste wordt geopend");
        }
        if (ids.length) {
            var bouwplanid = ids[0];
            window.open("Edit.action?edit=true&bouwplan="+bouwplanid, "_self");
        }
    }
});

Ext.define("RWBPLegend",{
    tabs: null,
    viewerController: null,
    config:{
        mapDiv:null,
        viewerController:null
    },
    constructor : function(config) {
//        this.viewerController = config.viewerController;
        this.initConfig(config);
        this.tabs  = ["legenda","onderwerpen"];
        this.init();
    },
    init : function (){
        //viewerController.mapComponent.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED,this.layerAdded,this);
        this.createHeader();
        this.createLegend();
        this.createOnderwerp();
    },
    createHeader : function (){
        var div = document.createElement('div');
        div.setAttribute("id", "legendheader");
        div.setAttribute('class','legendheader');


        var legendpic = document.createElement("img");
        legendpic.setAttribute("id","legendapic");
        legendpic.setAttribute("src","resources/images/legenda/legenda.png");

        var onderwerppic = document.createElement("img");
        onderwerppic.setAttribute("id","onderwerpenpic");
        onderwerppic.setAttribute("src","resources/images/legenda/onderwerpen.png");

        div.appendChild(legendpic);
        div.appendChild(onderwerppic);

        var map = document.getElementById (this.config.mapDiv);
        map.appendChild(div);
        var me = this;
        $("#legendapic").click(function (){
            me.toggleTab('legenda');
        }).mouseover(function(){
            var over = "resources/images/legenda/legenda_over.png";
            this.setAttribute("prev",this.getAttribute("src"));
            this.setAttribute("src",over);
        }).mouseout(function(){
            var over = "resources/images/legenda/legenda_over.png";
            if(this.getAttribute("src") == over){
                var prev = this.getAttribute("prev");
                this.setAttribute("src",prev);
            }
        });
        $("#onderwerpenpic").click(function (){
            me.toggleTab('onderwerpen');
        }).mouseover(function(){
            var over = "resources/images/legenda/onderwerpen_over.png";
            this.setAttribute("prev",this.getAttribute("src"));
            this.setAttribute("src",over);
        }).mouseout(function(){
            var over = "resources/images/legenda/onderwerpen_over.png";
            if(this.getAttribute("src") == over){
                var prev = this.getAttribute("prev");
                this.setAttribute("src",prev);
            }
        });
    },
    createLegend : function (){
        var legend = document.createElement('div');
        legend.setAttribute("id", "legenda");
        legend.innerHTML = "<img src='resources/images/legenda/bouwplanaanduiding.png'/>";
        legend.innerHTML += "<img src='resources/images/legenda/plannen_legenda.png'/>";
        legend.setAttribute('class','legendbody');
        var map = document.getElementById (this.config.mapDiv);
        map.appendChild(legend);
    },
    createOnderwerp : function (){
        var layers = document.createElement('div');
        layers.setAttribute("id","onderwerpen");
        layers.setAttribute('class','legendbody');
        var map = document.getElementById (this.config.mapDiv);
        map.appendChild(layers);
        var lyrs = this.config.viewerController.mapComponent.getMap().getLayers();
        for (var i = 0 ; i < lyrs.length ; i++){
            this.addLayer(lyrs[i],"Achtergronden");
        }
    },

    addLayer : function (layer, type){
        var typeDiv = document.getElementById(type);
        if(!typeDiv){
            typeDiv = document.createElement('div');
            typeDiv.setAttribute("id",type);
            typeDiv.innerHTML = "<b>"+type + "</b>";
            var layers = document.getElementById("onderwerpen");
            layers.appendChild(typeDiv);

        }
        var l = document.createElement('div');
        l.setAttribute("class","legendcheckboxes");
        var checkbox = document.createElement('input');
        checkbox.setAttribute("type","checkbox");
        if(layer.visible){
            checkbox.setAttribute("checked",true);
        }
        l.appendChild(checkbox);
        l.appendChild(document.createTextNode(layer.title));
        var me = this;
        $(checkbox).click(function(){
            me.toggleLayer(this,layer.id);
        });

        typeDiv.appendChild(l);
    },
    toggleTab : function (id){

        var tab = document.getElementById (id);
        // Switch off other tab
        var other = this.tabs[1];
        if(id != this.tabs[0]){
            other = this.tabs[0];
        }

        if( tab.style.visibility != "visible"){
            this.enableTab(id);
            this.disableTab(other);
        }else{
            this.disableTab(id);
        }
    },

    enableTab : function (id){
        var vis = 'visible';
        var tab = document.getElementById (id);
        tab.style.visibility = vis;
        var pic = id + "pic";
        var url = "resources/images/legenda/" + id + "_down.png";
        var picEl = document.getElementById(pic);
        picEl.setAttribute("src",url);
    },
    disableTab : function (id){
        var vis = 'hidden';
        var tab = document.getElementById (id);
        var pic = id + "pic";
        var url = "resources/images/legenda/" + id + ".png";
        var picEl = document.getElementById(pic);
        picEl.setAttribute("src",url);
        tab.style.visibility = vis;
    },

    toggleLayer : function (input,appLayerId){
        var visible = input.checked;
        var layer = this.config.viewerController.mapComponent.getMap().getLayer(appLayerId);
        layer.setVisible(visible);
    },

    layerAdded : function (map,options){
        var layer = options.layer;
        if(! (layer instanceof viewer.viewercontroller.controller.VectorLayer)){
            this.addLayer(layer,"Plannen");
        }
    },
    closeTabs: function(){
        for(var i = 0 ; i < this.tabs.length ; i++){
            this.disableTab(this.tabs[i]);
        }
    }
});
