/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase.stripes;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.commons.csv.CsvFormatException;
import nl.b3p.playbase.ImportReport;
import nl.b3p.playbase.PlayadvisorImporter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@StrictBinding
@UrlBinding(value="/action/importPlayadvisor")
public class ImportPlayadvisorActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog((String)"ImportPlayadvisorActionBean");
    private ActionBeanContext context;
    private static final String JSP = "/WEB-INF/jsp/admin/import/playadvisor.jsp";
    private PlayadvisorImporter processor;
    @Validate
    private FileBean csv;
    @Validate
    private FileBean comments;
    @Validate
    private String file;
    @Validate
    private String project;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public FileBean getCsv() {
        return this.csv;
    }

    public void setCsv(FileBean csv) {
        this.csv = csv;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public FileBean getComments() {
        return this.comments;
    }

    public void setComments(FileBean comments) {
        this.comments = comments;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution(JSP);
    }

    public Resolution importLocations() {
        try {
            ImportReport report = new ImportReport();
            this.processor = new PlayadvisorImporter(this.project);
            if (this.csv != null) {
                this.processor.importStream(this.csv.getInputStream(), report);
            }
            if (this.file != null) {
                try {
                    InputStream in = ImportPlayadvisorActionBean.class.getResourceAsStream(this.file);
                    this.processor.importStream(in, report);
                    in.close();
                }
                catch (IOException ex) {
                    log.error((Object)ex);
                    return new ForwardResolution(JSP);
                }
            }
            if (this.comments != null) {
                this.processor.importComments(this.comments.getInputStream(), report);
            }
            this.context.getMessages().add(new SimpleMessage("Er zijn " + report.getNumberInserted(ImportReport.ImportType.ASSET) + " " + ImportReport.ImportType.ASSET.toString() + " weggeschreven.", new Object[0]));
            this.context.getMessages().add(new SimpleMessage("Er zijn " + report.getNumberInserted(ImportReport.ImportType.LOCATION) + " " + ImportReport.ImportType.LOCATION.toString() + " weggeschreven.", new Object[0]));
            this.context.getMessages().add(new SimpleMessage("Er zijn " + report.getNumberInserted(ImportReport.ImportType.COMMENT) + " " + ImportReport.ImportType.COMMENT.toString() + " weggeschreven.", new Object[0]));
            this.context.getMessages().add(new SimpleMessage("Er zijn " + report.getNumberUpdated(ImportReport.ImportType.ASSET) + " " + ImportReport.ImportType.ASSET.toString() + " geupdatet.", new Object[0]));
            this.context.getMessages().add(new SimpleMessage("Er zijn " + report.getNumberUpdated(ImportReport.ImportType.LOCATION) + " " + ImportReport.ImportType.LOCATION.toString() + " geupdatet.", new Object[0]));
            this.context.getMessages().add(new SimpleMessage("Er zijn " + report.getNumberUpdated(ImportReport.ImportType.COMMENT) + " " + ImportReport.ImportType.COMMENT.toString() + " geupdatet.", new Object[0]));
            if (report.getErrors().size() > 0) {
                this.context.getMessages().add(new SimpleMessage("Er zijn " + report.getErrors(ImportReport.ImportType.ASSET).size() + " " + ImportReport.ImportType.ASSET.toString() + " mislukt:", new Object[0]));
                this.context.getMessages().add(new SimpleMessage("Er zijn " + report.getErrors(ImportReport.ImportType.LOCATION).size() + " " + ImportReport.ImportType.LOCATION.toString() + " mislukt:", new Object[0]));
                this.context.getMessages().add(new SimpleMessage("Er zijn " + report.getNumErrors(ImportReport.ImportType.COMMENT) + " " + ImportReport.ImportType.COMMENT.toString() + " mislukt:", new Object[0]));
                for (ImportReport.ImportType importType : report.getAllErrors().keySet()) {
                    Set errors = (Set)report.getAllErrors().get(importType);
                    for (String error : errors) {
                        this.context.getMessages().add(new SimpleMessage(importType.toString() + ": " + error, new Object[0]));
                    }
                }
            }
        }
        catch (IOException | CsvFormatException ex) {
            log.error((Object)"Cannot import playadvisor csv: ", ex);
        }
        return new ForwardResolution(JSP);
    }
}

