/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase.cron;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.naming.NamingException;
import nl.b3p.commons.csv.CsvFormatException;
import nl.b3p.mail.Mailer;
import nl.b3p.playbase.ImageDownloader;
import nl.b3p.playbase.ImportReport;
import nl.b3p.playbase.PlayadvisorImporter;
import nl.b3p.playbase.PlaymappingImporter;
import nl.b3p.playbase.cron.CronType;
import nl.b3p.playbase.cron.PlaybaseJob;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.CronJob;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class PlaybaseJob
implements Job {
    private static final Log log = LogFactory.getLog(PlaybaseJob.class);
    private ImageDownloader downloader;

    public void execute(JobExecutionContext jec) throws JobExecutionException {
        JobDataMap jdm = jec.getJobDetail().getJobDataMap();
        CronJob cj = (CronJob)jdm.get((Object)"CronJobEntity");
        log.info((Object)("Executing playbasejob " + cj.getId() + ". Type is " + cj.getType_().toString()));
        CronType ct = cj.getType_();
        switch (1.$SwitchMap$nl$b3p$playbase$cron$CronType[ct.ordinal()]) {
            case 1: {
                this.importPlayadvisor(cj);
                break;
            }
            case 2: {
                this.importPlaymapping(cj);
                break;
            }
            case 3: {
                this.exportPlayadvisor(cj);
            }
        }
    }

    private void importPlaymapping(CronJob job) {
        PlaymappingImporter pi = new PlaymappingImporter(job.getProject());
        ImportReport locationReport = new ImportReport();
        ImportReport assetsReport = new ImportReport();
        String importedString = null;
        try {
            List pm_guids = pi.importJSONLocationsFromAPI(job.getUsername(), job.getPassword(), "https://api.playmapping.com/CustomerLocation/GetAll", locationReport);
            assetsReport = pi.importJSONAssetsFromAPI(job.getUsername(), job.getPassword(), "https://api.playmapping.com/CustomerAsset/GetByLocationId/", pm_guids, assetsReport);
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot import playmapping: ", (Throwable)ex);
        }
        try {
            String logString;
            if (locationReport != null && assetsReport != null) {
                logString = "Location: " + locationReport.toLog() + System.lineSeparator() + "Assets: " + assetsReport.toLog();
                importedString = "Location: " + (String)locationReport.getImportedstring().get(ImportReport.ImportType.LOCATION) + System.lineSeparator() + "Assets: " + (String)assetsReport.getImportedstring().get(ImportReport.ImportType.ASSET);
            } else {
                logString = "Kon niet importeren. Zie logfile.";
            }
            this.savecronjob(job, logString, importedString);
            this.sendMail(job, logString);
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot save report: ", (Throwable)ex);
        }
    }

    private void importPlayadvisor(CronJob job) {
        PlayadvisorImporter pi = new PlayadvisorImporter(job.getProject());
        ImportReport report = new ImportReport();
        String res = pi.getResponse(null, null, job.getBaseurl() + "/wp-cron.php?export_key=" + job.getPassword() + "&export_id=" + job.getUsername() + "&action=trigger", report);
        String message = "";
        do {
            try {
                res = pi.getResponse(null, null, job.getBaseurl() + "/wp-cron.php?export_key=" + job.getPassword() + "&export_id=" + job.getUsername() + "&action=processing", report);
                JSONObject result = new JSONObject(res);
                message = result.getString("message");
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                log.error((Object)"I can get no sleep.", (Throwable)ex);
            }
        } while (!message.contains("complete"));
        res = pi.getResponse(null, null, job.getBaseurl() + "/wp-cron.php?security_token=" + job.getExporthash() + "&export_id=" + job.getUsername() + "&action=get_data", report);
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(res.getBytes("UTF-8"));
            pi.importStream((InputStream)is, report);
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)"Cannot import playadvisor csv", (Throwable)ex);
        }
        catch (IOException | CsvFormatException ex) {
            log.error((Object)"Cannot import playadvisor csv", ex);
        }
        String logmessage = report.toLog();
        try {
            this.savecronjob(job, logmessage, res);
            this.sendMail(job, logmessage);
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot save cronjob", (Throwable)ex);
        }
    }

    private void exportPlayadvisor(CronJob job) {
        this.downloader = new ImageDownloader(job.getExporthash());
        this.downloader.run();
        this.getAllImagesForJob(job);
        try {
            this.downloader.stop();
        }
        catch (IOException ex) {
            log.error((Object)"Cannot stop downloader", (Throwable)ex);
        }
        PlayadvisorImporter pi = new PlayadvisorImporter(job.getProject());
        ImportReport report = new ImportReport();
        String res = pi.getResponse(null, null, job.getBaseurl() + "/wp-cron.php?import_id=" + job.getUsername() + "&import_key=" + job.getPassword() + "&action=trigger", report);
        log.info((Object)"Triggering cronjob on wordpress...");
        String message = "";
        do {
            try {
                res = pi.getResponse(null, null, job.getBaseurl() + "/wp-cron.php?import_key=" + job.getPassword() + "&import_id=" + job.getUsername() + "&action=processing", report);
                JSONObject result = new JSONObject(res);
                message = result.getString("message");
                log.info((Object)("Response message: " + result.toString()));
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                log.error((Object)"I can get no sleep.", (Throwable)ex);
            }
        } while (!message.contains("complete"));
        log.info((Object)"Triggering cronjob on wordpress completed");
        String logmessage = report.toLog();
        try {
            this.savecronjob(job, logmessage, res);
            this.sendMail(job, logmessage);
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot save cronjob", (Throwable)ex);
        }
    }

    private void getAllImagesForJob(CronJob job) {
        log.info((Object)"Getting images for job");
        try {
            String query = "SELECT id from playservice_locations";
            ArrayListHandler rsh = new ArrayListHandler();
            query = query + " where project = ?";
            List locations = (List)DB.qr().query(query, (ResultSetHandler)rsh, new Object[]{job.getProject()});
            for (Object[] location : locations) {
                Integer id = (Integer)location[0];
                this.retrieveImages(id);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot get locations for cronjob", (Throwable)ex);
        }
        log.info((Object)"All images submitted");
    }

    protected void retrieveImages(Integer id) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List images = (List)DB.qr().query("SELECT url, caption,pm_guid from playservice_images WHERE location = ? order by equipment desc, lastupdated desc", (ResultSetHandler)rsh, new Object[]{id});
        int index = 0;
        for (Object[] image : images) {
            String url = (String)this.valueOrEmptyString(image[0]);
            if (url.isEmpty()) continue;
            String imageName = url.substring(url.lastIndexOf("/") + 1);
            if (imageName.contains("GetImage.ashx")) {
                imageName = "Image" + id + "-" + index + ".jpg";
            }
            this.downloadImage(url, imageName);
            ++index;
        }
    }

    private void downloadImage(String url, String filename) {
        this.downloader.add(url, filename);
    }

    private Object valueOrEmptyString(Object value) {
        return value == null ? "" : value;
    }

    private void savecronjob(CronJob cronjob, String logString, String importedString) throws NamingException, SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("update ");
        sb.append("cronjob");
        sb.append(" set ");
        sb.append("log = ?,");
        sb.append("importedstring = ?,");
        sb.append("lastrun = ?");
        sb.append(" where id = ?");
        DB.qr().update(sb.toString(), new Object[]{logString, importedString, new Timestamp(new Date().getTime()), cronjob.getId()});
    }

    private void sendMail(CronJob cronjob, String logString) {
        if (cronjob.getMailaddress() != null) {
            String subject = "Playbase cron status: " + cronjob.getType_().toString() + " voor project " + cronjob.getProject();
            StringBuilder content = new StringBuilder();
            content.append("Status rapport ").append(cronjob.getId());
            content.append(System.lineSeparator());
            content.append("Log: ");
            content.append(System.lineSeparator());
            content.append(logString);
            try {
                Mailer.sendMail((String)"Playbase", (String)"support@b3partners.nl", (String)cronjob.getMailaddress(), (String)subject, (String)content.toString());
            }
            catch (Exception ex) {
                log.error((Object)"Cannot send mail:", (Throwable)ex);
            }
        }
    }
}

