/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.loader.util.DbUtilsGeometryColumnConverter;
import nl.b3p.playbase.ImageDownloader;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Asset;
import nl.b3p.playbase.entities.Location;
import nl.b3p.playbase.entities.Project;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class PlayadvisorExporter {
    private static final Log log = LogFactory.getLog(PlayadvisorExporter.class);
    protected final ResultSetHandler<Project> projectHandler = new BeanHandler(Project.class);
    private ImageDownloader downloader;
    private final Integer[] excl = new Integer[]{58, 60, 61, 93, 22, 7, 56, 64, 177, 81, 82, 125, 87, 88, 89, 90, 92, 178, 111, 110, 109, 108, 127, 15, 23, 31, 32, 83, 171, 156, 155, 69, 68, 59, 152, 145, 144, 143, 141, 140, 139, 120, 119, 118, 117, 116, 115};
    private final List<Integer> excludedAssetTypes = Arrays.asList(this.excl);
    protected Map<Integer, List<String>> locationTypes;
    private Map<Integer, Integer> assetTypes;
    private Map<Integer, Integer> assetTypeToLocationCategory;
    private Map<Integer, String> equipmentTypes;

    public PlayadvisorExporter() {
        this.initLists();
    }

    public void export(List<Location> locations, Connection con, Project job) {
        for (Location location : locations) {
            try {
                this.pushLocation(location, con, job, new HashMap());
            }
            catch (IOException | SQLException | NamingException ex) {
                log.error((Object)"Error exporting to export", (Throwable)ex);
            }
        }
    }

    public String pushLocations(List<String> pm_guids, Project project) {
        this.downloader = new ImageDownloader(project.getImagepath());
        StringBuilder sb = new StringBuilder();
        try (Connection con = DB.getConnection();){
            GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
            BeanHandler handler = new BeanHandler(Location.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
            String sql = "select * from playservice_locations WHERE pm_guid = ?;";
            this.downloader.run();
            ArrayList<Location> locs = new ArrayList<Location>();
            HashMap<Integer, JSONArray> imagesPerLocation = new HashMap<Integer, JSONArray>();
            for (String pm_guid : pm_guids) {
                Location loc = (Location)DB.qr().query(con, sql, (ResultSetHandler)handler, new Object[]{pm_guid});
                locs.add(loc);
                imagesPerLocation.put(loc.getId(), this.retrieveImages(loc.getId(), con, project));
            }
            this.downloader.stop();
            for (Location loc : locs) {
                sb.append(this.pushLocation(loc, con, project, imagesPerLocation));
            }
        }
        catch (IOException | SQLException | NamingException ex) {
            log.error((Object)"Cannot push locations to playadvisor", (Throwable)ex);
        }
        return sb.toString();
    }

    public String pushLocation(Location loc, Connection con, Project project, HashMap<Integer, JSONArray> imgsPerLoc) throws IOException, SQLException, NamingException {
        return this.pushLocation(this.createLocationJSON(loc, con, project, imgsPerLoc), "", project);
    }

    public String pushLocation(JSONObject location, String id, Project job) throws IOException {
        return this.doRequest("", location, job);
    }

    public void updateIDs(List<Location> locs, Connection con) {
        for (Location loc : locs) {
            this.updateId(loc, con);
        }
    }

    public void updateId(Location loc, Connection con) {
        try {
            Project project = this.getProject(loc.getProject(), con);
            List images = loc.getImages();
            for (Map image : images) {
                JSONObject payload = new JSONObject();
                payload.put((String)image.get("pa_id"), (Object)((String)image.get("PlaybaseID")));
                try {
                    this.doRequest("update-ids", payload, project);
                }
                catch (IOException ex) {
                    log.error((Object)("Cannot update image id for imageurl: " + image.get("URI")), (Throwable)ex);
                }
            }
            JSONObject locationPayload = new JSONObject();
            try {
                locationPayload.put(loc.getPa_id(), (Object)loc.getId());
                this.doRequest("update-ids", locationPayload, project);
            }
            catch (IOException ex) {
                log.error((Object)("Cannot update image id for location: " + loc.getId()), (Throwable)ex);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)("Cannot get project for location " + loc.getId()), (Throwable)ex);
        }
    }

    private void processResponse(JSONObject obj) {
    }

    private String doRequest(String endpoint, JSONObject payload, Project project) throws IOException {
        String url = project.getBaseurl() + "/wp-json/b3p/v1/playbase/" + endpoint;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost request = new HttpPost(url);
        StringEntity params = new StringEntity(payload.toString(), ContentType.APPLICATION_JSON);
        request.addHeader("content-type", "application/json");
        request.addHeader("Authorization", "Basic " + project.getAuthkey());
        request.setEntity((HttpEntity)params);
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        StatusLine sl = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        int statusCode = sl.getStatusCode();
        if (statusCode != 200) {
            String statusLine = response.getStatusLine().getReasonPhrase();
            log.debug((Object)("Error: " + statusLine));
            throw new IOException(statusLine);
        }
        String stringResult = EntityUtils.toString((HttpEntity)entity);
        log.debug((Object)("Result: " + stringResult));
        return stringResult;
    }

    protected JSONObject createLocationJSON(Location loc, Connection con, Project p, HashMap<Integer, JSONArray> imgsPerLoc) throws SQLException, NamingException, IOException {
        JSONObject obj = loc.toPlayadvisorJSON();
        Integer id = loc.getId();
        this.retrieveCategories(id, obj, con);
        this.retrieveAssets(id, obj, con);
        JSONArray imgs = imgsPerLoc.getOrDefault(loc.getId(), new JSONArray());
        obj.put("Images", (Object)imgs);
        return obj;
    }

    protected JSONArray retrieveImages(Integer id, Connection con, Project project) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List images = (List)DB.qr().query(con, "SELECT url, caption,pa_id,id,pa_url from playservice_images WHERE location = ? and (pa_deleted is null or pa_deleted = false) and ( pm_deleted is null or pm_deleted = false ) order by equipment desc, lastupdated desc", (ResultSetHandler)rsh, new Object[]{id});
        JSONArray imgs = new JSONArray();
        int index = 0;
        for (Object[] image : images) {
            String url = (String)this.valueOrEmptyString(image[0]);
            if (url.isEmpty()) continue;
            String imageName = url.substring(url.lastIndexOf("/") + 1);
            if (imageName.contains("GetImage.ashx")) {
                imageName = "Image" + id + "-" + index + ".jpg";
            }
            Integer imageId = (Integer)image[3];
            JSONObject img = new JSONObject();
            img.put("Path", (Object)(project.getImagepath() + File.separator + imageName));
            img.put("PlaybaseID", (Object)imageId);
            img.put("PlayadvisorID", this.valueOrEmptyString(image[2]));
            imgs.put((Object)img);
            ++index;
            this.downloader.add(url, imageName);
        }
        return imgs;
    }

    private void retrieveAssets(Integer id, JSONObject location, Connection con) throws NamingException, SQLException {
        GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
        BeanListHandler assHandler = new BeanListHandler(Asset.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
        List assets = (List)DB.qr().query(con, "SELECT * FROM playservice_location_equipment WHERE location = ?", (ResultSetHandler)assHandler, new Object[]{id});
        HashSet<String> equipments = new HashSet<String>();
        for (Asset asset : assets) {
            Integer type = asset.getType_();
            Integer equipment = (Integer)this.assetTypes.get(type);
            String eq = (String)this.equipmentTypes.get(equipment);
            if (eq == null) continue;
            equipments.add(eq);
        }
        HashSet<String> types = new HashSet<String>();
        for (String assetType : equipments) {
            types.add(assetType);
        }
        location.put("Assets", (Object)new JSONArray(types));
    }

    protected void retrieveCategories(Integer id, JSONObject location, Connection con) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List cats = (List)DB.qr().query(con, "SELECT cat.main, cat.category from playservice_location_categories loc inner join playservice_categories_list cat on cat.id = loc.category  WHERE location = " + id, (ResultSetHandler)rsh);
        HashSet<String> types = new HashSet<String>();
        for (Object[] cat : cats) {
            types.add((String)cat[0]);
            types.add((String)cat[1]);
        }
        GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
        BeanListHandler assHandler = new BeanListHandler(Asset.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
        List assets = (List)DB.qr().query(con, "SELECT * FROM playservice_location_equipment WHERE location = ?", (ResultSetHandler)assHandler, new Object[]{id});
        for (Asset asset : assets) {
            Integer type = asset.getType_();
            if (this.excludedAssetTypes.contains(type) || type == null) continue;
            Integer eq = (Integer)this.assetTypeToLocationCategory.get(type);
            List locCats = (List)this.locationTypes.get(eq);
            types.addAll(locCats);
        }
        if (types.isEmpty()) {
            types.add("Openbare speeltuin");
        }
        location.put("Categorieen", (Object)new JSONArray(types));
    }

    private void initLists() {
        Integer id;
        List o;
        ArrayListHandler rsh = new ArrayListHandler();
        try {
            this.equipmentTypes = new HashMap();
            o = (List)DB.qr().query("SELECT id, equipment from playservice_equipment_list", (ResultSetHandler)rsh);
            for (Object[] type : o) {
                id = (Integer)type[0];
                String cat = (String)type[1];
                this.equipmentTypes.put(id, cat);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playmapping assettypes:", (Throwable)ex);
        }
        try {
            this.locationTypes = new HashMap();
            o = (List)DB.qr().query("SELECT id, category, main from playservice_categories_list", (ResultSetHandler)rsh);
            for (Object[] type : o) {
                id = (Integer)type[0];
                String category = (String)type[1];
                String main = (String)type[2];
                this.locationTypes.put(id, new ArrayList());
                ((List)this.locationTypes.get(id)).add(category);
                ((List)this.locationTypes.get(id)).add(main);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playadvisor location types:", (Throwable)ex);
        }
        try {
            this.assetTypes = new HashMap();
            this.assetTypeToLocationCategory = new HashMap();
            o = (List)DB.qr().query("SELECT id, equipment_type, locationcategory from playmapping_type_group", (ResultSetHandler)rsh);
            for (Object[] type : o) {
                id = (Integer)type[0];
                Integer equipmentType = (Integer)type[1];
                Integer locationcategory = (Integer)type[2];
                this.assetTypes.put(id, equipmentType);
                this.assetTypeToLocationCategory.put(id, locationcategory);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playmapping assettypes:", (Throwable)ex);
        }
    }

    private Object valueOrEmptyString(Object value) {
        return value == null ? "" : value;
    }

    protected Project getProject(Integer projectID, Connection con) throws NamingException, SQLException {
        Project p = (Project)DB.qr().query(con, "SELECT id,cronexpressie,type_,username,password,name,log,lastrun,mailaddress,baseurl, status, authkey, imagePath from project WHERE id = ?", this.projectHandler, new Object[]{projectID});
        return p;
    }
}

