/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase.cron;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import nl.b3p.playbase.cron.PlaybaseJob;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Project;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CronListener
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(CronListener.class);
    private ServletContext context;
    private static Scheduler scheduler;
    public static final String QUARTZ_GROUP_NAME = "PlaybaseJobgroup";
    public static final String QUARTZ_JOB_NAME = "PlaybaseJob";
    public static final String QUARTZ_TRIGGER_NAME = "PlaybaseTrigger";
    public static final String QUARTZ_JOB_DATA_MAP_ENTITY_KEY = "CronJobEntity";

    public void contextInitialized(ServletContextEvent sce) {
        this.init(sce);
        Properties props = new Properties();
        props.put("org.quartz.scheduler.instanceName", "MonitoringScheduler");
        props.put("org.quartz.threadPool.threadCount", "10");
        props.put("org.quartz.scheduler.interruptJobsOnShutdownWithWait", "true");
        props.put("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
        try {
            scheduler = new StdSchedulerFactory(props).getScheduler();
        }
        catch (SchedulerException ex) {
            log.error((Object)"Cannot create scheduler. ", (Throwable)ex);
        }
        BeanListHandler handler = new BeanListHandler(Project.class);
        String sql = "select id,cronexpressie,type_,username,password,name,lastrun,baseurl,name from project";
        try {
            List jobs = (List)DB.qr().query(sql, (ResultSetHandler)handler);
            for (Project jobEntity : jobs) {
                try {
                    CronListener.scheduleJob((Project)jobEntity);
                }
                catch (SchedulerException ex) {
                    log.error((Object)"Cannot create jobs", (Throwable)ex);
                }
            }
            scheduler.start();
        }
        catch (SQLException | NamingException | SchedulerException ex) {
            log.error((Object)"Cannot retrieve jobs", ex);
        }
    }

    public static void runNow(Project job) throws SchedulerException {
        JobKey jobKey = JobKey.jobKey((String)("PlaybaseJob" + job.getId()), (String)"PlaybaseJobgroup");
        JobDetail jobDetail = CronListener.createJobDetail((Project)job, (boolean)true);
        scheduler.addJob(jobDetail, true);
        scheduler.triggerJob(jobKey);
    }

    public static void scheduleJob(Project jobEntity) throws SchedulerException {
        if (CronExpression.isValidExpression((String)jobEntity.getCronexpressie())) {
            log.info((Object)("Scheduling job for expression " + jobEntity.getCronexpressie()));
            JobDetail job = CronListener.createJobDetail((Project)jobEntity, (boolean)false);
            CronScheduleBuilder cronSchedule = CronScheduleBuilder.cronSchedule((String)jobEntity.getCronexpressie());
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity("PlaybaseTrigger" + jobEntity.getId(), "PlaybaseJobgroup").startNow().withSchedule((ScheduleBuilder)cronSchedule).build();
            scheduler.scheduleJob(job, trigger);
        }
    }

    public static void rescheduleJob(Project jobEntity) throws SchedulerException {
        if (CronExpression.isValidExpression((String)jobEntity.getCronexpressie())) {
            log.info((Object)("Rescheduling job for expression " + jobEntity.getCronexpressie()));
            CronScheduleBuilder cronSchedule = CronScheduleBuilder.cronSchedule((String)jobEntity.getCronexpressie());
            TriggerKey oldTk = new TriggerKey("PlaybaseTrigger" + jobEntity.getId(), "PlaybaseJobgroup");
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity("PlaybaseTrigger" + jobEntity.getId(), "PlaybaseJobgroup").startNow().withSchedule((ScheduleBuilder)cronSchedule).build();
            scheduler.rescheduleJob(oldTk, trigger);
        }
    }

    public static void unscheduleJob(Project job) {
        try {
            TriggerKey tk = new TriggerKey("PlaybaseTrigger" + job.getId(), "PlaybaseJobgroup");
            scheduler.unscheduleJob(tk);
        }
        catch (SchedulerException ex) {
            log.error((Object)("Cannot unschedule job " + job.getId()), (Throwable)ex);
        }
    }

    public static Date getNextFireTime(Project job) {
        try {
            TriggerKey tk = new TriggerKey("PlaybaseTrigger" + job.getId(), "PlaybaseJobgroup");
            Trigger t = scheduler.getTrigger(tk);
            return t != null ? t.getNextFireTime() : null;
        }
        catch (SchedulerException ex) {
            log.error((Object)("Cannot get next firetime for job " + job.getId()), (Throwable)ex);
            return null;
        }
    }

    private static JobDetail createJobDetail(Project jobEntity, boolean durable) {
        JobDetail job = JobBuilder.newJob(PlaybaseJob.class).withIdentity("PlaybaseJob" + jobEntity.getId(), "PlaybaseJobgroup").storeDurably(durable).usingJobData(CronListener.createJobDataMap((Project)jobEntity)).build();
        return job;
    }

    private static JobDataMap createJobDataMap(Project job) {
        JobDataMap jdm = new JobDataMap();
        jdm.put("CronJobEntity", (Object)job);
        return jdm;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (scheduler != null) {
            try {
                scheduler.shutdown(true);
            }
            catch (SchedulerException ex) {
                log.error((Object)"Cannot shutdown quartz scheduler. ", (Throwable)ex);
            }
        }
    }

    private void init(ServletContextEvent sce) {
        this.context = sce.getServletContext();
    }
}

