/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import nl.b3p.playbase.ImportReport;
import nl.b3p.playbase.Importer;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Asset;
import nl.b3p.playbase.entities.Location;
import nl.b3p.playbase.entities.Project;
import nl.b3p.playbase.entities.Status;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class PlayadvisorImporter
extends Importer {
    private static final Log log = LogFactory.getLog(PlayadvisorImporter.class);

    public PlayadvisorImporter(Project project) {
        super(project);
        this.postfix = "_playadvisor";
    }

    public void initialLoad(Project job, ImportReport report, Connection con) throws NamingException, SQLException {
        try {
            String url = job.getBaseurl() + "/wp-json/b3p/v1/playbase/" + this.getProject().getName().toLowerCase() + "?" + System.nanoTime();
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpGet request = new HttpGet(url);
            request.addHeader("Content-Type", "application/json");
            request.addHeader("Authorization", "Basic " + job.getAuthkey());
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            StatusLine sl = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            int statusCode = sl.getStatusCode();
            if (statusCode != 200) {
                String statusLine = response.getStatusLine().getReasonPhrase();
                log.debug((Object)("Error: " + statusLine));
                throw new IOException(statusLine);
            }
            String stringResult = EntityUtils.toString((HttpEntity)entity);
            List locs = this.processLocations(stringResult, report, con);
            log.debug((Object)("Result: " + stringResult));
        }
        catch (IOException ex) {
            log.error((Object)("Error while getting all speelplekken for project " + this.getProject()), (Throwable)ex);
            report.addError(ex.getLocalizedMessage(), ImportReport.ImportType.GENERAL);
        }
    }

    public List<Location> processLocations(String locs, ImportReport report, Connection con) throws NamingException, SQLException {
        ArrayList<Location> locations = new ArrayList<Location>();
        JSONArray ar = new JSONArray(locs);
        for (JSONObject obj : ar) {
            boolean hasProject = this.getProject() != null;
            String prevpostfix = this.postfix;
            Location l = this.parseLocation(obj, con);
            try {
                if (this.isProjectReady(this.getProject(), con) || this.isPlaygroundAlreadyMerged(l, con)) {
                    this.postfix = "";
                }
                this.processLocation(l, obj, report, con);
                locations.add(l);
                if (!hasProject) {
                    this.setProject(null);
                }
                if (!this.postfix.isEmpty()) continue;
                this.postfix = prevpostfix;
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Error processing location " + l.getTitle()), (Throwable)e);
            }
        }
        return locations;
    }

    private boolean isProjectReady(Project project, Connection con) throws NamingException, SQLException, IllegalArgumentException {
        if (project.getStatus() == null) {
            BeanListHandler handler = new BeanListHandler(Project.class);
            List projects = (List)DB.qr().query(con, "SELECT id,cronexpressie,type_,username,password,name,log,lastrun,mailaddress,baseurl, status from project WHERE name = ?", (ResultSetHandler)handler, new Object[]{project.getName()});
            if (projects.size() == 1) {
                project = (Project)projects.get(0);
            } else {
                if (projects.isEmpty()) {
                    throw new IllegalArgumentException("Speelplek heeft geen geconfigureerd project voor " + project.getName());
                }
                throw new IllegalArgumentException("Speelplek heeft meer dan 1 (" + projects.size() + ") geconfigureerd project voor " + project.getName());
            }
        }
        return project.getStatus() == Status.PUBLISHED;
    }

    private boolean isPlaygroundAlreadyMerged(Location loc, Connection con) throws NamingException, SQLException, IllegalArgumentException {
        Status s = loc.getStatus();
        if (loc.getId() != null) {
            return true;
        }
        return s != null && s != Status.UNDER_REVIEW && s != Status.UNPUBLISHED;
    }

    protected void processLocation(Location location, JSONObject obj, ImportReport report, Connection con) throws NamingException, SQLException {
        if (location.getId() != null) {
            Location currentLocation = (Location)DB.qr().query(con, "select * from playservice_locations" + this.postfix + " where id = ?", this.locationHandler, new Object[]{location.getId()});
            if (currentLocation != null) {
                location.setStatus(currentLocation.getStatus());
            } else {
                location.setStatus(Status.UNPUBLISHED);
            }
        }
        List imgs = this.parseImages(location, obj, report);
        List images = this.processImages(location, imgs, report, con);
        location.setImages(images);
        int id = this.saveLocation(location, report);
        List assets = this.parseAssets(location, obj.getJSONArray("Assets"), report, false, con);
        for (Asset asset : assets) {
            this.saveAsset(asset, report);
        }
    }

    protected Location parseLocation(JSONObject obj, Connection con) throws NamingException, SQLException {
        Location loc = new Location();
        loc.setId(Integer.valueOf(obj.optInt("PlaybaseID")));
        loc.setPa_title(obj.optString("Titel"));
        loc.setTitle(obj.optString("Titel"));
        loc.setPhone(obj.optString("Telefoon"));
        loc.setPa_content(obj.optString("Content"));
        loc.setWebsite(obj.optString("Website"));
        if (obj.has("Latitude")) {
            loc.setLatitude(Double.valueOf(obj.getDouble("Latitude")));
        }
        if (obj.has("Longitude")) {
            loc.setLongitude(Double.valueOf(obj.getDouble("Longitude")));
        }
        loc.setPa_id("" + obj.getInt("PlayadvisorID"));
        loc.setMunicipality(obj.getString("Plaats"));
        if (this.getProject() == null) {
            Project p = this.getProject(loc.getMunicipality(), con);
            this.setProject(p);
            loc.setProject(p.getId());
        } else {
            loc.setProject(this.getProject().getId());
        }
        loc.setCountry(obj.getString("Land"));
        loc.setStreet(obj.optString("Straat"));
        loc.setEmail(obj.optString("Email"));
        return loc;
    }

    protected List<Asset> parseAssets(Location location, JSONArray assetsArray, ImportReport report, boolean merged, Connection con) throws NamingException, SQLException {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        for (String asset : assetsArray) {
            if (asset.isEmpty()) continue;
            Asset ass = new Asset();
            ass.setName(asset);
            ass.setPa_guid(location.getPa_id());
            ass.setLocation(location.getId());
            ass.setLatitude(location.getLatitude().doubleValue());
            ass.setLongitude(location.getLongitude().doubleValue());
            Integer[] cats = location.getAgecategories();
            ass.setAgecategories(cats);
            Integer equipmentType = this.getEquipmentType(asset);
            ass.setEquipment(equipmentType);
            ass.setType_((Integer)this.equipmenttypePAtoPM.get(equipmentType));
            assets.add(ass);
        }
        return assets;
    }

    protected List<Map<String, Object>> processImages(Location location, List<Map<String, Object>> imgs, ImportReport report, Connection con) {
        ArrayList<Map<String, Object>> newImages = new ArrayList<Map<String, Object>>();
        try {
            ArrayListHandler rsh = new ArrayListHandler();
            int id = location.getId();
            int index = 0;
            List images = (List)DB.qr().query(con, "SELECT url, caption,pa_id,id, equipment, location from playservice_images WHERE location = ? order by equipment desc, lastupdated desc", (ResultSetHandler)rsh, new Object[]{location.getId()});
            for (Object[] dbImg : images) {
                boolean found = false;
                String curImgUrl = (String)dbImg[0];
                String imageName = curImgUrl.substring(curImgUrl.lastIndexOf("/") + 1);
                if (imageName.contains("GetImage.ashx")) {
                    imageName = "Image" + id + "-" + index + ".jpg";
                }
                int curId = (Integer)dbImg[3];
                for (Map<String, Object> pushedImg : imgs) {
                    if (!((String)pushedImg.get("URI")).contains(imageName)) continue;
                    found = true;
                    HashMap<String, Object> dbImage = new HashMap<String, Object>();
                    dbImage.put("Description", dbImg[1]);
                    dbImage.put("URI", curImgUrl);
                    dbImage.put("location", dbImg[5]);
                    dbImage.put("pa_id", pushedImg.get("pa_id"));
                    dbImage.put("id", dbImg[3]);
                    int numUpdated = DB.qr().update(con, "UPDATE playservice_images SET pa_id = ? WHERE id = ?", new Object[]{pushedImg.get("pa_id"), curId});
                    newImages.add(dbImage);
                    break;
                }
                if (!found) {
                    int numUpdated = DB.qr().update(con, "UPDATE playservice_imagesSET pa_deleted = true WHERE id = ?", (Object)curId);
                    boolean bl = false;
                }
                ++index;
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot process images");
        }
        return newImages;
    }

    protected List<Map<String, Object>> parseImages(Location location, JSONObject obj, ImportReport report) {
        ArrayList<Map<String, Object>> images = new ArrayList<Map<String, Object>>();
        JSONArray imagesJSON = obj.optJSONArray("Images");
        for (Object object : imagesJSON) {
            JSONObject img = (JSONObject)object;
            images.add(this.parseImage(location, img, report));
        }
        return images;
    }

    protected Map<String, Object> parseImage(Location location, JSONObject image, ImportReport report) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pa_id", image.optString("PlayadvisorID"));
        String url = image.optString("Path");
        map.put("URI", url);
        map.put("PlaybaseID", image.optString("PlaybaseID"));
        return map;
    }
}

