/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import nl.b3p.playbase.ImageDownloader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ImageDownloader {
    private final Log log = LogFactory.getLog(this.getClass());
    private final List<ImageCollector> ics = new ArrayList();
    private final String downloadPath;
    private final int MAX_THREADS = 8;
    private ExecutorService threadPool = null;
    private CompletionService<ImageCollector> pool = null;
    private CloseableHttpClient client = null;
    private final PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
    private List<Future<ImageCollector>> futures;
    private boolean running = false;

    public ImageDownloader(String path) {
        this.downloadPath = path;
        this.futures = new ArrayList();
        if (path != null) {
            this.threadPool = Executors.newFixedThreadPool(8);
            this.pool = new ExecutorCompletionService(this.threadPool);
            this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.cm).setConnectionManagerShared(true).build();
        }
    }

    public void add(String url, String filename) {
        if (this.downloadPath != null) {
            ImageCollector ic = new ImageCollector(this, url, filename, this.client);
            if (this.running) {
                this.futures.add(this.pool.submit(ic));
            } else {
                this.ics.add(ic);
            }
        }
    }

    public void run() {
        if (this.downloadPath != null) {
            this.running = true;
            for (ImageCollector ic : this.ics) {
                this.futures.add(this.pool.submit(ic));
            }
        }
    }

    public void stop() throws IOException {
        if (this.downloadPath != null) {
            try {
                this.running = false;
                boolean isDone = true;
                for (Future future : this.futures) {
                    if (future.isDone()) continue;
                    isDone = false;
                    break;
                }
                if (!isDone) {
                    this.threadPool.awaitTermination(10L, TimeUnit.MINUTES);
                }
                this.client.close();
            }
            catch (InterruptedException ex) {
                this.log.error((Object)"Error terminating threadpool", (Throwable)ex);
                this.client.close();
            }
        }
    }

    static /* synthetic */ String access$000(ImageDownloader x0) {
        return x0.downloadPath;
    }

    static /* synthetic */ Log access$100(ImageDownloader x0) {
        return x0.log;
    }
}

