/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase.cron;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.naming.NamingException;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.loader.util.DbUtilsGeometryColumnConverter;
import nl.b3p.mail.Mailer;
import nl.b3p.playbase.ImageDownloader;
import nl.b3p.playbase.ImportReport;
import nl.b3p.playbase.PlayadvisorExporter;
import nl.b3p.playbase.PlaymappingImporter;
import nl.b3p.playbase.cron.PlaybaseJob;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Location;
import nl.b3p.playbase.entities.Project;
import nl.b3p.playbase.entities.ProjectType;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class PlaybaseJob
implements Job {
    private static final Log log = LogFactory.getLog(PlaybaseJob.class);
    private ImageDownloader downloader;

    public void execute(JobExecutionContext jec) throws JobExecutionException {
        JobDataMap jdm = jec.getJobDetail().getJobDataMap();
        Project cj = (Project)jdm.get((Object)"CronJobEntity");
        log.info((Object)("Executing playbasejob " + cj.getId() + ". Type is " + cj.getType_().toString()));
        ProjectType ct = cj.getType_();
        String imagepath = (String)jdm.get((Object)"wordpress.upload.path");
        String baseurl = (String)jdm.get((Object)"wordpress.baseurl");
        String authkey = (String)jdm.get((Object)"wordpress.authkey");
        switch (1.$SwitchMap$nl$b3p$playbase$entities$ProjectType[ct.ordinal()]) {
            case 1: {
                this.importPlayadvisor(cj);
                break;
            }
            case 2: {
                this.importPlaymapping(cj, imagepath, baseurl, authkey);
                break;
            }
            case 3: {
                this.importPlaymapping(cj, imagepath, baseurl, authkey);
                break;
            }
        }
    }

    public void importPlaymapping(Project project, String imagepath, String baseurl, String authkey) {
        PlaymappingImporter pi = new PlaymappingImporter(project);
        ImportReport locationReport = new ImportReport();
        ImportReport assetsReport = new ImportReport();
        String importedString = null;
        try (Connection con = DB.getConnection();){
            List pm_guids = pi.importJSONLocationsFromAPI(project.getUsername(), project.getPassword(), "https://api.playmapping.com/CustomerLocation/GetAll", locationReport, false, con);
            assetsReport = pi.importJSONAssetsFromAPI(project.getUsername(), project.getPassword(), "https://api.playmapping.com/CustomerAsset/GetByLocationId/", pm_guids, assetsReport, con);
            PlayadvisorExporter pe = new PlayadvisorExporter();
            GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
            BeanListHandler handler = new BeanListHandler(Location.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
            String sql = "select * from playservice_locations WHERE pm_guid in ? and removedfromplaymapping = false and removedfromplayadvisor = false;";
            List locs = (List)DB.qr().query(con, sql, (ResultSetHandler)handler, new Object[]{pm_guids});
            pe.pushLocations(locs, imagepath, baseurl, authkey);
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot import playmapping: ", (Throwable)ex);
        }
        try {
            String logString = "Location: " + locationReport.toLog() + System.lineSeparator() + "Assets: " + assetsReport.toLog();
            importedString = "Location: " + (String)locationReport.getImportedstring().get(ImportReport.ImportType.LOCATION) + System.lineSeparator() + "Assets: " + (String)assetsReport.getImportedstring().get(ImportReport.ImportType.ASSET);
            this.savecronjob(project, logString, importedString);
            this.sendMail(project, logString);
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot save report: ", (Throwable)ex);
        }
    }

    public void importPlayadvisor(Project job) {
    }

    public void exportPlayadvisor(Project job) {
    }

    private void getAllImagesForJob(Project job) {
        log.info((Object)"Getting images for job");
        try {
            String query = "SELECT id from playservice_locations";
            ArrayListHandler rsh = new ArrayListHandler();
            query = query + " where project = ?";
            List locations = (List)DB.qr().query(query, (ResultSetHandler)rsh, new Object[]{job.getName()});
            for (Object[] location : locations) {
                Integer id = (Integer)location[0];
                this.retrieveImages(id);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot get locations for cronjob", (Throwable)ex);
        }
        log.info((Object)"All images submitted");
    }

    protected void retrieveImages(Integer id) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List images = (List)DB.qr().query("SELECT url, caption,pm_guid from playservice_images WHERE location = ? order by equipment desc, lastupdated desc", (ResultSetHandler)rsh, new Object[]{id});
        int index = 0;
        for (Object[] image : images) {
            String url = (String)this.valueOrEmptyString(image[0]);
            if (url.isEmpty()) continue;
            String imageName = url.substring(url.lastIndexOf("/") + 1);
            if (imageName.contains("GetImage.ashx")) {
                imageName = "Image" + id + "-" + index + ".jpg";
            }
            this.downloadImage(url, imageName);
            ++index;
        }
    }

    private void downloadImage(String url, String filename) {
        this.downloader.add(url, filename);
    }

    private Object valueOrEmptyString(Object value) {
        return value == null ? "" : value;
    }

    private void savecronjob(Project cronjob, String logString, String importedString) throws NamingException, SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("update ");
        sb.append("project");
        sb.append(" set ");
        sb.append("log = ?,");
        sb.append("importedstring = ?,");
        sb.append("lastrun = ?");
        sb.append(" where id = ?");
        DB.qr().update(sb.toString(), new Object[]{logString, importedString, new Timestamp(new Date().getTime()), cronjob.getId()});
    }

    private void sendMail(Project cronjob, String logString) {
        if (cronjob.getMailaddress() != null) {
            String subject = "Playbase cron status: " + cronjob.getType_().toString() + " voor project " + cronjob.getName();
            StringBuilder content = new StringBuilder();
            content.append("Status rapport ").append(cronjob.getId());
            content.append(System.lineSeparator());
            content.append("Log: ");
            content.append(System.lineSeparator());
            content.append(logString);
            try {
                Mailer.sendMail((String)"Playbase", (String)"support@b3partners.nl", (String)cronjob.getMailaddress(), (String)subject, (String)content.toString());
            }
            catch (Exception ex) {
                log.error((Object)"Cannot send mail:", (Throwable)ex);
            }
        }
    }
}

