/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase.stripes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import info.debatty.java.stringsimilarity.NormalizedLevenshtein;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.loader.util.DbUtilsGeometryColumnConverter;
import nl.b3p.playbase.ImportReport;
import nl.b3p.playbase.PlayadvisorExporter;
import nl.b3p.playbase.PlaymappingImporter;
import nl.b3p.playbase.WaitPageStatus;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Asset;
import nl.b3p.playbase.entities.Location;
import nl.b3p.playbase.entities.Project;
import nl.b3p.playbase.entities.Status;
import nl.b3p.playbase.util.GeometryGsonSerializer;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.stripesstuff.plugin.waitpage.WaitPage;

/*
 * Exception performing whole class analysis ignored.
 */
@StrictBinding
@UrlBinding(value="/action/match/{$event}")
public class MatchActionBean
implements ActionBean {
    private ActionBeanContext context;
    private static final String JSP = "/WEB-INF/jsp/admin/match.jsp";
    private static final Log LOG = LogFactory.getLog((String)"MatchActionBean");
    @Validate
    private Integer playadvisorId;
    @Validate
    private Integer playmappingId;
    @Validate
    private String method;
    @Validate
    private double automaticMergeScore = 10.0;
    @Validate
    private boolean useDistance = false;
    @Validate
    private boolean useImagesFromPlayadvisor = false;
    private final Gson gson;
    private WaitPageStatus status;

    public MatchActionBean() {
        GsonBuilder builder = new GsonBuilder();
        builder.serializeSpecialFloatingPointValues();
        builder.registerTypeAdapter(Geometry.class, (Object)new GeometryGsonSerializer());
        this.gson = builder.create();
    }

    public Resolution addAll() {
        try (Connection con = DB.getConnection();){
            GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
            BeanListHandler handler = new BeanListHandler(Location.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
            String sql = "select * from playservice_locations_playadvisor";
            List locations = (List)DB.qr().query(sql, (ResultSetHandler)handler);
            ArrayList locs = new ArrayList();
            this.method = "add";
            for (Location loc : locations) {
                this.playadvisorId = loc.getId();
                this.save(locs);
            }
            String imagepath = this.context.getServletContext().getInitParameter("wordpress.upload.path");
            String baseurl = this.context.getServletContext().getInitParameter("wordpress.baseurl");
            String authkey = this.context.getServletContext().getInitParameter("wordpress.authkey");
            PlayadvisorExporter pe = new PlayadvisorExporter();
            pe.pushLocations(locs, imagepath, baseurl, authkey);
            for (Location loc : locs) {
                pe.updateId(loc, con, baseurl, authkey);
            }
        }
        catch (SQLException | NamingException ex) {
            LOG.error((Object)"Cannot get geometryConverter: ", (Throwable)ex);
        }
        return this.view();
    }

    @WaitPage(path="/WEB-INF/jsp/waitpage.jsp", delay=2000, refresh=1000, ajax="/WEB-INF/jsp/waitpageajax.jsp")
    public Resolution autoMerge() {
        this.status = new WaitPageStatus();
        this.status.addLog("Start");
        this.status.setCurrentAction("Start met berekenen gelijke locaties");
        JSONObject result = new JSONObject();
        try (Connection con = DB.getConnection();){
            GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
            BeanListHandler handler = new BeanListHandler(Location.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
            String sql = "select * from playservice_locations_playadvisor";
            List playadvisorLocs = (List)DB.qr().query(sql, (ResultSetHandler)handler);
            String sqlPM = "select * from playservice_locations where pa_id is null";
            List playmappingLocs = (List)DB.qr().query(sqlPM, (ResultSetHandler)handler);
            CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
            NormalizedLevenshtein l = new NormalizedLevenshtein();
            JSONArray ar = new JSONArray();
            result.put("messages", (Object)ar);
            this.method = "merge";
            double delta = 0.1;
            int steps = 20;
            ArrayList locs = new ArrayList();
            for (int i = 0; i <= steps; ++i) {
                double curDelta = (double)i * delta;
                if (i == steps) {
                    this.useDistance = true;
                }
                Iterator paIterator = playadvisorLocs.iterator();
                block12: while (paIterator.hasNext()) {
                    Location playadvisorLoc = (Location)paIterator.next();
                    boolean found = false;
                    double maxScore = -100.0;
                    double minDist = 100.0;
                    Iterator iterator = playmappingLocs.iterator();
                    while (iterator.hasNext()) {
                        Location pmLoc = (Location)iterator.next();
                        JSONObject pm = this.calculateScore(playadvisorLoc, pmLoc, l, crs, this.useDistance);
                        double score = pm.getDouble("score");
                        String distanceString = pm.getString("distance");
                        Double distance = distanceString.equals("-") ? 100.0 : Double.parseDouble(pm.getString("distance"));
                        maxScore = Math.max(score, maxScore);
                        minDist = Math.min(distance, minDist);
                        if (!(score >= this.automaticMergeScore - curDelta) && (!this.useDistance || !(distance < 0.05))) continue;
                        this.context.getMessages().add(new SimpleMessage("Gelinked: " + playadvisorLoc.getTitle() + " aan " + pm.getString("title"), new Object[0]));
                        this.status.addLog("Gelinked: " + playadvisorLoc.getTitle() + " aan " + pm.getString("title"));
                        this.playmappingId = pm.getInt("id");
                        this.playadvisorId = playadvisorLoc.getId();
                        this.save(locs);
                        found = true;
                        iterator.remove();
                        paIterator.remove();
                        continue block12;
                    }
                }
            }
            this.status.addLog("Playadvisor updaten met gelinkte locaties");
            String imagepath = this.context.getServletContext().getInitParameter("wordpress.upload.path");
            String baseurl = this.context.getServletContext().getInitParameter("wordpress.baseurl");
            String authkey = this.context.getServletContext().getInitParameter("wordpress.authkey");
            PlayadvisorExporter pe = new PlayadvisorExporter();
            pe.pushLocations(locs, imagepath, baseurl, authkey);
            this.status.addLog("Ids updaten...");
            for (Location loc : locs) {
                pe.updateId(loc, con, baseurl, authkey);
            }
            this.status.addLog("Klaar");
        }
        catch (SQLException | NamingException | FactoryException ex) {
            LOG.error((Object)"Cannot get geometryConverter: ", ex);
            result.put("message", (Object)("Cannot get geometryConverter: " + ex.getLocalizedMessage()));
        }
        return this.view();
    }

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution("/WEB-INF/jsp/admin/match.jsp");
    }

    private Map<Integer, String> getProjectMap(Connection con) {
        HashMap<Integer, String> projectMap = new HashMap<Integer, String>();
        try {
            BeanListHandler handler = new BeanListHandler(Project.class);
            String sql = "select id,cronexpressie,type_,name,lastrun, status from project";
            List projects = (List)DB.qr().query(con, sql, (ResultSetHandler)handler);
            for (Project project : projects) {
                projectMap.put(project.getId(), project.getName());
            }
        }
        catch (SQLException | NamingException ex) {
            LOG.error((Object)"Cannot get projectmap: ", (Throwable)ex);
        }
        return projectMap;
    }

    public Resolution dataPlayadvisor() {
        JSONObject result = new JSONObject();
        try (Connection con = DB.getConnection();){
            Map projectMap = this.getProjectMap(con);
            GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
            BeanListHandler handler = new BeanListHandler(Location.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
            String sql = "select * from playservice_locations_playadvisor";
            List locs = (List)DB.qr().query(sql, (ResultSetHandler)handler);
            JSONArray ar = new JSONArray();
            for (Location loc : locs) {
                JSONObject jsonLoc = new JSONObject(this.gson.toJson((Object)loc, Location.class));
                jsonLoc.put("project", projectMap.get(loc.getProject()));
                ar.put((Object)jsonLoc);
            }
            result.put("data", (Object)ar);
        }
        catch (SQLException | NamingException ex) {
            LOG.error((Object)"Cannot get geometryConverter: ", (Throwable)ex);
            result.put("message", (Object)("Cannot get geometryConverter: " + ex.getLocalizedMessage()));
        }
        StreamingResolution res = new StreamingResolution("application/json", result.toString(4));
        res.setFilename("");
        res.setAttachment(true);
        return res;
    }

    public Resolution dataPlaymapping() throws FactoryException {
        JSONObject result = new JSONObject();
        try (Connection con = DB.getConnection();){
            GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
            BeanHandler handler = new BeanHandler(Location.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
            Location playadvisorLoc = (Location)DB.qr().query("select * from playservice_locations_playadvisor where id = ?", (ResultSetHandler)handler, new Object[]{this.playadvisorId});
            if (playadvisorLoc != null) {
                List locations = this.getPlaymappingData(con, playadvisorLoc, geometryConverter, true);
                result.put("data", (Object)new JSONArray((Collection)locations));
            } else {
                result.put("message", (Object)"playadvisor location not found.");
            }
        }
        catch (SQLException | NamingException ex) {
            LOG.error((Object)"Cannot get geometryConverter: ", (Throwable)ex);
            result.put("message", (Object)("Cannot get geometryConverter: " + ex.getLocalizedMessage()));
        }
        StreamingResolution res = new StreamingResolution("application/json", result.toString(4));
        res.setFilename("");
        res.setAttachment(true);
        return res;
    }

    private List<JSONObject> getPlaymappingData(Connection con, Location playadvisorLoc, GeometryJdbcConverter geometryConverter, boolean useDistance) throws FactoryException, NamingException, SQLException {
        BeanListHandler listHandler = new BeanListHandler(Location.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
        NormalizedLevenshtein l = new NormalizedLevenshtein();
        Map projectMap = this.getProjectMap(con);
        List locs = (List)DB.qr().query("select * from playservice_locations where pa_id is null", (ResultSetHandler)listHandler);
        ArrayList<JSONObject> locations = new ArrayList<JSONObject>();
        for (Location loc : locs) {
            JSONObject obj = this.calculateScore(playadvisorLoc, loc, l, crs, useDistance);
            obj.put("project", projectMap.get(loc.getProject()));
            locations.add(obj);
        }
        return locations;
    }

    private JSONObject calculateScore(Location playadvisorLoc, Location playmappingLoc, NormalizedLevenshtein l, CoordinateReferenceSystem crs, boolean useDistance) {
        JSONObject obj = new JSONObject(this.gson.toJson((Object)playmappingLoc, Location.class));
        Geometry end = playmappingLoc.getGeom();
        double distanceScore = 3.0;
        try {
            if (end != null && playadvisorLoc.getGeom() != null) {
                double distance = JTS.orthodromicDistance((Coordinate)playadvisorLoc.getGeom().getCoordinate(), (Coordinate)end.getCoordinate(), (CoordinateReferenceSystem)crs) / 1000.0;
                obj.put("distance", (Object)String.format("%.2f", distance));
                distanceScore = Math.min(distance * 2.0, 10.0);
            } else {
                obj.put("distance", (Object)"-");
            }
        }
        catch (TransformException ex) {
            LOG.error((Object)"Error calculating distance: ", (Throwable)ex);
        }
        double similarity = l.similarity(playadvisorLoc.getPa_title(), playmappingLoc.getTitle()) * 10.0;
        obj.put("similarity", (double)Math.round(similarity * 10.0) / 10.0);
        double score = 10.0 - (10.0 - similarity) / 2.7 - distanceScore;
        obj.put("score", (Object)String.format("%.2f", score));
        return obj;
    }

    public Resolution save() {
        Resolution res = null;
        try (Connection con = DB.getConnection();){
            ArrayList locs = new ArrayList();
            res = this.save(locs);
            String imagepath = this.context.getServletContext().getInitParameter("wordpress.upload.path");
            String baseurl = this.context.getServletContext().getInitParameter("wordpress.baseurl");
            String authkey = this.context.getServletContext().getInitParameter("wordpress.authkey");
            PlayadvisorExporter pe = new PlayadvisorExporter();
            pe.pushLocations(locs, imagepath, baseurl, authkey);
            for (Location loc : locs) {
                pe.updateId(loc, con, baseurl, authkey);
            }
        }
        catch (SQLException | NamingException ex) {
            LOG.error((Object)"cannot merge locations", (Throwable)ex);
            res = this.view();
        }
        return res;
    }

    private Resolution save(List<Location> locs) {
        try (Connection con = DB.getConnection();){
            GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
            BeanHandler handler = new BeanHandler(Location.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
            BeanListHandler assHandler = new BeanListHandler(Asset.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
            Location playadvisorLoc = (Location)DB.qr().query("select * from playservice_locations_playadvisor where id = ?", (ResultSetHandler)handler, new Object[]{this.playadvisorId});
            Location playmappingLoc = (Location)DB.qr().query("select * from playservice_locations where id = ?", (ResultSetHandler)handler, new Object[]{this.playmappingId});
            PlaymappingImporter importer = new PlaymappingImporter(null);
            Location toSave = null;
            if (this.method.equals("merge")) {
                toSave = MatchActionBean.mergeLocations((Location)playadvisorLoc, (Location)playmappingLoc);
            } else if (this.method.equals("add")) {
                toSave = playadvisorLoc;
                toSave.setTitle(toSave.getPa_title());
                toSave.setId(null);
                playmappingLoc = playadvisorLoc;
            } else {
                throw new IllegalArgumentException("Location to save is null.");
            }
            Project p = importer.getProject(toSave.getProject(), con);
            importer.setProject(p);
            toSave.setStatus(Status.PUBLISHED);
            Integer locationId = importer.saveLocation(toSave, new ImportReport());
            if (this.method.equals("add") || this.useImagesFromPlayadvisor) {
                this.transferImages(playadvisorLoc, locationId, importer);
            } else {
                DB.qr().update("delete from playservice_images_playadvisor where location = ?", (Object)this.playadvisorId);
            }
            this.transferFacilities(playadvisorLoc, playmappingLoc, importer);
            this.transferAccessibilities(playadvisorLoc, locationId, importer);
            this.transferLocationAgecategories(playadvisorLoc, playmappingLoc, importer);
            this.transferLocationCategories(playadvisorLoc, playmappingLoc, importer);
            this.transferLocationEquipment(playadvisorLoc, locationId, importer, (ResultSetHandler)assHandler);
            DB.qr().update("delete from playservice_locations_playadvisor where id = ?", (Object)this.playadvisorId);
            locs.add(toSave);
        }
        catch (UnsupportedEncodingException | SQLException | NamingException ex) {
            LOG.error((Object)"cannot merge locations", (Throwable)ex);
        }
        return this.view();
    }

    public static Location mergeLocations(Location pa, Location pm) throws NamingException, SQLException {
        pm.setPa_id(pa.getPa_id());
        pm.setAveragerating(pa.getAveragerating());
        pm.setPa_content(pa.getPa_content());
        pm.setCountry(pa.getCountry());
        pm.setMunicipality(pa.getMunicipality());
        pm.setPa_title(pa.getPa_title());
        pm.setPhone(pa.getPhone());
        pm.setParking(pa.getParking());
        pm.setWebsite(pa.getWebsite());
        if (pm.getStreet() == null) {
            if (pa.getStreet() == null) {
                pm.setStreet(pm.getTitle());
            } else {
                pm.setStreet(pa.getStreet());
            }
        }
        if (pm.getPostalcode() == null && pa.getPostalcode() != null) {
            pm.setPostalcode(pa.getPostalcode());
        }
        return pm;
    }

    protected void transferImages(Location playadvisor, Integer playmapping, PlaymappingImporter importer) throws NamingException, SQLException {
        List paImages = (List)DB.qr().query("select caption as \"Description\", url as \"URI\" from playservice_images_playadvisor where location = ?", (ResultSetHandler)new MapListHandler(), new Object[]{this.playadvisorId});
        importer.saveImagesAndWords(paImages, null, playmapping, "playservice_images", false, null);
        DB.qr().update("delete from playservice_images_playadvisor where location = ?", (Object)this.playadvisorId);
    }

    protected void transferFacilities(Location playadvisor, Location playmapping, PlaymappingImporter importer) throws NamingException, SQLException {
        List paFacilities = (List)DB.qr().query("select location, facility from playservice_location_facilities_playadvisor where location = ?", (ResultSetHandler)new MapListHandler(), new Object[]{this.playadvisorId});
        for (Map facility : paFacilities) {
            importer.saveFacilities(playmapping, (Integer)facility.get("facility"));
        }
        DB.qr().update("delete from playservice_location_facilities_playadvisor where location = ?", (Object)this.playadvisorId);
    }

    protected void transferAccessibilities(Location playadvisor, Integer playmapping, PlaymappingImporter importer) throws NamingException, SQLException {
        List paAccessibilities = (List)DB.qr().query("select location, accessibility from playservice_location_accessibility_playadvisor where location = ?", (ResultSetHandler)new MapListHandler(), new Object[]{this.playadvisorId});
        for (Map acc : paAccessibilities) {
            importer.saveAccessibility(playmapping, (Integer)acc.get("accessibility"));
        }
        DB.qr().update("delete from playservice_location_accessibility_playadvisor where location = ?", (Object)this.playadvisorId);
    }

    protected void transferLocationAgecategories(Location playadvisor, Location playmapping, PlaymappingImporter importer) throws NamingException, SQLException {
        List paAccessibilities = (List)DB.qr().query("select location, agecategory from playservice_location_agecategories_playadvisor where location = ?", (ResultSetHandler)new MapListHandler(), new Object[]{this.playadvisorId});
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (Map paAccessibility : paAccessibilities) {
            ids.add((Integer)paAccessibility.get("agecategory"));
        }
        importer.saveLocationAgeCategory(playmapping, ids, false);
        DB.qr().update("delete from playservice_location_agecategories_playadvisor where location = ?", (Object)this.playadvisorId);
    }

    protected void transferLocationCategories(Location playadvisor, Location playmapping, PlaymappingImporter importer) throws NamingException, SQLException, UnsupportedEncodingException {
        List paAccessibilities = (List)DB.qr().query("select location, category from playservice_location_categories_playadvisor where location = ?", (ResultSetHandler)new MapListHandler(), new Object[]{this.playadvisorId});
        HashSet<Integer> types = new HashSet<Integer>();
        for (Map paAccessibility : paAccessibilities) {
            types.add((Integer)paAccessibility.get("category"));
        }
        importer.saveLocationTypes(types, playmapping.getId());
        DB.qr().update("delete from playservice_location_categories_playadvisor where location = ?", (Object)this.playadvisorId);
    }

    protected void transferLocationEquipment(Location playadvisor, Integer playmapping, PlaymappingImporter importer, ResultSetHandler<List<Asset>> assHandler) throws NamingException, SQLException, UnsupportedEncodingException {
        List assets = (List)DB.qr().query("select * from playservice_location_equipment_playadvisor where location = ?", assHandler, new Object[]{this.playadvisorId});
        for (Asset asset : assets) {
            this.transferLocationEquipmentAgecategory(asset);
            asset.setId(null);
            asset.setLocation(playmapping);
            importer.saveAsset(asset, new ImportReport());
        }
        DB.qr().update("delete from playservice_location_equipment_playadvisor where location = ?", (Object)this.playadvisorId);
    }

    protected void transferLocationEquipmentAgecategory(Asset asset) throws NamingException, SQLException, UnsupportedEncodingException {
        List agecategories = (List)DB.qr().query("select * from playservice_location_equipment_agecategories_playadvisor where location_equipment = ?", (ResultSetHandler)new MapListHandler(), new Object[]{asset.getId()});
        Integer[] ids = new Integer[agecategories.size()];
        for (int i = 0; i < agecategories.size(); ++i) {
            Map cat = (Map)agecategories.get(i);
            ids[i] = (Integer)cat.get("agecategory");
        }
        asset.setAgecategories(ids);
        DB.qr().update("delete from playservice_location_equipment_agecategories_playadvisor where location_equipment = ?", (Object)asset.getId());
    }

    public Integer getPlayadvisorId() {
        return this.playadvisorId;
    }

    public void setPlayadvisorId(Integer playadvisorId) {
        this.playadvisorId = playadvisorId;
    }

    public Integer getPlaymappingId() {
        return this.playmappingId;
    }

    public void setPlaymappingId(Integer playmappingId) {
        this.playmappingId = playmappingId;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public double getAutomaticMergeScore() {
        return this.automaticMergeScore;
    }

    public void setAutomaticMergeScore(double automaticMergeScore) {
        this.automaticMergeScore = automaticMergeScore;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public boolean isUseDistance() {
        return this.useDistance;
    }

    public void setUseDistance(boolean useDistance) {
        this.useDistance = useDistance;
    }

    public boolean isUseImagesFromPlayadvisor() {
        return this.useImagesFromPlayadvisor;
    }

    public void setUseImagesFromPlayadvisor(boolean useImagesFromPlayadvisor) {
        this.useImagesFromPlayadvisor = useImagesFromPlayadvisor;
    }

    public WaitPageStatus getStatus() {
        return this.status;
    }

    public void setStatus(WaitPageStatus status) {
        this.status = status;
    }
}

