/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase;

import com.vividsolutions.jts.io.ParseException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.loader.util.DbUtilsGeometryColumnConverter;
import nl.b3p.playbase.ImportReport;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Asset;
import nl.b3p.playbase.entities.Comment;
import nl.b3p.playbase.entities.Location;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public abstract class Importer {
    private static final Log log = LogFactory.getLog((String)"Importer");
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S");
    private GeometryJdbcConverter geometryConverter;
    protected ResultSetHandler<Location> locationHandler;
    protected ResultSetHandler<Asset> assHandler;
    protected ResultSetHandler<List<Asset>> assListHandler;
    private Map<String, Integer> assetTypes;
    protected Map<String, Integer> equipmentTypes;
    protected Map<Integer, Integer> equipmenttypePMtoPA;
    protected Map<Integer, Integer> equipmenttypePAtoPM;
    protected Map<Integer, Integer> assetTypeToLocationCategory;
    protected Map<String, Map<String, Integer>> locationTypes;
    protected Map<String, Integer> facilityTypes;
    protected Map<String, Integer> accessibilityTypes;
    protected Map<String, Integer> agecategoryTypes;
    protected Map<String, Integer> parkingTypes;
    public String postfix = "";
    private String project;

    public Importer(String project) {
        String cat;
        Integer id;
        List o;
        this.project = project;
        ArrayListHandler rsh = new ArrayListHandler();
        try {
            this.assetTypes = new HashMap();
            this.equipmenttypePMtoPA = new HashMap();
            this.equipmenttypePAtoPM = new HashMap();
            this.assetTypeToLocationCategory = new HashMap();
            o = (List)DB.qr().query("SELECT id, catasset, equipment_type,locationcategory from playmapping_type_group", (ResultSetHandler)rsh);
            for (Object[] type : o) {
                id = (Integer)type[0];
                cat = (String)type[1];
                Integer equipmentType = (Integer)type[2];
                Integer locationCategory = (Integer)type[3];
                this.assetTypes.put(cat, id);
                this.equipmenttypePMtoPA.put(id, equipmentType);
                this.equipmenttypePAtoPM.put(equipmentType, id);
                this.assetTypeToLocationCategory.put(id, locationCategory);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playmapping assettypes:", (Throwable)ex);
        }
        try {
            this.equipmentTypes = new HashMap();
            o = (List)DB.qr().query("SELECT id, equipment from playservice_equipment_list", (ResultSetHandler)rsh);
            for (Object[] type : o) {
                id = (Integer)type[0];
                cat = (String)type[1];
                this.equipmentTypes.put(cat, id);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playmapping assettypes:", (Throwable)ex);
        }
        try {
            Connection con = DB.getConnection();
            Iterator iterator = null;
            try {
                this.geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
                this.locationHandler = new BeanHandler(Location.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(this.geometryConverter)));
                this.assHandler = new BeanHandler(Asset.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(this.geometryConverter)));
                this.assListHandler = new BeanListHandler(Asset.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(this.geometryConverter)));
            }
            catch (Throwable type) {
                iterator = type;
                throw type;
            }
            finally {
                if (con != null) {
                    if (iterator != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable type) {
                            ((Throwable)((Object)iterator)).addSuppressed(type);
                        }
                    } else {
                        con.close();
                    }
                }
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot get geometryConverter: ", (Throwable)ex);
        }
        try {
            this.locationTypes = new HashMap();
            o = (List)DB.qr().query("SELECT id, category, main from playservice_categories_list", (ResultSetHandler)rsh);
            for (Object[] type : o) {
                id = (Integer)type[0];
                String category = (String)type[1];
                String main = (String)type[2];
                if (!this.locationTypes.containsKey(main)) {
                    this.locationTypes.put(main, new HashMap());
                }
                ((Map)this.locationTypes.get(main)).put(category, id);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playadvisor location types:", (Throwable)ex);
        }
        try {
            this.facilityTypes = new HashMap();
            o = (List)DB.qr().query("SELECT id, facility from playservice_facilities_list", (ResultSetHandler)rsh);
            for (Object[] type : o) {
                id = (Integer)type[0];
                String facility = (String)type[1];
                this.facilityTypes.put(facility, id);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playadvisory facilitytypes:", (Throwable)ex);
        }
        try {
            this.accessibilityTypes = new HashMap();
            o = (List)DB.qr().query("SELECT id, accessibility from playservice_accessibility_list", (ResultSetHandler)rsh);
            for (Object[] type : o) {
                id = (Integer)type[0];
                String accesiblity = (String)type[1];
                this.accessibilityTypes.put(accesiblity.toLowerCase(), id);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playadvisory facilitytypes:", (Throwable)ex);
        }
        try {
            this.agecategoryTypes = new HashMap();
            o = (List)DB.qr().query("SELECT id, agecategory from playservice_agecategories_list", (ResultSetHandler)rsh);
            for (Object[] type : o) {
                id = (Integer)type[0];
                String agecategory = (String)type[1];
                this.agecategoryTypes.put(agecategory.toLowerCase(), id);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playadvisory facilitytypes:", (Throwable)ex);
        }
        try {
            this.parkingTypes = new HashMap();
            o = (List)DB.qr().query("SELECT id, parking from playservice_parking_list", (ResultSetHandler)rsh);
            for (Object[] type : o) {
                id = (Integer)type[0];
                String parking = (String)type[1];
                this.parkingTypes.put(parking.toLowerCase(), id);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playadvisory parkingtypes:", (Throwable)ex);
        }
    }

    public int saveLocation(Location location, ImportReport report) throws NamingException, SQLException {
        Integer id;
        StringBuilder sb = new StringBuilder();
        boolean exists = this.locationExists(location);
        Object geom = null;
        try {
            geom = this.geometryConverter.createNativePoint(location.getLatitude().doubleValue(), location.getLongitude().doubleValue(), 4326);
        }
        catch (ParseException ex) {
            log.error((Object)"Cannot parse geometry", (Throwable)ex);
        }
        catch (NullPointerException ex) {
            log.info((Object)"no geom for asset");
        }
        if (!exists) {
            sb.append("INSERT ");
            sb.append("INTO ");
            sb.append("playservice_locations").append(this.postfix);
            sb.append("(title,");
            sb.append("latitude,");
            sb.append("longitude,");
            sb.append("geom,");
            sb.append("averagerating,");
            sb.append("pa_content,");
            sb.append("pm_content,");
            sb.append("municipality,");
            sb.append("country,");
            sb.append("street,");
            sb.append("postalcode,");
            sb.append("parking,");
            sb.append("phone,");
            sb.append("website,");
            sb.append("pa_id,");
            sb.append("pa_title,");
            sb.append("project,");
            sb.append("pm_guid) ");
            sb.append("VALUES( ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);");
            Location savedLocation = (Location)DB.qr().insert(sb.toString(), this.locationHandler, new Object[]{location.getTitle(), location.getLatitude(), location.getLongitude(), geom, location.getAveragerating() != null ? location.getAveragerating() : 0, location.getPa_content(), location.getPm_content(), location.getMunicipality(), location.getCountry(), location.getStreet(), location.getPostalcode(), location.getParking(), location.getPhone(), location.getWebsite(), location.getPa_id(), location.getPa_title(), this.project, location.getPm_guid()});
            id = savedLocation.getId();
            report.increaseInserted(ImportReport.ImportType.LOCATION);
            List images = location.getImages();
            this.saveImagesAndWords(images, null, savedLocation.getId(), "playservice_images" + this.postfix, true, savedLocation);
        } else {
            id = this.getLocationId(location);
            sb = new StringBuilder();
            sb.append("update ");
            sb.append("playservice_locations").append(this.postfix);
            sb.append(" ");
            sb.append("SET title = ?,");
            sb.append("latitude = ?,");
            sb.append("longitude = ?,");
            sb.append("geom = ?,");
            sb.append("averagerating = ?,");
            sb.append("pa_content = ?,");
            sb.append("pm_content = ?,");
            sb.append("municipality = ?,");
            sb.append("country = ?,");
            sb.append("street = ?,");
            sb.append("postalcode= ?,");
            sb.append("parking= ?,");
            sb.append("phone = ?,");
            sb.append("website = ?,");
            sb.append("pa_id = ?,");
            sb.append("pa_title = ?,");
            sb.append("project = ?,");
            sb.append("pm_guid = ?");
            sb.append("where id = ?;");
            DB.qr().update(sb.toString(), new Object[]{location.getTitle(), location.getLatitude(), location.getLongitude(), geom, location.getAveragerating() != null ? location.getAveragerating() : 0, location.getPa_content(), location.getPm_content(), location.getMunicipality(), location.getCountry(), location.getStreet(), location.getPostalcode(), location.getParking(), location.getPhone(), location.getWebsite(), location.getPa_id(), location.getPa_title(), this.project, location.getPm_guid(), id});
            report.increaseUpdated(ImportReport.ImportType.LOCATION);
            List images = location.getImages();
            this.saveImagesAndWords(images, null, id, "playservice_images" + this.postfix, true, location);
        }
        location.setId(id);
        return id;
    }

    public void saveLocationAgeCategory(Location location, List<Integer> agecategories, boolean removeBeforeAdding) throws NamingException, SQLException {
        if (removeBeforeAdding) {
            DB.qr().update("DELETE FROM playservice_location_agecategories" + this.postfix + " WHERE location = " + location.getId());
        }
        for (Integer agecategory : agecategories) {
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT ");
            sb.append("INTO ");
            sb.append("playservice_location_agecategories").append(this.postfix);
            sb.append("(");
            sb.append("location,");
            sb.append("pa_id,");
            sb.append("agecategory)");
            sb.append("VALUES( ");
            sb.append(location.getId());
            sb.append(",");
            sb.append(location.getPa_id());
            sb.append(",");
            sb.append(agecategory);
            sb.append(");");
            DB.qr().insert(sb.toString(), (ResultSetHandler)new ScalarHandler());
        }
    }

    public void saveLocationTypes(Set<Integer> types, Integer locationId) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List o = (List)DB.qr().query("SELECT category from playservice_location_categories WHERE location = ?", (ResultSetHandler)rsh, new Object[]{locationId});
        for (Object[] objects : o) {
            Integer cat = (Integer)objects[0];
            types.remove(cat);
        }
        for (Integer type : types) {
            if (type == null) continue;
            this.saveLocationType(type, locationId, null);
        }
    }

    private void saveLocationType(Integer categoryId, Location location) throws NamingException, SQLException, UnsupportedEncodingException {
        this.saveLocationType(categoryId, location.getId(), location.getPa_id());
    }

    private void saveLocationType(Integer categoryId, Integer locationId, String pa_id) throws NamingException, SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT ");
        sb.append("INTO ");
        sb.append("playservice_location_categories").append(this.postfix);
        sb.append("(");
        sb.append("location,");
        sb.append("pa_id,");
        sb.append("category)");
        sb.append("VALUES( ");
        sb.append(locationId).append(",");
        sb.append(pa_id).append(",");
        sb.append(categoryId);
        sb.append(");");
        DB.qr().insert(sb.toString(), (ResultSetHandler)new ScalarHandler());
    }

    protected boolean locationExists(Location location) throws NamingException, SQLException {
        return this.getLocationId(location) != null;
    }

    protected Integer getLocationId(Location location) throws NamingException, SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("select id from ");
        sb.append("playservice_locations").append(this.postfix);
        if (location.getPm_guid() != null) {
            sb.append(" where pm_guid = '");
            sb.append(location.getPm_guid());
        } else if (location.getPa_id() != null) {
            sb.append(" where pa_id = '");
            sb.append(location.getPa_id());
        } else {
            throw new IllegalArgumentException("No id found on location (either pa_id or pm_guid was not set)");
        }
        sb.append("';");
        Integer id = (Integer)DB.qr().query(sb.toString(), (ResultSetHandler)new ScalarHandler());
        return id;
    }

    protected Integer getLocationId(Comment comment) throws NamingException, SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("select id from ");
        sb.append("playservice_locations").append(this.postfix);
        if (comment.getPost_id() == null) {
            throw new IllegalArgumentException("No id found on location (either pa_id or pm_guid was not set)");
        }
        sb.append(" where pa_id = '");
        sb.append(comment.getPost_id());
        sb.append("';");
        Integer id = (Integer)DB.qr().query(sb.toString(), (ResultSetHandler)new ScalarHandler());
        return id;
    }

    public void saveFacilities(Location location, Integer facilityId) throws NamingException, SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT ");
        sb.append("INTO ");
        sb.append("playservice_location_facilities").append(this.postfix);
        sb.append("(");
        sb.append("location,");
        sb.append("pa_id,");
        sb.append("facility)");
        sb.append("VALUES( ");
        sb.append(location.getId()).append(",");
        sb.append(location.getPa_id()).append(",");
        sb.append(facilityId);
        sb.append(");");
        DB.qr().insert(sb.toString(), (ResultSetHandler)new ScalarHandler());
    }

    public void saveAccessibility(Integer locationId, Integer id) throws NamingException, SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT ");
        sb.append("INTO ");
        sb.append("playservice_location_accessibility").append(this.postfix);
        sb.append("(");
        sb.append("location,");
        sb.append("accessibility)");
        sb.append("VALUES( ");
        sb.append(locationId).append(",");
        sb.append(id);
        sb.append(");");
        DB.qr().insert(sb.toString(), (ResultSetHandler)new ScalarHandler());
    }

    public void saveAsset(Asset asset, ImportReport report) throws NamingException, SQLException {
        StringBuilder sb;
        Integer id = null;
        Object geom = null;
        try {
            geom = this.geometryConverter.createNativePoint(asset.getLatitude(), asset.getLongitude(), 4326);
        }
        catch (ParseException ex) {
            log.error((Object)"Cannot parse geometry", (Throwable)ex);
        }
        catch (NullPointerException ex) {
            log.info((Object)"no geom for asset");
        }
        if (this.assetExists(asset)) {
            id = this.getAssetId(asset);
            sb = new StringBuilder();
            sb.append("UPDATE ").append("playservice_location_equipment").append(this.postfix);
            sb.append(" set installeddate = ?,");
            sb.append("location = ?,");
            sb.append("name = ?,");
            sb.append("type_ = ?,");
            sb.append("equipment = ?,");
            sb.append("latitude = ?,");
            sb.append("longitude = ?,");
            sb.append("priceindexation = ?,");
            sb.append("priceinstallation = ?,");
            sb.append("pricemaintenance = ?,");
            sb.append("pricepurchase = ?,");
            sb.append("pricereinvestment = ?,");
            sb.append("depth = ?,");
            sb.append("width = ?,");
            sb.append("height = ?,");
            sb.append("endoflifeyear = ?,");
            sb.append("freefallheight = ?,");
            sb.append("safetyzonelength = ?,");
            sb.append("safetyzonewidth = ?,");
            sb.append("manufacturer = ?,");
            sb.append("material = ?,");
            sb.append("product = ?,");
            sb.append("productid = ?,");
            sb.append("productvariantid = ?,");
            sb.append("serialnumber = ?,");
            sb.append("geom = ?,");
            sb.append("pa_guid = ?,");
            sb.append("pm_guid = ?");
            sb.append(" WHERE id = ").append(id);
            DB.qr().update(sb.toString(), new Object[]{asset.getInstalleddate(), asset.getLocation(), asset.getName(), asset.getType_(), asset.getEquipment(), asset.getLatitude(), asset.getLongitude(), asset.getPriceindexation(), asset.getPriceinstallation(), asset.getPricemaintenance(), asset.getPricepurchase(), asset.getPricereinvestment(), asset.getDepth(), asset.getWidth(), asset.getHeight(), asset.getEndoflifeyear(), asset.getFreefallheight(), asset.getSafetyzonelength(), asset.getSafetyzonewidth(), asset.getManufacturer(), asset.getMaterial(), asset.getProduct(), asset.getProductid(), asset.getProductvariantid(), asset.getSerialnumber(), geom, asset.getPa_guid(), asset.getPm_guid()});
            report.increaseUpdated(ImportReport.ImportType.ASSET);
        } else {
            sb = new StringBuilder();
            sb.append("INSERT ");
            sb.append("INTO ");
            sb.append("playservice_location_equipment").append(this.postfix);
            sb.append("(");
            sb.append("installeddate,");
            sb.append("location,");
            sb.append("name,");
            sb.append("type_,");
            sb.append("equipment,");
            sb.append("latitude,");
            sb.append("longitude,");
            sb.append("priceindexation,");
            sb.append("priceinstallation,");
            sb.append("pricemaintenance,");
            sb.append("pricepurchase,");
            sb.append("pricereinvestment,");
            sb.append("depth,");
            sb.append("width,");
            sb.append("height,");
            sb.append("endoflifeyear,");
            sb.append("freefallheight,");
            sb.append("safetyzonelength,");
            sb.append("safetyzonewidth,");
            sb.append("manufacturer,");
            sb.append("material,");
            sb.append("product,");
            sb.append("productid,");
            sb.append("productvariantid,");
            sb.append("serialnumber,");
            sb.append("geom,");
            sb.append("pa_guid,");
            sb.append("pm_guid) ");
            sb.append("VALUES(  ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);");
            Asset as = (Asset)DB.qr().insert(sb.toString(), this.assHandler, new Object[]{asset.getInstalleddate(), asset.getLocation(), asset.getName(), asset.getType_(), asset.getEquipment(), asset.getLatitude(), asset.getLongitude(), asset.getPriceindexation(), asset.getPriceinstallation(), asset.getPricemaintenance(), asset.getPricepurchase(), asset.getPricereinvestment(), asset.getDepth(), asset.getWidth(), asset.getHeight(), asset.getEndoflifeyear(), asset.getFreefallheight(), asset.getSafetyzonelength(), asset.getSafetyzonewidth(), asset.getManufacturer(), asset.getMaterial(), asset.getProduct(), asset.getProductid(), asset.getProductvariantid(), asset.getSerialnumber(), geom, asset.getPa_guid(), asset.getPm_guid()});
            id = as.getId();
            report.increaseInserted(ImportReport.ImportType.ASSET);
        }
        this.saveAssetsAgeCategories(asset, id);
        Integer locationId = asset.getLocation();
        this.saveImagesAndWords(asset.getImages(), id, locationId, "playservice_images" + this.postfix, true, null);
        this.saveImagesAndWords(asset.getDocuments(), id, locationId, "playservice_documents" + this.postfix, true, null);
    }

    public void saveAssetsAgeCategories(Asset asset, Integer assetId) throws NamingException, SQLException {
        DB.qr().update("DELETE FROM playservice_location_equipment_agecategories" + this.postfix + " WHERE location_equipment = " + assetId);
        for (Integer agecategory : asset.getAgecategories()) {
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT ");
            sb.append("INTO ");
            sb.append("playservice_location_equipment_agecategories").append(this.postfix);
            sb.append("(");
            sb.append("location_equipment,");
            sb.append("agecategory)");
            sb.append("VALUES( ");
            sb.append(assetId);
            sb.append(",");
            sb.append(agecategory);
            sb.append(");");
            DB.qr().insert(sb.toString(), (ResultSetHandler)new ScalarHandler());
        }
    }

    protected boolean assetExists(Asset asset) {
        return this.getAssetId(asset) != null;
    }

    protected Integer getAssetId(Asset asset) {
        try {
            Asset o;
            if (asset.getPm_guid() == null) {
                if (asset.getLocation() == null || asset.getEquipment() == null) {
                    return null;
                }
                Integer equipment = asset.getEquipment();
                StringBuilder sb = new StringBuilder();
                sb.append("select * from ");
                sb.append("playservice_location_equipment").append(this.postfix);
                sb.append(" where location = ? and equipment = ?");
                o = (Asset)DB.qr().query(sb.toString(), this.assHandler, new Object[]{asset.getLocation(), equipment});
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("select * from ");
                sb.append("playservice_location_equipment").append(this.postfix);
                sb.append(" where pm_guid = '");
                sb.append(asset.getPm_guid());
                sb.append("';");
                o = (Asset)DB.qr().query(sb.toString(), this.assHandler);
            }
            return o != null ? o.getId() : null;
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot query if asset exists: ", (Throwable)ex);
            return null;
        }
    }

    public void saveComment(Comment comment, ImportReport report) throws NamingException, SQLException {
        Integer id = null;
        BeanHandler handler = new BeanHandler(Comment.class);
        Integer locationid = comment.getLocation_id();
        if (locationid == null) {
            locationid = this.getLocationId(comment);
            comment.setLocation_id(locationid);
        }
        if (locationid != null) {
            if (this.commentExists(comment)) {
                id = this.getCommentId(comment);
                StringBuilder sb = new StringBuilder();
                sb.append("UPDATE ").append("playservice_comment").append(this.postfix);
                sb.append(" set playadvisor_id = ?,");
                sb.append("post_id = ?,");
                sb.append("location = ?,");
                sb.append("content = ?,");
                sb.append("stars = ?,");
                sb.append("author = ?,");
                sb.append("date = ?");
                sb.append(" WHERE id = ").append(id);
                DB.qr().update(sb.toString(), new Object[]{comment.getPlayadvisor_id(), comment.getPost_id(), locationid, comment.getContent(), comment.getStars(), comment.getAuthor(), comment.getDate()});
                report.increaseUpdated(ImportReport.ImportType.COMMENT);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("INSERT ");
                sb.append("INTO ");
                sb.append("playservice_comment").append(this.postfix);
                sb.append("(");
                sb.append("playadvisor_id,");
                sb.append("post_id,");
                sb.append("location,");
                sb.append("content,");
                sb.append("stars,");
                sb.append("author,");
                sb.append("date) ");
                sb.append("VALUES( ?,?,?,?,?,?,?);");
                Comment cm = (Comment)DB.qr().insert(sb.toString(), (ResultSetHandler)handler, new Object[]{comment.getPlayadvisor_id(), comment.getPost_id(), locationid, comment.getContent(), comment.getStars(), comment.getAuthor(), comment.getDate()});
                id = cm.getId();
                report.increaseInserted(ImportReport.ImportType.COMMENT);
            }
        } else {
            report.addError("Commentaar van onbekende locatie", ImportReport.ImportType.COMMENT);
        }
    }

    private boolean commentExists(Comment comment) throws NamingException, SQLException {
        return this.getCommentId(comment) != null;
    }

    private Integer getCommentId(Comment comment) throws NamingException, SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("select id from ");
        sb.append("playservice_comment").append(this.postfix);
        if (comment.getPlayadvisor_id() == null) {
            throw new IllegalArgumentException("No id found on location (either pa_id or pm_guid was not set)");
        }
        sb.append(" where playadvisor_id = ");
        sb.append(comment.getPlayadvisor_id());
        sb.append(";");
        Integer id = (Integer)DB.qr().query(sb.toString(), (ResultSetHandler)new ScalarHandler());
        return id;
    }

    protected Integer getAssetType(String type) {
        Integer id = (Integer)this.assetTypes.get(type);
        return id;
    }

    protected Integer getEquipmentType(String type) {
        Integer id = (Integer)this.equipmentTypes.get(type);
        return id;
    }

    public void saveImagesAndWords(List<Map<String, Object>> images, Integer assetId, Integer locationId, String table, boolean removeBeforeAdding, Location l) throws NamingException, SQLException {
        if (removeBeforeAdding) {
            if (assetId != null) {
                DB.qr().update("DELETE FROM " + table + " WHERE equipment = " + assetId);
            } else if (l != null && l.getPa_id() != null && !l.getPa_id().isEmpty()) {
                DB.qr().update("DELETE FROM " + table + " WHERE pa_id = '" + l.getPa_id() + "'");
            }
        }
        if (images != null) {
            for (Map<String, Object> image : images) {
                StringBuilder sb = new StringBuilder();
                sb.append("INSERT ");
                sb.append("INTO ");
                sb.append(table);
                sb.append("(");
                sb.append("caption,");
                sb.append("url,");
                sb.append("location,");
                sb.append("equipment,");
                sb.append("pm_guid,");
                sb.append("pa_id,");
                sb.append("lastupdated)");
                sb.append("VALUES(?,?,?,?,?,?,?);");
                Date sqldate = image.containsKey("LastUpdated") && !image.get("LastUpdated").equals("") ? new Date(((java.util.Date)image.get("LastUpdated")).getTime()) : null;
                DB.qr().insert(sb.toString(), (ResultSetHandler)new ScalarHandler(), new Object[]{image.get("Description"), image.get("URI"), locationId, assetId, image.get("ID"), image.get("pa_id"), sqldate});
            }
        }
    }

    public String getPostfix() {
        return this.postfix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponse(String username, String password, String apiurl, ImportReport report) {
        RequestConfig defaultRequestConfig = RequestConfig.custom().setStaleConnectionCheckEnabled(false).setTargetPreferredAuthSchemes(Arrays.asList("Basic")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).setConnectionRequestTimeout(60).build();
        HttpClientBuilder hcb = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig);
        HttpClientContext httpContext = HttpClientContext.create();
        if (username != null && password != null) {
            String hostname = null;
            int port = -1;
            String scheme = "http";
            try {
                URL aURL = new URL(apiurl);
                hostname = aURL.getHost();
                port = aURL.getPort();
                scheme = aURL.getProtocol();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(username, password);
            AuthScope authScope = new AuthScope(hostname, port);
            credentialsProvider.setCredentials(authScope, (Credentials)defaultcreds);
            hcb = hcb.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            if (hostname != null) {
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                HttpHost targetHost = new HttpHost(hostname, port, scheme);
                authCache.put(targetHost, (AuthScheme)basicAuth);
                httpContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
                httpContext.setAuthCache((AuthCache)authCache);
                log.debug((Object)("Preemptive credentials: hostname: " + hostname + ", port: " + port + ", username: " + username + ", password: ****."));
            }
        }
        CloseableHttpClient hc = hcb.build();
        HttpGet request = new HttpGet(apiurl);
        request.setHeader("Accept-Language", "NL");
        request.setHeader("Accept", "application/json");
        String stringResult = null;
        HttpResponse response = null;
        try {
            response = hc.execute((HttpUriRequest)request, (HttpContext)httpContext);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            if (statusCode != 200) {
                report.addError("Could not retrieve JSON. Status " + statusCode + ". Reason given: " + response.getStatusLine().getReasonPhrase(), ImportReport.ImportType.GENERAL);
            } else {
                stringResult = EntityUtils.toString((HttpEntity)entity);
            }
        }
        catch (IOException ex) {
            log.debug((Object)"Exception False: ", (Throwable)ex);
            report.addError("Could not retrieve JSON." + ex.getLocalizedMessage(), ImportReport.ImportType.GENERAL);
        }
        finally {
            if (hc instanceof CloseableHttpClient) {
                try {
                    hc.close();
                }
                catch (IOException ex) {
                    log.info((Object)("Error closing HttpClient: " + ex.getLocalizedMessage()));
                }
            }
            if (response instanceof CloseableHttpResponse) {
                try {
                    ((CloseableHttpResponse)response).close();
                }
                catch (IOException ex) {
                    log.info((Object)("Error closing HttpResponse: " + ex.getLocalizedMessage()));
                }
            }
        }
        return stringResult;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }
}

