/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase.stripes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.EnumeratedTypeConverter;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import nl.b3p.playbase.cron.CronListener;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.CronJob;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.quartz.CronExpression;
import org.quartz.SchedulerException;

@StrictBinding
@UrlBinding(value="/action/cron/{$event}")
public class CronActionBean
implements ActionBean {
    private ResultSetHandler<CronJob> cronHandler = new BeanHandler(CronJob.class);
    private static final Log log = LogFactory.getLog(CronActionBean.class);
    private ActionBeanContext context;
    private static final String JSP = "/WEB-INF/jsp/admin/cron/cron.jsp";
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Validate
    private Integer cronjobid;
    @ValidateNestedProperties(value={@Validate(field="cronexpressie"), @Validate(field="username"), @Validate(field="password"), @Validate(field="mailaddress"), @Validate(field="exporthash"), @Validate(field="baseurl"), @Validate(field="project"), @Validate(field="id"), @Validate(field="type_", converter=EnumeratedTypeConverter.class, required=true, on={"save"})})
    private CronJob cronjob = new CronJob();

    @DefaultHandler
    public Resolution view() {
        if (this.cronjobid != null) {
            try {
                this.cronjob = (CronJob)DB.qr().query("SELECT id,cronexpressie,type_,username,password,project,log,lastrun,mailaddress,baseurl,exporthash from cronjob WHERE id = ?", this.cronHandler, new Object[]{this.cronjobid});
            }
            catch (SQLException | NamingException ex) {
                log.error((Object)"Cannot load cronjob", (Throwable)ex);
            }
        }
        return new ForwardResolution(JSP);
    }

    public Resolution nieuw() {
        this.cronjob = new CronJob();
        this.cronjobid = null;
        return this.view();
    }

    public Resolution removeCron() {
        try {
            CronListener.unscheduleJob((CronJob)this.cronjob);
            DB.qr().query("delete from cronjob WHERE id = ?", this.cronHandler, new Object[]{this.cronjob.getId()});
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot delete cronjob", (Throwable)ex);
            this.context.getValidationErrors().add("cronjob", (ValidationError)new SimpleError("Error deleting:", new Object[]{ex.getLocalizedMessage()}));
        }
        return this.nieuw();
    }

    public Resolution runNow() {
        try {
            CronListener.runNow((CronJob)this.cronjob);
        }
        catch (SchedulerException ex) {
            log.error((Object)"Cannot run cronjob", (Throwable)ex);
            this.context.getValidationErrors().add("cronjob", (ValidationError)new SimpleError("Error running:", new Object[]{ex.getLocalizedMessage()}));
        }
        return this.nieuw();
    }

    public Resolution downloadString() {
        MapHandler h = new MapHandler();
        try {
            Map o = (Map)DB.qr().query("SELECT importedstring from cronjob WHERE id = ?", (ResultSetHandler)h, new Object[]{this.cronjob.getId()});
            StreamingResolution res = new StreamingResolution("application/json", (String)o.get("importedstring"));
            res.setFilename(this.cronjob.getType_().toString() + "-" + this.cronjob.getProject() + this.cronjob.getId());
            res.setAttachment(true);
            return res;
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot retrieve string", (Throwable)ex);
            return this.view();
        }
    }

    public Resolution save() {
        if (!CronExpression.isValidExpression((String)this.cronjob.getCronexpressie())) {
            this.context.getValidationErrors().add("cronjob.cronexpressie", (ValidationError)new SimpleError("Cronexpressie niet correct", new Object[0]));
            return this.view();
        }
        try {
            StringBuilder sb = new StringBuilder();
            if (this.cronjob.getId() == null) {
                sb.append("INSERT ");
                sb.append("INTO ");
                sb.append("cronjob");
                sb.append("(");
                sb.append("type_,");
                sb.append("username,");
                sb.append("password,");
                sb.append("project,");
                sb.append("baseurl,");
                sb.append("exporthash,");
                sb.append("mailaddress,");
                sb.append("cronexpressie) ");
                sb.append("VALUES(  ?,?,?,?,?,?,?,?);");
                this.cronjob = (CronJob)DB.qr().insert(sb.toString(), this.cronHandler, new Object[]{this.cronjob.getType_().name(), this.cronjob.getUsername(), this.cronjob.getPassword(), this.cronjob.getProject(), this.cronjob.getBaseurl(), this.cronjob.getExporthash(), this.cronjob.getMailaddress(), this.cronjob.getCronexpressie()});
                CronListener.scheduleJob((CronJob)this.cronjob);
            } else {
                sb.append("update ");
                sb.append("cronjob");
                sb.append(" set ");
                sb.append("type_ = ?,");
                sb.append("username = ?,");
                sb.append("password = ?,");
                sb.append("project = ?,");
                sb.append("mailaddress= ?,");
                sb.append("baseurl= ?,");
                sb.append("exporthash= ?,");
                sb.append("cronexpressie = ?");
                sb.append(" where id = ?");
                DB.qr().update(sb.toString(), new Object[]{this.cronjob.getType_().name(), this.cronjob.getUsername(), this.cronjob.getPassword(), this.cronjob.getProject(), this.cronjob.getMailaddress(), this.cronjob.getBaseurl(), this.cronjob.getExporthash(), this.cronjob.getCronexpressie(), this.cronjob.getId()});
                CronListener.rescheduleJob((CronJob)this.cronjob);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot save cronjob", (Throwable)ex);
            this.context.getValidationErrors().add("cronjob", (ValidationError)new SimpleError("Error saving:", new Object[]{ex.getLocalizedMessage()}));
        }
        catch (SchedulerException ex) {
            Logger.getLogger(CronActionBean.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.view();
    }

    public Resolution tabledata() {
        JSONObject result = new JSONObject();
        GsonBuilder builder = new GsonBuilder();
        builder.serializeSpecialFloatingPointValues();
        Gson gson = builder.create();
        try {
            BeanListHandler handler = new BeanListHandler(CronJob.class);
            String sql = "select id,cronexpressie,type_,username,password,project,log,lastrun from cronjob";
            List jobs = (List)DB.qr().query(sql, (ResultSetHandler)handler);
            JSONArray ar = new JSONArray();
            for (CronJob job : jobs) {
                JSONObject obj = new JSONObject(gson.toJson((Object)job, CronJob.class));
                Date d = CronListener.getNextFireTime((CronJob)job);
                String formattedDate = d != null ? this.sdf.format(d) : "";
                obj.put("next_fire_time", (Object)formattedDate);
                obj.put("lastrun", (Object)obj.optString("lastrun", " - "));
                ar.put((Object)obj);
            }
            result.put("data", (Object)ar);
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot get geometryConverter: ", (Throwable)ex);
            result.put("message", (Object)("Cannot get geometryConverter: " + ex.getLocalizedMessage()));
        }
        StreamingResolution res = new StreamingResolution("application/json", result.toString(4));
        res.setFilename("");
        res.setAttachment(true);
        return res;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public CronJob getCronjob() {
        return this.cronjob;
    }

    public void setCronjob(CronJob cronjob) {
        this.cronjob = cronjob;
    }

    public Integer getCronjobid() {
        return this.cronjobid;
    }

    public void setCronjobid(Integer cronjobid) {
        this.cronjobid = cronjobid;
    }
}

