/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase;

import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import nl.b3p.playbase.ImportReport;
import nl.b3p.playbase.Importer;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Asset;
import nl.b3p.playbase.entities.Location;
import nl.b3p.playbase.stripes.MatchActionBean;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class PlaymappingImporter
extends Importer {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private Map<String, List<Integer>> agecategories;
    private static final Log log = LogFactory.getLog((String)"PlaymappingProcessor");
    private final String AGECATEGORY_TODDLER_KEY = "AgeGroupToddlers";
    private final String AGECATEGORY_JUNIOR_KEY = "AgeGroupJuniors";
    private final String AGECATEGORY_SENIOR_KEY = "AgeGroupSeniors";
    private final String[] AGECATEGORY_TODDLER = new String[]{"0 - 5 jaar"};
    private final String[] AGECATEGORY_JUNIOR = new String[]{"6 - 11 jaar", "12 - 18 jaar"};
    private final String[] AGECATEGORY_SENIOR = new String[]{"Volwassenen", "Senioren"};

    public PlaymappingImporter(String project) {
        super(project);
        ArrayListHandler rsh = new ArrayListHandler();
        try {
            this.agecategories = new HashMap();
            this.agecategories.put("AgeGroupToddlers", new ArrayList());
            this.agecategories.put("AgeGroupJuniors", new ArrayList());
            this.agecategories.put("AgeGroupSeniors", new ArrayList());
            List o = (List)DB.qr().query("SELECT * from playservice_agecategories_list", (ResultSetHandler)rsh);
            for (Object[] cat : o) {
                Integer id = (Integer)cat[0];
                String categorie = (String)cat[1];
                if (Arrays.asList(this.AGECATEGORY_TODDLER).contains(categorie)) {
                    ((List)this.agecategories.get("AgeGroupToddlers")).add(id);
                    continue;
                }
                if (Arrays.asList(this.AGECATEGORY_JUNIOR).contains(categorie)) {
                    ((List)this.agecategories.get("AgeGroupJuniors")).add(id);
                    continue;
                }
                if (Arrays.asList(this.AGECATEGORY_SENIOR).contains(categorie)) {
                    ((List)this.agecategories.get("AgeGroupSeniors")).add(id);
                    continue;
                }
                throw new IllegalArgumentException("Found agecategory in db not defined in code");
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playmapping processor:", (Throwable)ex);
        }
    }

    public void init() {
    }

    public ImportReport processAssets(String assetsString, ImportReport report) throws NamingException, SQLException {
        HashMap assetTypes = new HashMap();
        List assets = this.parseAssets(assetsString, assetTypes);
        for (Asset asset : assets) {
            try {
                this.saveAsset(asset, report);
            }
            catch (IllegalArgumentException | SQLException | NamingException ex) {
                log.error((Object)("Cannot save asset: " + ex.getLocalizedMessage()));
                report.addError(ex.getLocalizedMessage(), ImportReport.ImportType.ASSET);
            }
        }
        return report;
    }

    public void processLocations(String temp, ImportReport report) throws NamingException, SQLException {
        List childLocations = this.parseChildLocations(temp);
        for (Location childLocation : childLocations) {
            childLocation = this.mergeLocation(childLocation);
            this.saveLocation(childLocation, report);
        }
    }

    private Location mergeLocation(Location loc) throws SQLException, NamingException {
        Location merged = this.getMergedLocation(loc);
        if (merged != null) {
            loc = MatchActionBean.mergeLocations((Location)merged, (Location)loc);
        }
        return loc;
    }

    public Location getMergedLocation(Location newLocation) throws NamingException, SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ");
        sb.append("playservice_locations");
        if (newLocation.getId() != null) {
            sb.append(" where id = '");
            sb.append(newLocation.getId());
        } else {
            sb.append(" where pm_guid = '");
            sb.append(newLocation.getPm_guid());
        }
        sb.append("';");
        Location loc = (Location)DB.qr().query(sb.toString(), this.locationHandler);
        return loc;
    }

    protected List<Asset> parseAssets(String assetsString, Map<Integer, Set<Integer>> assetTypes) throws NamingException, SQLException {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        JSONArray assetsArray = new JSONArray(assetsString);
        for (int i = 0; i < assetsArray.length(); ++i) {
            JSONObject asset = assetsArray.getJSONObject(i);
            Integer locationId = this.getLocationId(asset.getString("LocationID"));
            assets.add(this.parseAsset(asset, locationId, assetTypes));
            String linkedAssets = asset.getJSONArray("LinkedAssets").toString();
            assets.addAll(this.parseAssets(linkedAssets, assetTypes));
        }
        return assets;
    }

    protected Asset parseAsset(JSONObject assetJSON, Integer locationId, Map<Integer, Set<Integer>> locationTypes) {
        Asset asset = new Asset();
        asset.setPm_guid(assetJSON.optString("ID"));
        asset.setLocation(locationId);
        asset.setName(assetJSON.optString("Name").replaceAll("'", "''"));
        asset.setType_(this.getAssetType(assetJSON.optString("AssetType")));
        asset.setManufacturer(assetJSON.optString("Manufacturer"));
        asset.setProduct(assetJSON.optString("Product"));
        asset.setSerialnumber(assetJSON.optString("SerialNumber"));
        asset.setMaterial(assetJSON.optString("Material"));
        asset.setInstalleddate(assetJSON.optString("InstalledDate"));
        asset.setEndoflifeyear(Integer.valueOf(assetJSON.optInt("EndOfLifeYear")));
        asset.setProductid(assetJSON.optString("ProductID"));
        asset.setProductvariantid(assetJSON.optString("ProductVariantID"));
        asset.setHeight(Integer.valueOf(assetJSON.optInt("Height")));
        asset.setDepth(Integer.valueOf(assetJSON.optInt("Depth")));
        asset.setWidth(Integer.valueOf(assetJSON.optInt("Width")));
        asset.setFreefallheight(Integer.valueOf(assetJSON.optInt("FreefallHeight")));
        asset.setSafetyzonelength(Integer.valueOf(assetJSON.optInt("SafetyZoneLength")));
        asset.setSafetyzonewidth(Integer.valueOf(assetJSON.optInt("SafetyZoneWidth")));
        asset.setPricepurchase(Integer.valueOf(assetJSON.optInt("PricePurchase")));
        asset.setPriceinstallation(Integer.valueOf(assetJSON.optInt("PriceInstallation")));
        asset.setPricereinvestment(Integer.valueOf(assetJSON.optInt("PriceReInvestment")));
        asset.setPricemaintenance(Integer.valueOf(assetJSON.optInt("PriceMaintenance")));
        asset.setPriceindexation(Integer.valueOf(assetJSON.optInt("PriceIndexation")));
        asset.setLatitude(Double.parseDouble(assetJSON.optString("Lat").replaceAll(",", ".")));
        asset.setLongitude(Double.parseDouble(assetJSON.optString("Lng").replaceAll(",", ".")));
        asset.setDocuments(this.parseImagesAndWords(assetJSON.optJSONArray("Documents")));
        asset.setImages(this.parseImagesAndWords(assetJSON.optJSONArray("Images")));
        asset.setAgecategories(this.parseAgecategories(assetJSON));
        if (!locationTypes.containsKey(locationId)) {
            locationTypes.put(locationId, new HashSet());
        }
        if (asset.getType_() != null) {
            locationTypes.get(locationId).add((Integer)this.assetTypeToLocationCategory.get(asset.getType_()));
        }
        return asset;
    }

    protected Integer[] parseAgecategories(JSONObject assetJSON) {
        boolean toddler = assetJSON.optBoolean("AgeGroupToddlers", false);
        boolean junior = assetJSON.optBoolean("AgeGroupJuniors", false);
        boolean senior = assetJSON.optBoolean("AgeGroupSeniors", false);
        ArrayList agecategoriesList = new ArrayList();
        if (toddler) {
            agecategoriesList.addAll((Collection)this.agecategories.get("AgeGroupToddlers"));
        }
        if (junior) {
            agecategoriesList.addAll((Collection)this.agecategories.get("AgeGroupJuniors"));
        }
        if (senior) {
            agecategoriesList.addAll((Collection)this.agecategories.get("AgeGroupSeniors"));
        }
        return agecategoriesList.toArray(new Integer[0]);
    }

    protected List<Location> parseChildLocations(String locations) {
        ArrayList<Location> locs = new ArrayList<Location>();
        JSONArray childLocations = new JSONArray(locations);
        for (int i = 0; i < childLocations.length(); ++i) {
            JSONObject childLocation = childLocations.getJSONObject(i);
            JSONArray cls = childLocation.getJSONArray("ChildLocations");
            if (cls.length() == 0) {
                locs.add(this.parseLocation(childLocation));
                continue;
            }
            locs.addAll(this.parseChildLocations(cls.toString()));
        }
        return locs;
    }

    protected Location parseLocation(JSONObject json) {
        Location location = new Location();
        location.setPm_guid(json.optString("ID"));
        location.setTitle(json.optString("Name").replaceAll("'", "''"));
        location.setStreet(json.optString("AddressLine1"));
        location.setMunicipality(json.optString("City"));
        location.setArea(json.optString("Area"));
        location.setPostalcode(json.optString("PostCode"));
        String content = json.optString("Notes");
        content = content == null || content.isEmpty() ? null : content;
        location.setPm_content(content);
        location.setLatitude(Double.valueOf(Double.parseDouble(json.optString("Lat").replaceAll(",", "."))));
        location.setLongitude(Double.valueOf(Double.parseDouble(json.optString("Lng").replaceAll(",", "."))));
        location.setDocuments(this.parseImagesAndWords(json.optJSONArray("Documents")));
        location.setImages(this.parseImagesAndWords(json.optJSONArray("Images")));
        return location;
    }

    protected List<Map<String, Object>> parseImagesAndWords(JSONArray images) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < images.length(); ++i) {
            JSONObject img = images.getJSONObject(i);
            Map image = this.parseImageAndWord(img);
            list.add(image);
        }
        return list;
    }

    protected Map<String, Object> parseImageAndWord(JSONObject image) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("$id", image.optString("$id"));
        map.put("ID", image.optString("ID"));
        String url = image.optString("URI");
        url = url.replaceAll("&w=350&h=350", "");
        map.put("URI", url);
        map.put("Description", image.optString("Description"));
        try {
            map.put("LastUpdated", image.has("LastUpdated") ? this.sdf.parse(image.getString("LastUpdated")) : null);
        }
        catch (ParseException ex) {
            log.debug((Object)("Cannot parse date: " + image.getString("LastUpdated")), (Throwable)ex);
        }
        return map;
    }

    protected Integer getLocationId(String pmguid) throws NamingException, SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("select id from ");
        sb.append("playservice_locations");
        sb.append(" where pm_guid = '");
        sb.append(pmguid);
        sb.append("';");
        Integer id = (Integer)DB.qr().query(sb.toString(), (ResultSetHandler)new ScalarHandler());
        return id;
    }

    public void importString(String stringResult, String apiurl, ImportReport report) throws NamingException, SQLException {
        if (stringResult != null) {
            ImportReport.ImportType type;
            if (apiurl.contains("Location")) {
                this.processLocations(stringResult, report);
                type = ImportReport.ImportType.LOCATION;
            } else if (apiurl.contains("Asset")) {
                this.processAssets(stringResult, report);
                type = ImportReport.ImportType.ASSET;
            } else {
                throw new IllegalArgumentException("Wrong url selected");
            }
            report.setImportedstring(type, stringResult);
        }
    }

    public ImportReport importJSONFromAPI(String username, String password, String apiurl) throws SQLException, NamingException {
        ImportReport report = new ImportReport();
        String stringResult = this.getResponse(username, password, apiurl, report);
        this.importString(stringResult, apiurl, report);
        return report;
    }
}

