/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.regex.Pattern;

public class CsvOutputStream
extends OutputStream {
    private static final char QUOTE = '\"';
    private static final String NEWLINE = "\n";
    private OutputStreamWriter output;
    private char separator;
    private boolean quoteAlways;
    private Pattern pattern;

    public CsvOutputStream(OutputStreamWriter output) {
        this(output, ',', false);
    }

    public CsvOutputStream(OutputStreamWriter output, char separator, boolean quoteAlways) {
        this.output = output;
        this.separator = separator;
        this.quoteAlways = quoteAlways;
        String regexp = ".*([^\\p{ASCII}]|[\\r\\n\\x" + Integer.toHexString(34) + "\\x" + Integer.toHexString(separator) + "])+.*";
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }

    private void writeValue(String value) throws IOException {
        if (value == null) {
            value = this.quoteAlways ? "\"\"" : "";
        } else if (this.quoteAlways) {
            value = '\"' + value.replaceAll("\\x" + Integer.toHexString(34), "\"\"") + '\"';
        }
        this.output.write(value);
    }

    public void writeRecord(String[] values) throws IOException {
        boolean first = true;
        for (int i = 0; i < values.length; ++i) {
            if (first) {
                first = false;
            } else {
                this.output.write(this.separator);
            }
            this.writeValue(values[i]);
        }
        this.output.write(NEWLINE);
    }

    public static void main(String[] args) throws IOException {
        CsvOutputStream csv = new CsvOutputStream(new OutputStreamWriter(System.out));
        csv.writeRecord(new String[]{"test", "t\"est", "t\u00e9st", "\"", "\"\"", "\"test\"", "te\nst", "te,st"});
        csv.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.output.write(b);
    }
}

