/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase.stripes;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.commons.csv.CsvOutputStream;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.loader.util.DbUtilsGeometryColumnConverter;
import nl.b3p.playbase.ImageDownloader;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Asset;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@StrictBinding
@UrlBinding(value="/action/export")
public class ExportActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(ExportActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/admin/export/csv.jsp";
    private static final String SEPERATOR_CHAR = ",";
    private ActionBeanContext context;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private Map<Integer, String> equipmentTypes;
    private Map<Integer, Integer> assetTypes;
    private Map<Integer, Integer> assetTypeToLocationCategory;
    protected Map<Integer, List<String>> locationTypes;
    private Integer[] excl = new Integer[]{58, 60, 61, 93, 22, 7, 56, 64, 177, 81, 82, 125, 87, 88, 89, 90, 92, 178, 111, 110, 109, 108, 127, 15, 23, 31, 32, 83, 171, 156, 155, 69, 68, 59, 152, 145, 144, 143, 141, 140, 139, 120, 119, 118, 117, 116, 115};
    private List<Integer> excludedAssetTypes = Arrays.asList(this.excl);
    @Validate
    private String locationName;
    @Validate
    private String downloadlocation;
    @Validate
    private String project;

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution(JSP);
    }

    public Resolution export() throws IOException, SQLException, NamingException {
        File f = File.createTempFile("locations_export", null);
        FileOutputStream fop = new FileOutputStream(f);
        CsvOutputStream out = new CsvOutputStream(new OutputStreamWriter(fop), '|', false);
        this.initLists();
        String[] header = new String[]{"id", "Titel", "Content", "Samenvatting", "Latitude", "Longitude", "Straat", "Huisnummer", "Huisnummertoevoeging", "Postcode 4 cijfers", "Plaats", "Regio", "Land", "Website", "E-mail", "Telefoon", "Playadvisor id", "Image URL", "Image Caption", "Image Id", "Categorie", "Leeftijdscategorie", "Toegankelijkheid", "Faciliteiten", "Parkeren", "Assets", "newPlayGround"};
        out.writeRecord(header);
        List records = this.getRecords();
        for (List record : records) {
            this.retrieveImages(Integer.valueOf(Integer.parseInt((String)record.get(0))));
            String[] ar = new String[]{};
            ar = record.toArray(ar);
            out.writeRecord(ar);
        }
        out.flush();
        String filename = "Speeltuinen.csv";
        return new /* Unavailable Anonymous Inner Class!! */.setAttachment(true).setFilename(filename);
    }

    private void getAllImagesForJob(String project, ImageDownloader downloader) {
        try {
            String query = "SELECT id from playservice_locations";
            ArrayListHandler rsh = new ArrayListHandler();
            query = query + " where project = ?";
            List locations = (List)DB.qr().query(query, (ResultSetHandler)rsh, new Object[]{project});
            for (Object[] location : locations) {
                Integer id = (Integer)location[0];
                this.retrieveImages(id);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot get locations for cronjob", (Throwable)ex);
        }
    }

    protected void retrieveImages(Integer id) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List images = (List)DB.qr().query("SELECT url, caption,pm_guid from playservice_images WHERE location = ? order by equipment desc, lastupdated desc", (ResultSetHandler)rsh, new Object[]{id});
        int index = 0;
        for (Object[] image : images) {
            String url = (String)this.valueOrEmptyString(image[0]);
            if (url.isEmpty()) continue;
            String imageName = url.substring(url.lastIndexOf("/") + 1);
            if (imageName.contains("GetImage.ashx")) {
                imageName = "Image" + id + "-" + index + ".jpg";
            }
            ++index;
        }
    }

    private List<List<String>> getRecords() {
        try {
            ArrayList<List<String>> records = new ArrayList<List<String>>();
            ArrayListHandler rsh = new ArrayListHandler();
            String query = "SELECT id, coalesce(pa_title,title),coalesce(pm_content, pa_content),summary, latitude,longitude,street,number, numberextra,postalcode,municipality,    area,   coalesce(country,'Nederland'),website,email, phone, pa_id from playservice_locations";
            List locations = null;
            if (this.locationName != null) {
                query = query + " where pa_title like ? or title like ?";
                String wildcard = "%" + this.locationName + "%";
                locations = (List)DB.qr().query(query, (ResultSetHandler)rsh, new Object[]{wildcard, wildcard});
            } else if (this.project != null) {
                query = query + " where project = ?";
                locations = (List)DB.qr().query(query, (ResultSetHandler)rsh, new Object[]{this.project});
            } else {
                locations = (List)DB.qr().query(query, (ResultSetHandler)rsh);
            }
            for (Object[] location : locations) {
                records.add(this.getRecord(location));
            }
            return records;
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot get locations: ", (Throwable)ex);
            return null;
        }
    }

    private List<String> getRecord(Object[] location) throws NamingException, SQLException {
        ArrayList<String> record = new ArrayList<String>();
        Integer id = null;
        int index = 0;
        int[] indexOfContentColumn = new int[]{2, 6};
        for (Object col : location) {
            Object value;
            if (id == null) {
                id = (Integer)col;
            }
            if ((value = col) == null) {
                record.add(null);
            } else {
                String valueString = value.toString();
                if (ArrayUtils.contains((int[])indexOfContentColumn, (int)index)) {
                    valueString = valueString.replace("\n", "").replace("\r", "");
                }
                record.add(valueString);
            }
            ++index;
        }
        this.retrieveReferencedTables(id, record);
        return record;
    }

    protected void retrieveReferencedTables(Integer id, List<String> record) throws NamingException, SQLException {
        this.retrieveImages(id, record);
        this.retrieveCategories(id, record);
        this.retrieveAgeCategories(id, record);
        this.retrieveAccessibilities(id, record);
        this.retrieveFacilities(id, record);
        this.retrieveParking(id, record);
        this.retrieveAssets(id, record);
        this.retrieveYoungestAssetDate(id, record);
    }

    private void retrieveAssets(Integer id, List<String> record) throws NamingException, SQLException {
        try (Connection con = DB.getConnection();){
            GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
            BeanListHandler assHandler = new BeanListHandler(Asset.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
            List assets = (List)DB.qr().query("SELECT * FROM playservice_location_equipment WHERE location = ?", (ResultSetHandler)assHandler, new Object[]{id});
            HashSet<String> equipments = new HashSet<String>();
            for (Asset asset : assets) {
                Integer type = asset.getType_();
                Integer equipment = (Integer)this.assetTypes.get(type);
                String eq = (String)this.equipmentTypes.get(equipment);
                if (eq == null) continue;
                equipments.add(eq);
            }
            String equipmentTypeString = "";
            for (String assetType : equipments) {
                if (equipmentTypeString.length() != 0) {
                    equipmentTypeString = equipmentTypeString + SEPERATOR_CHAR;
                }
                equipmentTypeString = equipmentTypeString + assetType;
            }
            record.add(equipmentTypeString);
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot get geometryConverter: ", (Throwable)ex);
        }
    }

    private void retrieveYoungestAssetDate(Integer id, List<String> record) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List m = (List)DB.qr().query("select installeddate from playservice_location_equipment where  location = " + id, (ResultSetHandler)rsh);
        int numNew = 0;
        Calendar c = Calendar.getInstance();
        c.add(1, -2);
        Date mustBeAfter = c.getTime();
        for (Object[] asset : m) {
            String d = (String)asset[0];
            if (d == null || d.equals("")) continue;
            try {
                Date date = this.sdf.parse(d);
                if (!mustBeAfter.before(date)) continue;
                ++numNew;
            }
            catch (ParseException ex) {
                log.debug((Object)("Cannot parse date: " + d), (Throwable)ex);
            }
        }
        double ratio = (double)numNew / (double)m.size();
        Boolean isNew = ratio > 0.3;
        record.add(isNew.toString());
    }

    protected void retrieveParking(Integer id, List<String> record) throws NamingException, SQLException {
        MapHandler rsh = new MapHandler();
        Map m = (Map)DB.qr().query("SELECT park.parking from playservice_locations loc inner join playservice_parking_list park on loc.parking = park.id", (ResultSetHandler)rsh);
        if (m != null) {
            record.add((String)m.get("parking"));
        } else {
            record.add(null);
        }
    }

    protected void retrieveFacilities(Integer id, List<String> record) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List facilities = (List)DB.qr().query("SELECT cat.facility from playservice_location_facilities loc inner join playservice_facilities_list as cat on cat.id = loc.facility  WHERE location = " + id, (ResultSetHandler)rsh);
        String facilitiesString = "";
        for (Object[] fac : facilities) {
            if (!facilitiesString.isEmpty()) {
                facilitiesString = facilitiesString + SEPERATOR_CHAR;
            }
            facilitiesString = facilitiesString + fac[0];
        }
        record.add(facilitiesString);
    }

    protected void retrieveAccessibilities(Integer id, List<String> record) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List cats = (List)DB.qr().query("SELECT cat.accessibility from playservice_location_accessibility loc inner join playservice_accessibility_list as cat on cat.id = loc.accessibility  WHERE location = " + id, (ResultSetHandler)rsh);
        String categories = "";
        for (Object[] cat : cats) {
            if (!categories.isEmpty()) {
                categories = categories + SEPERATOR_CHAR;
            }
            categories = categories + cat[0];
        }
        record.add(categories);
    }

    protected void retrieveAgeCategories(Integer id, List<String> record) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List cats = (List)DB.qr().query("SELECT cat.agecategory from playservice_location_agecategories loc inner join playservice_agecategories_list as cat on cat.id = loc.agecategory  WHERE location = " + id, (ResultSetHandler)rsh);
        String categories = "";
        for (Object[] cat : cats) {
            if (!categories.isEmpty()) {
                categories = categories + SEPERATOR_CHAR;
            }
            categories = categories + cat[0];
        }
        record.add(categories);
    }

    protected void retrieveCategories(Integer id, List<String> record) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List cats = (List)DB.qr().query("SELECT cat.main, cat.category from playservice_location_categories loc inner join playservice_categories_list cat on cat.id = loc.category  WHERE location = " + id, (ResultSetHandler)rsh);
        String categories = "";
        HashSet<String> types = new HashSet<String>();
        for (Object[] cat : cats) {
            if (!categories.isEmpty()) {
                categories = categories + SEPERATOR_CHAR;
            }
            types.add((String)cat[0]);
            types.add((String)cat[1]);
        }
        try (Connection con = DB.getConnection();){
            GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
            BeanListHandler assHandler = new BeanListHandler(Asset.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
            List assets = (List)DB.qr().query("SELECT * FROM playservice_location_equipment WHERE location = ?", (ResultSetHandler)assHandler, new Object[]{id});
            for (Asset asset : assets) {
                Integer type = asset.getType_();
                if (this.excludedAssetTypes.contains(type) || type == null) continue;
                Integer eq = (Integer)this.assetTypeToLocationCategory.get(type);
                List locCats = (List)this.locationTypes.get(eq);
                types.addAll(locCats);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot get geometryConverter: ", (Throwable)ex);
        }
        categories = types.isEmpty() ? "Openbare speeltuin" : String.join((CharSequence)SEPERATOR_CHAR, types);
        record.add(categories);
    }

    protected void retrieveImages(Integer id, List<String> record) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List images = (List)DB.qr().query("SELECT url, caption,pm_guid from playservice_images WHERE location = ? order by equipment desc, lastupdated desc", (ResultSetHandler)rsh, new Object[]{id});
        String urls = "";
        String captions = "";
        String ids = "";
        int index = 0;
        for (Object[] image : images) {
            String imageName;
            String url = (String)this.valueOrEmptyString(image[0]);
            if (url.isEmpty()) continue;
            if (!urls.isEmpty()) {
                urls = urls + SEPERATOR_CHAR;
                captions = captions + SEPERATOR_CHAR;
                ids = ids + SEPERATOR_CHAR;
            }
            if ((imageName = url.substring(url.lastIndexOf("/") + 1)).contains("GetImage.ashx")) {
                imageName = "Image" + id + "-" + index + ".jpg";
            }
            urls = urls + imageName;
            captions = captions + this.valueOrEmptyString(image[1]);
            ids = ids + this.valueOrEmptyString(image[2]);
            ++index;
        }
        record.add(urls);
        record.add(captions);
        record.add(ids);
    }

    private Object valueOrEmptyString(Object value) {
        return value == null ? "" : value;
    }

    private void initLists() {
        Integer id;
        List o;
        ArrayListHandler rsh = new ArrayListHandler();
        try {
            this.equipmentTypes = new HashMap();
            o = (List)DB.qr().query("SELECT id, equipment from playservice_equipment_list", (ResultSetHandler)rsh);
            for (Object[] type : o) {
                id = (Integer)type[0];
                String cat = (String)type[1];
                this.equipmentTypes.put(id, cat);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playmapping assettypes:", (Throwable)ex);
        }
        try {
            this.locationTypes = new HashMap();
            o = (List)DB.qr().query("SELECT id, category, main from playservice_categories_list", (ResultSetHandler)rsh);
            for (Object[] type : o) {
                id = (Integer)type[0];
                String category = (String)type[1];
                String main = (String)type[2];
                this.locationTypes.put(id, new ArrayList());
                ((List)this.locationTypes.get(id)).add(category);
                ((List)this.locationTypes.get(id)).add(main);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playadvisor location types:", (Throwable)ex);
        }
        try {
            this.assetTypes = new HashMap();
            this.assetTypeToLocationCategory = new HashMap();
            o = (List)DB.qr().query("SELECT id, equipment_type, locationcategory from playmapping_type_group", (ResultSetHandler)rsh);
            for (Object[] type : o) {
                id = (Integer)type[0];
                Integer equipmentType = (Integer)type[1];
                Integer locationcategory = (Integer)type[2];
                this.assetTypes.put(id, equipmentType);
                this.assetTypeToLocationCategory.put(id, locationcategory);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playmapping assettypes:", (Throwable)ex);
        }
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public String getDownloadlocation() {
        return this.downloadlocation;
    }

    public void setDownloadlocation(String downloadlocation) {
        this.downloadlocation = downloadlocation;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    static /* synthetic */ ActionBeanContext access$000(ExportActionBean x0) {
        return x0.context;
    }
}

