/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.naming.NamingException;
import nl.b3p.commons.csv.CsvFormatException;
import nl.b3p.commons.csv.CsvInputStream;
import nl.b3p.playbase.ImportReport;
import nl.b3p.playbase.Importer;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Asset;
import nl.b3p.playbase.entities.Comment;
import nl.b3p.playbase.entities.Location;
import nl.b3p.playbase.stripes.MatchActionBean;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlayadvisorImporter
extends Importer {
    private static final Log LOG = LogFactory.getLog((String)"PlayadvisorProcesor");
    private final Map<Integer, String> playadvisorColumnToPlaybase;
    private static final String LOCATIONSUBTYPE = "locationsubtype";
    private static final String FACILITIES = "facilities";
    private static final String ACCESSIBLITIY = "accessibility";
    private static final String AGECATEGORIES = "agecategories";
    private Map<String, String> parkingMapping;

    public PlayadvisorImporter(String project) {
        super(project);
        this.postfix = "_playadvisor";
        this.playadvisorColumnToPlaybase = new HashMap();
        this.playadvisorColumnToPlaybase.put(0, "pa_id");
        this.playadvisorColumnToPlaybase.put(1, "pa_title");
        this.playadvisorColumnToPlaybase.put(2, "content");
        this.playadvisorColumnToPlaybase.put(3, "summary");
        this.playadvisorColumnToPlaybase.put(4, "");
        this.playadvisorColumnToPlaybase.put(5, "locationtype");
        this.playadvisorColumnToPlaybase.put(6, "website");
        this.playadvisorColumnToPlaybase.put(7, "imageurl");
        this.playadvisorColumnToPlaybase.put(8, "imagetitle");
        this.playadvisorColumnToPlaybase.put(9, "imagecaption");
        this.playadvisorColumnToPlaybase.put(10, "imagedescription");
        this.playadvisorColumnToPlaybase.put(11, "imagealttext");
        this.playadvisorColumnToPlaybase.put(12, "url");
        this.playadvisorColumnToPlaybase.put(13, LOCATIONSUBTYPE);
        this.playadvisorColumnToPlaybase.put(14, "country");
        this.playadvisorColumnToPlaybase.put(15, "municipality");
        this.playadvisorColumnToPlaybase.put(16, "assets");
        this.playadvisorColumnToPlaybase.put(17, FACILITIES);
        this.playadvisorColumnToPlaybase.put(18, AGECATEGORIES);
        this.playadvisorColumnToPlaybase.put(19, "parking");
        this.playadvisorColumnToPlaybase.put(20, ACCESSIBLITIY);
        this.playadvisorColumnToPlaybase.put(21, "ambassadors");
        this.playadvisorColumnToPlaybase.put(22, "average_rating");
        this.playadvisorColumnToPlaybase.put(23, "Lng");
        this.playadvisorColumnToPlaybase.put(24, "Lat");
        this.playadvisorColumnToPlaybase.put(25, "Phone");
        this.playadvisorColumnToPlaybase.put(26, "Street");
        this.playadvisorColumnToPlaybase.put(27, "Postcode");
        this.playadvisorColumnToPlaybase.put(49, "PlaybaseID");
        this.parkingMapping = new HashMap();
        this.parkingMapping.put("Betaald", "ja - betaald");
        this.parkingMapping.put("Gratis", "ja - gratis");
        ((Map)this.locationTypes.get("Speeltuinen")).put("Indoor speeltuin", ((Map)this.locationTypes.get("Speeltuinen")).get("Binnenspeeltuin"));
    }

    public void init(String[] header) {
    }

    public void importComments(InputStream in, ImportReport report) throws IOException, CsvFormatException {
        CsvInputStream cis = new CsvInputStream((Reader)new InputStreamReader(in));
        String[] s = null;
        while ((s = cis.readRecord()).length <= 1) {
        }
        try {
            while ((s = cis.readRecord()) != null) {
                Comment c = this.processComment(s, report);
                this.saveComment(c, report);
                if (c != null) continue;
                boolean bl = false;
            }
        }
        catch (SQLException | NamingException ex) {
            LOG.error((Object)"Cannot save location to db: ", (Throwable)ex);
            report.addError(ex.getLocalizedMessage(), ImportReport.ImportType.COMMENT);
        }
    }

    public void importStream(InputStream in, ImportReport report) throws IOException, CsvFormatException {
        CsvInputStream cis = new CsvInputStream((Reader)new InputStreamReader(in));
        String[] s = null;
        while ((s = cis.readRecord()).length <= 1) {
        }
        this.init(s);
        try {
            while ((s = cis.readRecord()) != null) {
                Location l = this.processRecord(s, report);
                if (l != null) continue;
                boolean bl = false;
            }
        }
        catch (SQLException | NamingException ex) {
            LOG.error((Object)"Cannot save location to db: ", (Throwable)ex);
            report.addError(ex.getLocalizedMessage(), ImportReport.ImportType.LOCATION);
        }
    }

    protected Location processRecord(String[] s, ImportReport report) throws NamingException, SQLException, UnsupportedEncodingException {
        Map locationMap = this.parseRecord(s);
        Location location = null;
        try {
            location = this.parseMap(locationMap);
        }
        catch (IllegalArgumentException e) {
            report.addError(e.getLocalizedMessage(), ImportReport.ImportType.LOCATION);
            return null;
        }
        Location existingLocation = this.getMergedLocation(location);
        String prevPostfix = this.postfix;
        boolean locationAlreadyMerged = existingLocation != null;
        boolean locationAlreadyExists = false;
        if (locationAlreadyMerged) {
            existingLocation.setImages(location.getImages());
            MatchActionBean.mergeLocations((Location)location, (Location)existingLocation);
            location = existingLocation;
            this.postfix = "";
            DB.qr().update("DELETE FROM playservice_location_agecategories WHERE pa_id = ?", (Object)location.getPa_id());
            DB.qr().update("DELETE FROM playservice_location_categories WHERE pa_id = ?", (Object)location.getPa_id());
            DB.qr().update("delete from playservice_location_equipment where location = ? and pa_guid = ? and pm_guid is null", new Object[]{location.getId(), location.getPa_id()});
            locationAlreadyExists = true;
        } else {
            Location existingLoc = this.getExistingLocation(location);
            locationAlreadyExists = existingLoc != null;
        }
        int id = this.saveLocation(location, report);
        List assets = this.parseAssets(location, locationMap, locationAlreadyMerged);
        for (Asset asset : assets) {
            this.saveAsset(asset, report);
        }
        this.saveLocationAgeCategory(location, Arrays.asList(location.getAgecategories()), locationAlreadyExists);
        try {
            if (((String)locationMap.get(LOCATIONSUBTYPE)).length() > 0) {
                this.saveLocationType((String)locationMap.get(LOCATIONSUBTYPE), location, locationAlreadyExists);
            }
        }
        catch (IllegalArgumentException ex) {
            report.addError(ex.getLocalizedMessage() + ". Location is saved, but type is not.", ImportReport.ImportType.LOCATION);
        }
        try {
            if (((String)locationMap.get(FACILITIES)).length() > 0) {
                this.saveFacilities(location, (String)locationMap.get(FACILITIES), locationAlreadyExists);
            }
        }
        catch (IllegalArgumentException ex) {
            report.addError(ex.getLocalizedMessage() + ". Location is saved, but facilities are not.", ImportReport.ImportType.LOCATION);
        }
        try {
            if (((String)locationMap.get(ACCESSIBLITIY)).length() > 0) {
                this.saveAccessibility(Integer.valueOf(id), (String)locationMap.get(ACCESSIBLITIY));
            }
        }
        catch (IllegalArgumentException ex) {
            report.addError(ex.getLocalizedMessage() + ". Location is saved, but accessiblity is not.", ImportReport.ImportType.LOCATION);
        }
        this.postfix = prevPostfix;
        return location;
    }

    public Location getMergedLocation(Location newLocation) throws NamingException, SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ");
        sb.append("playservice_locations");
        if (newLocation.getId() != null) {
            sb.append(" where id = '");
            sb.append(newLocation.getId());
        } else {
            sb.append(" where pa_id = '");
            sb.append(newLocation.getPa_id());
        }
        sb.append("';");
        Location loc = (Location)DB.qr().query(sb.toString(), this.locationHandler);
        return loc;
    }

    public Location getExistingLocation(Location newLocation) throws NamingException, SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ");
        sb.append("playservice_locations").append(this.postfix);
        if (newLocation.getId() != null) {
            sb.append(" where id = '");
            sb.append(newLocation.getId());
        } else {
            sb.append(" where pa_id = '");
            sb.append(newLocation.getPa_id());
        }
        sb.append("';");
        Location loc = (Location)DB.qr().query(sb.toString(), this.locationHandler);
        return loc;
    }

    protected Map<String, Object> parseRecord(String[] record) {
        HashMap<String, Object> dbvalues = new HashMap<String, Object>();
        String[] imageUrls = null;
        String[] imageDescriptions = null;
        for (int i = 0; i < record.length; ++i) {
            String val = record[i];
            String col = (String)this.playadvisorColumnToPlaybase.get(i);
            String value = this.sanitizeValue(val);
            if (col == null) continue;
            switch (col) {
                case "imageurl": {
                    imageUrls = val.split("\\|");
                    break;
                }
                case "imagetitle": {
                    break;
                }
                case "imagecaption": {
                    break;
                }
                case "imagedescription": {
                    imageDescriptions = val.split("\\|");
                    break;
                }
                case "imagealttext": {
                    break;
                }
                case "assets": {
                    break;
                }
                case "facilities": {
                    break;
                }
                case "accessiblity": {
                    break;
                }
                case "Lng": 
                case "Lat": {
                    value = val == null || val.isEmpty() ? null : Double.valueOf(Double.parseDouble(val));
                    break;
                }
                case "average_rating": 
                case "PlaybaseID": {
                    value = val == null || val.isEmpty() ? null : Integer.valueOf(Integer.parseInt(val));
                    break;
                }
            }
            dbvalues.put(col, value);
        }
        List images = this.parseImages(imageUrls, imageDescriptions, (String)dbvalues.get("pa_id"));
        dbvalues.put("images", images);
        return dbvalues;
    }

    protected Location parseMap(Map<String, Object> lM) {
        Location l = new Location();
        l.setPa_id((String)lM.get("pa_id"));
        l.setArea((String)lM.get("area"));
        l.setCountry((String)lM.get("country"));
        l.setPa_content((String)lM.get("content"));
        l.setEmail((String)lM.get("e-mail"));
        l.setImages((List)lM.get("images"));
        l.setDocuments((List)lM.get("documents"));
        l.setMunicipality((String)lM.get("municipality"));
        l.setNumber((String)lM.get("number"));
        l.setNumberextra((String)lM.get("NumberExtra"));
        l.setPhone((String)lM.get("Phone"));
        l.setPostalcode((String)lM.get("Postcode"));
        l.setStreet((String)lM.get("Street"));
        l.setSummary((String)lM.get("Excerpt"));
        l.setPa_title((String)lM.get("pa_title"));
        l.setTitle((String)lM.get("pa_title"));
        l.setWebsite((String)lM.get("website"));
        l.setLatitude(lM.get("Lat") != null ? (Double)lM.get("Lat") : null);
        l.setLongitude(lM.get("Lng") != null ? (Double)lM.get("Lng") : null);
        l.setAveragerating(Integer.valueOf(lM.get("average_rating") != null ? (Integer)lM.get("average_rating") : 0));
        String parking = (String)lM.get("parking");
        l.setParking((Integer)this.parkingTypes.get(this.parkingMapping.get(parking)));
        String agecats = (String)lM.get(AGECATEGORIES);
        String[] agecategories = agecats.split("\\|");
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (String agecategory : agecategories) {
            if (agecategory.length() <= 0) continue;
            Integer id = (Integer)this.agecategoryTypes.get(agecategory.toLowerCase());
            if (id == null) {
                throw new IllegalArgumentException("Agecategory >" + agecategory + "< does not exist. Location with title >" + l.getTitle() + "< not saved.");
            }
            ids.add(id);
        }
        l.setAgecategories(ids.toArray(new Integer[0]));
        l.setId((Integer)lM.get("PlaybaseID"));
        return l;
    }

    private List<Asset> parseAssets(Location location, Map<String, Object> locationMap, boolean merged) throws NamingException, SQLException {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        String assetString = (String)locationMap.get("assets");
        String[] assetArray = assetString.split("\\|");
        List<String> paAssets = Arrays.asList(assetArray);
        if (merged) {
            ArrayList<String> nieuwList = new ArrayList<String>();
            List prevAssets = (List)DB.qr().query("SELECT * FROM playservice_location_equipment WHERE location = ?", this.assListHandler, new Object[]{location.getId()});
            for (String paAsset : assetArray) {
                boolean found = false;
                Integer paEquipmentType = (Integer)this.equipmentTypes.get(paAsset);
                for (Asset prevAsset : prevAssets) {
                    Integer pmEquipmentType = (Integer)this.equipmenttypePMtoPA.get(prevAsset.getType_());
                    if (!Objects.equals(paEquipmentType, pmEquipmentType)) continue;
                    found = true;
                    prevAsset.setPa_guid(location.getPa_id());
                    assets.add(prevAsset);
                    break;
                }
                if (found) continue;
                nieuwList.add(paAsset);
            }
            paAssets = nieuwList;
        }
        for (String asset : paAssets) {
            Asset ass = new Asset();
            ass.setName(asset);
            ass.setPa_guid(location.getPa_id());
            ass.setLocation(location.getId());
            ass.setLatitude(location.getLatitude().doubleValue());
            ass.setLongitude(location.getLongitude().doubleValue());
            Integer[] cats = location.getAgecategories();
            ass.setAgecategories(cats);
            Integer equipmentType = this.getEquipmentType(asset);
            ass.setEquipment(equipmentType);
            ass.setType_((Integer)this.equipmenttypePAtoPM.get(equipmentType));
            assets.add(ass);
        }
        return assets;
    }

    private List<Map<String, Object>> parseImages(String[] imageUrls, String[] imageDescriptions, String pa_id) {
        ArrayList<Map<String, Object>> images = new ArrayList<Map<String, Object>>();
        HashSet<String> urls = new HashSet<String>();
        for (int i = 0; i < imageUrls.length; ++i) {
            String imageUrl = imageUrls[i];
            if (urls.contains(imageUrl)) continue;
            urls.add(imageUrl);
            String description = imageDescriptions.length == imageUrls.length ? imageDescriptions[i] : null;
            Map image = this.parseImage(imageUrl, description, pa_id);
            images.add(image);
        }
        return images;
    }

    private Map<String, Object> parseImage(String imageUrl, String imageDescription, String pa_id) {
        HashMap<String, Object> image = new HashMap<String, Object>();
        image.put("Description", imageDescription);
        image.put("URI", imageUrl);
        image.put("pa_id", pa_id);
        return image;
    }

    private Comment processComment(String[] s, ImportReport report) throws NamingException, SQLException {
        Comment c = new Comment();
        c.setPlayadvisor_id(Integer.valueOf(Integer.parseInt(s[0])));
        c.setContent(s[2]);
        c.setDate(s[8]);
        c.setPost_id(Integer.valueOf(Integer.parseInt(s[4])));
        c.setAuthor(s[5]);
        Integer stars = s[3].isEmpty() ? null : Integer.valueOf(Integer.parseInt(s[3]));
        c.setStars(stars);
        return c;
    }

    private String sanitizeValue(String value) {
        String[] valuesToReplace = new String[]{"\u0083", "\u0082", "\u00c3", "\u00c2"};
        String sanitized = value;
        for (String replace : valuesToReplace) {
            sanitized = sanitized.replaceAll(replace, "");
        }
        return sanitized;
    }

    protected void saveFacilities(Location location, String facilitiesString, boolean deleteFirst) throws NamingException, SQLException {
        String[] facilities;
        if (deleteFirst) {
            DB.qr().update("DELETE FROM playservice_location_facilities" + this.postfix + " WHERE location = " + location.getId());
        }
        for (String facility : facilities = facilitiesString.split("\\|")) {
            Integer facilityId = (Integer)this.facilityTypes.get(facility);
            if (facilityId == null) {
                throw new IllegalArgumentException("Unknown facility given: " + facility + ". Cannot save facilities for location with id: " + location.getId());
            }
            this.saveFacilities(location, facilityId);
        }
    }

    protected void saveAccessibility(Integer locationId, String accessiblitiesString) throws NamingException, SQLException {
        String[] accessibilities;
        DB.qr().update("DELETE FROM playservice_location_accessibility" + this.postfix + " WHERE location = " + locationId);
        for (String accessiblity : accessibilities = accessiblitiesString.split("\\|")) {
            String acc = accessiblity.toLowerCase();
            acc = acc.contains(">") ? acc.substring(acc.indexOf(">") + 1) : acc;
            Integer id = (Integer)this.accessibilityTypes.get(acc);
            if (id == null) {
                throw new IllegalArgumentException("Unknown accessibilty given: " + acc + ". Cannot save types for location with id: " + locationId);
            }
            this.saveAccessibility(locationId, id);
        }
    }

    protected void saveLocationType(String typeString, Location location, boolean deleteFirst) throws NamingException, SQLException, UnsupportedEncodingException {
        if (deleteFirst) {
            DB.qr().update("DELETE FROM playservice_location_categories" + this.postfix + " WHERE location = " + location.getId());
        }
        String[] types = typeString.split("\\|");
        HashSet<Integer> typeSet = new HashSet<Integer>();
        for (String type : types) {
            Integer categoryId;
            String category;
            String main;
            int index = type.indexOf(">");
            if (index == -1) {
                main = type;
                category = type;
            } else {
                main = type.substring(0, index);
                category = type.substring(index + 1);
            }
            main = StringEscapeUtils.unescapeHtml4((String)main);
            Integer n = categoryId = this.locationTypes.containsKey(main) ? (Integer)((Map)this.locationTypes.get(main)).get(category) : null;
            if (categoryId == null) {
                throw new IllegalArgumentException("Unknown category given: main:" + main + ", subcategory: " + category + ". Cannot save types for location with id: " + location.getId());
            }
            typeSet.add(categoryId);
        }
        this.saveLocationTypes(typeSet, location.getId());
    }
}

