/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase.stripes;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Set;
import javax.naming.NamingException;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.playbase.ImportReport;
import nl.b3p.playbase.PlaymappingImporter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@StrictBinding
@UrlBinding(value="/action/importPlaymapping")
public class ImportPlaymappingActionBean
implements ActionBean {
    private ActionBeanContext context;
    private static final Log log = LogFactory.getLog(ImportPlaymappingActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/admin/import/playmapping.jsp";
    @Validate
    private String locationGuid;
    @Validate(required=true)
    private String username;
    @Validate(required=true)
    private String password;
    @Validate(required=true)
    private String apiurl;
    @Validate
    private String file;
    @Validate
    private String project;
    private PlaymappingImporter processor;

    @DefaultHandler
    @DontValidate
    public Resolution edit() throws Exception {
        return new ForwardResolution(JSP);
    }

    public Resolution importPM() throws NamingException, SQLException {
        ImportReport report = new ImportReport();
        this.processor = new PlaymappingImporter(this.project);
        this.processor.init();
        if (this.file.equalsIgnoreCase("Via API")) {
            if (this.getApiurl().contains("Location")) {
                this.processor.importJSONLocationsFromAPI(this.getUsername(), this.getPassword(), this.getApiurl(), report);
            } else {
                this.processor.importJSONAssetsFromAPI(this.getUsername(), this.getPassword(), this.getApiurl(), new ArrayList(), report);
            }
        } else {
            try {
                InputStream in = ImportPlaymappingActionBean.class.getResourceAsStream(this.file);
                String theString = IOUtils.toString((InputStream)in, (String)"UTF-8");
                in.close();
                this.processor.importString(theString, this.apiurl, report);
            }
            catch (IOException ex) {
                log.error((Object)ex);
                return new ForwardResolution(JSP);
            }
        }
        this.context.getMessages().add(new SimpleMessage("Er zijn " + report.getNumberInserted(ImportReport.ImportType.ASSET) + " " + ImportReport.ImportType.ASSET.toString() + " weggeschreven.", new Object[0]));
        this.context.getMessages().add(new SimpleMessage("Er zijn " + report.getNumberInserted(ImportReport.ImportType.LOCATION) + " " + ImportReport.ImportType.LOCATION.toString() + " weggeschreven.", new Object[0]));
        this.context.getMessages().add(new SimpleMessage("Er zijn " + report.getNumberUpdated(ImportReport.ImportType.ASSET) + " " + ImportReport.ImportType.ASSET.toString() + " geupdatet.", new Object[0]));
        this.context.getMessages().add(new SimpleMessage("Er zijn " + report.getNumberUpdated(ImportReport.ImportType.LOCATION) + " " + ImportReport.ImportType.LOCATION.toString() + " geupdatet.", new Object[0]));
        if (report.getErrors().size() > 0) {
            this.context.getMessages().add(new SimpleMessage("Er zijn " + report.getErrors(ImportReport.ImportType.ASSET).size() + " " + ImportReport.ImportType.ASSET.toString() + " mislukt:", new Object[0]));
            this.context.getMessages().add(new SimpleMessage("Er zijn " + report.getErrors(ImportReport.ImportType.LOCATION).size() + " " + ImportReport.ImportType.LOCATION.toString() + " mislukt:", new Object[0]));
            for (ImportReport.ImportType importType : report.getAllErrors().keySet()) {
                Set errors = (Set)report.getAllErrors().get(importType);
                for (String error : errors) {
                    this.context.getMessages().add(new SimpleMessage(importType.toString() + ": " + error, new Object[0]));
                }
            }
        }
        return new ForwardResolution(JSP);
    }

    public String getLocationGuid() {
        return this.locationGuid;
    }

    public void setLocationGuid(String locationGuid) {
        this.locationGuid = locationGuid;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getApiurl() {
        return this.apiurl;
    }

    public void setApiurl(String apiurl) {
        this.apiurl = apiurl;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }
}

