/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import nl.b3p.playbase.ImportReport;
import nl.b3p.playbase.Importer;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Asset;
import nl.b3p.playbase.entities.Location;
import nl.b3p.playbase.entities.Project;
import nl.b3p.playbase.stripes.MatchActionBean;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class PlaymappingImporter
extends Importer {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private Map<String, List<Integer>> agecategories;
    private final Map<String, String> iso3ToCountryName;
    private static final Log log = LogFactory.getLog((String)"PlaymappingProcessor");
    private final String AGECATEGORY_TODDLER_KEY = "AgeGroupToddlers";
    private final String AGECATEGORY_JUNIOR_KEY = "AgeGroupJuniors";
    private final String AGECATEGORY_SENIOR_KEY = "AgeGroupSeniors";
    private final String[] AGECATEGORY_TODDLER = new String[]{"0 - 5 jaar"};
    private final String[] AGECATEGORY_JUNIOR = new String[]{"6 - 11 jaar", "12 - 18 jaar"};
    private final String[] AGECATEGORY_SENIOR = new String[]{"Volwassenen", "Senioren"};

    public PlaymappingImporter(Project project) {
        super(project);
        String[] countries;
        ArrayListHandler rsh = new ArrayListHandler();
        try {
            this.agecategories = new HashMap();
            this.agecategories.put("AgeGroupToddlers", new ArrayList());
            this.agecategories.put("AgeGroupJuniors", new ArrayList());
            this.agecategories.put("AgeGroupSeniors", new ArrayList());
            List o = (List)DB.qr().query("SELECT * from playservice_agecategories_list", (ResultSetHandler)rsh);
            for (Object[] cat : o) {
                Integer id = (Integer)cat[0];
                String categorie = (String)cat[1];
                if (Arrays.asList(this.AGECATEGORY_TODDLER).contains(categorie)) {
                    ((List)this.agecategories.get("AgeGroupToddlers")).add(id);
                    continue;
                }
                if (Arrays.asList(this.AGECATEGORY_JUNIOR).contains(categorie)) {
                    ((List)this.agecategories.get("AgeGroupJuniors")).add(id);
                    continue;
                }
                if (Arrays.asList(this.AGECATEGORY_SENIOR).contains(categorie)) {
                    ((List)this.agecategories.get("AgeGroupSeniors")).add(id);
                    continue;
                }
                throw new IllegalArgumentException("Found agecategory in db not defined in code");
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playmapping processor:", (Throwable)ex);
        }
        this.iso3ToCountryName = new HashMap();
        Locale dutch = new Locale("nl", "NLD");
        for (String country : countries = Locale.getISOCountries()) {
            Locale l = new Locale("nl", country);
            this.iso3ToCountryName.put(l.getISO3Country(), l.getDisplayCountry(dutch));
        }
    }

    public void init() {
    }

    public ImportReport processAssets(JSONArray assetsString, ImportReport report, Connection con) throws NamingException, SQLException {
        HashMap assetTypes = new HashMap();
        List assets = this.parseAssets(assetsString, assetTypes, report, con);
        for (Asset asset : assets) {
            try {
                this.saveAsset(asset, report);
            }
            catch (IllegalArgumentException | SQLException | NamingException ex) {
                log.error((Object)("Cannot save asset: " + ex.getLocalizedMessage()));
                report.addError(ex.getLocalizedMessage(), ImportReport.ImportType.ASSET);
            }
        }
        return report;
    }

    public List<String> processLocations(String temp, ImportReport report, Connection con) throws NamingException, SQLException {
        List childLocations = this.parseChildLocations(temp, report, con);
        ArrayList<String> pm_guids = new ArrayList<String>();
        for (Location childLocation : childLocations) {
            childLocation = this.mergeLocation(childLocation);
            pm_guids.add(childLocation.getPm_guid());
            this.saveLocation(childLocation, report);
        }
        return pm_guids;
    }

    private Location mergeLocation(Location loc) throws SQLException, NamingException {
        Location dbLoc = this.getExistingLocation(loc);
        if (dbLoc != null) {
            dbLoc.setMunicipality(loc.getMunicipality());
            loc = MatchActionBean.mergeLocations((Location)dbLoc, (Location)loc);
        }
        return loc;
    }

    public Location getExistingLocation(Location newLocation) throws NamingException, SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ");
        sb.append("playservice_locations");
        if (newLocation.getId() != null) {
            sb.append(" where id = '");
            sb.append(newLocation.getId());
        } else {
            sb.append(" where pm_guid = '");
            sb.append(newLocation.getPm_guid());
        }
        sb.append("';");
        Location loc = (Location)DB.qr().query(sb.toString(), this.locationHandler);
        return loc;
    }

    protected List<Asset> parseAssets(JSONArray assetsArray, Map<Integer, Set<Integer>> assetTypes, ImportReport report, Connection con) throws NamingException, SQLException {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        for (int i = 0; i < assetsArray.length(); ++i) {
            JSONObject asset = assetsArray.getJSONObject(i);
            JSONObject location = asset.getJSONObject("Location");
            Integer locationId = this.getLocationId(location.getString("ID"));
            assets.add(this.parseAsset(asset, locationId, assetTypes, report, con));
            JSONArray linkedAssets = asset.getJSONArray("LinkedAssets");
            assets.addAll(this.parseAssets(linkedAssets, assetTypes, report, con));
        }
        return assets;
    }

    protected Asset parseAsset(JSONObject assetJSON, Integer locationId, Map<Integer, Set<Integer>> locationTypes, ImportReport report, Connection con) {
        JSONObject material;
        JSONObject product;
        JSONObject manufacturer;
        Asset asset = new Asset();
        asset.setPm_guid(assetJSON.optString("ID"));
        asset.setLocation(locationId);
        asset.setName(assetJSON.optString("Name").replaceAll("'", "''"));
        JSONObject assetType = assetJSON.optJSONObject("AssetType");
        if (assetType != null) {
            asset.setType_(this.getAssetType(assetType.optString("Name")));
        }
        if ((manufacturer = assetJSON.optJSONObject("Manufacturer")) != null) {
            asset.setManufacturer(manufacturer.optString("Name"));
        }
        if ((product = assetJSON.optJSONObject("Product")) != null) {
            asset.setProduct(product.optString("ProductNumber"));
            asset.setSerialnumber(product.optString("SerialNumber"));
            asset.setProductid(product.optString("ID"));
            JSONObject productgroup = product.optJSONObject("ProductGroup");
            if (productgroup != null) {
                asset.setProductvariantid(productgroup.optString("ID"));
            }
        }
        if ((material = assetJSON.optJSONObject("Material")) != null) {
            asset.setMaterial(material.optString("Name"));
        }
        asset.setInstalleddate(assetJSON.optString("InstalledDate"));
        asset.setEndoflifeyear(Integer.valueOf(assetJSON.optInt("EndOfLifeYear")));
        asset.setHeight(Integer.valueOf(assetJSON.optInt("Height")));
        asset.setDepth(Integer.valueOf(assetJSON.optInt("Depth")));
        asset.setWidth(Integer.valueOf(assetJSON.optInt("Width")));
        asset.setFreefallheight(Integer.valueOf(assetJSON.optInt("FreefallHeight")));
        asset.setSafetyzonelength(Integer.valueOf(assetJSON.optInt("SafetyZoneLength")));
        asset.setSafetyzonewidth(Integer.valueOf(assetJSON.optInt("SafetyZoneWidth")));
        asset.setPricepurchase(Integer.valueOf(assetJSON.optInt("PricePurchase")));
        asset.setPriceinstallation(Integer.valueOf(assetJSON.optInt("PriceInstallation")));
        asset.setPricereinvestment(Integer.valueOf(assetJSON.optInt("PriceReInvestment")));
        asset.setPricemaintenance(Integer.valueOf(assetJSON.optInt("PriceMaintenance")));
        asset.setPriceindexation(Integer.valueOf(assetJSON.optInt("PriceIndexation")));
        asset.setLatitude(Double.parseDouble(assetJSON.optString("Lat").replaceAll(",", ".")));
        asset.setLongitude(Double.parseDouble(assetJSON.optString("Lng").replaceAll(",", ".")));
        asset.setRemovedfromplaymapping(assetJSON.optBoolean("Removed", false) || assetJSON.optBoolean("Archived", false));
        asset.setDocuments(this.parseImagesAndWords(assetJSON.optJSONArray("Documents")));
        List images = this.parseImagesAndWords(assetJSON.optJSONArray("Images"));
        this.processImages(locationId, images, report, con, true, asset.isRemovedfromplaymapping());
        asset.setImages(images);
        asset.setAgecategories(this.parseAgecategories(assetJSON));
        if (!locationTypes.containsKey(locationId)) {
            locationTypes.put(locationId, new HashSet());
        }
        if (asset.getType_() != null) {
            locationTypes.get(locationId).add((Integer)this.assetTypeToLocationCategory.get(asset.getType_()));
        }
        return asset;
    }

    protected Integer[] parseAgecategories(JSONObject assetJSON) {
        boolean toddler = assetJSON.optBoolean("AgeGroupToddlers", false);
        boolean junior = assetJSON.optBoolean("AgeGroupJuniors", false);
        boolean senior = assetJSON.optBoolean("AgeGroupSeniors", false);
        ArrayList agecategoriesList = new ArrayList();
        if (toddler) {
            agecategoriesList.addAll((Collection)this.agecategories.get("AgeGroupToddlers"));
        }
        if (junior) {
            agecategoriesList.addAll((Collection)this.agecategories.get("AgeGroupJuniors"));
        }
        if (senior) {
            agecategoriesList.addAll((Collection)this.agecategories.get("AgeGroupSeniors"));
        }
        return agecategoriesList.toArray(new Integer[0]);
    }

    protected List<Location> parseChildLocations(String locations, ImportReport report, Connection con) {
        ArrayList<Location> locs = new ArrayList<Location>();
        JSONArray childLocations = new JSONArray(locations);
        for (int i = 0; i < childLocations.length(); ++i) {
            JSONObject childLocation = childLocations.getJSONObject(i);
            JSONArray cls = childLocation.getJSONArray("ChildLocations");
            if (cls.length() == 0) {
                locs.add(this.parseLocation(childLocation, report, con));
                continue;
            }
            locs.addAll(this.parseChildLocations(cls.toString(), report, con));
        }
        return locs;
    }

    protected Location parseLocation(JSONObject json, ImportReport report, Connection con) {
        Location location = new Location();
        location.setPm_guid(json.optString("ID"));
        location.setTitle(json.optString("Name").replaceAll("'", "''"));
        location.setStreet(json.optString("AddressLine1"));
        location.setMunicipality(json.optString("City"));
        location.setArea(json.optString("Area"));
        location.setPostalcode(json.optString("PostCode"));
        String content = json.optString("Notes");
        content = content == null || content.isEmpty() ? null : content;
        location.setPm_content(content);
        try {
            location.setPm_lastmodified(json.has("LastUpdated") ? this.sdf.parse(json.getString("LastUpdated")) : null);
        }
        catch (ParseException ex) {
            log.error((Object)"Cannot parse last updated field to date", (Throwable)ex);
        }
        location.setLatitude(Double.valueOf(Double.parseDouble(json.optString("Lat").replaceAll(",", "."))));
        location.setLongitude(Double.valueOf(Double.parseDouble(json.optString("Lng").replaceAll(",", "."))));
        location.setRemovedfromplaymapping(Boolean.valueOf(json.optBoolean("Archived", true)));
        String country = (String)this.iso3ToCountryName.get(json.optString("Country", "NLD"));
        location.setCountry(country);
        location.setDocuments(this.parseImagesAndWords(json.optJSONArray("Documents")));
        List images = this.parseImagesAndWords(json.optJSONArray("Images"));
        this.processImages(location.getId(), images, report, con, false, false);
        location.setImages(images);
        return location;
    }

    protected List<Map<String, Object>> parseImagesAndWords(JSONArray images) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < images.length(); ++i) {
            JSONObject img = images.getJSONObject(i);
            Map image = this.parseImageAndWord(img);
            list.add(image);
        }
        return list;
    }

    protected Map<String, Object> parseImageAndWord(JSONObject image) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("$id", image.optString("$id"));
        map.put("ID", image.optString("ID"));
        String url = image.optString("URI");
        url = url.replaceAll("&w=350&h=350", "");
        map.put("URI", url);
        map.put("Description", image.optString("Description"));
        try {
            map.put("LastUpdated", image.has("LastUpdated") ? this.sdf.parse(image.getString("LastUpdated")) : null);
        }
        catch (ParseException ex) {
            log.debug((Object)("Cannot parse date: " + image.getString("LastUpdated")), (Throwable)ex);
        }
        return map;
    }

    protected void processImages(Integer location, List<Map<String, Object>> imgs, ImportReport report, Connection con, boolean isAsset, boolean isAssetRemoved) {
        try {
            ArrayListHandler rsh = new ArrayListHandler();
            String q = "SELECT url, caption,pa_id,id from playservice_images WHERE location = ? and pm_guid is not null ";
            if (isAsset) {
                q = q + "and equipment is not null ";
            }
            q = q + "order by equipment desc, lastupdated desc";
            List images = (List)DB.qr().query(con, q, (ResultSetHandler)rsh, new Object[]{location});
            for (Object[] img : images) {
                boolean found = false;
                String curImgUrl = (String)img[0];
                int curId = (Integer)img[3];
                for (Map<String, Object> pushedImg : imgs) {
                    if (pushedImg.get("Path") == null || !((String)pushedImg.get("Path")).equals(curImgUrl)) continue;
                    found = true;
                    break;
                }
                if (found && !isAssetRemoved) continue;
                int numUpdated = DB.qr().update(con, "UPDATE playservice_images SET pm_deleted = true WHERE id = ?", (Object)curId);
                boolean bl = false;
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot process images", (Throwable)ex);
        }
    }

    protected Integer getLocationId(String pmguid) throws NamingException, SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("select id from ");
        sb.append("playservice_locations");
        sb.append(" where pm_guid = '");
        sb.append(pmguid);
        sb.append("';");
        Integer id = (Integer)DB.qr().query(sb.toString(), (ResultSetHandler)new ScalarHandler());
        return id;
    }

    public ImportReport importJSONAssetsFromAPI(String username, String password, String apiurl, List<String> pm_guids, ImportReport report, Connection con) throws SQLException, NamingException {
        JSONArray results = new JSONArray();
        for (String pm_guid : pm_guids) {
            String url = apiurl + pm_guid;
            String stringResult = this.getResponse(username, password, url, report);
            JSONArray result = new JSONArray(stringResult);
            for (Object next : result) {
                results.put(next);
            }
        }
        this.processAssets(results, report, con);
        ImportReport.ImportType type = ImportReport.ImportType.ASSET;
        report.setImportedstring(type, results.toString());
        return report;
    }

    public List<String> importJSONLocationsFromAPI(String username, String password, String apiurl, ImportReport report, boolean isInitialLoad, Connection con) throws SQLException, NamingException {
        String stringResult = this.getResponse(username, password, apiurl, report);
        if (stringResult == null) {
            return null;
        }
        List locationIds = this.processLocations(stringResult, report, con);
        ImportReport.ImportType type = ImportReport.ImportType.LOCATION;
        report.setImportedstring(type, stringResult);
        return locationIds;
    }
}

