/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.loader.util.DbUtilsGeometryColumnConverter;
import nl.b3p.playbase.ImageDownloader;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Asset;
import nl.b3p.playbase.entities.Location;
import nl.b3p.playbase.entities.Project;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class PlayadvisorExporter {
    private static final Log log = LogFactory.getLog(PlayadvisorExporter.class);
    protected final ResultSetHandler<Project> projectHandler = new BeanHandler(Project.class);
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private final Integer[] excl = new Integer[]{58, 60, 61, 93, 22, 7, 56, 64, 177, 81, 82, 125, 87, 88, 89, 90, 92, 178, 111, 110, 109, 108, 127, 15, 23, 31, 32, 83, 171, 156, 155, 69, 68, 59, 152, 145, 144, 143, 141, 140, 139, 120, 119, 118, 117, 116, 115};
    private final List<Integer> excludedAssetTypes = Arrays.asList(this.excl);
    protected Map<Integer, List<String>> locationTypes;
    private Map<Integer, Integer> assetTypes;
    private Map<Integer, Integer> assetTypeToLocationCategory;
    private Map<Integer, String> equipmentTypes;

    public PlayadvisorExporter() {
        this.initLists();
    }

    public void export(List<Location> locations, Connection con, String baseurl, String authkey) {
        for (Location location : locations) {
            try {
                this.pushLocation(location, con, new HashMap(), baseurl, authkey);
            }
            catch (IOException | SQLException | NamingException ex) {
                log.error((Object)"Error exporting to export", (Throwable)ex);
            }
        }
    }

    public String pushLocations(List<Location> locations, String imagepath, String baseurl, String authkey, ImageDownloader downloader) {
        StringBuilder sb = new StringBuilder();
        try (Connection con = DB.getConnection();){
            downloader.run();
            HashMap<Integer, JSONArray> imagesPerLocation = new HashMap<Integer, JSONArray>();
            for (Location loc : locations) {
                if (loc.getRemovedfromplayadvisor() != null && loc.getRemovedfromplayadvisor().booleanValue() || loc.getRemovedfromplaymapping() != null && loc.getRemovedfromplaymapping().booleanValue()) continue;
                imagesPerLocation.put(loc.getId(), this.retrieveImages(loc.getId(), con, imagepath, downloader));
            }
            downloader.stop();
            for (Location loc : locations) {
                if (loc.getRemovedfromplayadvisor() != null && loc.getRemovedfromplayadvisor().booleanValue() || loc.getRemovedfromplaymapping() != null && loc.getRemovedfromplaymapping().booleanValue()) continue;
                try {
                    sb.append(this.pushLocation(loc, con, imagesPerLocation, baseurl, authkey));
                }
                catch (IOException ex) {
                    log.error((Object)("Cannot push location to playadvisor: " + ex.getLocalizedMessage()));
                    log.debug((Object)ex);
                }
            }
        }
        catch (IOException | SQLException | NamingException ex) {
            log.error((Object)"Cannot push locations to playadvisor", (Throwable)ex);
        }
        return sb.toString();
    }

    public String pushLocation(Location loc, Connection con, HashMap<Integer, JSONArray> imgsPerLoc, String baseurl, String authkey) throws IOException, SQLException, NamingException {
        return this.pushLocation(this.createLocationJSON(loc, con, imgsPerLoc), "", baseurl, authkey);
    }

    public String pushLocation(JSONObject location, String id, String baseurl, String authkey) throws IOException {
        return this.doRequest("", location, baseurl, authkey);
    }

    public void updateIDs(List<Location> locs, Connection con, String baseurl, String authkey) {
        for (Location loc : locs) {
            this.updateId(loc, con, baseurl, authkey);
        }
    }

    public void updateId(Location loc, Connection con, String baseurl, String authkey) {
        try {
            Project project = this.getProject(loc.getProject(), con);
            List images = loc.getImages();
            for (Map image : images) {
                JSONObject payload = new JSONObject();
                payload.put((String)image.get("pa_id"), (Object)((String)image.get("PlaybaseID")));
                try {
                    this.doRequest("update-ids", payload, baseurl, authkey);
                }
                catch (IOException ex) {
                    log.error((Object)("Cannot update image id for imageurl: " + image.get("URI")), (Throwable)ex);
                }
            }
            JSONObject locationPayload = new JSONObject();
            try {
                locationPayload.put(loc.getPa_id(), (Object)loc.getId());
                this.doRequest("update-ids", locationPayload, baseurl, authkey);
            }
            catch (IOException ex) {
                log.error((Object)("Cannot update image id for location: " + loc.getId()), (Throwable)ex);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)("Cannot get project for location " + loc.getId()), (Throwable)ex);
        }
    }

    private void processResponse(JSONObject obj) {
    }

    private String doRequest(String endpoint, JSONObject payload, String baseurl, String authkey) throws IOException {
        String url = baseurl + "/wp-json/b3p/v1/playbase/" + endpoint;
        log.debug((Object)("Do request to playadvisor: " + url + ". With payload: " + payload.toString()));
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost request = new HttpPost(url);
        StringEntity params = new StringEntity(payload.toString(), ContentType.APPLICATION_JSON);
        request.addHeader("content-type", "application/json");
        request.addHeader("Authorization", "Basic " + authkey);
        request.setEntity((HttpEntity)params);
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        StatusLine sl = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        int statusCode = sl.getStatusCode();
        String stringResult = EntityUtils.toString((HttpEntity)entity);
        if (statusCode != 200) {
            String statusLine = response.getStatusLine().getReasonPhrase();
            log.debug((Object)("Error: " + statusLine));
            log.debug((Object)("Error: " + stringResult));
            throw new IOException(statusLine);
        }
        log.debug((Object)("Result: " + stringResult));
        return stringResult;
    }

    public JSONObject createLocationJSON(Location loc, Connection con, HashMap<Integer, JSONArray> imgsPerLoc) throws SQLException, NamingException, IOException {
        JSONObject obj = loc.toPlayadvisorJSON();
        Integer id = loc.getId();
        JSONArray imgs = imgsPerLoc.getOrDefault(loc.getId(), new JSONArray());
        obj.put("Images", (Object)imgs);
        this.retrieveCategories(id, obj, con);
        this.retrieveAssets(id, obj, con);
        this.retrieveAgeCategories(id, obj, con);
        this.retrieveAccessibilities(id, obj, con);
        this.retrieveFacilities(id, obj, con);
        this.retrieveParking(id, obj, con);
        this.retrieveYoungestAssetDate(id, obj, con);
        return obj;
    }

    protected void retrieveParking(Integer id, JSONObject obj, Connection con) throws NamingException, SQLException {
        MapHandler rsh = new MapHandler();
        Map m = (Map)DB.qr().query(con, "SELECT park.parking from playservice_locations loc inner join playservice_parking_list park on loc.parking = park.id", (ResultSetHandler)rsh);
        JSONArray parkings = new JSONArray();
        if (m != null) {
            parkings.put(m.get("parking"));
        }
        obj.put("Parkeren", (Object)parkings);
    }

    protected void retrieveFacilities(Integer id, JSONObject obj, Connection con) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List facilities = (List)DB.qr().query(con, "SELECT cat.facility from playservice_location_facilities loc inner join playservice_facilities_list as cat on cat.id = loc.facility  WHERE location = " + id, (ResultSetHandler)rsh);
        JSONArray facs = new JSONArray();
        for (Object[] cat : facilities) {
            facs.put(cat[0]);
        }
        obj.put("Faciliteiten", (Object)facs);
    }

    protected void retrieveAccessibilities(Integer id, JSONObject obj, Connection con) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List cats = (List)DB.qr().query(con, "SELECT cat.accessibility from playservice_location_accessibility loc inner join playservice_accessibility_list as cat on cat.id = loc.accessibility  WHERE location = " + id, (ResultSetHandler)rsh);
        JSONArray agecats = new JSONArray();
        for (Object[] cat : cats) {
            agecats.put(cat[0]);
        }
        obj.put("Toegankelijkheid", (Object)agecats);
    }

    protected void retrieveAgeCategories(Integer id, JSONObject obj, Connection con) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List cats = (List)DB.qr().query(con, "SELECT cat.agecategory from playservice_location_agecategories loc inner join playservice_agecategories_list as cat on cat.id = loc.agecategory  WHERE location = " + id, (ResultSetHandler)rsh);
        JSONArray agecats = new JSONArray();
        for (Object[] cat : cats) {
            agecats.put(cat[0]);
        }
        obj.put("Leeftijdscategorie", (Object)agecats);
    }

    private void retrieveYoungestAssetDate(Integer id, JSONObject obj, Connection con) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List m = (List)DB.qr().query(con, "select installeddate from playservice_location_equipment where  location = " + id, (ResultSetHandler)rsh);
        int numNew = 0;
        Calendar c = Calendar.getInstance();
        c.add(1, -2);
        Date mustBeAfter = c.getTime();
        for (Object[] asset : m) {
            String d = (String)asset[0];
            if (d == null || d.equals("")) continue;
            try {
                Date date = this.sdf.parse(d);
                if (!mustBeAfter.before(date)) continue;
                ++numNew;
            }
            catch (ParseException ex) {
                log.debug((Object)("Cannot parse date: " + d), (Throwable)ex);
            }
        }
        double ratio = (double)numNew / (double)m.size();
        Boolean isNew = ratio > 0.3;
        obj.put("newPlayGround", (Object)isNew.toString());
    }

    public JSONArray retrieveImages(Integer id, Connection con, String imagepath, ImageDownloader downloader) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List images = (List)DB.qr().query(con, "SELECT url, caption,pa_id,id,pa_url, pa_deleted, pm_deleted from playservice_images WHERE location = ? order by equipment desc, lastupdated desc", (ResultSetHandler)rsh, new Object[]{id});
        JSONArray imgs = new JSONArray();
        int index = 0;
        for (Object[] image : images) {
            String url = (String)this.valueOrEmptyString(image[0]);
            if (url.isEmpty()) continue;
            Boolean pa_deleted = (Boolean)image[5];
            Boolean pm_deleted = (Boolean)image[6];
            if (pa_deleted != null && pa_deleted.booleanValue() || pm_deleted != null && pm_deleted.booleanValue()) {
                ++index;
                continue;
            }
            String imageName = url.substring(url.lastIndexOf("/") + 1);
            if (imageName.contains("GetImage.ashx")) {
                imageName = "Image" + id + "-" + index + ".jpg";
            }
            Integer imageId = (Integer)image[3];
            JSONObject img = new JSONObject();
            img.put("Path", (Object)(imagepath + File.separator + imageName));
            img.put("PlaybaseID", (Object)imageId);
            img.put("PlayadvisorID", this.valueOrEmptyString(image[2]));
            imgs.put((Object)img);
            ++index;
            if (downloader == null) continue;
            downloader.add(url, imageName);
        }
        return imgs;
    }

    private void retrieveAssets(Integer id, JSONObject location, Connection con) throws NamingException, SQLException {
        GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
        BeanListHandler assHandler = new BeanListHandler(Asset.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
        List assets = (List)DB.qr().query(con, "SELECT * FROM playservice_location_equipment WHERE location = ? and removedfromplaymapping = false", (ResultSetHandler)assHandler, new Object[]{id});
        HashSet<String> equipments = new HashSet<String>();
        for (Asset asset : assets) {
            Integer type = asset.getType_();
            Integer equipment = (Integer)this.assetTypes.get(type);
            String eq = (String)this.equipmentTypes.get(equipment);
            if (eq == null) continue;
            equipments.add(eq);
        }
        HashSet<String> types = new HashSet<String>();
        for (String assetType : equipments) {
            types.add(assetType);
        }
        location.put("Assets", (Object)new JSONArray(types));
    }

    protected void retrieveCategories(Integer id, JSONObject location, Connection con) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List cats = (List)DB.qr().query(con, "SELECT cat.main, cat.category from playservice_location_categories loc inner join playservice_categories_list cat on cat.id = loc.category  WHERE location = " + id, (ResultSetHandler)rsh);
        HashSet<String> types = new HashSet<String>();
        for (Object[] cat : cats) {
            types.add((String)cat[0]);
            types.add((String)cat[1]);
        }
        GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
        BeanListHandler assHandler = new BeanListHandler(Asset.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
        List assets = (List)DB.qr().query(con, "SELECT * FROM playservice_location_equipment WHERE location = ? and removedfromplaymapping = false", (ResultSetHandler)assHandler, new Object[]{id});
        for (Asset asset : assets) {
            Integer type = asset.getType_();
            if (this.excludedAssetTypes.contains(type) || type == null) continue;
            Integer eq = (Integer)this.assetTypeToLocationCategory.get(type);
            List locCats = (List)this.locationTypes.get(eq);
            types.addAll(locCats);
        }
        if (types.isEmpty()) {
            types.add("Openbare speeltuin");
        }
        location.put("Categorieen", (Object)new JSONArray(types));
    }

    private void initLists() {
        Integer id;
        List o;
        ArrayListHandler rsh = new ArrayListHandler();
        try {
            this.equipmentTypes = new HashMap();
            o = (List)DB.qr().query("SELECT id, equipment from playservice_equipment_list", (ResultSetHandler)rsh);
            for (Object[] type : o) {
                id = (Integer)type[0];
                String cat = (String)type[1];
                this.equipmentTypes.put(id, cat);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playmapping assettypes:", (Throwable)ex);
        }
        try {
            this.locationTypes = new HashMap();
            o = (List)DB.qr().query("SELECT id, category, main from playservice_categories_list", (ResultSetHandler)rsh);
            for (Object[] type : o) {
                id = (Integer)type[0];
                String category = (String)type[1];
                String main = (String)type[2];
                this.locationTypes.put(id, new ArrayList());
                ((List)this.locationTypes.get(id)).add(category);
                ((List)this.locationTypes.get(id)).add(main);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playadvisor location types:", (Throwable)ex);
        }
        try {
            this.assetTypes = new HashMap();
            this.assetTypeToLocationCategory = new HashMap();
            o = (List)DB.qr().query("SELECT id, equipment_type, locationcategory from playmapping_type_group", (ResultSetHandler)rsh);
            for (Object[] type : o) {
                id = (Integer)type[0];
                Integer equipmentType = (Integer)type[1];
                Integer locationcategory = (Integer)type[2];
                this.assetTypes.put(id, equipmentType);
                this.assetTypeToLocationCategory.put(id, locationcategory);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playmapping assettypes:", (Throwable)ex);
        }
    }

    private Object valueOrEmptyString(Object value) {
        return value == null ? "" : value;
    }

    protected Project getProject(Integer projectID, Connection con) throws NamingException, SQLException {
        Project p = (Project)DB.qr().query(con, "SELECT id,cronexpressie,type_,username,password,name,log,lastrun,mailaddress,baseurl, status, authkey, imagePath from project WHERE id = ?", this.projectHandler, new Object[]{projectID});
        return p;
    }
}

