/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.naming.NamingException;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.loader.util.DbUtilsGeometryColumnConverter;
import nl.b3p.playbase.Exporter;
import nl.b3p.playbase.ImportReport;
import nl.b3p.playbase.PlaymappingBase;
import nl.b3p.playbase.PlaymappingImporter;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Asset;
import nl.b3p.playbase.entities.Location;
import nl.b3p.playbase.entities.Project;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.json.JSONArray;
import org.json.JSONObject;

public class PlaymappingExporter
extends Exporter
implements PlaymappingBase {
    private static final Log log = LogFactory.getLog(PlaymappingExporter.class);
    public final HashMap<String, String> countryToISO = new HashMap();

    public PlaymappingExporter() {
        String[] countries;
        Locale dutch = new Locale("nl", "NLD");
        for (String country : countries = Locale.getISOCountries()) {
            Locale l = new Locale("", country);
            this.countryToISO.put(l.getDisplayCountry(dutch), l.getISO3Country());
        }
    }

    public String postToPlaymapping(Integer locationId, String username, String password, String apiurl, Connection con, Project p) throws NamingException, SQLException {
        String locationResult;
        HttpPost request;
        PlaymappingImporter pi = new PlaymappingImporter(p);
        ImportReport report = new ImportReport();
        GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
        BeanHandler locationHandler = new BeanHandler(Location.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
        Location loc = (Location)DB.qr().query(con, "SELECT * from playservice_locations WHERE id = ?", (ResultSetHandler)locationHandler, new Object[]{locationId});
        JSONObject obj = loc.toPlaymappingJSON(this.countryToISO);
        StringEntity params = new StringEntity(obj.toString(), ContentType.APPLICATION_JSON);
        JSONArray results = new JSONArray();
        if (loc.getPm_guid() == null) {
            request = new HttpPost(apiurl + "CustomerLocation/CreateLocation");
            request.addHeader("content-type", "application/json");
            request.setEntity((HttpEntity)params);
            locationResult = this.getResponse(username, password, apiurl + "CustomerLocation/CreateLocation", report, (HttpRequestBase)request);
            JSONObject locationJSON = new JSONObject(locationResult);
            JSONArray ar = new JSONArray();
            ar.put((Object)locationJSON);
            pi.processLocations(ar.toString(), report, con);
            results.put((Object)locationResult);
        } else {
            request = new HttpPut(apiurl + "CustomerLocation/UpdateLocation/" + loc.getPm_guid());
            request.addHeader("content-type", "application/json");
            request.setEntity((HttpEntity)params);
            locationResult = this.getResponse(username, password, apiurl + "CustomerLocation/UpdateLocation/" + loc.getPm_guid(), report, (HttpRequestBase)request);
            results.put((Object)locationResult);
        }
        BeanListHandler assHandler = new BeanListHandler(Asset.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
        List assets = (List)DB.qr().query(con, "SELECT * FROM playservice_location_equipment WHERE location = ? and removedfromplaymapping = false", (ResultSetHandler)assHandler, new Object[]{locationId});
        for (Asset asset : assets) {
            String assetResult;
            JSONObject assetObj = asset.toJSONObject(loc);
            log.debug((Object)("Payload IS: " + assetObj.toString()));
            StringEntity assetParams = new StringEntity(assetObj.toString(), ContentType.APPLICATION_JSON);
            if (asset.getPm_guid() == null) {
                HttpPost request2 = new HttpPost(apiurl + "CustomerAsset/CreateAsset/CreateAsset");
                request2.addHeader("content-type", "application/json");
                request2.setEntity((HttpEntity)assetParams);
                assetResult = this.getResponse(username, password, apiurl + "CustomerAsset/CreateAsset/CreateAsset", report, (HttpRequestBase)request2);
                JSONObject assetJSON = new JSONObject(assetResult);
                JSONArray ar = new JSONArray();
                ar.put((Object)assetJSON);
                pi.processAssets(ar, report, con);
                results.put((Object)assetResult);
                continue;
            }
            String endpointurl = "CustomerAsset/UpdateAsset/" + asset.getPm_guid();
            HttpPut request3 = new HttpPut(apiurl + endpointurl);
            request3.addHeader("content-type", "application/json");
            request3.setEntity((HttpEntity)assetParams);
            assetResult = this.getResponse(username, password, apiurl + endpointurl, report, (HttpRequestBase)request3);
            results.put((Object)assetResult);
        }
        String s = report.toLog();
        results.put((Object)s);
        return results.toString();
    }
}

