/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase.stripes;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.naming.NamingException;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.loader.util.DbUtilsGeometryColumnConverter;
import nl.b3p.playbase.PlaymappingExporter;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Location;
import nl.b3p.playbase.entities.Project;
import nl.b3p.playbase.stripes.ProjectActionBean;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

@StrictBinding
@UrlBinding(value="/action/exportplaymapping")
public class ExportPlaymappingActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(ProjectActionBean.class);
    private ActionBeanContext context;
    private static final String JSP = "/WEB-INF/jsp/admin/playmapping/view.jsp";
    @Validate
    private Integer location;
    @Validate
    private Integer project;
    private String locationJSON;
    private String result;

    public Integer getLocation() {
        return this.location;
    }

    public void setLocation(Integer location) {
        this.location = location;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getLocationJSON() {
        return this.locationJSON;
    }

    public void setLocationJSON(String locationJSON) {
        this.locationJSON = locationJSON;
    }

    public Integer getProject() {
        return this.project;
    }

    public void setProject(Integer project) {
        this.project = project;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution(JSP);
    }

    public Resolution showJSON() {
        if (this.location != null) {
            try (Connection con = DB.getConnection();){
                GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
                BeanHandler locationHandler = new BeanHandler(Location.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
                Location loc = (Location)DB.qr().query("SELECT * from playservice_locations WHERE id = ?", (ResultSetHandler)locationHandler, new Object[]{this.location});
                PlaymappingExporter pe = new PlaymappingExporter();
                JSONObject obj = loc.toPlaymappingJSON(pe.countryToISO);
                obj = pe.createLocationJSON(obj, loc, con, new HashMap());
                this.locationJSON = obj.toString(4);
            }
            catch (IOException | SQLException | NamingException ex) {
                log.error((Object)"Cannot load cronjob", (Throwable)ex);
            }
        }
        return new ForwardResolution(JSP);
    }

    public Resolution updateLocation() {
        if (this.location != null && this.project != null) {
            try (Connection con = DB.getConnection();){
                BeanHandler projectHandler = new BeanHandler(Project.class);
                Project p = (Project)DB.qr().query(con, "SELECT id,cronexpressie,type_,username,password,name,log,lastrun,mailaddress,baseurl, status,authkey,imagepath from project WHERE id = ?", (ResultSetHandler)projectHandler, new Object[]{this.project});
                PlaymappingExporter pe = new PlaymappingExporter();
                String baseurl = this.context.getServletContext().getInitParameter("playmapping.baseurl");
                this.result = pe.postToPlaymapping(this.location, p.getUsername(), p.getPassword(), baseurl, con, p);
            }
            catch (SQLException | NamingException ex) {
                log.error((Object)"Cannot load cronjob", (Throwable)ex);
            }
        }
        return new ForwardResolution(JSP);
    }
}

