/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase.stripes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.EnumeratedTypeConverter;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import nl.b3p.playbase.ImportReport;
import nl.b3p.playbase.PlayadvisorImporter;
import nl.b3p.playbase.PlaymappingImporter;
import nl.b3p.playbase.WaitPageStatus;
import nl.b3p.playbase.cron.CronListener;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Project;
import nl.b3p.playbase.entities.ProjectType;
import nl.b3p.playbase.entities.Status;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.quartz.CronExpression;
import org.quartz.SchedulerException;
import org.stripesstuff.plugin.waitpage.WaitPage;

@StrictBinding
@UrlBinding(value="/action/project/{$event}")
public class ProjectActionBean
implements ActionBean {
    private ResultSetHandler<Project> projectHandler = new BeanHandler(Project.class);
    private static final Log log = LogFactory.getLog(ProjectActionBean.class);
    private ActionBeanContext context;
    private static final String JSP = "/WEB-INF/jsp/admin/project/view.jsp";
    private static final String WIZARD_NEW_JSP = "/WEB-INF/jsp/admin/project/createNew.jsp";
    private static final String WIZARD_AFTER_INITIAL_IMPORT = "/WEB-INF/jsp/admin/project/afterInitialImport.jsp";
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private WaitPageStatus status;
    @Validate
    private String locationguid;
    @Validate
    private Integer projectid;
    @ValidateNestedProperties(value={@Validate(field="cronexpressie"), @Validate(field="username"), @Validate(field="password"), @Validate(field="mailaddress"), @Validate(field="name"), @Validate(field="id"), @Validate(field="type_", converter=EnumeratedTypeConverter.class, required=true, on={"save"}), @Validate(field="status", converter=EnumeratedTypeConverter.class, required=true, on={"save"})})
    private Project project = new Project();

    @DefaultHandler
    public Resolution view() {
        if (this.projectid != null) {
            try {
                this.project = (Project)DB.qr().query("SELECT id,cronexpressie,type_,username,password,name,log,lastrun,mailaddress,baseurl, status,authkey,imagepath from project WHERE id = ?", this.projectHandler, new Object[]{this.projectid});
            }
            catch (SQLException | NamingException ex) {
                log.error((Object)"Cannot load cronjob", (Throwable)ex);
            }
        }
        return new ForwardResolution(JSP);
    }

    public Resolution nieuw() {
        this.project = new Project();
        this.projectid = null;
        return new ForwardResolution(WIZARD_NEW_JSP);
    }

    public Resolution removeCron() {
        try {
            CronListener.unscheduleJob((Project)this.project);
            DB.qr().update("delete from project WHERE id = ?", (Object)this.project.getId());
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot delete cronjob", (Throwable)ex);
            this.context.getValidationErrors().add("cronjob", (ValidationError)new SimpleError("Error deleting:", new Object[]{ex.getLocalizedMessage()}));
        }
        return this.view();
    }

    public Resolution runNow() {
        try {
            CronListener.runNow((Project)this.project);
        }
        catch (SchedulerException ex) {
            log.error((Object)"Cannot run cronjob", (Throwable)ex);
            this.context.getValidationErrors().add("cronjob", (ValidationError)new SimpleError("Error running:", new Object[]{ex.getLocalizedMessage()}));
        }
        return this.view();
    }

    public Resolution downloadString() {
        MapHandler h = new MapHandler();
        try {
            Map o = (Map)DB.qr().query("SELECT importedstring from project WHERE id = ?", (ResultSetHandler)h, new Object[]{this.project.getId()});
            StreamingResolution res = new StreamingResolution("application/json", (String)o.get("importedstring"));
            res.setFilename(this.project.getType_().toString() + "-" + this.project.getName() + this.project.getId());
            res.setAttachment(true);
            return res;
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot retrieve string", (Throwable)ex);
            return this.view();
        }
    }

    @WaitPage(path="/WEB-INF/jsp/waitpage.jsp", delay=2000, refresh=1000, ajax="/WEB-INF/jsp/waitpageajax.jsp")
    public Resolution saveNew() {
        this.project.setStatus(Status.UNDER_REVIEW);
        if (this.project.getCronexpressie() == null || !CronExpression.isValidExpression((String)this.project.getCronexpressie())) {
            this.context.getValidationErrors().add("cronjob.cronexpressie", (ValidationError)new SimpleError("Cronexpressie niet correct", new Object[0]));
            return this.view();
        }
        this.doSave();
        if (this.context.getValidationErrors().size() > 0) {
            return this.nieuw();
        }
        String baseurl = CronListener.WORDPRESS_BASEURL;
        String authkey = CronListener.AUTHKEY;
        String pmbaseurl = CronListener.PLAYMAPPING_BASEURL;
        this.executeInitialLoad(baseurl, authkey, pmbaseurl);
        return new ForwardResolution(WIZARD_AFTER_INITIAL_IMPORT);
    }

    @WaitPage(path="/WEB-INF/jsp/waitpage.jsp", delay=2000, refresh=1000, ajax="/WEB-INF/jsp/waitpageajax.jsp")
    public Resolution doInitialLoad() {
        String baseurl = CronListener.WORDPRESS_BASEURL;
        String authkey = CronListener.AUTHKEY;
        String pmbaseurl = CronListener.PLAYMAPPING_BASEURL;
        this.executeInitialLoad(baseurl, authkey, pmbaseurl);
        return new ForwardResolution(WIZARD_AFTER_INITIAL_IMPORT);
    }

    public String executeInitialLoad(String wpbaseurl, String authkey, String pmbaseurl) {
        Throwable throwable;
        Connection con;
        this.status = new WaitPageStatus();
        this.status.addLog("Start");
        String logString = "";
        if (this.project.getType_() == ProjectType.IMPORT_PLAYADVISOR || this.project.getType_() == ProjectType.PLAYMAPPING_PLAYADVISOR) {
            this.status.setCurrentAction("Start met laden playadvisor");
            this.status.addLog("Start met laden playadvisor");
            this.status.setProgress(10);
            try {
                con = DB.getConnection();
                throwable = null;
                try {
                    ImportReport report = new ImportReport();
                    PlayadvisorImporter paimporter = new PlayadvisorImporter(this.project);
                    paimporter.initialLoad(this.project, report, con, wpbaseurl, authkey);
                    logString = "Playadvisor:  " + System.lineSeparator() + report.toLog() + System.lineSeparator();
                }
                catch (Throwable report) {
                    throwable = report;
                    throw report;
                }
                finally {
                    if (con != null) {
                        if (throwable != null) {
                            try {
                                con.close();
                            }
                            catch (Throwable report) {
                                throwable.addSuppressed(report);
                            }
                        } else {
                            con.close();
                        }
                    }
                }
            }
            catch (SQLException | NamingException ex) {
                log.error((Object)"Cannot do initial load for playadvisor", (Throwable)ex);
                this.context.getValidationErrors().add("cronjob", (ValidationError)new SimpleError("Error saving:" + ex.getLocalizedMessage(), new Object[0]));
                logString = "Error for playadvisor: " + System.lineSeparator();
                logString = logString + ex.getLocalizedMessage();
            }
            catch (Exception e) {
                log.error((Object)"Cannot process locations: ", (Throwable)e);
            }
        }
        this.status.setProgress(30);
        if (this.project.getType_() == ProjectType.IMPORT_PLAYMAPPING || this.project.getType_() == ProjectType.PLAYMAPPING_PLAYADVISOR) {
            this.status.setCurrentAction("Start met laden playmapping locaties");
            this.status.addLog("Start met laden playmapping locaties");
            try {
                con = DB.getConnection();
                throwable = null;
                try {
                    PlaymappingImporter pi = new PlaymappingImporter(this.project);
                    ImportReport locationReport = new ImportReport();
                    ImportReport assetsReport = new ImportReport();
                    this.status.setProgress(50);
                    List pm_guids = pi.importJSONLocationsFromAPI(this.project.getUsername(), this.project.getPassword(), pmbaseurl + "/CustomerLocation/GetAll", locationReport, true, con);
                    if (pm_guids != null) {
                        this.status.addLog("Start met laden playmapping assets");
                        this.status.setCurrentAction("Start met laden playmapping assets");
                        assetsReport = pi.importJSONAssetsFromAPI(this.project.getUsername(), this.project.getPassword(), pmbaseurl + "/CustomerAsset/GetByLocationId/", pm_guids, assetsReport, con, this.status);
                    } else {
                        logString = logString + "Playmapping: " + locationReport.getErrors(ImportReport.ImportType.GENERAL);
                    }
                    logString = logString + "Playmapping: " + System.lineSeparator() + " Location: " + locationReport.toLog() + System.lineSeparator() + "Assets: " + assetsReport.toLog();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (con != null) {
                        if (throwable != null) {
                            try {
                                con.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            con.close();
                        }
                    }
                }
            }
            catch (SQLException | NamingException ex) {
                log.error((Object)"Cannot do initial load for playadvisor", (Throwable)ex);
                this.context.getValidationErrors().add("cronjob", (ValidationError)new SimpleError("Error saving:" + ex.getLocalizedMessage(), new Object[0]));
                logString = "Error for playmapping: " + System.lineSeparator();
                logString = logString + ex.getLocalizedMessage();
            }
        }
        this.status.setProgress(90);
        this.project.setLog(logString);
        this.status.setCurrentAction("Eind");
        this.status.setFinished(true);
        return logString;
    }

    @WaitPage(path="/WEB-INF/jsp/waitpage.jsp", delay=2000, refresh=1000, ajax="/WEB-INF/jsp/waitpageajax.jsp")
    public Resolution loadPMLocation() {
        this.status = new WaitPageStatus();
        this.status.addLog("Start");
        String logString = "";
        String pmbaseurl = CronListener.PLAYMAPPING_BASEURL;
        this.status.setCurrentAction("Start met laden playmapping locatie ");
        this.status.addLog("Start met laden playmapping locaties");
        try (Connection con = DB.getConnection();){
            this.project = (Project)DB.qr().query("SELECT id,cronexpressie,type_,username,password,name,log,lastrun,mailaddress,baseurl, status,authkey,imagepath from project WHERE id = ?", this.projectHandler, new Object[]{this.projectid});
            PlaymappingImporter pi = new PlaymappingImporter(this.project);
            ImportReport locationReport = new ImportReport();
            pi.importJSONLocationsFromAPI(this.project.getUsername(), this.project.getPassword(), pmbaseurl + "/CustomerLocation/GetById/" + this.locationguid, locationReport, false, con);
            ImportReport assetsReport = new ImportReport();
            this.status.setProgress(50);
            List<String> pm_guids = Collections.singletonList(this.locationguid);
            if (pm_guids != null) {
                this.status.addLog("Start met laden playmapping assets");
                this.status.setCurrentAction("Start met laden playmapping assets");
                assetsReport = pi.importJSONAssetsFromAPI(this.project.getUsername(), this.project.getPassword(), pmbaseurl + "/CustomerAsset/GetByLocationId/", pm_guids, assetsReport, con, this.status);
            } else {
                logString = logString + "Playmapping: " + locationReport.getErrors(ImportReport.ImportType.GENERAL);
            }
            logString = logString + "Playmapping: " + System.lineSeparator() + " Location: " + locationReport.toLog() + System.lineSeparator() + "Assets: " + assetsReport.toLog();
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot do initial load for playadvisor", (Throwable)ex);
            this.context.getValidationErrors().add("cronjob", (ValidationError)new SimpleError("Error saving:" + ex.getLocalizedMessage(), new Object[0]));
            logString = "Error for playmapping: " + System.lineSeparator();
            logString = logString + ex.getLocalizedMessage();
        }
        return new ForwardResolution(JSP);
    }

    public Resolution save() {
        if (this.project.getCronexpressie() == null || !CronExpression.isValidExpression((String)this.project.getCronexpressie())) {
            this.context.getValidationErrors().add("cronjob.cronexpressie", (ValidationError)new SimpleError("Cronexpressie niet correct", new Object[0]));
            return this.view();
        }
        this.doSave();
        return this.view();
    }

    private void doSave() {
        try (Connection con = DB.getConnection();){
            StringBuilder sb = new StringBuilder();
            if (this.project.getId() == null) {
                sb.append("INSERT ");
                sb.append("INTO ");
                sb.append("project");
                sb.append("(");
                sb.append("username,");
                sb.append("password,");
                sb.append("name,");
                sb.append("type_,");
                sb.append("mailaddress,");
                sb.append("status,");
                sb.append("cronexpressie) ");
                sb.append("VALUES(  ?,?,?,?,?,?,?);");
                this.project = (Project)DB.qr().insert(con, sb.toString(), this.projectHandler, new Object[]{this.project.getUsername(), this.project.getPassword(), this.project.getName(), this.project.getType_().name(), this.project.getMailaddress(), this.project.getStatus().name(), this.project.getCronexpressie()});
                CronListener.scheduleProject((Project)this.project);
            } else {
                sb.append("update ");
                sb.append("project");
                sb.append(" set ");
                sb.append("username = ?,");
                sb.append("password = ?,");
                sb.append("name = ?,");
                sb.append("mailaddress= ?,");
                sb.append("status= ?,");
                sb.append("type_= ?,");
                sb.append("cronexpressie = ?");
                sb.append(" where id = ?");
                DB.qr().update(con, sb.toString(), new Object[]{this.project.getUsername(), this.project.getPassword(), this.project.getName(), this.project.getMailaddress(), this.project.getStatus().name(), this.project.getType_().name(), this.project.getCronexpressie(), this.project.getId()});
                CronListener.rescheduleJob((Project)this.project);
            }
        }
        catch (SQLException | NamingException | SchedulerException ex) {
            log.error((Object)"Cannot save cronjob", ex);
            this.context.getValidationErrors().add("cronjob", (ValidationError)new SimpleError("Error saving:" + ex.getLocalizedMessage(), new Object[0]));
        }
    }

    public Resolution tabledata() {
        JSONObject result = new JSONObject();
        GsonBuilder builder = new GsonBuilder();
        builder.serializeSpecialFloatingPointValues();
        Gson gson = builder.create();
        try {
            BeanListHandler handler = new BeanListHandler(Project.class);
            String sql = "select id,cronexpressie,type_,username,password,name,log,lastrun, status, authkey from project";
            List jobs = (List)DB.qr().query(sql, (ResultSetHandler)handler);
            JSONArray ar = new JSONArray();
            for (Project job : jobs) {
                JSONObject obj = new JSONObject(gson.toJson((Object)job, Project.class));
                Date d = CronListener.getNextFireTime((Project)job);
                String formattedDate = d != null ? this.sdf.format(d) : "";
                obj.put("next_fire_time", (Object)formattedDate);
                obj.put("lastrun", (Object)obj.optString("lastrun", " - "));
                obj.put("type_", (Object)obj.optString("type_", " - "));
                obj.put("authkey", (Object)obj.optString("authkey", " - "));
                ar.put((Object)obj);
            }
            result.put("data", (Object)ar);
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot get geometryConverter: ", (Throwable)ex);
            result.put("message", (Object)("Cannot get geometryConverter: " + ex.getLocalizedMessage()));
        }
        StreamingResolution res = new StreamingResolution("application/json", result.toString(4));
        res.setFilename("");
        res.setAttachment(true);
        return res;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Integer getProjectid() {
        return this.projectid;
    }

    public void setProjectid(Integer projectid) {
        this.projectid = projectid;
    }

    public WaitPageStatus getStatus() {
        return this.status;
    }

    public void setStatus(WaitPageStatus status) {
        this.status = status;
    }

    public String getLocationguid() {
        return this.locationguid;
    }

    public void setLocationguid(String locationguid) {
        this.locationguid = locationguid;
    }
}

