/*
 * Copyright (C) 2018 B3Partners B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package nl.b3p.playbase.stripes;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.naming.NamingException;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.loader.util.DbUtilsGeometryColumnConverter;
import nl.b3p.playbase.PlaymappingExporter;
import nl.b3p.playbase.cron.CronListener;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Location;
import nl.b3p.playbase.entities.Project;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

/**
 *
 * @author Meine Toonen
 */
@StrictBinding
@UrlBinding("/action/exportplaymapping")
public class ExportPlaymappingActionBean implements ActionBean {

    private static final Log log = LogFactory.getLog(ProjectActionBean.class);

    private ActionBeanContext context;
    private static final String JSP = "/WEB-INF/jsp/admin/playmapping/view.jsp";

    @Validate
    private Integer location;
    @Validate
    private Integer project;

    private String locationJSON;
    
    private String result;

    // <editor-fold desc="getters and setters" defaultstate="collapsed">
    public Integer getLocation() {
        return location;
    }

    public void setLocation(Integer location) {
        this.location = location;
    }

    @Override
    public ActionBeanContext getContext() {
        return context;
    }

    @Override
    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getLocationJSON() {
        return locationJSON;
    }

    public void setLocationJSON(String locationJSON) {
        this.locationJSON = locationJSON;
    }

    public Integer getProject() {
        return project;
    }

    public void setProject(Integer project) {
        this.project = project;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    // </editor-fold>
    
    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution(JSP);
    }

    public Resolution showJSON() {
        if (location != null) {

            try (Connection con = DB.getConnection()) {
                GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter(con);
                BeanHandler<Location> locationHandler = new BeanHandler(Location.class, new BasicRowProcessor(new DbUtilsGeometryColumnConverter(geometryConverter)));
                Location loc = DB.qr().query("SELECT * from " + DB.LOCATION_TABLE + " WHERE id = ?", locationHandler, location);
                PlaymappingExporter pe = new PlaymappingExporter();
                JSONObject obj = loc.toPlaymappingJSON(pe.countryToISO);
                obj = pe.createLocationJSON(obj, loc, con, new HashMap<>());
                locationJSON = obj.toString(4);
            } catch (NamingException | SQLException | IOException ex) {
                log.error("Cannot load cronjob", ex);
            }
        }
        return new ForwardResolution(JSP);
    }

    public Resolution updateLocation() {
        if (location != null && project != null) {

            try (Connection con = DB.getConnection()) {
                ResultSetHandler<Project> projectHandler = new BeanHandler(Project.class);
                Project p = DB.qr().query(con,"SELECT id,cronexpressie,type_,username,password,name,log,lastrun,mailaddress,baseurl, status,authkey,imagepath from " + DB.PROJECT_TABLE + " WHERE id = ?", projectHandler, project);
                
                PlaymappingExporter pe = new PlaymappingExporter();
                String baseurl = context.getServletContext().getInitParameter(CronListener.KEY_PLAYMAPPING_BASEURL);
                
                result = pe.postToPlaymapping(location, p.getUsername(), p.getPassword(), baseurl, con, p);
            } catch (NamingException | SQLException ex) {
                log.error("Cannot load cronjob", ex);
            }
        }
        return new ForwardResolution(JSP);
    }
}
