/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase.cron;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.naming.NamingException;
import net.sourceforge.stripes.action.ActionBeanContext;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.loader.util.DbUtilsGeometryColumnConverter;
import nl.b3p.mail.Mailer;
import nl.b3p.playbase.ImageDownloader;
import nl.b3p.playbase.PlayadvisorExporter;
import nl.b3p.playbase.PlaymappingExporter;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Location;
import nl.b3p.playbase.entities.Project;
import nl.b3p.playbase.entities.ProjectType;
import nl.b3p.playbase.stripes.ProjectActionBean;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class PlaybaseJob
implements Job {
    private static final Log log = LogFactory.getLog(PlaybaseJob.class);
    private ImageDownloader downloader;

    public void execute(JobExecutionContext jec) throws JobExecutionException {
        PlayadvisorExporter pe;
        List locs;
        BeanListHandler listHandler;
        GeometryJdbcConverter geometryConverter2;
        Throwable throwable;
        Connection con;
        JobDataMap jdm = jec.getJobDetail().getJobDataMap();
        Project project = (Project)jdm.get((Object)"CronJobEntity");
        log.info((Object)("Executing playbasejob " + project.getId() + ". Type is " + project.getType_().toString()));
        ProjectType ct = project.getType_();
        String imagepath = (String)jdm.get((Object)"wordpress.upload.path");
        String wpbaseurl = (String)jdm.get((Object)"wordpress.baseurl");
        String authkey = (String)jdm.get((Object)"wordpress.authkey");
        String pmbaseurl = (String)jdm.get((Object)"playmapping.baseurl");
        String logstring = "";
        if (project.getType_() != ProjectType.SYNC_PLAYMAPPING) {
            logstring = logstring + this.loadAll(project, wpbaseurl, authkey, pmbaseurl);
        }
        if (project.getType_() == ProjectType.PLAYMAPPING_PLAYADVISOR) {
            log.debug((Object)"Updating locations to playadvisor.");
            try {
                con = DB.getConnection();
                throwable = null;
                try {
                    geometryConverter2 = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
                    listHandler = new BeanListHandler(Location.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter2)));
                    locs = (List)DB.qr().query(con, "select * from playservice_locations where project = ? and (removedfromplaymapping is null or removedfromplaymapping = false) and (removedfromplayadvisor = false or removedfromplayadvisor is null);", (ResultSetHandler)listHandler, new Object[]{"" + project.getId()});
                    pe = new PlayadvisorExporter();
                    this.downloader = new ImageDownloader(imagepath);
                    String result = pe.pushLocations(locs, imagepath, wpbaseurl, authkey, this.downloader);
                    pe.updateIDs(locs, con, wpbaseurl, authkey);
                }
                catch (Throwable geometryConverter2) {
                    throwable = geometryConverter2;
                    throw geometryConverter2;
                }
                finally {
                    if (con != null) {
                        if (throwable != null) {
                            try {
                                con.close();
                            }
                            catch (Throwable geometryConverter2) {
                                throwable.addSuppressed(geometryConverter2);
                            }
                        } else {
                            con.close();
                        }
                    }
                }
            }
            catch (SQLException | NamingException ex) {
                log.error((Object)"Error updating locations", (Throwable)ex);
            }
        }
        if (project.getType_() == ProjectType.SYNC_PLAYMAPPING) {
            log.debug((Object)"Updating locations to playmapping.");
            try {
                con = DB.getConnection();
                throwable = null;
                try {
                    geometryConverter2 = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
                    listHandler = new BeanListHandler(Location.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter2)));
                    locs = (List)DB.qr().query(con, "select * from playservice_locations where project = ? and (removedfromplaymapping is null or removedfromplaymapping = false) and (removedfromplayadvisor = false or removedfromplayadvisor is null);", (ResultSetHandler)listHandler, new Object[]{"" + project.getId()});
                    pe = new PlaymappingExporter();
                    for (Location loc : locs) {
                        pe.postToPlaymapping(loc, project.getUsername(), project.getPassword(), pmbaseurl, con, project, geometryConverter2);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (con != null) {
                        if (throwable != null) {
                            try {
                                con.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            con.close();
                        }
                    }
                }
            }
            catch (SQLException | NamingException ex) {
                log.error((Object)"Error updating locations", (Throwable)ex);
            }
            logstring = logstring + this.loadAll(project, wpbaseurl, authkey, pmbaseurl);
        }
        this.sendMail(project, logstring);
    }

    private String loadAll(Project project, String wpbaseurl, String authkey, String pmbaseurl) {
        ProjectActionBean pab = new ProjectActionBean();
        pab.setProject(project);
        pab.setContext(new ActionBeanContext());
        return pab.executeInitialLoad(wpbaseurl, authkey, pmbaseurl);
    }

    private void sendMail(Project cronjob, String logString) {
        if (cronjob.getMailaddress() != null) {
            String subject = "Playbase cron status: " + cronjob.getType_().toString() + " voor project " + cronjob.getName();
            StringBuilder content = new StringBuilder();
            content.append("Status rapport ").append(cronjob.getName());
            content.append(System.lineSeparator());
            content.append("Log: ");
            content.append(System.lineSeparator());
            content.append(logString);
            try {
                Mailer.sendMail((String)"Playbase", (String)"support@b3partners.nl", (String)cronjob.getMailaddress(), (String)subject, (String)content.toString());
            }
            catch (Exception ex) {
                log.error((Object)"Cannot send mail:", (Throwable)ex);
            }
        }
    }
}

