/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase.entities;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.b3p.playbase.PlaymappingExporter;
import nl.b3p.playbase.entities.Status;
import org.json.JSONObject;

public class Location {
    private Integer id;
    private String title;
    private String pa_title;
    private String pa_content;
    private String pm_content;
    private String summary;
    private String street;
    private String number;
    private String numberextra;
    private String postalcode;
    private String municipality;
    private String area;
    private String country;
    private String website;
    private String email;
    private String phone;
    private Integer project;
    private Double longitude = null;
    private Double latitude = null;
    private String pm_guid;
    private String pa_id;
    private Integer parking;
    private Integer averagerating;
    private Geometry geom;
    private Geometry geom_polygon;
    private List<Map<String, Object>> images = new ArrayList();
    private List<Map<String, Object>> documents = new ArrayList();
    private Integer[] agecategories = new Integer[0];
    private Date pm_lastmodified;
    private Boolean removedfromplayadvisor;
    private Boolean removedfromplaymapping;
    private Status status;
    private Boolean duplicate_images_checked;
    private String parentlocationid;
    private String contactname;
    private String ref;
    private String suburb;
    private boolean isupdated;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPa_content() {
        return this.pa_content;
    }

    public void setPa_content(String pa_content) {
        this.pa_content = pa_content;
    }

    public String getPm_content() {
        return this.pm_content;
    }

    public void setPm_content(String pm_content) {
        this.pm_content = pm_content;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getNumberextra() {
        return this.numberextra;
    }

    public void setNumberextra(String numberextra) {
        this.numberextra = numberextra;
    }

    public String getPostalcode() {
        return this.postalcode;
    }

    public void setPostalcode(String postalcode) {
        this.postalcode = postalcode;
    }

    public String getMunicipality() {
        return this.municipality;
    }

    public void setMunicipality(String municipality) {
        this.municipality = municipality;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public String getPm_guid() {
        return this.pm_guid;
    }

    public void setPm_guid(String pm_guid) {
        this.pm_guid = pm_guid;
    }

    public String getPa_id() {
        return this.pa_id;
    }

    public void setPa_id(String pa_id) {
        this.pa_id = pa_id;
    }

    public Integer getParking() {
        return this.parking;
    }

    public void setParking(Integer parking) {
        this.parking = parking;
    }

    public Geometry getGeom() {
        return this.geom;
    }

    public void setGeom(Geometry geom) {
        this.geom = geom;
    }

    public List<Map<String, Object>> getImages() {
        return this.images;
    }

    public void setImages(List<Map<String, Object>> images) {
        this.images = images;
    }

    public Integer[] getAgecategories() {
        return this.agecategories;
    }

    public void setAgecategories(Integer[] agecategories) {
        this.agecategories = agecategories;
    }

    public List<Map<String, Object>> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Map<String, Object>> documents) {
        this.documents = documents;
    }

    public Integer getAveragerating() {
        return this.averagerating;
    }

    public void setAveragerating(Integer averagerating) {
        this.averagerating = averagerating;
    }

    public String getPa_title() {
        return this.pa_title;
    }

    public void setPa_title(String pa_title) {
        this.pa_title = pa_title;
    }

    public Integer getProject() {
        return this.project;
    }

    public void setProject(Integer project) {
        this.project = project;
    }

    public Date getPm_lastmodified() {
        return this.pm_lastmodified;
    }

    public void setPm_lastmodified(Date pm_lastmodified) {
        this.pm_lastmodified = pm_lastmodified;
    }

    public Boolean getRemovedfromplayadvisor() {
        return this.removedfromplayadvisor;
    }

    public void setRemovedfromplayadvisor(Boolean removedfromplayadvisor) {
        this.removedfromplayadvisor = removedfromplayadvisor;
    }

    public Boolean getRemovedfromplaymapping() {
        return this.removedfromplaymapping;
    }

    public void setRemovedfromplaymapping(Boolean removedfromplaymapping) {
        this.removedfromplaymapping = removedfromplaymapping;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Boolean getDuplicate_images_checked() {
        return this.duplicate_images_checked;
    }

    public void setDuplicate_images_checked(Boolean duplicate_images_checked) {
        this.duplicate_images_checked = duplicate_images_checked;
    }

    public String getParentlocationid() {
        return this.parentlocationid;
    }

    public void setParentlocationid(String parentlocationid) {
        this.parentlocationid = parentlocationid;
    }

    public String getContactname() {
        return this.contactname;
    }

    public void setContactname(String contactname) {
        this.contactname = contactname;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getSuburb() {
        return this.suburb;
    }

    public void setSuburb(String suburb) {
        this.suburb = suburb;
    }

    public boolean isIsupdated() {
        return this.isupdated;
    }

    public void setIsupdated(boolean isupdated) {
        this.isupdated = isupdated;
    }

    public Geometry getGeom_polygon() {
        return this.geom_polygon;
    }

    public void setGeom_polygon(Geometry geom_polygon) {
        this.geom_polygon = geom_polygon;
    }

    public JSONObject toPlayadvisorJSON() {
        JSONObject obj = new JSONObject();
        obj.put("Plaats", (Object)this.municipality);
        obj.put("Content", (Object)(this.pm_content != null && !this.pm_content.isEmpty() ? this.pm_content : this.pa_content));
        obj.put("Longitude", (Object)this.longitude);
        obj.put("Email", (Object)this.email);
        obj.put("Website", (Object)this.website);
        obj.put("Telefoon", (Object)this.phone);
        obj.put("Land", (Object)this.country);
        obj.put("PlayadvisorID", (Object)this.pa_id);
        obj.put("Titel", (Object)(this.title != null && !this.title.isEmpty() ? this.title : this.pa_title));
        obj.put("PlaybaseID", (Object)this.id);
        obj.put("Latitude", (Object)this.latitude);
        obj.put("Straat", (Object)this.street);
        obj.put("Samenvatting", (Object)this.summary);
        return obj;
    }

    public JSONObject toPlaymappingJSON(HashMap<String, String> countryToISO) {
        JSONObject obj = new JSONObject();
        obj.put("$id", (Object)"3");
        obj.put("AddressLine1", (Object)this.street);
        obj.put("Archived", (Object)this.removedfromplaymapping);
        obj.put("City", (Object)this.municipality);
        obj.put("ContactEmail", (Object)this.email);
        obj.put("ContactName", (Object)this.contactname);
        obj.put("ContactPhone", (Object)this.phone);
        obj.put("ParentLocationID", (Object)this.parentlocationid);
        obj.put("Ref", (Object)this.ref);
        obj.put("Area", (Object)this.area);
        obj.put("Suburb", (Object)this.suburb);
        obj.put("Country", (Object)countryToISO.get(this.country));
        obj.put("ID", (Object)this.pm_guid);
        obj.put("LastUpdated", (Object)PlaymappingExporter.sdf.format(this.pm_lastmodified));
        if (this.latitude == null && this.longitude == null && this.geom_polygon != null) {
            Point p = this.geom_polygon.getCentroid();
            this.longitude = p.getX();
            this.latitude = p.getY();
        }
        obj.put("Lat", (Object)this.latitude);
        obj.put("Lng", (Object)this.longitude);
        obj.put("Name", (Object)this.title);
        obj.put("Notes", (Object)this.pm_content);
        obj.put("PostCode", (Object)this.postalcode);
        return obj;
    }
}

