CREATE TABLE public.cronjob
(
   id serial, 
   cronexpressie text, 
   type_ text, 
   username text, 
   password text, 
   project text, 
   log text, 
   exporthash text, 
   baseurl text, 
   importedstring text,
   mailaddress text,
   lastrun timestamp without time zone
) 
WITH (
  OIDS = FALSE
)
;
ALTER TABLE public.cronjob
  OWNER TO playbase;

ALTER TABLE public.cronjob
  ADD CONSTRAINT prim_key_cronjob PRIMARY KEY (id);

ALTER TABLE public.playservice_location_equipment_agecategories
  DROP CONSTRAINT playservicelocationequipmentagecategories_fk2;
ALTER TABLE public.playservice_location_equipment_agecategories
  ADD CONSTRAINT playservicelocationequipmentagecategories_fk2 FOREIGN KEY (location_equipment) REFERENCES public.playservice_location_equipment (id) ON UPDATE NO ACTION ON DELETE CASCADE;

ALTER TABLE public.playservice_locations
  ADD COLUMN project character varying(255);


ALTER TABLE public.playservice_locations_playadvisor
  ADD COLUMN project character varying(255);



ALTER TABLE public.cronjob
  ADD COLUMN exporthash text;


ALTER TABLE public.cronjob
  ADD COLUMN baseurl text;


ALTER TABLE public.playservice_images
  ADD COLUMN pa_id character varying(255);



ALTER TABLE public.playservice_images_playadvisor
  ADD COLUMN pa_id character varying(255);



ALTER TABLE public.playservice_documents
  ADD COLUMN pa_id character varying(255);



ALTER TABLE public.playservice_documents_playadvisor
  ADD COLUMN pa_id character varying(255);



update playservice_images set pm_guid = null where location in (select pl.id from playservice_images pi inner join playservice_locations pl on pi.location  = pl.id where pl.pa_id is not null and pl.pm_guid is null) 
update playservice_images as pi set pa_id = (select pl.pa_id from playservice_locations pl where pl.id = pi.location ) where location in (select pl.id from playservice_images pi inner join playservice_locations pl on pi.location  = pl.id where pl.pa_id is not null and pl.pm_guid is null) 



update playmapping_type_group set catasset = 'Ondergrond/' || catasset where catasset ilike '%ondergrond%';
update playmapping_type_group set catasset = 'Speeltoestellen/' || catasset where not catasset like 'Ondergrond/%';
update playmapping_type_group set catasset = 'Speeltoestellen/Carrousel' where catasset = 'Speeltoestellen/Speeltoestellen/Carrousel';
update playmapping_type_group set catasset = 'Faciliteiten/Zitgelegenheden/Bank' where catasset = 'Speeltoestellen/Zitgelegenheden/Bank';
update playmapping_type_group set catasset = 'Faciliteiten' where catasset = 'Speeltoestellen/Faciliteiten';
update playmapping_type_group set catasset = 'Faciliteiten/Kunstobjecten' where catasset = 'Speeltoestellen/Faciliteiten/Kunstobjecten';
	
  ALTER TABLE public.playservice_locations
  ADD COLUMN pm_lastmodified timestamp without time zone;

--ALTER TABLE public.playservice_locations  ADD COLUMN lastexported timestamp without time zone;

update playservice_locations set pm_lastmodified =  date '02-01-1970' ;
--update playservice_locations set lastexported =  date '01-01-1970' ;


  ALTER TABLE public.playservice_locations_playadvisor
  ADD COLUMN pm_lastmodified timestamp without time zone;
update playservice_locations_playadvisor set pm_lastmodified =  date '02-01-1970' ;


ALTER TABLE public.cronjob RENAME exporthash  TO authkey;


ALTER TABLE public.playservice_locations
  ADD COLUMN removedfromplayadvisor boolean;
ALTER TABLE public.playservice_locations_playadvisor
  ADD COLUMN removedfromplayadvisor boolean;

ALTER TABLE public.playservice_locations
  ADD COLUMN removedfromplaymapping boolean;
ALTER TABLE public.playservice_locations_playadvisor
  ADD COLUMN removedfromplaymapping boolean;


ALTER TABLE public.cronjob 
  ADD COLUMN status character varying(255);

ALTER TABLE public.cronjob
  RENAME TO project;
ALTER TABLE public.project RENAME project  TO name;


ALTER TABLE public.playservice_locations
  ADD COLUMN status character varying(255);
ALTER TABLE public.playservice_locations_playadvisor
  ADD COLUMN status character varying(255);

  
ALTER TABLE public.project
  ADD COLUMN imagepath character varying(255);




ALTER TABLE public.playservice_images
  ADD COLUMN pa_deleted boolean;



ALTER TABLE public.playservice_images_playadvisor
  ADD COLUMN pa_deleted boolean;

ALTER TABLE public.playservice_images
  ADD COLUMN pa_url text;

ALTER TABLE public.playservice_images_playadvisor
  ADD COLUMN pa_url text;



ALTER TABLE public.playservice_images
  ADD COLUMN pm_deleted boolean;



ALTER TABLE public.playservice_images_playadvisor
  ADD COLUMN pm_deleted boolean;


update playservice_locations pl set project = (select id from project p where lower(p.name) = pl.project);


ALTER TABLE public.playservice_location_equipment
  ADD COLUMN removedfromplaymapping boolean;
ALTER TABLE public.playservice_location_equipment_playadvisor
  ADD COLUMN removedfromplaymapping boolean;

update playservice_locations set removedfromplayadvisor = false where removedfromplayadvisor is null;
  update playservice_locations set removedfromplaymapping = false where removedfromplaymapping is null;


  update playservice_location_equipment set removedfromplaymapping = false where removedfromplaymapping is null;

    ALTER TABLE public.playservice_locations
   ALTER COLUMN title DROP NOT NULL;

ALTER TABLE public.playservice_locations_playadvisor
   ALTER COLUMN title DROP NOT NULL;




ALTER TABLE public.playservice_documents
  ADD COLUMN pm_deleted boolean;


ALTER TABLE public.playservice_documents_playadvisor
  ADD COLUMN pm_deleted boolean;

ALTER TABLE public.playservice_documents
  ADD COLUMN pa_deleted boolean;

ALTER TABLE public.playservice_documents_playadvisor
  ADD COLUMN pa_deleted boolean;



ALTER TABLE public.playservice_locations ADD COLUMN duplicate_images_checked boolean;
ALTER TABLE public.playservice_locations_playadvisor ADD COLUMN duplicate_images_checked boolean;

ALTER TABLE public.playservice_locations ADD COLUMN parentlocationid character varying(255);
ALTER TABLE public.playservice_locations ADD COLUMN contactname character varying(255);
ALTER TABLE public.playservice_locations ADD COLUMN contactphone character varying(255);
ALTER TABLE public.playservice_locations ADD COLUMN ref character varying(255);
ALTER TABLE public.playservice_locations ADD COLUMN suburb character varying(255);



ALTER TABLE public.playservice_locations_playadvisor ADD COLUMN parentlocationid character varying(255);
ALTER TABLE public.playservice_locations_playadvisor ADD COLUMN contactname character varying(255);
ALTER TABLE public.playservice_locations_playadvisor ADD COLUMN contactphone character varying(255);
ALTER TABLE public.playservice_locations_playadvisor ADD COLUMN ref character varying(255);
ALTER TABLE public.playservice_locations_playadvisor ADD COLUMN suburb character varying(255);




ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN manufacturerid character varying(255);
ALTER TABLE public.playservice_location_equipment ADD COLUMN manufacturerid character varying(255);
ALTER TABLE public.playservice_location_equipment ADD COLUMN materialid character varying(255);
ALTER TABLE public.playservice_location_equipment ADD COLUMN contactsupplierid character varying(255);
ALTER TABLE public.playservice_location_equipment ADD COLUMN contactinstallerid character varying(255);
ALTER TABLE public.playservice_location_equipment ADD COLUMN assettypeid character varying(255);
ALTER TABLE public.playservice_location_equipment ADD COLUMN typenumber character varying(255);
ALTER TABLE public.playservice_location_equipment ADD COLUMN purchaseddate character varying(255);
ALTER TABLE public.playservice_location_equipment ADD COLUMN lifespan character varying(255);
ALTER TABLE public.playservice_location_equipment ADD COLUMN installationcertificate character varying(255);
ALTER TABLE public.playservice_location_equipment ADD COLUMN installationcertificatenumber character varying(255);
ALTER TABLE public.playservice_location_equipment ADD COLUMN agegrouptoddlers character varying(255);
ALTER TABLE public.playservice_location_equipment ADD COLUMN agegroupjuniors character varying(255);
ALTER TABLE public.playservice_location_equipment ADD COLUMN agegroupseniors character varying(255);
ALTER TABLE public.playservice_location_equipment ADD COLUMN agegroupadults character varying(255);
ALTER TABLE public.playservice_location_equipment ADD COLUMN notes character varying(255);

ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN manufacturerid character varying(255);
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN materialid character varying(255);
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN contactsupplierid character varying(255);
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN contactinstallerid character varying(255);
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN assettypeid character varying(255);
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN typenumber character varying(255);
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN purchaseddate character varying(255);
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN lifespan character varying(255);
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN installationcertificate character varying(255);
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN installationcertificatenumber character varying(255);
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN agegrouptoddlers character varying(255);
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN agegroupjuniors character varying(255);
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN agegroupseniors character varying(255);
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN agegroupadults character varying(255);
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN notes character varying(255);


ALTER TABLE public.playservice_location_equipment ADD COLUMN isupdated boolean;
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN isupdated boolean;
ALTER TABLE public.playservice_location_equipment ADD COLUMN pm_lastmodified timestamp without time zone;
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN pm_lastmodified timestamp without time zone;


ALTER TABLE public.playservice_locations ADD COLUMN isupdated boolean;
ALTER TABLE public.playservice_locations_playadvisor ADD COLUMN isupdated boolean;


ALTER TABLE public.playservice_locations ADD COLUMN geom_polygon geometry(Polygon,4326);
ALTER TABLE public.playservice_locations_playadvisor ADD COLUMN geom_polygon geometry(Polygon,4326);


ALTER TABLE public.playservice_location_equipment ADD COLUMN objecttype character varying(255);
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN objecttype character varying(255);
ALTER TABLE public.playservice_location_equipment ADD COLUMN toestelgroep character varying(255);
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN toestelgroep character varying(255);
ALTER TABLE public.playservice_location_equipment ADD COLUMN typeplus character varying(255);
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN typeplus character varying(255);



ALTER TABLE public.playservice_locations ADD COLUMN objecttype character varying(255);
ALTER TABLE public.playservice_locations_playadvisor ADD COLUMN objecttype character varying(255);
ALTER TABLE public.playservice_locations ADD COLUMN toestelgroep character varying(255);
ALTER TABLE public.playservice_locations_playadvisor ADD COLUMN toestelgroep character varying(255);
ALTER TABLE public.playservice_locations ADD COLUMN typeplus character varying(255);
ALTER TABLE public.playservice_locations_playadvisor ADD COLUMN typeplus character varying(255);



ALTER TABLE public.playservice_locations ADD COLUMN externalsupplierid character varying(255);
ALTER TABLE public.playservice_locations_playadvisor ADD COLUMN externalsupplierid character varying(255);
ALTER TABLE public.playservice_location_equipment ADD COLUMN externalsupplierid character varying(255);
ALTER TABLE public.playservice_location_equipment_playadvisor ADD COLUMN externalsupplierid character varying(255);