/*
 * Copyright (C) 2018 B3Partners B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package nl.b3p.playbase;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.naming.NamingException;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.loader.util.DbUtilsGeometryColumnConverter;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Asset;
import nl.b3p.playbase.entities.Location;
import nl.b3p.playbase.entities.Project;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 *
 * @author Meine Toonen
 */
public class PlaymappingExporter extends Exporter implements PlaymappingBase {

    private static final Log log = LogFactory.getLog(PlaymappingExporter.class);
    public final HashMap<String, String> countryToISO;
    public static final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    
    public PlaymappingExporter() {
        super();
        countryToISO = new HashMap<>();
        Locale dutch = new Locale("nl", "NLD");
        String[] countries = Locale.getISOCountries();
        for (String country : countries) {
            Locale l = new Locale("", country);
            countryToISO.put(l.getDisplayCountry(dutch), l.getISO3Country());
        }
    }

    public String postToPlaymapping(Integer locationId, String username, String password, String apiurl, Connection con, Project p) throws NamingException, SQLException {
        
        GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter(con);
        BeanHandler<Location> locationHandler = new BeanHandler(Location.class, new BasicRowProcessor(new DbUtilsGeometryColumnConverter(geometryConverter)));

        Location loc = DB.qr().query(con, "SELECT * from " + DB.LOCATION_TABLE + " WHERE id = ?", locationHandler, locationId);
        return postToPlaymapping(loc, username, password, apiurl, con, p, geometryConverter);
    }
    
    public String postToPlaymapping(Location loc, String username, String password, String apiurl, Connection con, Project p, GeometryJdbcConverter geometryConverter ) throws NamingException, SQLException {
        JSONObject obj = loc.toPlaymappingJSON(countryToISO);
        log.debug("Payload for location: " + obj.toString());
        PlaymappingImporter pi = new PlaymappingImporter(p);
        ImportReport report = new ImportReport();
        StringEntity params = new StringEntity(obj.toString(), ContentType.APPLICATION_JSON);
        JSONArray results = new JSONArray();
        if (loc.getPm_guid() == null) {
            String locationResult;

            HttpPost request = new HttpPost(apiurl+ "CustomerLocation/CreateLocation");
            request.addHeader("content-type", "application/json");
            request.setEntity(params);
            locationResult = getResponse(username, password, apiurl + "CustomerLocation/CreateLocation", report, request);
            JSONObject locationJSON = new JSONObject(locationResult);
            JSONArray ar = new JSONArray();
            ar.put(locationJSON);
            pi.processLocations(ar.toString(), report, con);

            results.put(locationResult);
        } else {
            String locationResult;
            HttpPut request = new HttpPut(apiurl + "CustomerLocation/UpdateLocation/" + loc.getPm_guid());

            request.addHeader("content-type", "application/json");
            request.setEntity(params);
            locationResult = getResponse(username, password, apiurl + "CustomerLocation/UpdateLocation/" + loc.getPm_guid(), report, request);

            results.put(locationResult);
        }

        ResultSetHandler<List<Asset>> assHandler = new BeanListHandler(Asset.class, new BasicRowProcessor(new DbUtilsGeometryColumnConverter(geometryConverter)));

        List<Asset> assets = DB.qr().query(con, "SELECT * FROM " + DB.ASSETS_TABLE + " WHERE location = ? and removedfromplaymapping = false", assHandler, loc.getId());
        for (Asset asset : assets) {
            JSONObject assetObj = asset.toJSONObject(loc);
            log.debug("***********************************************************");
            log.debug("Payload for asset:: " + assetObj.toString());
            StringEntity assetParams = new StringEntity(assetObj.toString(), ContentType.APPLICATION_JSON);
            if (asset.getPm_guid() == null) {
                String assetResult;
                HttpPost request = new HttpPost(apiurl + "CustomerAsset/CreateAsset");
                request.addHeader("content-type", "application/json");
                request.setEntity(assetParams);

                assetResult = getResponse(username, password, apiurl + "CustomerAsset/CreateAsset", report, request);

                JSONObject assetJSON = new JSONObject(assetResult);
                JSONArray ar = new JSONArray();
                ar.put(assetJSON);
                pi.processAssets(ar, report, con);

                results.put(assetResult);
            } else {
                String assetResult;
                String endpointurl = "CustomerAsset/UpdateAsset/" + asset.getPm_guid();
                HttpPut request = new HttpPut(apiurl  + endpointurl);

                request.addHeader("content-type", "application/json");
                request.setEntity(assetParams);
                assetResult = getResponse(username, password, apiurl + endpointurl, report, request);
                if(assetResult != null){
                    JSONObject assetJSON = new JSONObject(assetResult);
                    JSONArray ar = new JSONArray();
                    ar.put(assetJSON);
                    pi.processAssets(ar, report, con);
                }
                results.put(assetResult);
            }
            log.debug("***********************************************************");
        }
        String s= report.toLog();
        results.put(s);
        return results.toString();
    }

}
