/*
 * Copyright (C) 2017 B3Partners B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package nl.b3p.playbase.entities;

import com.vividsolutions.jts.geom.Geometry;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import nl.b3p.playbase.PlaymappingExporter;
import nl.b3p.playbase.PlaymappingImporter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 *
 * @author Meine Toonen
 */
public class Asset {
    private static final Log log = LogFactory.getLog(Asset.class);

    private Integer id;
    private Integer location;
    private Integer equipment;
    private String pa_guid;
    private double longitude;
    private double latitude;
    private Integer type_;
    private String installeddate;
    private String pm_guid;
    private String name;
    private Integer priceindexation;
    private Integer priceinstallation;
    private Integer pricemaintenance;
    private Integer pricepurchase;
    private Integer pricereinvestment;
    private Integer depth;
    private Integer width;
    private Integer height;
    private Date pm_lastmodified;
    private Integer endoflifeyear;
    private Integer freefallheight;
    private Integer safetyzonelength;
    private Integer safetyzonewidth;
    private String manufacturer;
    private String material;
    private String product;
    private String productid;
    private String productvariantid;
    private String serialnumber;
    private Geometry geom;
    private Integer[] agecategories = new Integer[0];
    private boolean removedfromplaymapping = false;

    private String materialid;
    private String manufacturerid;
    private String contactsupplierid;
    private String contactinstallerid;
    private String assettypeid;
    private String typenumber;
    private String purchaseddate;
    private String lifespan;
    private String installationcertificatenumber;
    private String agegrouptoddlers;
    private String agegroupjuniors;
    private String agegroupseniors;
    private String agegroupadults;
    private String notes;
    private boolean isupdated;
    
    private String objecttype;
    private String typeplus;
    private String toestelgroep;
    
    private List<Map<String, Object>> images;
    private List<Map<String, Object>> documents;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getLocation() {
        return location;
    }

    public void setLocation(Integer location) {
        this.location = location;
    }

    public Integer getEquipment() {
        return equipment;
    }

    public void setEquipment(Integer equipment) {
        this.equipment = equipment;
    }

    public String getPa_guid() {
        return pa_guid;
    }

    public void setPa_guid(String pa_guid) {
        this.pa_guid = pa_guid;
    }

    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public Integer getType_() {
        return type_;
    }

    public void setType_(Integer type_) {
        this.type_ = type_;
    }

    public String getInstalleddate() {
        return installeddate;
    }

    public void setInstalleddate(String installeddate) {
        this.installeddate = installeddate;
    }

    public String getPm_guid() {
        return pm_guid;
    }

    public void setPm_guid(String pm_guid) {
        this.pm_guid = pm_guid;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getPriceindexation() {
        return priceindexation;
    }

    public void setPriceindexation(Integer priceindexation) {
        this.priceindexation = priceindexation;
    }

    public Integer getPriceinstallation() {
        return priceinstallation;
    }

    public void setPriceinstallation(Integer priceinstallation) {
        this.priceinstallation = priceinstallation;
    }

    public Integer getPricemaintenance() {
        return pricemaintenance;
    }

    public void setPricemaintenance(Integer pricemaintenance) {
        this.pricemaintenance = pricemaintenance;
    }

    public Integer getPricepurchase() {
        return pricepurchase;
    }

    public void setPricepurchase(Integer pricepurchase) {
        this.pricepurchase = pricepurchase;
    }

    public Integer getPricereinvestment() {
        return pricereinvestment;
    }

    public void setPricereinvestment(Integer pricereinvestment) {
        this.pricereinvestment = pricereinvestment;
    }

    public Integer getDepth() {
        return depth;
    }

    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getEndoflifeyear() {
        return endoflifeyear;
    }

    public void setEndoflifeyear(Integer endoflifeyear) {
        this.endoflifeyear = endoflifeyear;
    }

    public Integer getFreefallheight() {
        return freefallheight;
    }

    public void setFreefallheight(Integer freefallheight) {
        this.freefallheight = freefallheight;
    }

    public Integer getSafetyzonelength() {
        return safetyzonelength;
    }

    public void setSafetyzonelength(Integer safetyzonelength) {
        this.safetyzonelength = safetyzonelength;
    }

    public Integer getSafetyzonewidth() {
        return safetyzonewidth;
    }

    public void setSafetyzonewidth(Integer safetyzonewidth) {
        this.safetyzonewidth = safetyzonewidth;
    }

    public String getManufacturer() {
        return manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getMaterial() {
        return material;
    }

    public void setMaterial(String material) {
        this.material = material;
    }

    public String getProduct() {
        return product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String getProductid() {
        return productid;
    }

    public void setProductid(String productid) {
        this.productid = productid;
    }

    public String getProductvariantid() {
        return productvariantid;
    }

    public void setProductvariantid(String productvariantid) {
        this.productvariantid = productvariantid;
    }

    public String getSerialnumber() {
        return serialnumber;
    }

    public void setSerialnumber(String serialnumber) {
        this.serialnumber = serialnumber;
    }

    public Geometry getGeom() {
        return geom;
    }

    public void setGeom(Geometry geom) {
        this.geom = geom;
    }

    public Integer[] getAgecategories() {
        return agecategories;
    }

    public void setAgecategories(Integer[] agecategories) {
        this.agecategories = agecategories;
    }

    public List<Map<String, Object>> getImages() {
        return images;
    }

    public void setImages(List<Map<String, Object>> images) {
        this.images = images;
    }

    public List<Map<String, Object>> getDocuments() {
        return documents;
    }

    public void setDocuments(List<Map<String, Object>> documents) {
        this.documents = documents;
    }

    public boolean isRemovedfromplaymapping() {
        return removedfromplaymapping;
    }

    public void setRemovedfromplaymapping(boolean removedfromplaymapping) {
        this.removedfromplaymapping = removedfromplaymapping;
    }

    public String getMaterialid() {
        return materialid;
    }

    public void setMaterialid(String materialid) {
        this.materialid = materialid;
    }

    public String getContactsupplierid() {
        return contactsupplierid;
    }

    public void setContactsupplierid(String contactsupplierid) {
        this.contactsupplierid = contactsupplierid;
    }

    public String getContactinstallerid() {
        return contactinstallerid;
    }

    public void setContactinstallerid(String contactinstallerid) {
        this.contactinstallerid = contactinstallerid;
    }

    public String getAssettypeid() {
        return assettypeid;
    }

    public void setAssettypeid(String assettypeid) {
        this.assettypeid = assettypeid;
    }

    public String getTypenumber() {
        return typenumber;
    }

    public void setTypenumber(String typenumber) {
        this.typenumber = typenumber;
    }

    public String getPurchaseddate() {
        return purchaseddate;
    }

    public void setPurchaseddate(String purchaseddate) {
        this.purchaseddate = purchaseddate;
    }

    public String getLifespan() {
        return lifespan;
    }

    public void setLifespan(String lifespan) {
        this.lifespan = lifespan;
    }

    public String getInstallationcertificatenumber() {
        return installationcertificatenumber;
    }

    public void setInstallationcertificatenumber(String installationcertificatenumber) {
        this.installationcertificatenumber = installationcertificatenumber;
    }

    public String getAgegrouptoddlers() {
        return agegrouptoddlers;
    }

    public void setAgegrouptoddlers(String agegrouptoddlers) {
        this.agegrouptoddlers = agegrouptoddlers;
    }

    public String getAgegroupjuniors() {
        return agegroupjuniors;
    }

    public void setAgegroupjuniors(String agegroupjuniors) {
        this.agegroupjuniors = agegroupjuniors;
    }

    public String getAgegroupseniors() {
        return agegroupseniors;
    }

    public void setAgegroupseniors(String agegroupseniors) {
        this.agegroupseniors = agegroupseniors;
    }

    public String getAgegroupadults() {
        return agegroupadults;
    }

    public void setAgegroupadults(String agegroupadults) {
        this.agegroupadults = agegroupadults;
    }

    public String getNotes() {
        return notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getManufacturerid() {
        return manufacturerid;
    }

    public void setManufacturerid(String manufacturerid) {
        this.manufacturerid = manufacturerid;
    }

    public Date getPm_lastmodified() {
        return pm_lastmodified;
    }

    public void setPm_lastmodified(Date pm_lastmodified) {
        this.pm_lastmodified = pm_lastmodified;
    }

    public boolean isIsupdated() {
        return isupdated;
    }

    public void setIsupdated(boolean isupdated) {
        this.isupdated = isupdated;
    }

    public String getObjecttype() {
        return objecttype;
    }

    public void setObjecttype(String objecttype) {
        this.objecttype = objecttype;
    }

    public String getTypeplus() {
        return typeplus;
    }

    public void setTypeplus(String typeplus) {
        this.typeplus = typeplus;
    }

    public String getToestelgroep() {
        return toestelgroep;
    }

    public void setToestelgroep(String toestelgroep) {
        this.toestelgroep = toestelgroep;
    }
    
    public JSONObject toJSONObject(Location loc)  {
        JSONObject obj = new JSONObject();
        obj.put("ID", pm_guid);
        if (assettypeid != null) {
            obj.put("AssetTypeID", assettypeid);
        } else {
            if(objecttype != null){
                if(objecttype.equals("Sporttoestel")){
                    obj.put("AssetTypeID", "1F60C63B-14CF-4FD8-9142-0E9AE4809863"); // ga er vanuit dat het een generiek type "sportoestel" is
                }else if(objecttype.equals("Speeltoestel")){
                    obj.put("AssetTypeID", "C0F5FE48-F81E-4239-AD58-836B1685ECD0"); // ga er vanuit dat het een generiek type "SPeeltoestel" is
                }
            }
        }
        obj.put("AssetLocationID",loc.getPm_guid());
        obj.put("ProductID",productid);
        
        obj.put("ProductVariantID", productvariantid);
        obj.put("ManufacturerID",manufacturerid);
        
        obj.put("MaterialID", materialid);
        obj.put("ContactSupplierID", contactsupplierid);
        obj.put("ContactInstallerID", contactinstallerid);
        obj.put("Archived",removedfromplaymapping);
        obj.put("AssetID",pm_guid);
        obj.put("Lat",latitude);
        obj.put("Lng",longitude);
        obj.put("TypeNumber", typenumber);
        obj.put("SerialNumber",serialnumber);
        try {
            obj.put("PurchasedDate",PlaymappingExporter.sdf.format(PlaymappingImporter.sdfShort.parse(purchaseddate)));
        } catch (ParseException ex) {
            log.error("Cannot parse purchaseddate: " + ex.getLocalizedMessage());
        }
        obj.put("EndOfLifeYear", endoflifeyear);
        try {
            obj.put("InstalledDate",PlaymappingExporter.sdf.format(PlaymappingImporter.sdfShort.parse(installeddate)));
        } catch (ParseException ex) {
            log.debug("Cannot parse InstalledDate: " + ex.getLocalizedMessage());
        }
        obj.put("InstallationCertificateNumber", installationcertificatenumber);
        obj.put("PricePurchase",pricepurchase);
        obj.put("PriceInstallation",priceinstallation);
        obj.put("PriceIndexation",priceindexation);
        obj.put("PriceReInvestment",pricereinvestment);
        obj.put("PriceMaintenance",pricemaintenance);
        obj.put("Height",height);
        obj.put("Width",width);
        obj.put("Depth",depth);
        obj.put("FreeFallHeight",freefallheight);
        obj.put("SafetyZoneLength",safetyzonelength);
        obj.put("SafetyZoneWidth",safetyzonewidth);
        obj.put("AgeGroupToddlers",agegrouptoddlers);
        obj.put("AgeGroupJuniors",agegroupjuniors);
        obj.put("AgeGroupSeniors",agegroupseniors);
        obj.put("AgeGroupAdults",agegroupadults);
        obj.put("Notes", notes);
        obj.put("Name", name);
        
        // customproperties
        JSONArray customproperties = new JSONArray();
        if(toestelgroep != null){
            JSONObject t = new JSONObject();
            t.put("ID", "9db7f7e2-678b-48b7-b2e7-0d40ddbd3f61");
            t.put("Value", toestelgroep);
            customproperties.put(t);
        }
        
        obj.put("CustomProperties", customproperties);
        return obj;
    }
    
    public String convertStringdateToString(String date){
        String newDate = null;
        if(date != null){
            String split = "-";
            String[] tokens = date.split(split);
            newDate = tokens[2] + "/" + tokens [1] + "/" + tokens [0];
        }
        return newDate;
    }
}
