/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.b3p.playbase.ImportReport;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImportReport {
    private final Map<ImportType, String> importedstring = new HashMap();
    private final Map<ImportType, Set<String>> errorsMessages = new HashMap();
    private final Map<ImportType, Integer> errors = new HashMap();
    private final Map<ImportType, Integer> inserted = new HashMap();
    private final Map<ImportType, Integer> updated = new HashMap();

    public ImportReport() {
        for (ImportType type : ImportType.values()) {
            this.errorsMessages.put(type, new HashSet());
            this.inserted.put(type, 0);
            this.updated.put(type, 0);
            this.errors.put(type, 0);
        }
    }

    public int getNumberInserted(ImportType type) {
        return (Integer)this.inserted.get(type);
    }

    public int getNumberUpdated(ImportType type) {
        return (Integer)this.updated.get(type);
    }

    public void increaseUpdated(ImportType type) {
        this.updated.put(type, (Integer)this.updated.get(type) + 1);
    }

    public void increaseInserted(ImportType type) {
        this.inserted.put(type, (Integer)this.inserted.get(type) + 1);
    }

    public void addError(String message, ImportType type) {
        this.errors.put(type, (Integer)this.errors.get(type) + 1);
        ((Set)this.errorsMessages.get(type)).add(message);
    }

    public Set<String> getErrors(ImportType type) {
        return (Set)this.errorsMessages.get(type);
    }

    public Map<ImportType, Set<String>> getAllErrors() {
        return this.errorsMessages;
    }

    public int getNumErrors(ImportType type) {
        return (Integer)this.errors.get(type);
    }

    public List<String> getErrors() {
        ArrayList<String> allErrors = new ArrayList<String>();
        for (ImportType importType : this.errorsMessages.keySet()) {
            allErrors.addAll((Collection)this.errorsMessages.get(importType));
        }
        return allErrors;
    }

    public Map<ImportType, String> getImportedstring() {
        return this.importedstring;
    }

    public void setImportedstring(ImportType type, String importedstring) {
        this.importedstring.put(type, importedstring);
    }

    public String toLog() {
        String ls = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append("Import on ");
        sb.append(new Date());
        sb.append(ls);
        sb.append("*******************");
        sb.append(ls);
        sb.append("Er zijn ").append(this.getNumberInserted(ImportType.ASSET)).append(" ").append(ImportType.ASSET.toString()).append(" weggeschreven.");
        sb.append(ls);
        sb.append("Er zijn ").append(this.getNumberInserted(ImportType.LOCATION)).append(" ").append(ImportType.LOCATION.toString()).append(" weggeschreven.");
        sb.append(ls);
        sb.append("Er zijn ").append(this.getNumberUpdated(ImportType.ASSET)).append(" ").append(ImportType.ASSET.toString()).append(" geupdatet.");
        sb.append(ls);
        sb.append("Er zijn ").append(this.getNumberUpdated(ImportType.LOCATION)).append(" ").append(ImportType.LOCATION.toString()).append(" geupdatet.");
        sb.append(ls);
        if (this.getErrors().size() > 0) {
            sb.append("Er zijn ").append(this.getErrors(ImportType.ASSET).size()).append(" ").append(ImportType.ASSET.toString()).append(" mislukt:");
            sb.append(ls);
            sb.append("Er zijn ").append(this.getErrors(ImportType.LOCATION).size()).append(" ").append(ImportType.LOCATION.toString()).append(" mislukt:");
            sb.append(ls);
            for (ImportType importType : this.getAllErrors().keySet()) {
                Set errs = (Set)this.getAllErrors().get(importType);
                for (String error : errs) {
                    sb.append(importType.toString()).append(": ").append(error);
                    sb.append(ls);
                }
            }
        }
        return sb.toString();
    }
}

