/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import nl.b3p.playbase.ImportReport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public interface PlaymappingBase {
    public static final Log log = LogFactory.getLog(PlaymappingBase.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public String getResponse(String username, String password, String apiurl, ImportReport report, HttpRequestBase request) {
        RequestConfig defaultRequestConfig = RequestConfig.custom().setStaleConnectionCheckEnabled(false).setTargetPreferredAuthSchemes(Arrays.asList("Basic")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).setConnectionRequestTimeout(60).build();
        HttpClientBuilder hcb = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig);
        HttpClientContext httpContext = HttpClientContext.create();
        if (username != null && password != null) {
            String hostname = null;
            int port = -1;
            String scheme = "http";
            try {
                URL aURL = new URL(apiurl);
                hostname = aURL.getHost();
                port = aURL.getPort();
                scheme = aURL.getProtocol();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(username, password);
            AuthScope authScope = new AuthScope(hostname, port);
            credentialsProvider.setCredentials(authScope, (Credentials)defaultcreds);
            hcb = hcb.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            if (hostname != null) {
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                HttpHost targetHost = new HttpHost(hostname, port, scheme);
                authCache.put(targetHost, (AuthScheme)basicAuth);
                httpContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
                httpContext.setAuthCache((AuthCache)authCache);
                log.debug((Object)("Preemptive credentials: hostname: " + hostname + ", port: " + port + ", username: " + username + ", password: ****."));
            }
        }
        log.debug((Object)"Creating httpclient");
        CloseableHttpClient hc = hcb.build();
        request.setHeader("Accept-Language", "NL");
        request.setHeader("Accept", "application/json");
        String stringResult = null;
        HttpResponse response = null;
        try {
            log.debug((Object)"Executing request");
            response = hc.execute((HttpUriRequest)request, (HttpContext)httpContext);
            int statusCode = response.getStatusLine().getStatusCode();
            log.debug((Object)("Request finished with status " + statusCode));
            HttpEntity entity = response.getEntity();
            if (statusCode >= 200 && statusCode <= 299) {
                stringResult = EntityUtils.toString((HttpEntity)entity);
                log.debug((Object)("Result: " + stringResult));
            } else {
                String statusLine = response.getStatusLine().getReasonPhrase();
                log.debug((Object)("Error: " + statusLine));
                report.addError("Could not retrieve JSON. Status " + statusCode + ". Reason given: " + statusLine, ImportReport.ImportType.GENERAL);
            }
        }
        catch (IOException ex) {
            log.debug((Object)"Exception False: ", (Throwable)ex);
            report.addError("Could not retrieve JSON." + ex.getLocalizedMessage(), ImportReport.ImportType.GENERAL);
        }
        finally {
            log.debug((Object)"Closing http client");
            if (hc instanceof CloseableHttpClient) {
                try {
                    hc.close();
                }
                catch (IOException ex) {
                    log.info((Object)("Error closing HttpClient: " + ex.getLocalizedMessage()));
                }
            }
            if (response instanceof CloseableHttpResponse) {
                try {
                    ((CloseableHttpResponse)response).close();
                }
                catch (IOException ex) {
                    log.info((Object)("Error closing HttpResponse: " + ex.getLocalizedMessage()));
                }
            }
        }
        return stringResult;
    }
}

