/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase.cron;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.naming.NamingException;
import net.sourceforge.stripes.action.ActionBeanContext;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.loader.util.DbUtilsGeometryColumnConverter;
import nl.b3p.mail.Mailer;
import nl.b3p.playbase.ImageDownloader;
import nl.b3p.playbase.PlayadvisorExporter;
import nl.b3p.playbase.PlaymappingExporter;
import nl.b3p.playbase.cron.PlaybaseJob;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Location;
import nl.b3p.playbase.entities.Project;
import nl.b3p.playbase.entities.ProjectType;
import nl.b3p.playbase.stripes.ProjectActionBean;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class PlaybaseJob
implements Job {
    private static final Log log = LogFactory.getLog(PlaybaseJob.class);
    private ImageDownloader downloader;

    public void execute(JobExecutionContext jec) throws JobExecutionException {
        JobDataMap jdm = jec.getJobDetail().getJobDataMap();
        Project project = (Project)jdm.get((Object)"CronJobEntity");
        log.info((Object)("Executing playbasejob " + project.getId() + ". Type is " + project.getType_().toString()));
        ProjectType ct = project.getType_();
        String imagepath = (String)jdm.get((Object)"wordpress.upload.path");
        String wpbaseurl = (String)jdm.get((Object)"wordpress.baseurl");
        String authkey = (String)jdm.get((Object)"wordpress.authkey");
        String pmbaseurl = (String)jdm.get((Object)"playmapping.baseurl");
        String logstring = "";
        switch (1.$SwitchMap$nl$b3p$playbase$entities$ProjectType[project.getType_().ordinal()]) {
            case 1: {
                this.importPlayadvisor(logstring, project, wpbaseurl, authkey, pmbaseurl);
                break;
            }
            case 2: {
                this.importPlaymapping(logstring, project, wpbaseurl, authkey, pmbaseurl);
                break;
            }
            case 3: {
                this.syncPlaymapping(logstring, project, wpbaseurl, authkey, pmbaseurl);
                break;
            }
            case 4: {
                this.syncPlaymappingPlayadvisor(logstring, project, wpbaseurl, authkey, pmbaseurl, imagepath);
                break;
            }
        }
        this.sendMail(project, logstring);
    }

    private void syncPlaymappingPlayadvisor(String logstring, Project project, String wpbaseurl, String authkey, String pmbaseurl, String imagepath) {
        logstring = logstring + this.loadAll(project, wpbaseurl, authkey, pmbaseurl);
        log.debug((Object)"Updating locations to playadvisor.");
        try (Connection con = DB.getConnection();){
            GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
            BeanListHandler listHandler = new BeanListHandler(Location.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
            List locs = (List)DB.qr().query(con, "select * from playservice_locations where project = ? and (removedfromplaymapping is null or removedfromplaymapping = false) and (removedfromplayadvisor = false or removedfromplayadvisor is null);", (ResultSetHandler)listHandler, new Object[]{"" + project.getId()});
            PlayadvisorExporter pe = new PlayadvisorExporter();
            this.downloader = new ImageDownloader(imagepath);
            String result = pe.pushLocations(locs, imagepath, wpbaseurl, authkey, this.downloader);
            pe.updateIDs(locs, con, wpbaseurl, authkey);
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Error updating locations", (Throwable)ex);
        }
    }

    private void syncPlaymapping(String logstring, Project project, String wpbaseurl, String authkey, String pmbaseurl) {
        log.debug((Object)"Updating locations to playmapping.");
        try (Connection con = DB.getConnection();){
            GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
            BeanListHandler listHandler = new BeanListHandler(Location.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
            List locs = (List)DB.qr().query(con, "select * from playservice_locations where project = ? and (removedfromplaymapping is null or removedfromplaymapping = false) and (removedfromplayadvisor = false or removedfromplayadvisor is null);", (ResultSetHandler)listHandler, new Object[]{"" + project.getId()});
            PlaymappingExporter pe = new PlaymappingExporter();
            for (Location loc : locs) {
                pe.postToPlaymapping(loc, project.getUsername(), project.getPassword(), pmbaseurl, con, project, geometryConverter);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Error updating locations", (Throwable)ex);
        }
        logstring = logstring + this.loadAll(project, wpbaseurl, authkey, pmbaseurl);
    }

    private void importPlaymapping(String logstring, Project project, String wpbaseurl, String authkey, String pmbaseurl) {
        logstring = logstring + this.loadAll(project, wpbaseurl, authkey, pmbaseurl);
    }

    private void importPlayadvisor(String logstring, Project project, String wpbaseurl, String authkey, String pmbaseurl) {
        logstring = logstring + this.loadAll(project, wpbaseurl, authkey, pmbaseurl);
    }

    private String loadAll(Project project, String wpbaseurl, String authkey, String pmbaseurl) {
        ProjectActionBean pab = new ProjectActionBean();
        pab.setProject(project);
        pab.setContext(new ActionBeanContext());
        return pab.executeInitialLoad(wpbaseurl, authkey, pmbaseurl);
    }

    private void sendMail(Project cronjob, String logString) {
        if (cronjob.getMailaddress() != null) {
            String subject = "Playbase cron status: " + cronjob.getType_().toString() + " voor project " + cronjob.getName();
            StringBuilder content = new StringBuilder();
            content.append("Status rapport ").append(cronjob.getName());
            content.append(System.lineSeparator());
            content.append("Log: ");
            content.append(System.lineSeparator());
            content.append(logString);
            try {
                Mailer.sendMail((String)"Playbase", (String)"support@b3partners.nl", (String)cronjob.getMailaddress(), (String)subject, (String)content.toString());
            }
            catch (Exception ex) {
                log.error((Object)"Cannot send mail:", (Throwable)ex);
            }
        }
    }
}

