/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase.stripes;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.JsonResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.RestActionBean;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.loader.util.DbUtilsGeometryColumnConverter;
import nl.b3p.playbase.ImageDownloader;
import nl.b3p.playbase.ImportReport;
import nl.b3p.playbase.PlayadvisorExporter;
import nl.b3p.playbase.PlayadvisorImporter;
import nl.b3p.playbase.PlaymappingImporter;
import nl.b3p.playbase.cron.CronListener;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Location;
import nl.b3p.playbase.entities.Project;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

@RestActionBean
@UrlBinding(value="/rest/playadvisor/{location}")
public class PlayadvisorRESTAPIActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(PlayadvisorRESTAPIActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/admin/playadvisor/view.jsp";
    protected ResultSetHandler<Location> locationHandler;
    protected final ResultSetHandler<Project> projectHandler = new BeanHandler(Project.class);
    private ActionBeanContext context;
    @Validate
    private Integer location;
    @Validate
    private Integer project;

    public void setLocation(Integer location) {
        this.location = location;
    }

    public Integer getLocation() {
        return this.location;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Integer getProject() {
        return this.project;
    }

    public void setProject(Integer project) {
        this.project = project;
    }

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution(JSP);
    }

    public Resolution post() {
        String logString = "";
        try (Connection con = DB.getConnection();){
            ImportReport report = new ImportReport();
            HttpServletRequest req = this.context.getRequest();
            String data = IOUtils.toString((InputStream)req.getInputStream(), (String)"UTF-8");
            log.debug((Object)("Receiving post: " + data));
            PlayadvisorImporter paimporter = new PlayadvisorImporter(null);
            JSONArray ar = new JSONArray();
            ar.put((Object)new JSONObject(data));
            List locs = paimporter.processLocations(ar.toString(), report, con);
            logString = "Playadvisor:  " + System.lineSeparator() + report.toLog();
            PlayadvisorExporter pe = new PlayadvisorExporter();
            String baseurl = this.context.getServletContext().getInitParameter("wordpress.baseurl");
            String authkey = this.context.getServletContext().getInitParameter("wordpress.authkey");
            pe.updateIDs(locs, con, baseurl, authkey);
        }
        catch (IOException | SQLException | NamingException ex) {
            log.error((Object)"Cannot do initial load for playadvisor", (Throwable)ex);
            this.context.getValidationErrors().add("cronjob", (ValidationError)new SimpleError("Error saving:" + ex.getLocalizedMessage(), new Object[0]));
            logString = "Error for playadvisor: " + System.lineSeparator();
            logString = logString + ex.getLocalizedMessage();
        }
        return new JsonResolution((Object)logString, new String[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Resolution delete() {
        if (this.location == null) return new JsonResolution((Object)"No location given.", new String[0]);
        log.debug((Object)("Receiving delete: " + this.location));
        try (Connection con = DB.getConnection();){
            GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
            this.locationHandler = new BeanHandler(Location.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
            StringBuilder sb = new StringBuilder();
            sb.append("select * from ");
            sb.append("playservice_locations");
            sb.append(" where id = '");
            sb.append(this.location);
            sb.append("';");
            Location loc = (Location)DB.qr().query(con, sb.toString(), this.locationHandler);
            if (loc != null) {
                loc.setRemovedfromplayadvisor(Boolean.valueOf(true));
                Project p = this.getProject(loc.getProject(), con);
                PlaymappingImporter imp = new PlaymappingImporter(p);
                ImportReport report = new ImportReport();
                imp.saveLocation(loc, report);
                List errors = report.getErrors();
                if (errors.isEmpty()) {
                    JsonResolution jsonResolution = new JsonResolution((Object)"Success", new String[0]);
                    return jsonResolution;
                }
                JsonResolution jsonResolution = new JsonResolution((Object)report.getAllErrors(), new String[0]);
                return jsonResolution;
            }
            JsonResolution jsonResolution = new JsonResolution((Object)"Error: invalid id given", new String[0]);
            return jsonResolution;
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Error updating locations", (Throwable)ex);
            return new JsonResolution((Object)ex, new String[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Resolution get() {
        if (this.location == null) return new JsonResolution((Object)"Geen locatie gevonden", new String[0]);
        try (Connection con = DB.getConnection();){
            GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
            BeanListHandler listHandler = new BeanListHandler(Location.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
            List locs = null;
            locs = (List)DB.qr().query(con, "select * from playservice_locations where id = ? and removedfromplaymapping = false and (removedfromplayadvisor = false or removedfromplayadvisor is null);", (ResultSetHandler)listHandler, new Object[]{this.location});
            Location loc = (Location)locs.get(0);
            HashMap<Integer, JSONArray> imgsPerLoc = new HashMap<Integer, JSONArray>();
            PlayadvisorExporter pe = new PlayadvisorExporter();
            if (!(loc.getRemovedfromplayadvisor() != null && loc.getRemovedfromplayadvisor().booleanValue() || loc.getRemovedfromplaymapping() != null && loc.getRemovedfromplaymapping().booleanValue())) {
                imgsPerLoc.put(loc.getId(), pe.retrieveImages(loc.getId(), con, "pietje", null));
            }
            JSONObject obj = pe.createLocationJSON(loc, con, imgsPerLoc);
            StreamingResolution streamingResolution = new StreamingResolution("application/json", obj.toString(4));
            return streamingResolution;
        }
        catch (IOException | SQLException | NamingException ex) {
            log.error((Object)"Error updating locations", (Throwable)ex);
            return new JsonResolution((Object)ex, new String[0]);
        }
    }

    public Resolution importPlayadvisorLocation() {
        String logString = "";
        String baseurl = CronListener.WORDPRESS_BASEURL;
        String authkey = CronListener.AUTHKEY;
        String pmbaseurl = CronListener.PLAYMAPPING_BASEURL;
        try (Connection con = DB.getConnection();){
            Project p = this.getProject(this.project, con);
            ImportReport report = new ImportReport();
            PlayadvisorImporter paimporter = new PlayadvisorImporter(p);
            paimporter.loadLocation(this.location, con, baseurl, authkey, report);
            logString = "Playadvisor:  " + System.lineSeparator() + report.toLog() + System.lineSeparator();
            this.context.getMessages().add(new SimpleMessage(logString, new Object[0]));
            log.error((Object)("imported: " + logString));
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot do initial load for playadvisor", (Throwable)ex);
            this.context.getValidationErrors().add("cronjob", (ValidationError)new SimpleError("Error saving:" + ex.getLocalizedMessage(), new Object[0]));
            logString = "Error for playadvisor: " + System.lineSeparator();
            logString = logString + ex.getLocalizedMessage();
        }
        catch (Exception e) {
            log.error((Object)"Cannot process locations: ", (Throwable)e);
        }
        return new ForwardResolution(JSP);
    }

    public Resolution pushLocationsWithoutImages() {
        if (this.location != null || this.project != null) {
            try (Connection con = DB.getConnection();){
                GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
                BeanListHandler listHandler = new BeanListHandler(Location.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
                PlayadvisorExporter pe = new PlayadvisorExporter();
                List locs = null;
                locs = this.project != null ? (List)DB.qr().query(con, "select * from playservice_locations where project = ?", (ResultSetHandler)listHandler, new Object[]{"" + this.project}) : (List)DB.qr().query(con, "select * from playservice_locations where id = ?", (ResultSetHandler)listHandler, new Object[]{this.location});
                for (Location loc : locs) {
                    Project p = this.getProject(loc.getMunicipality(), con);
                    if (p == null) {
                        this.context.getMessages().add(new SimpleMessage("Locatie overgeslagen want geen project. Loc: " + loc.getTitle() + " - Gemeente: " + loc.getMunicipality(), new Object[0]));
                        continue;
                    }
                    try {
                        String baseurl = this.context.getServletContext().getInitParameter("wordpress.baseurl");
                        String authkey = this.context.getServletContext().getInitParameter("wordpress.authkey");
                        String result = pe.pushLocation(loc, con, new HashMap(), baseurl, authkey);
                        this.context.getMessages().add(new SimpleMessage(result, new Object[0]));
                    }
                    catch (IOException | URISyntaxException ex) {
                        log.error((Object)"Canot push location to playadvisor", (Throwable)ex);
                        this.context.getValidationErrors().add("Error", (ValidationError)new SimpleError(ex.getLocalizedMessage(), new Object[0]));
                    }
                }
            }
            catch (SQLException | NamingException ex) {
                log.error((Object)"Error updating locations", (Throwable)ex);
                this.context.getMessages().add(new SimpleMessage("FOUT: ", new Object[]{ex}));
            }
        }
        return new ForwardResolution(JSP);
    }

    public Resolution updateLocation() {
        if (this.location != null || this.project != null) {
            try (Connection con = DB.getConnection();){
                GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
                BeanListHandler listHandler = new BeanListHandler(Location.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
                List locs = null;
                locs = this.project != null ? (List)DB.qr().query(con, "select * from playservice_locations where project = ?;", (ResultSetHandler)listHandler, new Object[]{"" + this.project}) : (List)DB.qr().query(con, "select * from playservice_locations where id = ?;", (ResultSetHandler)listHandler, new Object[]{this.location});
                String imagepath = this.context.getServletContext().getInitParameter("wordpress.upload.path");
                String baseurl = this.context.getServletContext().getInitParameter("wordpress.baseurl");
                String authkey = this.context.getServletContext().getInitParameter("wordpress.authkey");
                this.updateLoc(locs, imagepath, baseurl, authkey);
            }
            catch (SQLException | NamingException ex) {
                log.error((Object)"Error updating locations", (Throwable)ex);
            }
        }
        return new ForwardResolution(JSP);
    }

    private void updateLoc(List<Location> locs, String imagepath, String baseurl, String authkey) {
        PlayadvisorExporter pe = new PlayadvisorExporter();
        ImageDownloader downloader = new ImageDownloader(imagepath, locs.size() == 1 ? 30 : 600);
        String result = pe.pushLocations(locs, imagepath, baseurl, authkey, downloader);
        this.context.getMessages().add(new SimpleMessage(result, new Object[0]));
    }

    protected Project getProject(String gemeente, Connection con) throws NamingException, SQLException {
        Project p = (Project)DB.qr().query(con, "SELECT id,cronexpressie,type_,username,password,name,log,lastrun,mailaddress,baseurl, status, authkey, imagePath from project WHERE name ilike ?", this.projectHandler, new Object[]{"%" + gemeente + "%"});
        return p;
    }

    protected Project getProject(Integer projectID, Connection con) throws NamingException, SQLException {
        Project p = (Project)DB.qr().query(con, "SELECT id,cronexpressie,type_,username,password,name,log,lastrun,mailaddress,baseurl, status, authkey, imagePath from project WHERE id = ?", this.projectHandler, new Object[]{projectID});
        return p;
    }
}

