/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.naming.NamingException;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.loader.util.DbUtilsGeometryColumnConverter;
import nl.b3p.playbase.HttpDeleteWithBody;
import nl.b3p.playbase.ImageDownloader;
import nl.b3p.playbase.ImportReport;
import nl.b3p.playbase.PlayadvisorImporter;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Asset;
import nl.b3p.playbase.entities.Location;
import nl.b3p.playbase.entities.Project;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class PlayadvisorExporter {
    private static final Log log = LogFactory.getLog(PlayadvisorExporter.class);
    protected final ResultSetHandler<Project> projectHandler = new BeanHandler(Project.class);
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private final Integer[] excl = new Integer[]{58, 60, 61, 93, 22, 7, 56, 64, 177, 81, 82, 125, 87, 88, 89, 90, 92, 178, 111, 110, 109, 108, 127, 15, 23, 31, 32, 83, 171, 156, 155, 69, 68, 59, 152, 145, 144, 143, 141, 140, 139, 120, 119, 118, 117, 116, 115};
    private final List<Integer> excludedAssetTypes = Arrays.asList(this.excl);
    protected Map<Integer, List<String>> locationTypes;
    private Map<Integer, Integer> assetTypes;
    private Map<Integer, Integer> assetTypeToLocationCategory;
    private Map<Integer, String> equipmentTypes;

    public PlayadvisorExporter() {
        this.initLists();
    }

    public String pushLocations(List<Location> locations, String imagepath, String baseurl, String authkey, ImageDownloader downloader) throws IOException, URISyntaxException {
        StringBuilder sb = new StringBuilder();
        try (Connection con = DB.getConnection();){
            this.filterLocations(locations, con);
            log.debug((Object)("Pushing " + locations.size() + " locations to playadvisor."));
            downloader.run();
            log.debug((Object)"Retrieving images");
            HashMap<Integer, JSONArray> imagesPerLocation = new HashMap<Integer, JSONArray>();
            for (Location loc : locations) {
                if (loc.getRemovedfromplayadvisor() != null && loc.getRemovedfromplayadvisor().booleanValue() || loc.getRemovedfromplaymapping() != null && loc.getRemovedfromplaymapping().booleanValue()) continue;
                imagesPerLocation.put(loc.getId(), this.retrieveImages(loc.getId(), con, imagepath, downloader));
            }
            log.debug((Object)"Images downloading...");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                log.error((Object)"Error sleeping for 1 sec.", (Throwable)ex);
            }
            downloader.stop();
            log.debug((Object)"Images downloaded.");
            this.analyseImagesForDuplicates(locations, imagesPerLocation, con);
            log.debug((Object)"Pushing locations...");
            for (Location loc : locations) {
                try {
                    sb.append(this.pushLocation(loc, con, imagesPerLocation, baseurl, authkey));
                }
                catch (IOException | URISyntaxException ex) {
                    log.error((Object)"Error pushing location, retrying...", (Throwable)ex);
                    boolean success = this.retryPushingLocation(loc, sb, con, baseurl, authkey, imagesPerLocation);
                    if (success) continue;
                    log.error((Object)"Too many retries, break off pushing locations");
                    break;
                }
            }
            log.debug((Object)"Locations pushed.");
        }
        catch (InterruptedException | SQLException | NamingException ex) {
            log.error((Object)"Cannot push locations to playadvisor", (Throwable)ex);
        }
        return sb.toString();
    }

    private void filterLocations(List<Location> locs, Connection con) {
        Iterator<Location> iterator = locs.iterator();
        while (iterator.hasNext()) {
            Location next = iterator.next();
            if (this.shouldLocationBePushed(next, con)) continue;
            iterator.remove();
        }
    }

    private boolean retryPushingLocation(Location loc, StringBuilder sb, Connection con, String baseurl, String authkey, HashMap<Integer, JSONArray> imagesPerLocation) throws InterruptedException, SQLException, NamingException {
        int delay = 5000;
        int MAXDELAY = 10001;
        boolean trying = true;
        while (trying) {
            Thread.sleep(delay);
            try {
                sb.append(this.pushLocation(loc, con, imagesPerLocation, baseurl, authkey));
                trying = false;
            }
            catch (IOException | URISyntaxException e) {
                delay *= 2;
            }
            if (delay <= 10001) continue;
        }
        return !trying;
    }

    public Map<Integer, JSONArray> analyseImagesForDuplicates(List<Location> locations, Map<Integer, JSONArray> imagesPerLocation, Connection con) throws NamingException, SQLException {
        HashMap<Integer, JSONArray> uniques = new HashMap<Integer, JSONArray>();
        for (Location location : locations) {
            Boolean alreadyChecked = location.getDuplicate_images_checked();
            if (location.getPm_guid() == null || location.getPa_id() == null || alreadyChecked != null && alreadyChecked.booleanValue()) continue;
            log.debug((Object)("Checking for duplicates for " + location.getTitle()));
            JSONArray images = imagesPerLocation.get(location.getId());
            if (images == null) continue;
            JSONArray uniqueArray = this.removeDuplicates(images, con);
            imagesPerLocation.put(location.getId(), uniqueArray);
            uniques.put(location.getId(), uniqueArray);
            try {
                int numUpdated = DB.qr().update(con, "UPDATE playservice_locations SET duplicate_images_checked = true WHERE id = ?", (Object)location.getId());
                location.setDuplicate_images_checked(Boolean.valueOf(true));
                boolean bl = false;
            }
            catch (SQLException | NamingException ex) {
                log.error((Object)"Cannot update location for duplicate_images_checked", (Throwable)ex);
            }
        }
        log.debug((Object)"analyzing finished");
        return uniques;
    }

    protected JSONArray removeDuplicates(JSONArray images, Connection con) throws NamingException, SQLException {
        HashMap loadedImages = new HashMap();
        HashMap<Integer, JSONObject> indexedImages = new HashMap<Integer, JSONObject>();
        for (Object image : images) {
            JSONObject img = (JSONObject)image;
            Integer id = img.getInt("PlaybaseID");
            BufferedImage ri = this.open(img);
            if (ri == null) continue;
            loadedImages.put(id, ri);
            indexedImages.put(id, img);
        }
        ArrayList<Integer> imgsToRemove = new ArrayList<Integer>();
        double threshold = 5.0;
        HashSet<Integer> completedKeys = new HashSet<Integer>();
        for (Integer key1 : loadedImages.keySet()) {
            if (completedKeys.contains(key1)) continue;
            BufferedImage img1 = (BufferedImage)loadedImages.get(key1);
            for (Integer key2 : loadedImages.keySet()) {
                BufferedImage img2;
                double diff;
                if (key1.equals(key2) || completedKeys.contains(key2) || !((diff = this.getDifferencePercent(img1, img2 = (BufferedImage)loadedImages.get(key2))) < threshold)) continue;
                log.error((Object)("Difference for " + ((JSONObject)indexedImages.get(key1)).getString("Path") + " - " + ((JSONObject)indexedImages.get(key2)).getString("Path") + ": " + diff));
                completedKeys.add(key2);
                imgsToRemove.add(key1);
            }
        }
        for (Integer keyToRemove : imgsToRemove) {
            JSONObject objectToRemove = (JSONObject)indexedImages.remove(keyToRemove);
            this.removeImage(objectToRemove, con);
        }
        JSONArray uniqueImages = new JSONArray();
        for (Object image : images) {
            JSONObject img = (JSONObject)image;
            Integer id = img.getInt("PlaybaseID");
            if (!indexedImages.containsKey(id)) continue;
            uniqueImages.put((Object)img);
        }
        return uniqueImages;
    }

    private double getDifferencePercent(BufferedImage img1, BufferedImage img2) {
        int width = img1.getWidth();
        int height = img1.getHeight();
        int width2 = img2.getWidth();
        int height2 = img2.getHeight();
        if (width != width2 || height != height2) {
            return 100.0;
        }
        long diff = 0L;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                diff += (long)this.pixelDiff(img1.getRGB(x, y), img2.getRGB(x, y));
            }
        }
        long maxDiff = 765L * (long)width * (long)height;
        return 100.0 * (double)diff / (double)maxDiff;
    }

    private int pixelDiff(int rgb1, int rgb2) {
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int r2 = rgb2 >> 16 & 0xFF;
        int g2 = rgb2 >> 8 & 0xFF;
        int b2 = rgb2 & 0xFF;
        return Math.abs(r1 - r2) + Math.abs(g1 - g2) + Math.abs(b1 - b2);
    }

    public BufferedImage open(JSONObject obj) {
        try {
            String path = obj.getString("Path");
            URI u = new URI(path);
            File f = u.isAbsolute() ? new File(u) : new File(path);
            BufferedImage renderedImage = ImageIO.read(f);
            return renderedImage;
        }
        catch (IOException | URISyntaxException e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    private void removeImage(JSONObject img, Connection con) {
        if (img != null) {
            log.info((Object)("Removing image: " + img.toString()));
            try {
                int n = DB.qr().update(con, "UPDATE playservice_images SET pa_deleted = true WHERE id = ?", (Object)img.getInt("PlaybaseID"));
            }
            catch (SQLException | NamingException ex) {
                log.error((Object)"Cannot update location for duplicate_images_checked", (Throwable)ex);
            }
            try {
                String path = img.getString("Path");
                URI u = new URI(path);
                File f = u.isAbsolute() ? new File(u) : new File(path);
                boolean deleted = f.delete();
                if (!deleted) {
                    log.error((Object)("Cannot create file: " + path));
                }
            }
            catch (URISyntaxException ex) {
                log.error((Object)"Cannot create file object for deleting file: ", (Throwable)ex);
            }
        }
    }

    public String pushLocation(Location loc, Connection con, HashMap<Integer, JSONArray> imgsPerLoc, String baseurl, String authkey) throws IOException, SQLException, NamingException, URISyntaxException {
        return this.pushLocation(loc, this.createLocationJSON(loc, con, imgsPerLoc), "", baseurl, authkey, con);
    }

    private String pushLocation(Location loc, JSONObject location, String id, String baseurl, String authkey, Connection con) throws IOException, URISyntaxException {
        String result = "";
        if (loc.getRemovedfromplaymapping() != null && loc.getRemovedfromplaymapping().booleanValue() && (loc.getRemovedfromplayadvisor() == null || !loc.getRemovedfromplayadvisor().booleanValue())) {
            if (loc.getPa_id() != null) {
                HttpDeleteWithBody request = new HttpDeleteWithBody();
                log.debug((Object)"Nieuw verwijderd item in playmapping verwijderen uit playadvisor.");
                result = this.doRequest(loc.getPa_id(), location, baseurl, authkey, (HttpEntityEnclosingRequestBase)request);
                this.setLocationLastPushed(loc, con);
            } else {
                result = "locatie niet bekend bij playadvisor.";
            }
            loc.setRemovedfromplayadvisor(Boolean.valueOf(true));
            try {
                PlayadvisorImporter imp = new PlayadvisorImporter(this.getProject(loc.getProject(), con));
                imp.postfix = "";
                ImportReport report = new ImportReport();
                imp.saveLocation(loc, report, con);
            }
            catch (SQLException | NamingException ex) {
                log.error((Object)"Cannot update location with removedfromplayadvisor = true", (Throwable)ex);
            }
        } else if (!(loc.getRemovedfromplaymapping() != null && loc.getRemovedfromplaymapping().booleanValue() || loc.getRemovedfromplayadvisor() != null && loc.getRemovedfromplayadvisor().booleanValue())) {
            HttpPost request = new HttpPost();
            result = this.doRequest("", location, baseurl, authkey, (HttpEntityEnclosingRequestBase)request);
            this.processResponse(result, con);
            this.setLocationLastPushed(loc, con);
        } else if (loc.getRemovedfromplaymapping().booleanValue() && loc.getRemovedfromplayadvisor().booleanValue()) {
            result = "Verwijderd, nergens up te daten.";
        }
        return result;
    }

    private void setLocationLastPushed(Location loc, Connection con) {
        StringBuilder sb = new StringBuilder();
        sb.append("update ");
        sb.append("playservice_locations");
        sb.append(" set last_pushed_to_pa = ? where id = ?");
        try {
            DB.qr().update(con, sb.toString(), new Object[]{new Date(new java.util.Date().getTime()), loc.getId()});
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot update date last pushed for location ", (Throwable)ex);
        }
    }

    public boolean shouldLocationBePushed(Location loc, Connection con) {
        if (loc.getPm_guid() == null) {
            return false;
        }
        java.util.Date prevPushedDate = loc.getLast_pushed_to_pa();
        java.util.Date lastModified = loc.getPm_lastmodified();
        if (prevPushedDate == null) {
            return true;
        }
        if (lastModified.after(prevPushedDate)) {
            return true;
        }
        try {
            List assets = this.retrieveAssets(loc.getId(), con);
            for (Asset asset : assets) {
                java.util.Date assetModified = asset.getPm_lastmodified();
                if (asset.getPm_guid() == null || assetModified != null && !assetModified.after(prevPushedDate) && !assetModified.equals(prevPushedDate)) continue;
                return true;
            }
            return this.newImages(loc, con);
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot get assets or images. Update to playadvisor", (Throwable)ex);
            return true;
        }
    }

    private boolean newImages(Location loc, Connection con) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List images = (List)DB.qr().query(con, "SELECT url, lastupdated from playservice_images WHERE location = ? and pm_guid is not null", (ResultSetHandler)rsh, new Object[]{loc.getId()});
        for (Object[] image : images) {
            java.util.Date lastupdated;
            String url = (String)this.valueOrEmptyString(image[0]);
            if (url.isEmpty() || (lastupdated = (java.util.Date)image[1]) == null || !lastupdated.after(loc.getLast_pushed_to_pa())) continue;
            return true;
        }
        return false;
    }

    public void updateIDs(List<Location> locs, Connection con, String baseurl, String authkey) throws IOException, URISyntaxException {
        JSONObject ids = new JSONObject();
        for (Location loc : locs) {
            List images = loc.getImages();
            if (loc.getPa_id() != null) {
                ids.put(loc.getPa_id(), (Object)loc.getId());
            }
            for (Map image : images) {
                String pa_id = (String)image.get("pa_id");
                if (pa_id == null || pa_id.isEmpty()) continue;
                ids.put((String)image.get("pa_id"), (Object)((String)image.get("PlaybaseID")));
            }
        }
        try {
            HttpPost request = new HttpPost();
            this.doRequest("update-ids", ids, baseurl, authkey, (HttpEntityEnclosingRequestBase)request);
        }
        catch (IOException | URISyntaxException ex) {
            log.error((Object)"Cannot update image id for location ", (Throwable)ex);
        }
    }

    private void processResponse(String obj, Connection con) {
        PlayadvisorImporter imp = new PlayadvisorImporter(null);
        ImportReport report = new ImportReport();
        try {
            JSONObject jsonObj = new JSONObject(obj);
            JSONArray jsonArray = new JSONArray();
            jsonArray.put((Object)jsonObj);
            List list = imp.processLocations(jsonArray.toString(), report, con);
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot process response: ", (Throwable)ex);
        }
    }

    private String doRequest(String endpoint, JSONObject payload, String baseurl, String authkey, HttpEntityEnclosingRequestBase request) throws IOException, URISyntaxException {
        String url = baseurl + "/wp-json/b3p/v1/playbase/" + endpoint;
        log.debug((Object)("Do request to playadvisor: " + url + ". With payload: " + payload.toString()));
        request.setURI(new URI(url));
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        StringEntity params = new StringEntity(payload.toString(), ContentType.APPLICATION_JSON);
        request.addHeader("content-type", "application/json");
        request.addHeader("Authorization", "Basic " + authkey);
        request.setEntity((HttpEntity)params);
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        StatusLine sl = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        int statusCode = sl.getStatusCode();
        String stringResult = EntityUtils.toString((HttpEntity)entity);
        if (statusCode != 200) {
            String statusLine = response.getStatusLine().getReasonPhrase();
            log.debug((Object)("Error: " + statusLine));
            log.debug((Object)("Error: " + stringResult));
            throw new IOException(statusLine);
        }
        log.debug((Object)("Result: " + stringResult));
        return stringResult;
    }

    public JSONObject createLocationJSON(Location loc, Connection con, HashMap<Integer, JSONArray> imgsPerLoc) throws SQLException, NamingException, IOException {
        JSONObject obj = loc.toPlayadvisorJSON();
        Integer id = loc.getId();
        JSONArray imgs = imgsPerLoc.getOrDefault(loc.getId(), new JSONArray());
        obj.put("Images", (Object)imgs);
        this.retrieveCategories(id, obj, con);
        this.retrieveAssets(id, obj, con, loc.getPm_guid() != null);
        this.retrieveAgeCategories(id, obj, con);
        this.retrieveAccessibilities(id, obj, con);
        this.retrieveFacilities(id, obj, con);
        this.retrieveParking(id, obj, con);
        this.retrieveYoungestAssetDate(id, obj, con);
        return obj;
    }

    protected void retrieveParking(Integer id, JSONObject obj, Connection con) throws NamingException, SQLException {
        MapHandler rsh = new MapHandler();
        Map m = (Map)DB.qr().query(con, "SELECT park.parking from playservice_locations loc inner join playservice_parking_list park on loc.parking = park.id", (ResultSetHandler)rsh);
        JSONArray parkings = new JSONArray();
        if (m != null) {
            parkings.put(m.get("parking"));
        }
        obj.put("Parkeren", (Object)parkings);
    }

    protected void retrieveFacilities(Integer id, JSONObject obj, Connection con) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List facilities = (List)DB.qr().query(con, "SELECT cat.facility from playservice_location_facilities loc inner join playservice_facilities_list as cat on cat.id = loc.facility  WHERE location = " + id, (ResultSetHandler)rsh);
        JSONArray facs = new JSONArray();
        for (Object[] cat : facilities) {
            facs.put(cat[0]);
        }
        obj.put("Faciliteiten", (Object)facs);
    }

    protected void retrieveAccessibilities(Integer id, JSONObject obj, Connection con) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List cats = (List)DB.qr().query(con, "SELECT cat.accessibility from playservice_location_accessibility loc inner join playservice_accessibility_list as cat on cat.id = loc.accessibility  WHERE location = " + id, (ResultSetHandler)rsh);
        JSONArray agecats = new JSONArray();
        for (Object[] cat : cats) {
            agecats.put(cat[0]);
        }
        obj.put("Toegankelijkheid", (Object)agecats);
    }

    protected void retrieveAgeCategories(Integer id, JSONObject obj, Connection con) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List cats = (List)DB.qr().query(con, "SELECT cat.agecategory from playservice_location_agecategories loc inner join playservice_agecategories_list as cat on cat.id = loc.agecategory  WHERE location = " + id, (ResultSetHandler)rsh);
        JSONArray agecats = new JSONArray();
        for (Object[] cat : cats) {
            agecats.put(cat[0]);
        }
        obj.put("Leeftijdscategorie", (Object)agecats);
    }

    private void retrieveYoungestAssetDate(Integer id, JSONObject obj, Connection con) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List m = (List)DB.qr().query(con, "select installeddate from playservice_location_equipment where  location = " + id, (ResultSetHandler)rsh);
        int numNew = 0;
        Calendar c = Calendar.getInstance();
        c.add(1, -2);
        java.util.Date mustBeAfter = c.getTime();
        for (Object[] asset : m) {
            String d = (String)asset[0];
            if (d == null || d.equals("")) continue;
            try {
                java.util.Date date = this.sdf.parse(d);
                if (!mustBeAfter.before(date)) continue;
                ++numNew;
            }
            catch (ParseException ex) {
                log.debug((Object)("Cannot parse date: " + d), (Throwable)ex);
            }
        }
        double ratio = (double)numNew / (double)m.size();
        Boolean isNew = ratio > 0.3;
        obj.put("newPlayGround", (Object)isNew.toString());
    }

    public JSONArray retrieveImages(Integer id, Connection con, String imagepath, ImageDownloader downloader) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List images = (List)DB.qr().query(con, "SELECT url, caption,pa_id,id,pa_url, pa_deleted, pm_deleted from playservice_images WHERE location = ? order by equipment desc, lastupdated desc", (ResultSetHandler)rsh, new Object[]{id});
        JSONArray imgs = new JSONArray();
        int index = 0;
        for (Object[] image : images) {
            String url = (String)this.valueOrEmptyString(image[0]);
            if (url.isEmpty()) continue;
            Boolean pa_deleted = (Boolean)image[5];
            Boolean pm_deleted = (Boolean)image[6];
            if (pa_deleted != null && pa_deleted.booleanValue() || pm_deleted != null && pm_deleted.booleanValue()) {
                ++index;
                continue;
            }
            String imageName = url.substring(url.lastIndexOf("/") + 1);
            if (imageName.toLowerCase().contains("getimage.ashx")) {
                imageName = "Image" + id + "-" + index + ".jpg";
            }
            Integer imageId = (Integer)image[3];
            JSONObject img = new JSONObject();
            img.put("Path", (Object)(imagepath + File.separator + imageName));
            img.put("PlaybaseID", (Object)imageId);
            img.put("PlayadvisorID", this.valueOrEmptyString(image[2]));
            imgs.put((Object)img);
            ++index;
            if (downloader == null) continue;
            downloader.add(url, imageName);
        }
        return imgs;
    }

    private void retrieveAssets(Integer id, JSONObject location, Connection con, boolean onlyPlaymapping) throws NamingException, SQLException {
        List assets = this.retrieveAssets(id, con);
        HashSet<String> types = new HashSet<String>();
        HashSet<String> equipments = new HashSet<String>();
        for (Asset asset : assets) {
            Integer type;
            Integer equipment;
            String eq;
            if ((!onlyPlaymapping || asset.getPm_guid() == null) && onlyPlaymapping || (eq = (String)this.equipmentTypes.get(equipment = (Integer)this.assetTypes.get(type = asset.getType_()))) == null) continue;
            equipments.add(eq);
        }
        for (String assetType : equipments) {
            types.add(assetType);
        }
        location.put("Assets", (Object)new JSONArray(types));
    }

    private List<Asset> retrieveAssets(Integer locationId, Connection con) throws NamingException, SQLException {
        GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
        BeanListHandler assHandler = new BeanListHandler(Asset.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
        List assets = (List)DB.qr().query(con, "SELECT * FROM playservice_location_equipment WHERE location = ? and removedfromplaymapping = false", (ResultSetHandler)assHandler, new Object[]{locationId});
        return assets;
    }

    protected void retrieveCategories(Integer id, JSONObject location, Connection con) throws NamingException, SQLException {
        ArrayListHandler rsh = new ArrayListHandler();
        List cats = (List)DB.qr().query(con, "SELECT cat.main, cat.category from playservice_location_categories loc inner join playservice_categories_list cat on cat.id = loc.category  WHERE location = " + id, (ResultSetHandler)rsh);
        HashSet<String> types = new HashSet<String>();
        for (Object[] cat : cats) {
            types.add((String)cat[0]);
            types.add((String)cat[1]);
        }
        GeometryJdbcConverter geometryConverter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)con);
        BeanListHandler assHandler = new BeanListHandler(Asset.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(geometryConverter)));
        List assets = (List)DB.qr().query(con, "SELECT * FROM playservice_location_equipment WHERE location = ? and removedfromplaymapping = false", (ResultSetHandler)assHandler, new Object[]{id});
        for (Asset asset : assets) {
            Integer type = asset.getType_();
            if (this.excludedAssetTypes.contains(type) || type == null) continue;
            Integer eq = (Integer)this.assetTypeToLocationCategory.get(type);
            List locCats = (List)this.locationTypes.get(eq);
            types.addAll(locCats);
        }
        if (types.isEmpty()) {
            types.add("Openbare speeltuin");
        }
        location.put("Categorieen", (Object)new JSONArray(types));
    }

    private void initLists() {
        Integer id;
        List o;
        ArrayListHandler rsh = new ArrayListHandler();
        try {
            this.equipmentTypes = new HashMap();
            o = (List)DB.qr().query("SELECT id, equipment from playservice_equipment_list", (ResultSetHandler)rsh);
            for (Object[] type : o) {
                id = (Integer)type[0];
                String cat = (String)type[1];
                this.equipmentTypes.put(id, cat);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playmapping assettypes:", (Throwable)ex);
        }
        try {
            this.locationTypes = new HashMap();
            o = (List)DB.qr().query("SELECT id, category, main from playservice_categories_list", (ResultSetHandler)rsh);
            for (Object[] type : o) {
                id = (Integer)type[0];
                String category = (String)type[1];
                String main = (String)type[2];
                this.locationTypes.put(id, new ArrayList());
                ((List)this.locationTypes.get(id)).add(category);
                ((List)this.locationTypes.get(id)).add(main);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playadvisor location types:", (Throwable)ex);
        }
        try {
            this.assetTypes = new HashMap();
            this.assetTypeToLocationCategory = new HashMap();
            o = (List)DB.qr().query("SELECT id, equipment_type, locationcategory from playmapping_type_group", (ResultSetHandler)rsh);
            for (Object[] type : o) {
                id = (Integer)type[0];
                Integer equipmentType = (Integer)type[1];
                Integer locationcategory = (Integer)type[2];
                this.assetTypes.put(id, equipmentType);
                this.assetTypeToLocationCategory.put(id, locationcategory);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot initialize playmapping assettypes:", (Throwable)ex);
        }
    }

    private Object valueOrEmptyString(Object value) {
        return value == null ? "" : value;
    }

    protected Project getProject(Integer projectID, Connection con) throws NamingException, SQLException {
        Project p = (Project)DB.qr().query(con, "SELECT id,cronexpressie,type_,username,password,name,log,lastrun,mailaddress,baseurl, status, authkey, imagePath from project WHERE id = ?", this.projectHandler, new Object[]{projectID});
        return p;
    }
}

