/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import nl.b3p.playbase.ImportReport;
import nl.b3p.playbase.Importer;
import nl.b3p.playbase.db.DB;
import nl.b3p.playbase.entities.Asset;
import nl.b3p.playbase.entities.Location;
import nl.b3p.playbase.entities.Project;
import nl.b3p.playbase.entities.Status;
import nl.b3p.playbase.stripes.MatchActionBean;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class PlayadvisorImporter
extends Importer {
    private static final Log log = LogFactory.getLog(PlayadvisorImporter.class);

    public PlayadvisorImporter(Project project) {
        super(project);
        this.postfix = "_playadvisor";
    }

    public void initialLoad(Project job, ImportReport report, Connection con, String baseurl, String authkey) throws NamingException, SQLException {
        String[] municipalities;
        String muns = this.getProject().getName().toLowerCase();
        for (String municipality : municipalities = muns.split(",")) {
            municipality = municipality.trim();
            try {
                String url = baseurl + "/wp-json/b3p/v1/playbase/" + URLEncoder.encode(municipality, "UTF-8") + "?" + System.nanoTime();
                CloseableHttpClient httpClient = HttpClientBuilder.create().build();
                HttpGet request = new HttpGet(url);
                request.addHeader("Content-Type", "application/json");
                request.addHeader("Authorization", "Basic " + authkey);
                HttpResponse response = httpClient.execute((HttpUriRequest)request);
                StatusLine sl = response.getStatusLine();
                HttpEntity entity = response.getEntity();
                int statusCode = sl.getStatusCode();
                if (statusCode != 200) {
                    String statusLine = response.getStatusLine().getReasonPhrase();
                    log.debug((Object)("Error: " + statusLine));
                    throw new IOException(statusLine);
                }
                String stringResult = EntityUtils.toString((HttpEntity)entity);
                List locs = this.processLocations(stringResult, report, con);
                log.debug((Object)("Result: " + stringResult));
            }
            catch (IOException ex) {
                log.error((Object)("Error while getting all speelplekken for project " + this.getProject() + " and municipality: " + municipality), (Throwable)ex);
                report.addError(ex.getLocalizedMessage(), ImportReport.ImportType.GENERAL);
            }
        }
    }

    public void loadLocation(Integer locationId, Connection con, String baseurl, String authkey, ImportReport report) throws NamingException, SQLException {
        try {
            String url = baseurl + "/wp-json/b3p/v1/playbase/" + locationId + "?" + System.nanoTime();
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpGet request = new HttpGet(url);
            request.addHeader("Content-Type", "application/json");
            request.addHeader("Authorization", "Basic " + authkey);
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            StatusLine sl = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            int statusCode = sl.getStatusCode();
            if (statusCode != 200) {
                String statusLine = response.getStatusLine().getReasonPhrase();
                log.debug((Object)("Error: " + statusLine));
                throw new IOException(statusLine);
            }
            String stringResult = EntityUtils.toString((HttpEntity)entity);
            List locs = this.processLocations(stringResult, report, con);
            log.debug((Object)("Result: " + stringResult));
        }
        catch (IOException ex) {
            log.error((Object)("Error while getting all speelplekken for project " + this.getProject() + " and location: " + locationId), (Throwable)ex);
            report.addError(ex.getLocalizedMessage(), ImportReport.ImportType.GENERAL);
        }
    }

    public List<Location> processLocations(String locs, ImportReport report, Connection con) throws NamingException, SQLException {
        ArrayList<Location> locations = new ArrayList<Location>();
        JSONArray ar = new JSONArray(locs);
        for (JSONObject obj : ar) {
            boolean hasProject = this.getProject() != null;
            Location l = this.parseLocation(obj, con, report);
            if (l == null) continue;
            String prevpostfix = this.postfix;
            try {
                if (this.isProjectReady(this.getProject(), con) || this.isPlaygroundAlreadyMerged(l, con)) {
                    this.postfix = "";
                }
                this.processLocation(l, obj, report, con);
                locations.add(l);
                if (!hasProject) {
                    this.setProject(null);
                }
                if (!this.postfix.isEmpty()) continue;
                this.postfix = prevpostfix;
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Error processing location " + l.getTitle()), (Throwable)e);
            }
        }
        return locations;
    }

    private boolean isProjectReady(Project project, Connection con) throws NamingException, SQLException, IllegalArgumentException {
        if (project.getStatus() == null) {
            BeanListHandler handler = new BeanListHandler(Project.class);
            List projects = (List)DB.qr().query(con, "SELECT id,cronexpressie,type_,username,password,name,log,lastrun,mailaddress,baseurl, status from project WHERE name = ?", (ResultSetHandler)handler, new Object[]{project.getName()});
            if (projects.size() == 1) {
                project = (Project)projects.get(0);
            } else {
                if (projects.isEmpty()) {
                    throw new IllegalArgumentException("Speelplek heeft geen geconfigureerd project voor " + project.getName());
                }
                throw new IllegalArgumentException("Speelplek heeft meer dan 1 (" + projects.size() + ") geconfigureerd project voor " + project.getName());
            }
        }
        return project.getStatus() == Status.PUBLISHED;
    }

    private boolean isPlaygroundAlreadyMerged(Location loc, Connection con) throws NamingException, SQLException, IllegalArgumentException {
        Status s = loc.getStatus();
        if (loc.getId() != null) {
            Location currentLocation = (Location)DB.qr().query(con, "select * from playservice_locations where id = ?", this.locationHandler, new Object[]{loc.getId()});
            if (currentLocation == null && loc.getPa_id() != null) {
                currentLocation = (Location)DB.qr().query(con, "select * from playservice_locations where pa_id = ?", this.locationHandler, new Object[]{loc.getPa_id()});
                return currentLocation != null;
            }
            return true;
        }
        return s != null && s != Status.UNDER_REVIEW && s != Status.UNPUBLISHED;
    }

    protected void processLocation(Location location, JSONObject obj, ImportReport report, Connection con) throws NamingException {
        boolean locationAlreadyExists = false;
        int id = -1;
        try {
            if (location.getPa_id() != null) {
                Location currentLocation = (Location)DB.qr().query(con, "select * from playservice_locations" + this.postfix + " where pa_id = ?", this.locationHandler, new Object[]{location.getPa_id()});
                if (currentLocation != null) {
                    locationAlreadyExists = true;
                    location.setStatus(currentLocation.getStatus());
                } else {
                    location.setStatus(Status.UNPUBLISHED);
                }
            }
            List imgs = this.parseImages(location, obj, report);
            List images = this.processImages(location, imgs, report, con);
            location = this.mergeLocation(location);
            location.setImages(images);
            id = this.saveLocation(location, report, con);
            try {
                List assets = this.parseAssets(location, obj.getJSONArray("Assets"), report, false, con);
                for (Asset asset : assets) {
                    this.saveAsset(asset, report);
                }
            }
            catch (SQLException e) {
                log.error((Object)"Cannot process location", (Throwable)e);
                report.addError("Cannot process location: " + e.getLocalizedMessage(), ImportReport.ImportType.ASSET);
            }
        }
        catch (SQLException e) {
            log.error((Object)"Cannot process location", (Throwable)e);
            report.addError("Cannot process location: " + e.getLocalizedMessage(), ImportReport.ImportType.LOCATION);
        }
        try {
            this.saveLocationAgeCategory(location, Arrays.asList(location.getAgecategories()), locationAlreadyExists);
        }
        catch (SQLException ex) {
            report.addError(ex.getLocalizedMessage() + ". Location is saved, but agecategory is not.", ImportReport.ImportType.LOCATION);
        }
        try {
            this.saveLocationType(location, obj, locationAlreadyExists);
        }
        catch (UnsupportedEncodingException | IllegalArgumentException | SQLException ex) {
            report.addError(ex.getLocalizedMessage() + ". Location is saved, but type is not.", ImportReport.ImportType.LOCATION);
        }
        try {
            this.saveFacilities(location, obj, locationAlreadyExists);
        }
        catch (IllegalArgumentException | SQLException ex) {
            report.addError(ex.getLocalizedMessage() + ". Location is saved, but facilities are not.", ImportReport.ImportType.LOCATION);
        }
        try {
            this.saveAccessibility(Integer.valueOf(id), obj, locationAlreadyExists);
        }
        catch (IllegalArgumentException | SQLException ex) {
            report.addError(ex.getLocalizedMessage() + ". Location is saved, but accessiblity is not.", ImportReport.ImportType.LOCATION);
        }
    }

    private Location mergeLocation(Location loc) throws SQLException, NamingException {
        Location dbLoc = this.getExistingLocation(loc);
        if (dbLoc != null) {
            dbLoc.setMunicipality(loc.getMunicipality());
            dbLoc.setAgecategories(loc.getAgecategories());
            dbLoc.setStatus(loc.getStatus());
            loc = MatchActionBean.mergeLocations((Location)loc, (Location)dbLoc);
        }
        return loc;
    }

    public Location getExistingLocation(Location newLocation) throws NamingException, SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ");
        sb.append("playservice_locations");
        if (newLocation.getId() != null && newLocation.getId() != -1) {
            sb.append(" where id = '");
            sb.append(newLocation.getId());
        } else {
            sb.append(" where pa_id = '");
            sb.append(newLocation.getPa_id());
        }
        sb.append("';");
        Location loc = (Location)DB.qr().query(sb.toString(), this.locationHandler);
        return loc;
    }

    protected Location parseLocation(JSONObject obj, Connection con, ImportReport report) throws NamingException, SQLException {
        Location loc = new Location();
        loc.setId(Integer.valueOf(obj.optInt("PlaybaseID")));
        loc.setPa_title(obj.optString("Titel"));
        loc.setPhone(obj.optString("Telefoon"));
        loc.setPa_content(obj.optString("Content"));
        loc.setWebsite(obj.optString("Website"));
        if (obj.has("Latitude")) {
            loc.setLatitude(Double.valueOf(obj.getDouble("Latitude")));
        } else if (obj.has("Latitude") && obj.get("Latitude") instanceof String && !obj.get("Latitude").equals("")) {
            loc.setLatitude(Double.valueOf(Double.parseDouble(obj.getString("Longitude"))));
        }
        if (obj.has("Longitude") && obj.get("Longitude") instanceof Double) {
            loc.setLongitude(Double.valueOf(obj.getDouble("Longitude")));
        } else if (obj.has("Longitude") && obj.get("Longitude") instanceof String && !obj.get("Longitude").equals("")) {
            loc.setLongitude(Double.valueOf(Double.parseDouble(obj.getString("Longitude"))));
        }
        loc.setPa_id("" + obj.getInt("PlayadvisorID"));
        loc.setMunicipality(obj.getString("Plaats"));
        if (this.getProject() == null) {
            Project p = this.getProject(loc, con);
            if (p == null) {
                if (report != null) {
                    report.addError("Project kan niet worden gevonden voor locatie " + loc.getPa_title() + " in " + loc.getMunicipality() + ". Controleer configuratie.", ImportReport.ImportType.LOCATION);
                }
                log.error((Object)("Project kan niet worden gevonden voor locatie " + loc.getPa_title() + " in " + loc.getMunicipality() + ". Controleer configuratie."));
                return null;
            }
            this.setProject(p);
            loc.setProject(p.getId());
        } else {
            loc.setProject(this.getProject().getId());
        }
        loc.setCountry(obj.getString("Land"));
        loc.setStreet(obj.optString("Straat"));
        loc.setEmail(obj.optString("Email"));
        JSONArray agecategories = obj.optJSONArray("Leeftijdscategorie");
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (Object next : agecategories) {
            String agecategory = (String)next;
            Integer id = (Integer)this.agecategoryTypes.get(agecategory.toLowerCase());
            if (id == null) {
                throw new IllegalArgumentException("Agecategory >" + agecategory + "< does not exist. Location with title >" + loc.getPa_title() + "< not saved.");
            }
            ids.add(id);
        }
        loc.setAgecategories(ids.toArray(new Integer[0]));
        return loc;
    }

    protected void saveLocationType(Location location, JSONObject locationObject, boolean deleteFirst) throws NamingException, SQLException, UnsupportedEncodingException {
        if (deleteFirst) {
            DB.qr().update("DELETE FROM playservice_location_categories" + this.postfix + " WHERE location = " + location.getId());
        }
        JSONArray types = locationObject.getJSONArray("Categorieen");
        HashSet<Integer> typeSet = new HashSet<Integer>();
        for (Object t : types) {
            Integer categoryId;
            String type = (String)t;
            Integer n = categoryId = this.allLocationTypes.containsKey(type = StringEscapeUtils.unescapeHtml4((String)type)) ? (Integer)this.allLocationTypes.get(type) : null;
            if (categoryId == null) {
                throw new IllegalArgumentException("Unknown category given: subcategory: " + type + ". Cannot save types for location with id: " + location.getId());
            }
            typeSet.add(categoryId);
        }
        this.saveLocationTypes(typeSet, location.getId());
    }

    protected void saveFacilities(Location location, JSONObject locationObj, boolean deleteFirst) throws NamingException, SQLException {
        if (deleteFirst) {
            DB.qr().update("DELETE FROM playservice_location_facilities" + this.postfix + " WHERE location = " + location.getId());
        }
        JSONArray facilities = locationObj.getJSONArray("Faciliteiten");
        for (Object f : facilities) {
            String facility = (String)f;
            Integer facilityId = (Integer)this.facilityTypes.get(facility);
            if (facilityId == null) {
                throw new IllegalArgumentException("Unknown facility given: " + facility + ". Cannot save facilities for location with id: " + location.getId());
            }
            this.saveFacilities(location, facilityId);
        }
    }

    protected void saveAccessibility(Integer locationId, JSONObject locationObj, boolean deleteFirst) throws NamingException, SQLException {
        if (deleteFirst) {
            DB.qr().update("DELETE FROM playservice_location_accessibility" + this.postfix + " WHERE location = " + locationId);
        }
        JSONArray accessibilities = locationObj.getJSONArray("Toegankelijkheid");
        for (Object a : accessibilities) {
            String accessiblity = (String)a;
            Integer id = (Integer)this.accessibilityTypes.get(accessiblity);
            if (id == null) {
                throw new IllegalArgumentException("Unknown accessibilty given: " + accessiblity + ". Cannot save types for location with id: " + locationId);
            }
            this.saveAccessibility(locationId, id);
        }
    }

    protected List<Asset> parseAssets(Location location, JSONArray assetsArray, ImportReport report, boolean merged, Connection con) throws NamingException, SQLException {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        for (String asset : assetsArray) {
            if (asset.isEmpty()) continue;
            Asset ass = new Asset();
            ass.setName(asset);
            ass.setPa_guid(location.getPa_id());
            ass.setLocation(location.getId());
            if (location.getLatitude() != null) {
                ass.setLatitude(location.getLatitude().doubleValue());
            }
            if (location.getLongitude() != null) {
                ass.setLongitude(location.getLongitude().doubleValue());
            }
            Integer[] cats = location.getAgecategories();
            ass.setAgecategories(cats);
            Integer equipmentType = this.getEquipmentType(asset);
            ass.setEquipment(equipmentType);
            ass.setType_((Integer)this.equipmenttypePAtoPM.get(equipmentType));
            assets.add(ass);
        }
        return assets;
    }

    protected List<Map<String, Object>> processImages(Location location, List<Map<String, Object>> imgs, ImportReport report, Connection con) {
        ArrayList<Map<String, Object>> newImages = new ArrayList<Map<String, Object>>();
        try {
            ArrayListHandler rsh = new ArrayListHandler();
            int id = location.getId();
            int index = 0;
            List dbImages = (List)DB.qr().query(con, "SELECT url, caption,pa_id,id, equipment, location from playservice_images WHERE location = ? order by equipment desc, lastupdated desc", (ResultSetHandler)rsh, new Object[]{location.getId()});
            for (Object[] objectArray : dbImages) {
                boolean found = false;
                String curImgUrl = (String)objectArray[0];
                String imageName = curImgUrl.substring(curImgUrl.lastIndexOf("/") + 1);
                if (imageName.toLowerCase().contains("getimage.ashx")) {
                    imageName = "Image" + id + "-" + index + ".jpg";
                }
                int curId = (Integer)objectArray[3];
                for (Map<String, Object> pushedImg : imgs) {
                    String pushedImgURI = (String)pushedImg.get("URI");
                    Integer dbPlaybaseId = (Integer)objectArray[3];
                    String pushedPlaybaseId = (String)pushedImg.get("PlaybaseID");
                    if (!pushedImgURI.contains(imageName) && !pushedImgURI.contains(imageName.substring(0, imageName.lastIndexOf("."))) && !pushedPlaybaseId.equals(dbPlaybaseId.toString())) continue;
                    found = true;
                    HashMap<String, Object> dbImage = new HashMap<String, Object>();
                    dbImage.put("Description", objectArray[1]);
                    dbImage.put("URI", curImgUrl);
                    dbImage.put("location", objectArray[5]);
                    dbImage.put("pa_id", pushedImg.get("pa_id"));
                    dbImage.put("id", dbPlaybaseId);
                    int numUpdated = DB.qr().update(con, "UPDATE playservice_images SET pa_id = ? WHERE id = ?", new Object[]{pushedImg.get("pa_id"), curId});
                    newImages.add(dbImage);
                    break;
                }
                if (!found) {
                    int numUpdated = DB.qr().update(con, "UPDATE playservice_images SET pa_deleted = true WHERE id = ?", (Object)curId);
                    boolean pushedImg = false;
                }
                ++index;
            }
            for (Map map : imgs) {
                boolean existsInDB = false;
                index = 0;
                for (Object[] dbImg : dbImages) {
                    String curImgUrl = (String)dbImg[0];
                    String imageName = curImgUrl.substring(curImgUrl.lastIndexOf("/") + 1);
                    if (imageName.toLowerCase().contains("getimage.ashx")) {
                        imageName = "Image" + id + "-" + index + ".jpg";
                    }
                    String pushedImgURI = (String)map.get("URI");
                    Integer dbPlaybaseId = (Integer)dbImg[3];
                    String pushedPlaybaseId = (String)map.get("PlaybaseID");
                    ++index;
                    if (!pushedImgURI.contains(imageName) && (!pushedImgURI.contains(imageName.substring(0, imageName.lastIndexOf("."))) || !pushedPlaybaseId.equals(dbPlaybaseId.toString()))) continue;
                    existsInDB = true;
                    break;
                }
                if (existsInDB) continue;
                newImages.add(map);
            }
        }
        catch (SQLException | NamingException ex) {
            log.error((Object)"Cannot process images");
        }
        return newImages;
    }

    protected List<Map<String, Object>> parseImages(Location location, JSONObject obj, ImportReport report) {
        ArrayList<Map<String, Object>> images = new ArrayList<Map<String, Object>>();
        JSONArray imagesJSON = obj.optJSONArray("Images");
        for (Object object : imagesJSON) {
            JSONObject img = (JSONObject)object;
            images.add(this.parseImage(location, img, report));
        }
        return images;
    }

    protected Map<String, Object> parseImage(Location location, JSONObject image, ImportReport report) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pa_id", image.optString("PlayadvisorID"));
        String url = image.optString("Path");
        map.put("URI", url);
        map.put("PlaybaseID", image.optString("PlaybaseID"));
        return map;
    }
}

