/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.playbase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WaitPageStatus {
    private static final Log log = LogFactory.getLog(WaitPageStatus.class);
    private AtomicInteger progress = new AtomicInteger(0);
    protected AtomicReference<String> currentAction = new AtomicReference<String>("Loading...");
    protected Queue<String> logs = new ConcurrentLinkedQueue();
    private int logDequeueCount = 0;
    private AtomicBoolean finished = new AtomicBoolean();

    public String getCurrentAction() {
        return this.currentAction.toString();
    }

    public void setCurrentAction(String currentAction) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("action: " + currentAction));
        }
        this.currentAction.set(currentAction);
    }

    public boolean isFinished() {
        return this.finished.get();
    }

    public void setFinished(boolean finished) {
        this.finished.set(finished);
    }

    public int getLogDequeueCount() {
        return this.logDequeueCount;
    }

    public int getProgress() {
        return this.progress.get();
    }

    public void setProgress(int progress) {
        this.progress.set(progress);
    }

    public void addLog(String message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("log: " + message));
        }
        this.logs.add(message);
    }

    public void addLog(String messageFormat, Object ... args) {
        this.addLog(String.format(messageFormat, args));
    }

    public List<String> dequeueLog() {
        String s;
        ArrayList<String> currentLogs = new ArrayList<String>();
        while ((s = (String)this.logs.poll()) != null) {
            currentLogs.add(s);
        }
        this.logDequeueCount += currentLogs.size();
        return currentLogs;
    }

    public WaitPageStatus subtask(String subtaskPrefix, float percent) {
        MutableInt progressUntilSubtask = new MutableInt(this.getProgress());
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public String getJSON() throws JSONException {
        JSONObject j = new JSONObject();
        j.put("progress", this.getProgress());
        j.put("currentAction", (Object)this.getCurrentAction());
        j.put("finished", this.isFinished());
        List currentLogs = this.dequeueLog();
        if (!currentLogs.isEmpty()) {
            JSONArray ja = new JSONArray((Collection)currentLogs);
            j.put("logs", (Object)ja);
            j.put("logStart", this.logDequeueCount);
        }
        return j.toString();
    }
}

