/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.admin.processes;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import nl.tailormap.viewer.admin.processes.SPOTinfoTokenRefresher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SPOTinfoTokenRefresherListener
implements ServletContextListener {
    private static final Log LOG = LogFactory.getLog(SPOTinfoTokenRefresherListener.class);
    private static final int DEFAULT_REFRESH_INTERVAL_MINUTES = 60;
    private static ServletContext context;
    private ScheduledExecutorService processThread;

    public void contextInitialized(ServletContextEvent sce) {
        LOG.info((Object)"starting SPOTinfoTokenRefresher thread.");
        this.init(sce);
        Runnable updateToken = () -> {
            SPOTinfoTokenRefresher tokenRefresher = new SPOTinfoTokenRefresher();
            tokenRefresher.refreshTokens();
        };
        this.processThread = Executors.newSingleThreadScheduledExecutor();
        int refreshInterval = 60;
        try {
            refreshInterval = Integer.parseInt(context.getInitParameter("spotinfo.token.refresh.interval"));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            // empty catch block
        }
        LOG.info((Object)("Using " + refreshInterval + "-minute refresh interval for SPOTinfo access token."));
        this.processThread.scheduleAtFixedRate(updateToken, 1L, refreshInterval, TimeUnit.MINUTES);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        LOG.info((Object)"Stopping SPOTinfoTokenRefresher thread.");
        if (this.processThread != null) {
            this.processThread.shutdown();
        }
    }

    private void init(ServletContextEvent sce) {
        context = sce.getServletContext();
    }
}

