/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.admin.stripes;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontBind;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import nl.tailormap.viewer.admin.stripes.ApplicationActionBean;
import nl.tailormap.viewer.admin.stripes.ChooseApplicationActionBean;
import nl.tailormap.viewer.config.CRS;
import nl.tailormap.viewer.config.ClobElement;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.Level;
import nl.tailormap.viewer.config.security.User;
import nl.tailormap.viewer.config.services.BoundingBox;
import nl.tailormap.viewer.config.services.CoordinateReferenceSystem;
import nl.tailormap.viewer.helpers.app.ApplicationHelper;
import nl.tailormap.viewer.util.SelectedContentCache;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

/*
 * Exception performing whole class analysis ignored.
 */
@UrlBinding(value="/action/applicationsettings/")
@StrictBinding
@RolesAllowed(value={"Admin", "ApplicationAdmin"})
public class ApplicationSettingsActionBean
extends ApplicationActionBean {
    private static final Log log = LogFactory.getLog(ApplicationSettingsActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/application/applicationSettings.jsp";
    private static final String DEFAULT_SPRITE = "/viewer/viewer-html/sprite.svg";
    private static final String LANGUAGE_CODES_KEY = "tailormap.i18n.languagecodes";
    public static final String PROJECTION_NAMES_KEY = "tailormap.projections.epsgnames";
    public static final String PROJECTION_CODES_KEY = "tailormap.projections.epsgcodes";
    @Validate
    private String name;
    @Validate
    private String version;
    @Validate
    private String title;
    @Validate
    private String language;
    @Validate
    private String owner;
    @Validate
    private boolean authenticatedRequired;
    @Validate
    private boolean mashupMustPointToPublishedVersion = false;
    @Validate
    private String mashupName;
    @Validate
    private boolean mustUpdateComponents;
    @Validate
    private Map<String, ClobElement> details = new HashMap();
    private String[] languageCodes;
    private List<CRS> crses;
    @Validate
    private String projection;
    @ValidateNestedProperties(value={@Validate(field="minx", maxlength=255), @Validate(field="miny", maxlength=255), @Validate(field="maxx", maxlength=255), @Validate(field="maxy", maxlength=255)})
    private BoundingBox startExtent;
    @ValidateNestedProperties(value={@Validate(field="minx", maxlength=255), @Validate(field="miny", maxlength=255), @Validate(field="maxx", maxlength=255), @Validate(field="maxy", maxlength=255)})
    private BoundingBox maxExtent;
    @Validate
    private List<String> groupsRead = new ArrayList();

    public Map<String, ClobElement> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, ClobElement> details) {
        this.details = details;
    }

    public boolean getAuthenticatedRequired() {
        return this.authenticatedRequired;
    }

    public void setAuthenticatedRequired(boolean authenticatedRequired) {
        this.authenticatedRequired = authenticatedRequired;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public BoundingBox getStartExtent() {
        return this.startExtent;
    }

    public void setStartExtent(BoundingBox startExtent) {
        this.startExtent = startExtent;
    }

    public BoundingBox getMaxExtent() {
        return this.maxExtent;
    }

    public void setMaxExtent(BoundingBox maxExtent) {
        this.maxExtent = maxExtent;
    }

    public String getMashupName() {
        return this.mashupName;
    }

    public void setMashupName(String mashupName) {
        this.mashupName = mashupName;
    }

    public boolean isMashupMustPointToPublishedVersion() {
        return this.mashupMustPointToPublishedVersion;
    }

    public void setMashupMustPointToPublishedVersion(boolean mashupMustPointToPublishedVersion) {
        this.mashupMustPointToPublishedVersion = mashupMustPointToPublishedVersion;
    }

    public boolean isMustUpdateComponents() {
        return this.mustUpdateComponents;
    }

    public void setMustUpdateComponents(boolean mustUpdateComponents) {
        this.mustUpdateComponents = mustUpdateComponents;
    }

    public List<String> getGroupsRead() {
        return this.groupsRead;
    }

    public void setGroupsRead(List<String> groupsRead) {
        this.groupsRead = groupsRead;
    }

    public String[] getLanguageCodes() {
        return this.languageCodes;
    }

    public void setLanguageCodes(String[] languageCodes) {
        this.languageCodes = languageCodes;
    }

    public List<CRS> getCrses() {
        return this.crses;
    }

    public void setCrses(List<CRS> crses) {
        this.crses = crses;
    }

    public String getProjection() {
        return this.projection;
    }

    public void setProjection(String projection) {
        this.projection = projection;
    }

    @DefaultHandler
    @DontValidate
    public Resolution view() {
        if (this.application != null) {
            this.details = this.application.getDetails();
            if (this.application.getOwner() != null) {
                this.owner = this.application.getOwner().getUsername();
            }
            this.startExtent = this.application.getStartExtent();
            this.maxExtent = this.application.getMaxExtent();
            this.name = this.application.getName();
            this.title = this.application.getTitle();
            this.language = this.application.getLang();
            this.version = this.application.getVersion();
            this.authenticatedRequired = this.application.isAuthenticatedRequired();
            this.groupsRead.addAll(this.application.getReaders());
            this.projection = this.application.getProjectionCode();
        }
        if (!this.details.containsKey("iconSprite")) {
            this.details.put("iconSprite", new ClobElement("/viewer/viewer-html/sprite.svg"));
        }
        if (!this.details.containsKey("stylesheetMetadata")) {
            this.details.put("stylesheetMetadata", new ClobElement(""));
        }
        if (!this.details.containsKey("stylesheetPrint")) {
            this.details.put("stylesheetPrint", new ClobElement(""));
        }
        String languageCodesString = this.context.getServletContext().getInitParameter("tailormap.i18n.languagecodes");
        this.languageCodes = StringUtils.stripAll((String[])languageCodesString.split(","));
        String codesString = this.context.getServletContext().getInitParameter("tailormap.projections.epsgcodes");
        String namesString = this.context.getServletContext().getInitParameter("tailormap.projections.epsgnames");
        String[] codes = codesString.split(";");
        String[] names = namesString.split(",");
        this.crses = new ArrayList();
        for (int i = 0; i < names.length; ++i) {
            CRS c = new CRS(names[i], codes[i]);
            this.crses.add(c);
        }
        if (this.projection == null && !this.crses.isEmpty()) {
            this.projection = ((CRS)this.crses.get(0)).getCode();
        }
        return new ForwardResolution("/WEB-INF/jsp/application/applicationSettings.jsp");
    }

    @DontValidate
    public Resolution newApplication() {
        this.application = null;
        this.applicationId = -1L;
        this.details.put("iconSprite", new ClobElement("/viewer/viewer-html/sprite.svg"));
        this.details.put("stylesheetMetadata", new ClobElement(""));
        this.details.put("stylesheetPrint", new ClobElement(""));
        return this.view();
    }

    @DontBind
    public Resolution cancel() {
        return new ForwardResolution("/WEB-INF/jsp/application/applicationSettings.jsp");
    }

    public Resolution save() {
        if (this.application == null) {
            this.application = new Application();
            Level root = new Level();
            root.setName(this.getBundle().getString("viewer_admin.applicationsettingsbean.applabel"));
            Level background = new Level();
            background.setName(this.getBundle().getString("viewer_admin.applicationsettingsbean.background"));
            background.setBackground(true);
            root.getChildren().add(background);
            background.setParent(root);
            Stripersist.getEntityManager().persist((Object)background);
            Stripersist.getEntityManager().persist((Object)root);
            this.application.setRoot(root);
        }
        this.bindAppProperties();
        Stripersist.getEntityManager().persist((Object)this.application);
        Stripersist.getEntityManager().getTransaction().commit();
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.applicationsettingsbean.appsaved"), new Object[0]));
        this.setApplication(this.application);
        return this.view();
    }

    private void bindAppProperties() {
        this.application.setName(this.name);
        this.application.setVersion(this.version);
        this.application.setTitle(this.title);
        this.application.setLang(this.language);
        if (this.owner != null) {
            User appOwner = (User)Stripersist.getEntityManager().find(User.class, (Object)this.owner);
            this.application.setOwner(appOwner);
        }
        this.application.setStartExtent(this.startExtent);
        this.application.setMaxExtent(this.maxExtent);
        this.application.setAuthenticatedRequired(this.authenticatedRequired);
        this.application.getReaders().clear();
        for (String string : this.groupsRead) {
            this.application.getReaders().add(string);
        }
        this.application.authorizationsModified();
        this.application.setProjectionCode(this.projection);
        for (Map.Entry entry : this.application.getDetails().entrySet()) {
            if (!Application.preventClearDetails.contains(entry.getKey())) continue;
            this.details.put((String)entry.getKey(), (ClobElement)entry.getValue());
        }
        this.application.getDetails().clear();
        this.application.getDetails().putAll(this.details);
    }

    @ValidationMethod(on={"save"})
    public void validate(ValidationErrors errors) throws Exception {
        if (this.name == null) {
            errors.add("name", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.applicationsettingsbean.noname"), new Object[0]));
            return;
        }
        try {
            Long foundId = this.version == null ? (Long)Stripersist.getEntityManager().createQuery("select id from Application where name = :name and version is null").setMaxResults(1).setParameter("name", (Object)this.name).getSingleResult() : (Long)Stripersist.getEntityManager().createQuery("select id from Application where name = :name and version = :version").setMaxResults(1).setParameter("name", (Object)this.name).setParameter("version", (Object)this.version).getSingleResult();
            if (this.application != null && this.application.getId() != null) {
                if (!foundId.equals(this.application.getId())) {
                    errors.add("name", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.applicationsettingsbean.appnotfound"), new Object[0]));
                }
            } else {
                errors.add("name", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.applicationsettingsbean.appnotfound"), new Object[0]));
            }
        }
        catch (NoResultException foundId) {
            // empty catch block
        }
        if (this.owner != null) {
            try {
                User appOwner = (User)Stripersist.getEntityManager().find(User.class, (Object)this.owner);
                if (appOwner == null) {
                    errors.add("owner", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.applicationsettingsbean.nouser"), new Object[0]));
                }
            }
            catch (NoResultException nre) {
                errors.add("owner", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.applicationsettingsbean.nouser"), new Object[0]));
            }
        }
        if (this.startExtent != null) {
            if (this.startExtent.getMinx() == null || this.startExtent.getMiny() == null || this.startExtent.getMaxx() == null || this.startExtent.getMaxy() == null) {
                errors.add("startExtent", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.applicationsettingsbean.nostartext"), new Object[0]));
            }
            if (null == this.startExtent.getCrs()) {
                this.startExtent.setCrs(new CoordinateReferenceSystem(this.projection.substring(0, this.projection.indexOf(91))));
            }
        }
        if (this.maxExtent != null) {
            if (this.maxExtent.getMinx() == null || this.maxExtent.getMiny() == null || this.maxExtent.getMaxx() == null || this.maxExtent.getMaxy() == null) {
                errors.add("maxExtent", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.applicationsettingsbean.nomaxext"), new Object[0]));
            }
            if (null == this.maxExtent.getCrs()) {
                this.maxExtent.setCrs(new CoordinateReferenceSystem(this.projection.substring(0, this.projection.indexOf(91))));
            }
        }
    }

    public Resolution copy() throws Exception {
        EntityManager em = Stripersist.getEntityManager();
        try {
            Object o = em.createQuery("select 1 from Application where name = :name").setMaxResults(1).setParameter("name", (Object)this.name).getSingleResult();
            this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.applicationsettingsbean.copyexists"), new Object[]{this.name}));
            return new RedirectResolution(this.getClass());
        }
        catch (NoResultException o) {
            try {
                this.copyApplication(em);
                this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.applicationsettingsbean.appcopied"), new Object[0]));
                return new RedirectResolution(this.getClass());
            }
            catch (Exception e) {
                log.error((Object)String.format("Error copying application #%d named %s %swith new name %s", this.application.getId(), this.application.getName(), this.application.getVersion() == null ? "" : "v" + this.application.getVersion() + " ", this.name), (Throwable)e);
                StringBuilder ex = new StringBuilder(e.toString());
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    ex.append(";\n<br>").append(cause);
                }
                this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.applicationsettingsbean.copyerror"), new Object[]{ex.toString()}));
                return new ForwardResolution("/WEB-INF/jsp/application/applicationSettings.jsp");
            }
        }
    }

    protected void copyApplication(EntityManager em) throws Exception {
        Application copy = null;
        if (this.application.isMashup().booleanValue()) {
            copy = ApplicationHelper.createMashup((Application)this.application, (String)this.name, (EntityManager)em, (boolean)false);
            SelectedContentCache.setApplicationCacheDirty((Application)copy, (Boolean)Boolean.TRUE, (Boolean)true, (EntityManager)em);
        } else {
            this.bindAppProperties();
            copy = ApplicationHelper.deepCopy((Application)this.application);
            em.detach((Object)this.application);
            em.persist((Object)copy);
            em.persist((Object)copy);
            em.flush();
            SelectedContentCache.setApplicationCacheDirty((Application)copy, (Boolean)Boolean.TRUE, (Boolean)false, (EntityManager)em);
        }
        em.getTransaction().commit();
        this.setApplication(copy);
    }

    public Resolution mashup() {
        ValidationErrors errors = this.context.getValidationErrors();
        try {
            EntityManager em = Stripersist.getEntityManager();
            Application mashup = ApplicationHelper.createMashup((Application)this.application, (String)this.mashupName, (EntityManager)em, (boolean)this.mustUpdateComponents);
            em.persist((Object)mashup);
            em.getTransaction().commit();
            this.setApplication(mashup);
        }
        catch (Exception ex) {
            log.error((Object)"Error creating mashup", (Throwable)ex);
            errors.add("Fout", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.applicationsettingsbean.nomashup"), new Object[0]));
        }
        return new RedirectResolution(ApplicationSettingsActionBean.class);
    }

    public Resolution publish() {
        EntityManager em = Stripersist.getEntityManager();
        this.publish(em);
        return new RedirectResolution(ChooseApplicationActionBean.class);
    }

    protected void publish(EntityManager em) {
        try {
            Application oldPublished = (Application)em.createQuery("from Application where name = :name AND version IS null").setMaxResults(1).setParameter("name", (Object)this.name).getSingleResult();
            Date nowDate = new Date(System.currentTimeMillis());
            SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
            sdf.applyPattern("HH-mm_dd-MM-yyyy");
            String now = sdf.format(nowDate);
            String uniqueVersion = ApplicationSettingsActionBean.findUniqueVersion((String)this.name, (String)("B_" + now), (EntityManager)em);
            oldPublished.setVersion(uniqueVersion);
            em.persist((Object)oldPublished);
            if (this.mashupMustPointToPublishedVersion) {
                for (Application mashup : ApplicationHelper.getMashups((Application)oldPublished, (EntityManager)em)) {
                    mashup.setRoot(this.application.getRoot());
                    SelectedContentCache.setApplicationCacheDirty((Application)mashup, (Boolean)true, (Boolean)false, (EntityManager)em);
                    ApplicationHelper.transferMashupLevels((Application)mashup, (Application)oldPublished, (EntityManager)em);
                    ApplicationHelper.transferMashupComponents((Application)mashup, (Application)this.application);
                    em.persist((Object)mashup);
                }
            }
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        this.application.setVersion(null);
        em.persist((Object)this.application);
        em.getTransaction().commit();
        this.setApplication(null);
    }

    public static String findUniqueVersion(String name, String version, EntityManager em) {
        int uniqueCounter = 0;
        while (true) {
            Object testVersion = uniqueCounter == 0 ? version : (String)version + " (" + uniqueCounter + ")";
            try {
                em.createQuery("select 1 from Application where name = :name AND version = :version").setParameter("name", (Object)name).setParameter("version", testVersion).setMaxResults(1).getSingleResult();
                ++uniqueCounter;
            }
            catch (NoResultException nre) {
                version = testVersion;
                return version;
            }
        }
    }
}

