/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.admin.stripes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import nl.tailormap.viewer.admin.stripes.ApplicationActionBean;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.Level;
import nl.tailormap.viewer.config.services.Category;
import nl.tailormap.viewer.config.services.Document;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.util.SelectedContentCache;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/applicationtree")
@StrictBinding
@RolesAllowed(value={"Admin", "ApplicationAdmin"})
public class ApplicationTreeActionBean
extends ApplicationActionBean {
    private static final String JSP = "/WEB-INF/jsp/application/applicationTree.jsp";
    @Validate(on={"addLevel"}, required=true)
    private String parentId;
    @Validate
    private String nodeId;
    @Validate
    private String levelId;
    @Validate(on={"moveLevel"}, required=true)
    private String targetLevelId;
    @Validate(on={"addLevel"}, required=true)
    private String name;
    @Validate(on={"loadRegistryPath"}, required=true)
    private String layerId;
    private Level rootLevel;

    public Level getRootLevel() {
        return this.rootLevel;
    }

    public void setRootLevel(Level rootLevel) {
        this.rootLevel = rootLevel;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getLevelId() {
        return this.levelId;
    }

    public void setLevelId(String levelId) {
        this.levelId = levelId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getTargetLevelId() {
        return this.targetLevelId;
    }

    public void setTargetLevelId(String targetLevelId) {
        this.targetLevelId = targetLevelId;
    }

    public String setLayerId() {
        return this.layerId;
    }

    public void setLayerId(String layerId) {
        this.layerId = layerId;
    }

    @DefaultHandler
    public Resolution view() {
        if (this.application == null) {
            this.getContext().getMessages().add(new SimpleError("Er moet eerst een bestaande applicatie geactiveerd of een nieuwe applicatie gemaakt worden.", new Object[0]));
            return new ForwardResolution("/WEB-INF/jsp/application/chooseApplication.jsp");
        }
        this.rootLevel = this.application.getRoot();
        return new ForwardResolution(JSP);
    }

    public Resolution tree() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        JSONArray children = new JSONArray();
        if (!this.nodeId.equals("n")) {
            String type = this.nodeId.substring(0, 1);
            int id = Integer.parseInt(this.nodeId.substring(1));
            if (type.equals("n")) {
                JSONObject j;
                Level l = (Level)em.find(Level.class, (Object)id);
                List levels = l.getChildren();
                Collections.sort(levels);
                for (Level sub : levels) {
                    j = new JSONObject();
                    j.put("id", (Object)("n" + sub.getId()));
                    j.put("name", (Object)sub.getName());
                    j.put("type", (Object)"level");
                    j.put("isLeaf", sub.getChildren().isEmpty() && sub.getLayers().isEmpty());
                    if (sub.getParent() != null) {
                        j.put("parentid", (Object)sub.getParent().getId());
                    }
                    children.put((Object)j);
                }
                for (ApplicationLayer layer : l.getLayers()) {
                    j = new JSONObject();
                    j.put("id", (Object)("s" + layer.getId()));
                    j.put("type", (Object)"layer");
                    j.put("isLeaf", true);
                    j.put("parentid", (Object)this.nodeId);
                    j.put("name", (Object)layer.getDisplayName(em));
                    children.put((Object)j);
                }
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution loadSelectedLayers() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        JSONArray children = new JSONArray();
        if (!this.levelId.equals("")) {
            int id = Integer.parseInt(this.levelId);
            Level l = (Level)em.find(Level.class, (Object)id);
            for (ApplicationLayer appl : l.getLayers()) {
                JSONObject j = new JSONObject();
                j.put("id", (Object)("al" + appl.getId()));
                j.put("type", (Object)"layer");
                j.put("isLeaf", true);
                j.put("name", (Object)appl.getDisplayName(em));
                children.put((Object)j);
                Layer serviceLayer = appl.getService().getLayer(appl.getLayerName(), em);
                j.put("status", (Object)(serviceLayer != null && appl.getService().isMonitoringStatusok() ? "ok" : "error"));
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution loadRegistryPath() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        String layerType = this.layerId.substring(0, 1);
        String appLayerType = this.layerId.substring(0, 2);
        JSONArray path = new JSONArray();
        if (appLayerType.equals("al") || layerType.equals("l")) {
            int id;
            Layer foundLayer = null;
            if (appLayerType.equals("al")) {
                id = Integer.parseInt(this.layerId.substring(2));
                ApplicationLayer appl = (ApplicationLayer)em.find(ApplicationLayer.class, (Object)id);
                GeoService gs = appl.getService();
                List layers = gs.loadLayerTree(em);
                for (Layer l : layers) {
                    if (l.getName() == null || !l.getName().equals(appl.getLayerName())) continue;
                    foundLayer = l;
                    break;
                }
            } else {
                id = Integer.parseInt(this.layerId.substring(1));
                foundLayer = (Layer)em.find(Layer.class, (Object)id);
            }
            if (foundLayer != null) {
                path.put((Object)("l" + foundLayer.getId()));
                for (Layer parent = foundLayer.getParent(); parent != null; parent = parent.getParent()) {
                    if (parent.isVirtual()) continue;
                    path.put((Object)("l" + parent.getId()));
                }
                path.put((Object)("s" + foundLayer.getService().getId()));
                for (Category c = foundLayer.getService().getCategory(); c != null; c = c.getParent()) {
                    path.put((Object)("c" + c.getId()));
                }
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution loadDocumentTree() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        JSONArray children = new JSONArray();
        List documents = em.createQuery("from Document", Document.class).getResultList();
        for (Document doc : documents) {
            JSONObject j = new JSONObject();
            j.put("id", (Object)("d" + doc.getId()));
            j.put("name", (Object)doc.getName());
            j.put("type", (Object)"document");
            j.put("isLeaf", true);
            j.put("parentid", (Object)this.nodeId);
            children.put((Object)j);
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution loadSelectedDocuments() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        JSONArray children = new JSONArray();
        if (!this.levelId.equals("")) {
            int id = Integer.parseInt(this.levelId);
            Level l = (Level)em.find(Level.class, (Object)id);
            for (Document doc : l.getDocuments()) {
                JSONObject j = new JSONObject();
                j.put("id", (Object)("d" + doc.getId()));
                j.put("name", (Object)doc.getName());
                j.put("type", (Object)"document");
                j.put("isLeaf", true);
                children.put((Object)j);
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution addLevel() throws JSONException {
        long parentIdLong;
        EntityManager em = Stripersist.getEntityManager();
        Level parent = (Level)em.find(Level.class, (Object)(parentIdLong = !this.parentId.contains("n") ? Long.parseLong(this.parentId) : Long.parseLong(this.parentId.substring(1))));
        if (!parent.isBackground() && parent.getParent() != null && parent.getParent().isBackground()) {
            return null;
        }
        Level l = new Level();
        l.setName(this.name);
        l.setParent(parent);
        parent.getChildren().add(l);
        em.persist((Object)l);
        em.persist((Object)parent);
        SelectedContentCache.setApplicationCacheDirty((Application)this.application, (Boolean)true, (Boolean)false, (EntityManager)em);
        this.application.authorizationsModified();
        em.getTransaction().commit();
        JSONObject j = new JSONObject();
        j.put("id", (Object)("n" + l.getId()));
        j.put("name", (Object)l.getName());
        j.put("type", (Object)"level");
        j.put("isLeaf", true);
        j.put("parentid", (Object)this.parentId);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution moveLevel() {
        JSONObject j = new JSONObject();
        j.put("success", false);
        try {
            EntityManager em = Stripersist.getEntityManager();
            this.moveLevel(this.levelId, this.targetLevelId, em);
            SelectedContentCache.setApplicationCacheDirty((Application)this.application, (Boolean)true, (Boolean)false, (EntityManager)em);
            this.application.authorizationsModified();
            em.getTransaction().commit();
            j.put("success", true);
        }
        catch (Exception e) {
            j.put("message", (Object)e.getLocalizedMessage());
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void moveLevel(String levelToMove, String targetLevel, EntityManager em) {
        if (levelToMove == null || targetLevel == null) {
            throw new IllegalArgumentException("level to move, or target level is null.");
        }
        if (levelToMove.contains("n")) {
            levelToMove = levelToMove.substring(1);
        }
        if (targetLevel.contains("n")) {
            targetLevel = targetLevel.substring(1);
        }
        Level l = (Level)em.find(Level.class, (Object)Long.parseLong(levelToMove));
        Level target = (Level)em.find(Level.class, (Object)Long.parseLong(targetLevel));
        Level oldParent = l.getParent();
        if (l == null || target == null || oldParent == null) {
            throw new IllegalArgumentException("Passed ids yield no levels, or level doesn't have a parent (do not try to move the application level. No. Don't.)");
        }
        this.removeLevelFromChildren(l, target, em);
        if (!oldParent.getId().equals(target.getId())) {
            target.getChildren().add(l);
            l.setParent(target);
            ArrayList<Level> newChilds = new ArrayList<Level>();
            for (Level level : oldParent.getChildren()) {
                if (level.getId().equals(l.getId())) continue;
                newChilds.add(level);
            }
            oldParent.setChildren(newChilds);
            em.persist((Object)l);
            em.persist((Object)target);
            em.persist((Object)oldParent);
        }
    }

    private void removeLevelFromChildren(Level level, Level newParent, EntityManager em) {
        List parentList = em.createQuery("select l FROM Level l join l.children c where c = :level", Level.class).setParameter("level", (Object)level).getResultList();
        for (Level l : parentList) {
            if (l.getId().equals(newParent.getId())) continue;
            l.getChildren().remove(level);
            em.persist((Object)l);
        }
    }
}

