/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.admin.stripes;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import nl.tailormap.i18n.LocalizableActionBean;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.Bookmark;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

public class BookmarkActionBean
extends LocalizableActionBean {
    private static final String JSP = "/WEB-INF/jsp/services/bookmark.jsp";
    private static final String EDITJSP = "/WEB-INF/jsp/services/bookmarkEdit.jsp";
    private ActionBeanContext context;
    @Validate
    private int limit;
    @Validate
    private int start;
    @Validate
    private int page;
    @Validate
    private String sort;
    @Validate
    private JSONArray filter;
    @Validate
    private String dir;
    @Validate
    private Bookmark bookmark;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public JSONArray getFilter() {
        return this.filter;
    }

    public void setFilter(JSONArray filter) {
        this.filter = filter;
    }

    public Bookmark getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(Bookmark bookmark) {
        this.bookmark = bookmark;
    }

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution(JSP);
    }

    public Resolution viewEdit() {
        return new ForwardResolution(EDITJSP);
    }

    public Resolution deleteBookmark() throws JSONException {
        try {
            EntityManager em = Stripersist.getEntityManager();
            em.remove((Object)this.bookmark);
            em.getTransaction().commit();
            this.context.getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.bookmarkactionbean.remsuccess"), new Object[0]));
        }
        catch (Exception e) {
            this.context.getValidationErrors().add("Verwijderen", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.bookmarkactionbean.remfailed"), new Object[]{e.getLocalizedMessage()}));
        }
        return this.viewEdit();
    }

    public Resolution getGridData() throws JSONException {
        JSONObject result = new JSONObject();
        JSONArray gridrows = new JSONArray();
        Session sess = (Session)Stripersist.getEntityManager().getDelegate();
        Criteria c = sess.createCriteria(Bookmark.class, "bookmark");
        c.createAlias("bookmark.application", "application");
        String applicationName = "";
        if (this.getFilter() != null) {
            for (int k = 0; k < this.getFilter().length(); ++k) {
                JSONObject j = this.getFilter().getJSONObject(k);
                String property = j.getString("property");
                String value = j.getString("value");
                if (!property.equals("application.name")) continue;
                applicationName = value;
            }
        }
        if (this.sort != null && this.dir != null) {
            if (this.sort.equals("published")) {
                this.sort = "version";
            }
            Order order = this.dir.equals("ASC") ? Order.asc((String)this.sort) : Order.desc((String)this.sort);
            order.ignoreCase();
            c.addOrder(order);
        }
        if (applicationName != null && applicationName.length() > 0) {
            Criterion nameCrit = Restrictions.ilike((String)"application.name", (String)applicationName, (MatchMode)MatchMode.ANYWHERE);
            c.add(nameCrit);
        }
        int rowCount = c.list().size();
        c.setMaxResults(this.limit);
        c.setFirstResult(this.start);
        List bookmarks = c.list();
        for (Bookmark bm : bookmarks) {
            Application app = bm.getApplication();
            Object appName = null;
            if (app != null) {
                appName = app.getName();
                if (app.getVersion() != null) {
                    appName = (String)appName + " v" + app.getVersion();
                }
            }
            Date dateCreated = bm.getCreatedAt();
            JSONObject j = this.getGridRow(bm.getId().longValue(), (String)appName, bm.getCode(), dateCreated);
            gridrows.put((Object)j);
        }
        result.put("totalCount", rowCount);
        result.put("gridrows", (Object)gridrows);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private JSONObject getGridRow(long id, String appName, String code, Date createdDate) throws JSONException {
        JSONObject row = new JSONObject();
        row.put("id", id);
        row.put("application.name", (Object)appName);
        row.put("code", (Object)code);
        SimpleDateFormat sdf = new SimpleDateFormat("HH-mm dd-MM-yyyy");
        String date = sdf.format(createdDate);
        row.put("createdAt", (Object)date);
        return row;
    }
}

