/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.admin.stripes;

import java.io.File;
import javax.annotation.security.RolesAllowed;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.tailormap.viewer.admin.stripes.ComponentConfigSourceActionBean;
import nl.tailormap.viewer.components.ComponentRegistry;
import nl.tailormap.viewer.components.ViewerComponent;

@UrlBinding(value="/action/componentConfigSource")
@StrictBinding
@RolesAllowed(value={"Admin", "ApplicationAdmin"})
public class ComponentConfigSourceActionBean
implements ActionBean {
    private ActionBeanContext context;
    @Validate
    private String className;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Resolution source() {
        long ifModifiedSince;
        ViewerComponent vc = ComponentRegistry.getInstance().getViewerComponent(this.className);
        ErrorResolution notFound = new ErrorResolution(404);
        if (vc == null) {
            return notFound;
        }
        File[] files = vc.getConfigSources();
        long lastModified = -1L;
        for (File f : files) {
            if (!f.exists() || !f.canRead()) {
                return notFound;
            }
            lastModified = Math.max(lastModified, f.lastModified());
        }
        File[] theFiles = files;
        1 res = new /* Unavailable Anonymous Inner Class!! */;
        if (lastModified != -1L && (ifModifiedSince = this.context.getRequest().getDateHeader("If-Modified-Since")) != -1L && ifModifiedSince >= lastModified) {
            return new ErrorResolution(304);
        }
        return res;
    }
}

