/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.admin.stripes;

import java.text.MessageFormat;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontBind;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import nl.tailormap.i18n.LocalizableActionBean;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.Level;
import nl.tailormap.viewer.config.services.Document;
import nl.tailormap.viewer.helpers.app.LevelHelper;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@StrictBinding
@UrlBinding(value="/action/document/{$event}/{service}")
@RolesAllowed(value={"Admin", "RegistryAdmin"})
public class DocumentActionBean
extends LocalizableActionBean {
    private static final String JSP = "/WEB-INF/jsp/services/document.jsp";
    private static final String EDITJSP = "/WEB-INF/jsp/services/editdocument.jsp";
    private ActionBeanContext context;
    @Validate
    private int page;
    @Validate
    private int start;
    @Validate
    private int limit;
    @Validate
    private String sort;
    @Validate
    private String dir;
    @Validate
    private JSONArray filter;
    @Validate
    @ValidateNestedProperties(value={@Validate(field="name", required=true, maxlength=255, label="Naam"), @Validate(field="category", maxlength=255, label="Category"), @Validate(field="url", required=true, maxlength=255, label="URL")})
    private Document document;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public JSONArray getFilter() {
        return this.filter;
    }

    public void setFilter(JSONArray filter) {
        this.filter = filter;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    @DefaultHandler
    @HandlesEvent(value="default")
    @DontValidate
    public Resolution defaultResolution() {
        return new ForwardResolution(JSP);
    }

    @DontValidate
    public Resolution edit() {
        return new ForwardResolution(EDITJSP);
    }

    @DontBind
    public Resolution cancel() {
        return new ForwardResolution(EDITJSP);
    }

    @DontValidate
    public Resolution delete() {
        EntityManager em = Stripersist.getEntityManager();
        if (this.documentInUse()) {
            StringBuilder message = new StringBuilder("<ul> ");
            List levels = em.createQuery("from Level l where :doc member of l.documents", Level.class).setParameter("doc", (Object)this.document).getResultList();
            for (Level level : levels) {
                for (Application app : LevelHelper.findApplications((Level)level, (EntityManager)em)) {
                    message.append("<li>").append(MessageFormat.format(this.getBundle().getString("viewer_admin.documentactionbean.inuseapp"), level.getPath(), app.getNameWithVersion())).append("</li>");
                }
            }
            message.append("</ul>");
            this.getContext().getValidationErrors().add("document", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.documentactionbean.inuse"), new Object[]{message.toString()}));
            return new ForwardResolution(EDITJSP);
        }
        em.remove((Object)this.document);
        em.getTransaction().commit();
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.documentactionbean.docrem"), new Object[0]));
        return new ForwardResolution(EDITJSP);
    }

    private boolean documentInUse() {
        return !Stripersist.getEntityManager().createQuery("select 1 from Level l where :doc member of l.documents").setParameter("doc", (Object)this.document).getResultList().isEmpty();
    }

    public Resolution save() {
        Stripersist.getEntityManager().persist((Object)this.document);
        Stripersist.getEntityManager().getTransaction().commit();
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.documentactionbean.docsaved"), new Object[0]));
        return new ForwardResolution(EDITJSP);
    }

    @DontValidate
    public Resolution getGridData() throws JSONException {
        JSONArray jsonData = new JSONArray();
        String filterName = "";
        String filterUrl = "";
        String filterCategory = "";
        if (this.getFilter() != null) {
            for (int k = 0; k < this.getFilter().length(); ++k) {
                JSONObject j = this.getFilter().getJSONObject(k);
                String property = j.getString("property");
                String value = j.getString("value");
                if (property.equals("name")) {
                    filterName = value;
                }
                if (property.equals("url")) {
                    filterUrl = value;
                }
                if (!property.equals("category")) continue;
                filterCategory = value;
            }
        }
        Session sess = (Session)Stripersist.getEntityManager().getDelegate();
        Criteria c = sess.createCriteria(Document.class);
        if (this.sort != null && this.dir != null) {
            Order order = this.dir.equals("ASC") ? Order.asc((String)this.sort) : Order.desc((String)this.sort);
            order.ignoreCase();
            c.addOrder(order);
        }
        if (filterName != null && filterName.length() > 0) {
            Criterion nameCrit = Restrictions.ilike((String)"name", (String)filterName, (MatchMode)MatchMode.ANYWHERE);
            c.add(nameCrit);
        }
        if (filterUrl != null && filterUrl.length() > 0) {
            Criterion urlCrit = Restrictions.ilike((String)"url", (String)filterUrl, (MatchMode)MatchMode.ANYWHERE);
            c.add(urlCrit);
        }
        if (filterCategory != null && filterCategory.length() > 0) {
            Criterion rubriekCrit = Restrictions.ilike((String)"category", (String)filterCategory, (MatchMode)MatchMode.ANYWHERE);
            c.add(rubriekCrit);
        }
        int rowCount = c.list().size();
        c.setMaxResults(this.limit);
        c.setFirstResult(this.start);
        List documenten = c.list();
        for (Object o : documenten) {
            Document doc = (Document)o;
            JSONObject j = this.getGridRow(doc.getId().intValue(), doc.getName(), doc.getUrl(), doc.getCategory());
            jsonData.put((Object)j);
        }
        JSONObject grid = new JSONObject();
        grid.put("totalCount", rowCount);
        grid.put("gridrows", (Object)jsonData);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private JSONObject getGridRow(int i, String name, String url, String category) throws JSONException {
        JSONObject j = new JSONObject();
        j.put("id", i);
        j.put("name", (Object)name);
        j.put("url", (Object)url);
        j.put("category", (Object)category);
        return j;
    }
}

