/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.admin.stripes;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrorHandler;
import net.sourceforge.stripes.validation.ValidationErrors;
import nl.tailormap.gbi.converter.Attribuut;
import nl.tailormap.gbi.converter.Converter;
import nl.tailormap.gbi.converter.Formulier;
import nl.tailormap.gbi.converter.Parser;
import nl.tailormap.i18n.LocalizableActionBean;
import nl.tailormap.viewer.config.forms.Form;
import nl.tailormap.viewer.config.metadata.Metadata;
import nl.tailormap.viewer.config.security.Group;
import nl.tailormap.viewer.config.services.FeatureSource;
import nl.tailormap.viewer.config.services.JDBCFeatureSource;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import nl.tailormap.viewer.helpers.featuresources.FeatureSourceFactoryHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.feature.simple.SimpleFeature;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/form/{$event}")
@StrictBinding
@RolesAllowed(value={"Admin", "RegistryAdmin"})
public class FormActionBean
extends LocalizableActionBean
implements ValidationErrorHandler {
    private static final Log log = LogFactory.getLog(FormActionBean.class);
    public ActionBeanContext context;
    private static final String JSP = "/WEB-INF/jsp/services/form.jsp";
    private static final String EDITJSP = "/WEB-INF/jsp/services/editform.jsp";
    private Set<String> featureTypes = new HashSet();
    private List<Form> formList = new ArrayList();
    private JSONArray forms;
    private String defaultFeatureSourceId;
    private List<FeatureSource> featureSources;
    private List<Group> allGroups = new ArrayList();
    @Validate
    private List<String> groupsRead = new ArrayList();
    @Validate
    private FeatureSource defaultFeatureSource;
    @Validate
    private JSONArray filter;
    @Validate
    private int page;
    @Validate
    private int start;
    @Validate
    private int limit;
    @Validate
    private String sort;
    @Validate
    private String dir;
    @Validate
    private String id;
    @Validate
    private String json;
    @Validate
    private String name;
    @Validate
    private String featureTypeName;
    @Validate(on={"delete", "save"})
    @ValidateNestedProperties(value={@Validate(field="id", on={"save", "delete"}), @Validate(field="json", on={"save"}), @Validate(field="name", on={"save"}), @Validate(field="featureTypeName", on={"save"})})
    private Form form;
    @Validate
    private FileBean file;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    @Before
    public void init() {
        EntityManager em = Stripersist.getEntityManager();
        this.formList = em.createQuery("FROM Form", Form.class).getResultList();
        this.formList.forEach(form -> this.featureTypes.add(form.getFeatureTypeName()));
        this.forms = new JSONArray((Collection)this.formList);
        this.allGroups = em.createQuery("FROM Group ", Group.class).getResultList();
    }

    @After
    public void makeLists() {
        EntityManager em = Stripersist.getEntityManager();
        if (this.form != null && em.contains((Object)this.form)) {
            this.groupsRead = new ArrayList(this.form.getReaders());
        }
    }

    @DefaultHandler
    @DontValidate
    public Resolution view() {
        return new ForwardResolution(JSP).addParameter("debug", new Object[]{this.context.getRequest().getParameter("debug")});
    }

    public Resolution cancel() {
        return new ForwardResolution(EDITJSP);
    }

    public Resolution add() {
        this.form = new Form();
        return new ForwardResolution(EDITJSP);
    }

    public Resolution save() {
        EntityManager em = Stripersist.getEntityManager();
        try {
            if (this.form.getId() != null && this.form.getId() != -1L) {
                Form old = (Form)em.find(Form.class, (Object)this.form.getId());
                old.setJson(this.form.getJson());
                old.setFeatureTypeName(this.form.getFeatureTypeName());
                old.setName(this.form.getName());
                this.form = old;
            } else {
                this.form.setId(null);
            }
            this.form = this.processForm(this.form);
            this.form.getReaders().clear();
            this.form.getReaders().addAll(this.groupsRead);
            em.persist((Object)this.form);
            em.getTransaction().commit();
        }
        catch (IOException e) {
            log.error((Object)"Exception occured during processing of form json", (Throwable)e);
            this.context.getValidationErrors().add("json", (ValidationError)new SimpleError(e.getLocalizedMessage(), new Object[0]));
            return new ErrorResolution(400);
        }
        return new ForwardResolution(EDITJSP);
    }

    private Form processForm(Form f) throws IOException {
        String json = f.getJson();
        if (json.contains("GeoVisia")) {
            List attrs = this.getLookupDB();
            Converter c = new Converter(attrs);
            Parser p = new Parser();
            List ps = p.parse(json);
            List fs = c.convert(ps);
            Formulier formulier = (Formulier)fs.get(0);
            f.setFeatureTypeName(formulier.getFeatureType());
            f.setJson(formulier.toString());
        }
        return f;
    }

    public Resolution delete() {
        EntityManager em = Stripersist.getEntityManager();
        if (this.id != null && Long.parseLong(this.id) != -1L) {
            this.form = (Form)em.find(Form.class, (Object)Long.parseLong(this.id));
            em.remove((Object)this.form);
            em.getTransaction().commit();
        }
        return this.view();
    }

    public Resolution edit() {
        return new ForwardResolution(EDITJSP);
    }

    public Resolution getGridData() throws JSONException {
        JSONArray jsonData = new JSONArray();
        String filterName = "";
        String featureTypeName = "";
        if (this.getFilter() != null) {
            for (int k = 0; k < this.getFilter().length(); ++k) {
                JSONObject j = this.getFilter().getJSONObject(k);
                String property = j.getString("property");
                String value = j.getString("value");
                if (property.equals("name")) {
                    filterName = value;
                }
                if (!property.equals("featureTypeName")) continue;
                featureTypeName = value;
            }
        }
        Session sess = (Session)Stripersist.getEntityManager().getDelegate();
        Criteria c = sess.createCriteria(Form.class);
        if (this.sort != null && this.dir != null) {
            Order order = this.dir.equals("ASC") ? Order.asc((String)this.sort) : Order.desc((String)this.sort);
            order.ignoreCase();
            c.addOrder(order);
        }
        if (filterName != null && filterName.length() > 0) {
            Criterion nameCrit = Restrictions.ilike((String)"name", (String)filterName, (MatchMode)MatchMode.ANYWHERE);
            c.add(nameCrit);
        }
        if (featureTypeName != null && featureTypeName.length() > 0) {
            Criterion urlCrit = Restrictions.ilike((String)"featureTypeName", (String)featureTypeName, (MatchMode)MatchMode.ANYWHERE);
            c.add(urlCrit);
        }
        List sources = c.list();
        int rowCount = c.list().size();
        c.setMaxResults(this.limit);
        c.setFirstResult(this.start);
        for (Object source : sources) {
            Form form = (Form)source;
            JSONObject j = this.getGridRow(form);
            jsonData.put((Object)j);
        }
        JSONObject grid = new JSONObject();
        grid.put("totalCount", rowCount);
        grid.put("gridrows", (Object)jsonData);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution saveDefaultFeatureSource() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        try {
            EntityManager em = Stripersist.getEntityManager();
            Metadata md = null;
            try {
                md = (Metadata)em.createQuery("from Metadata where configKey = :key", Metadata.class).setParameter("key", (Object)"default_form_featuresource").getSingleResult();
            }
            catch (NoResultException e) {
                md = new Metadata();
                md.setConfigKey("default_form_featuresource");
            }
            if (this.defaultFeatureSource != null) {
                md.setConfigValue(this.defaultFeatureSource.getId().toString());
            } else {
                md.setConfigValue(null);
            }
            this.defaultFeatureSourceId = md.getConfigValue();
            em.persist((Object)md);
            em.getTransaction().commit();
            json.put("success", (Object)Boolean.TRUE);
        }
        catch (Exception ex) {
            log.error((Object)"Error during setting the default application: ", (Throwable)ex);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    @After(stages={LifecycleStage.BindingAndValidation})
    public void createLists() {
        EntityManager em = Stripersist.getEntityManager();
        this.featureSources = em.createQuery("From FeatureSource", FeatureSource.class).getResultList();
        try {
            Metadata md = (Metadata)em.createQuery("from Metadata where configKey = :key", Metadata.class).setParameter("key", (Object)"default_form_featuresource").getSingleResult();
            this.defaultFeatureSourceId = md.getConfigValue();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Attribuut> getLookupDB() {
        ArrayList<Attribuut> attrs;
        block10: {
            EntityManager em = Stripersist.getEntityManager();
            attrs = new ArrayList<Attribuut>();
            try {
                Metadata md = (Metadata)em.createQuery("from Metadata where configKey = :key", Metadata.class).setParameter("key", (Object)"default_form_featuresource").getSingleResult();
                if (md.getConfigValue() == null) {
                    return attrs;
                }
                FeatureSource fs = (FeatureSource)em.find(FeatureSource.class, (Object)Long.parseLong(md.getConfigValue()));
                DataStore ds = null;
                if (fs == null || !(fs instanceof JDBCFeatureSource)) break block10;
                try {
                    SimpleFeatureType sft = (SimpleFeatureType)fs.getFeatureTypes().get(0);
                    ds = (DataStore)FeatureSourceFactoryHelper.openGeoToolsFeatureSource((SimpleFeatureType)sft).getDataStore();
                    SimpleFeatureSource sfs = ds.getFeatureSource("attribuut");
                    SimpleFeatureCollection sfc = sfs.getFeatures();
                    SimpleFeatureIterator i = sfc.features();
                    while (i.hasNext()) {
                        Attribuut a = new Attribuut();
                        SimpleFeature sf = (SimpleFeature)i.next();
                        a.setId(Integer.valueOf((Integer)sf.getAttribute("id")));
                        a.setKolom_naam((String)sf.getAttribute("kolom_naam"));
                        a.setTabel_naam((String)sf.getAttribute("tabel_naam"));
                        a.setNaam((String)sf.getAttribute("naam"));
                        a.setObject_naam((String)sf.getAttribute("object_naam"));
                        Object mut = sf.getAttribute("muteerbaar");
                        a.setMuteerbaar(mut != null ? (Boolean)mut : null);
                        attrs.add(a);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Cannot retrieve lookup featuresource: ", (Throwable)e);
                }
                finally {
                    if (ds != null) {
                        ds.dispose();
                    }
                }
            }
            catch (NoResultException e) {
                return attrs;
            }
        }
        return attrs;
    }

    private JSONObject getGridRow(Form form) throws JSONException {
        JSONObject j = new JSONObject();
        j.put("id", (Object)form.getId());
        j.put("name", (Object)form.getName());
        j.put("featureTypeName", (Object)form.getFeatureTypeName());
        return j;
    }

    public Set<String> getFeatureTypes() {
        return this.featureTypes;
    }

    public void setFeatureTypes(Set<String> featureTypes) {
        this.featureTypes = featureTypes;
    }

    public List<Form> getFormList() {
        return this.formList;
    }

    public void setFormList(List<Form> formList) {
        this.formList = formList;
    }

    public JSONArray getForms() {
        return this.forms;
    }

    public void setForms(JSONArray forms) {
        this.forms = forms;
    }

    public JSONArray getFilter() {
        return this.filter;
    }

    public void setFilter(JSONArray filter) {
        this.filter = filter;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public Form getForm() {
        return this.form;
    }

    public void setForm(Form form) {
        this.form = form;
    }

    public FileBean getFile() {
        return this.file;
    }

    public void setFile(FileBean file) {
        this.file = file;
    }

    public String getDefaultFeatureSourceId() {
        return this.defaultFeatureSourceId;
    }

    public void setDefaultFeatureSourceId(String defaultFeatureSourceId) {
        this.defaultFeatureSourceId = defaultFeatureSourceId;
    }

    public FeatureSource getDefaultFeatureSource() {
        return this.defaultFeatureSource;
    }

    public void setDefaultFeatureSource(FeatureSource defaultFeatureSource) {
        this.defaultFeatureSource = defaultFeatureSource;
    }

    public List<FeatureSource> getFeatureSources() {
        return this.featureSources;
    }

    public void setFeatureSources(List<FeatureSource> featureSources) {
        this.featureSources = featureSources;
    }

    public List<Group> getAllGroups() {
        return this.allGroups;
    }

    public void setAllGroups(List<Group> allGroups) {
        this.allGroups = allGroups;
    }

    public List<String> getGroupsRead() {
        return this.groupsRead;
    }

    public void setGroupsRead(List<String> groupsRead) {
        this.groupsRead = groupsRead;
    }

    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFeatureTypeName() {
        return this.featureTypeName;
    }

    public void setFeatureTypeName(String featureTypeName) {
        this.featureTypeName = featureTypeName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Resolution handleValidationErrors(ValidationErrors validationErrors) throws Exception {
        return this.view();
    }
}

