/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.admin.stripes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import nl.tailormap.viewer.admin.stripes.ApplicationActionBean;
import nl.tailormap.viewer.components.ComponentRegistry;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ConfiguredComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/layoutmanager/{$event}")
@StrictBinding
@RolesAllowed(value={"Admin", "ApplicationAdmin"})
public class LayoutManagerActionBean
extends ApplicationActionBean {
    private static final Log log = LogFactory.getLog(LayoutManagerActionBean.class);
    private JSONObject metadata;
    private JSONArray components;
    @Validate(on={"config", "removeComponent"})
    private String name;
    @Validate(on={"config"})
    private String className;
    @Validate(on={"saveComponentConfig"})
    private ConfiguredComponent component;
    @Validate(on={"saveComponentConfig"})
    private String configObject;
    @Validate(on={"saveComponentConfig"})
    private List<String> groups = new ArrayList();
    @Validate(on={"saveApplicationLayout"})
    private String layout;
    @Validate(on={"saveApplicationLayout"})
    private String globalLayout;
    @Validate(on={"saveComponentConfig"})
    private String componentLayout;
    private Boolean loadCustomConfig = false;
    private JSONObject details;
    private String defaultAppId;
    private List<Application> apps;
    private String ngConfigComponent = "";

    public JSONArray getComponents() {
        return this.components;
    }

    public void setComponents(JSONArray components) {
        this.components = components;
    }

    public String getConfigObject() {
        return this.configObject;
    }

    public void setConfigObject(String configObject) {
        this.configObject = configObject;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ConfiguredComponent getComponent() {
        return this.component;
    }

    public void setComponent(ConfiguredComponent component) {
        this.component = component;
    }

    public JSONObject getMetadata() {
        return this.metadata;
    }

    public void setMetadata(JSONObject metadata) {
        this.metadata = metadata;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getGlobalLayout() {
        return this.globalLayout;
    }

    public void setGlobalLayout(String globalLayout) {
        this.globalLayout = globalLayout;
    }

    public String getComponentLayout() {
        return this.componentLayout;
    }

    public void setComponentLayout(String componentLayout) {
        this.componentLayout = componentLayout;
    }

    public Boolean getLoadCustomConfig() {
        return this.loadCustomConfig;
    }

    public void setLoadCustomConfig(Boolean loadCustomConfig) {
        this.loadCustomConfig = loadCustomConfig;
    }

    public JSONObject getDetails() {
        return this.details;
    }

    public void setDetails(JSONObject details) {
        this.details = details;
    }

    public String getDefaultAppId() {
        return this.defaultAppId;
    }

    public void setDefaultAppId(String defaultAppId) {
        this.defaultAppId = defaultAppId;
    }

    public List<Application> getApps() {
        return this.apps;
    }

    public void setApps(List<Application> apps) {
        this.apps = apps;
    }

    public String getNgConfigComponent() {
        return this.ngConfigComponent;
    }

    public void setNgConfigComponent(String ngConfigComponent) {
        this.ngConfigComponent = ngConfigComponent;
    }

    @DefaultHandler
    public Resolution view() throws JSONException {
        if (this.application == null) {
            this.getContext().getMessages().add(new SimpleError(this.getBundle().getString("viewer_admin.layoutmanageractionbean.actapp"), new Object[0]));
            return new ForwardResolution("/WEB-INF/jsp/application/chooseApplication.jsp");
        }
        Stripersist.getEntityManager().getTransaction().commit();
        return new ForwardResolution("/WEB-INF/jsp/application/layoutmanager.jsp");
    }

    public Resolution config() {
        EntityManager em = Stripersist.getEntityManager();
        try {
            if (this.component == null) {
                this.component = (ConfiguredComponent)em.createQuery("from ConfiguredComponent where application = :application and name = :name").setParameter("application", (Object)this.application).setParameter("name", (Object)this.name).getSingleResult();
            }
            this.groups = new ArrayList(this.component.getReaders());
            try {
                JSONObject d = new JSONObject();
                for (Map.Entry e : this.component.getDetails().entrySet()) {
                    d.put((String)e.getKey(), e.getValue());
                }
                this.details = d;
            }
            catch (JSONException d) {}
        }
        catch (NoResultException ex) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError(((Object)((Object)ex)).getClass().getName() + ": " + ex.getMessage(), new Object[0]));
        }
        this.metadata = ComponentRegistry.getInstance().getViewerComponent(this.className).getMetadata();
        if (this.metadata.has("configSource")) {
            this.loadCustomConfig = true;
        }
        if (this.metadata.has("configXML") && !this.metadata.has("extPropertyGridConfigs")) {
            try {
                String xml = this.metadata.getString("configXML");
                JSONObject properties = new JSONObject();
                int beginIndex = xml.indexOf("[");
                int endIndex = -1;
                while (beginIndex != -1 && beginIndex < xml.length() && (endIndex = xml.indexOf("]", beginIndex)) != -1) {
                    String name = xml.substring(beginIndex + 1, endIndex);
                    properties.put(name, (Object)"");
                    beginIndex = xml.indexOf("[", endIndex);
                }
                JSONObject pgConfig = new JSONObject();
                pgConfig.put("source", (Object)properties);
                this.metadata.put("extPropertyGridConfigs", (Object)pgConfig);
            }
            catch (JSONException je) {
                log.error((Object)"Error while making 'extPropertyGridConfigs' properties for xml object", (Throwable)je);
            }
        }
        if (this.metadata.has("ngConfigComponent")) {
            this.ngConfigComponent = this.metadata.getString("ngConfigComponent");
            return new ForwardResolution("/WEB-INF/jsp/application/configPageAngular.jsp");
        }
        return new ForwardResolution("/WEB-INF/jsp/application/configPage.jsp");
    }

    public Resolution saveComponentConfig() {
        EntityManager em = Stripersist.getEntityManager();
        if (this.component == null) {
            this.component = new ConfiguredComponent();
        }
        this.saveComponent(em, this.component, this.configObject, this.name, this.className, this.application, this.componentLayout);
        return this.config();
    }

    protected void saveComponent(EntityManager em, ConfiguredComponent component, String configObject, String name, String className, Application application, String componentLayout) {
        component.setConfig(configObject);
        component.setName(name);
        component.setClassName(className);
        component.setApplication(application);
        this.pushChangesToLinkedComponents(component);
        HashMap<String, String> compDetails = new HashMap<String, String>();
        try {
            if (componentLayout != null) {
                JSONObject compLayout = new JSONObject(componentLayout);
                Iterator it = compLayout.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    Object val = compLayout.get(key);
                    compDetails.put(key, val.toString());
                }
            }
        }
        catch (JSONException ex) {
            log.error((Object)"Error saving component", (Throwable)ex);
        }
        component.setDetails(compDetails);
        component.getReaders().clear();
        component.setReaders(new HashSet(this.groups));
        em.persist((Object)component);
        application.authorizationsModified();
        em.getTransaction().commit();
    }

    private void pushChangesToLinkedComponents(ConfiguredComponent comp) {
        for (ConfiguredComponent linkedComponent : comp.getLinkedComponents()) {
            if (ConfiguredComponent.classesExcludedFromPushing.contains(linkedComponent.getClassName())) continue;
            linkedComponent.setConfig(comp.getConfig());
        }
    }

    private void removeFromLinkedComponents(ConfiguredComponent comp) {
        for (ConfiguredComponent linkedComponent : comp.getLinkedComponents()) {
            linkedComponent.setMotherComponent(null);
        }
        comp.setLinkedComponents(new ArrayList());
    }

    public Resolution removeComponent() {
        EntityManager em = Stripersist.getEntityManager();
        try {
            this.component = (ConfiguredComponent)em.createQuery("from ConfiguredComponent where application = :application and name = :name").setParameter("application", (Object)this.application).setParameter("name", (Object)this.name).getSingleResult();
            this.removeFromLinkedComponents(this.component);
            em.remove((Object)this.component);
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        em.getTransaction().commit();
        return new ForwardResolution("/WEB-INF/jsp/application/layoutmanager.jsp");
    }

    public Resolution saveApplicationLayout() {
        try {
            EntityManager em = Stripersist.getEntityManager();
            JSONObject jsonLayout = new JSONObject(this.layout);
            Iterator it = jsonLayout.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                JSONObject layoutItem = jsonLayout.getJSONObject(key);
                if (!layoutItem.has("components")) continue;
                JSONArray layoutItemComponents = layoutItem.getJSONArray("components");
                for (int i = 0; i < layoutItemComponents.length(); ++i) {
                    JSONObject layoutComponent = layoutItemComponents.getJSONObject(i);
                    String compName = layoutComponent.getString("name");
                    String compClassName = layoutComponent.getString("componentClass");
                    Query q = em.createQuery("from ConfiguredComponent where application = :application and name = :name").setParameter("application", (Object)this.application).setParameter("name", (Object)compName);
                    try {
                        q.getSingleResult();
                        continue;
                    }
                    catch (NoResultException nre) {
                        ConfiguredComponent cc = new ConfiguredComponent();
                        cc.setClassName(compClassName);
                        cc.setName(compName);
                        cc.setApplication(this.application);
                        em.persist((Object)cc);
                    }
                }
            }
            this.application.setLayout(this.layout);
            this.application.setGlobalLayout(this.globalLayout);
            this.application.removeOldProperties();
            em.persist((Object)this.application);
            em.getTransaction().commit();
        }
        catch (JSONException ex) {
            log.error((Object)"error saving the application layout", (Throwable)ex);
        }
        return new ForwardResolution("/WEB-INF/jsp/application/layoutmanager.jsp");
    }

    @Before(stages={LifecycleStage.HandlerResolution})
    public void getComponentList() {
        this.components = new JSONArray();
        for (String cn : ComponentRegistry.getInstance().getClassNameListSortedByDisplayName()) {
            this.components.put((Object)ComponentRegistry.getInstance().getViewerComponent(cn).getMetadata());
        }
    }
}

