/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.admin.stripes;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontBind;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import nl.tailormap.i18n.LocalizableActionBean;
import nl.tailormap.viewer.admin.jaas.TailormapLoginModule;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.ConfiguredComponent;
import nl.tailormap.viewer.config.app.Level;
import nl.tailormap.viewer.config.security.Group;
import nl.tailormap.viewer.config.security.User;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.helpers.AuthorizationsHelper;
import org.apache.commons.lang3.math.NumberUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@StrictBinding
@UrlBinding(value="/action/user/{$event}")
@RolesAllowed(value={"Admin", "UserAdmin"})
public class UserActionBean
extends LocalizableActionBean {
    private static final String JSP = "/WEB-INF/jsp/security/user.jsp";
    private static final String EDITJSP = "/WEB-INF/jsp/security/edituser.jsp";
    @Validate
    Application application;
    List<Application> applications;
    Set<Layer> authorizedLayers = Collections.emptySet();
    Set<Layer> authorizedEditableLayers = Collections.emptySet();
    AuthorizationsHelper.ApplicationCache applicationCache;
    Set<Level> authorizedLevels = Collections.emptySet();
    Set<ApplicationLayer> authorizedAppLayers = Collections.emptySet();
    Set<ApplicationLayer> authorizedEditableAppLayers = Collections.emptySet();
    Set<ConfiguredComponent> authorizedComponents = Collections.emptySet();
    private ActionBeanContext context;
    @Validate
    private int page;
    @Validate
    private int start;
    @Validate
    private int limit;
    @Validate
    private String sort;
    @Validate
    private String dir;
    @Validate
    private JSONArray filter;
    @Validate
    private User user;
    @Validate
    private String username;
    @Validate
    private String password;
    private List<Group> allGroups;
    @Validate
    private List<String> groups = new ArrayList();
    @Validate
    private List<String> ips = new ArrayList();
    private JSONArray ipJSON = new JSONArray();
    @Validate
    private Map<String, String> details = new HashMap();

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public List<Group> getAllGroups() {
        return this.allGroups;
    }

    public void setAllGroups(List<Group> allGroups) {
        this.allGroups = allGroups;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public JSONArray getFilter() {
        return this.filter;
    }

    public void setFilter(JSONArray filter) {
        this.filter = filter;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, String> details) {
        this.details = details;
    }

    public List<String> getIps() {
        return this.ips;
    }

    public void setIps(List<String> ips) {
        this.ips = ips;
    }

    public JSONArray getIpJSON() {
        return this.ipJSON;
    }

    public void setIpJSON(JSONArray ipJSON) {
        this.ipJSON = ipJSON;
    }

    @DefaultHandler
    @HandlesEvent(value="default")
    @DontValidate
    public Resolution defaultResolution() {
        return new ForwardResolution(JSP);
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    public void load() {
        this.allGroups = Stripersist.getEntityManager().createQuery("from Group order by name").getResultList();
    }

    @DontValidate
    public Resolution edit() {
        if (this.user != null) {
            for (Group g : this.user.getGroups()) {
                this.groups.add(g.getName());
            }
            this.details = this.user.getDetails();
            this.username = this.user.getUsername();
            for (String ip : this.user.getIps()) {
                this.ipJSON.put((Object)ip);
            }
        }
        return new ForwardResolution(EDITJSP);
    }

    @DontBind
    public Resolution cancel() {
        return new ForwardResolution(EDITJSP);
    }

    @ValidationMethod(on={"save"})
    public void validate(ValidationErrors errors) throws Exception {
        if (this.user == null) {
            if (this.username == null) {
                errors.add("username", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.useractionbean.nameobl"), new Object[0]));
                return;
            }
            try {
                Object o = Stripersist.getEntityManager().createQuery("select 1 from User where username = :username").setMaxResults(1).setParameter("username", (Object)this.username).getSingleResult();
                errors.add("username", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.useractionbean.namedup"), new Object[0]));
                return;
            }
            catch (NoResultException o) {
                // empty catch block
            }
        }
        if (this.user == null && this.password == null) {
            errors.add("password", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.useractionbean.pwobl"), new Object[0]));
            return;
        }
        if (this.password != null) {
            int passwordLength = NumberUtils.toInt((String)this.getContext().getServletContext().getInitParameter("password.length"), (int)0);
            passwordLength = Math.max(passwordLength, 8);
            if (this.password.length() < passwordLength) {
                errors.add("password", (ValidationError)new SimpleError(MessageFormat.format(this.getBundle().getString("viewer_admin.useractionbean.pwshort"), passwordLength), new Object[0]));
            }
        }
    }

    public Resolution save() throws Exception {
        if (this.user == null) {
            this.user = new User();
            this.user.setUsername(this.username);
            this.user.setPassword(TailormapLoginModule.getPasswordEncoder().encode((CharSequence)this.password));
        } else if (this.password != null) {
            this.user.setPassword(TailormapLoginModule.getPasswordEncoder().encode((CharSequence)this.password));
        }
        this.user.getDetails().clear();
        this.user.getDetails().putAll(this.details);
        this.user.getGroups().clear();
        for (String groupName : this.groups) {
            this.user.getGroups().add((Group)Stripersist.getEntityManager().find(Group.class, (Object)groupName));
        }
        this.user.getIps().clear();
        this.user.getIps().addAll(this.ips);
        Stripersist.getEntityManager().persist((Object)this.user);
        Stripersist.getEntityManager().getTransaction().commit();
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.useractionbean.usaved"), new Object[0]));
        return new ForwardResolution(EDITJSP);
    }

    @DontValidate
    public Resolution delete() {
        List applications;
        boolean inUse = false;
        String currentUser = this.context.getRequest().getUserPrincipal().getName();
        if (currentUser.equals(this.user.getUsername())) {
            inUse = true;
            this.getContext().getMessages().add(new SimpleError(this.getBundle().getString("viewer_admin.useractionbean.unorem"), new Object[0]));
        }
        if ((applications = Stripersist.getEntityManager().createQuery("from Application where owner = :owner", Application.class).setParameter("owner", (Object)this.user).getResultList()) != null && applications.size() > 0) {
            inUse = true;
            this.getContext().getMessages().add(new SimpleError(this.getBundle().getString("viewer_admin.useractionbean.uinuse"), new Object[0]));
        }
        if (!inUse) {
            Stripersist.getEntityManager().remove((Object)this.user);
            Stripersist.getEntityManager().getTransaction().commit();
            this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.useractionbean.urem"), new Object[0]));
        }
        return new ForwardResolution(EDITJSP);
    }

    @DontValidate
    public Resolution getGridData() throws JSONException {
        String org;
        Map map;
        List users;
        JSONArray jsonData = new JSONArray();
        String filterName = "";
        String filterOrganization = "";
        String filterPosition = "";
        if (this.getFilter() != null) {
            for (int k = 0; k < this.getFilter().length(); ++k) {
                JSONObject j = this.getFilter().getJSONObject(k);
                String property = j.getString("property");
                String value = j.getString("value");
                if (property.equals("username")) {
                    filterName = value;
                }
                if (property.equals("organization")) {
                    filterOrganization = value;
                }
                if (!property.equals("position")) continue;
                filterPosition = value;
            }
        }
        Session sess = (Session)Stripersist.getEntityManager().getDelegate();
        Criteria c = sess.createCriteria(User.class);
        if (this.sort != null && this.dir != null && this.sort.equals("username")) {
            Order order = this.dir.equals("ASC") ? Order.asc((String)this.sort) : Order.desc((String)this.sort);
            order.ignoreCase();
            c.addOrder(order);
        }
        if (filterName != null && filterName.length() > 0) {
            Criterion nameCrit = Restrictions.ilike((String)"username", (String)filterName, (MatchMode)MatchMode.ANYWHERE);
            c.add(nameCrit);
        }
        ArrayList<String> usersToSelect = new ArrayList<String>();
        if (filterOrganization != null && filterOrganization.length() > 0) {
            Criteria detailsCrit = sess.createCriteria(User.class);
            users = detailsCrit.list();
            for (User us : users) {
                map = us.getDetails();
                if (!map.containsKey("organization") || !(org = ((String)map.get("organization")).toLowerCase()).contains(filterOrganization.toLowerCase())) continue;
                usersToSelect.add(us.getUsername());
            }
            c.add(Restrictions.in((String)"username", usersToSelect));
        }
        if (filterPosition != null && filterPosition.length() > 0) {
            Criteria posCrit = sess.createCriteria(User.class);
            users = posCrit.list();
            for (User us : users) {
                map = us.getDetails();
                if (!map.containsKey("position")) continue;
                org = ((String)map.get("position")).toLowerCase();
                assert (filterOrganization != null);
                if (!org.contains(filterOrganization.toLowerCase())) continue;
                usersToSelect.add(us.getUsername());
            }
            c.add(Restrictions.in((String)"username", usersToSelect));
        }
        int rowCount = c.list().size();
        c.setMaxResults(this.limit);
        c.setFirstResult(this.start);
        users = c.list();
        for (User us : users) {
            JSONObject j = this.getGridRow(us.getUsername(), us.getDetails());
            jsonData.put((Object)j);
        }
        JSONObject grid = new JSONObject();
        grid.put("totalCount", rowCount);
        grid.put("gridrows", (Object)jsonData);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private JSONObject getGridRow(String username, Map<String, String> details) throws JSONException {
        JSONObject j = new JSONObject();
        j.put("id", (Object)username);
        j.put("username", (Object)username);
        j.put("organization", (Object)details.get("organization"));
        j.put("position", (Object)details.get("position"));
        return j;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public List<Application> getApplications() {
        return this.applications;
    }

    public Set<ApplicationLayer> getAuthorizedAppLayers() {
        return this.authorizedAppLayers;
    }

    public Set<ApplicationLayer> getAuthorizedEditableAppLayers() {
        return this.authorizedEditableAppLayers;
    }

    public Set<Layer> getAuthorizedEditableLayers() {
        return this.authorizedEditableLayers;
    }

    public Set<Layer> getAuthorizedLayers() {
        return this.authorizedLayers;
    }

    public Set<Level> getAuthorizedLevels() {
        return this.authorizedLevels;
    }

    public AuthorizationsHelper.ApplicationCache getApplicationCache() {
        return this.applicationCache;
    }

    public Set<ConfiguredComponent> getAuthorizedComponents() {
        return this.authorizedComponents;
    }

    public void setAuthorizedComponents(Set<ConfiguredComponent> authorizedComponents) {
        this.authorizedComponents = authorizedComponents;
    }

    public Resolution authorizations() {
        EntityManager em = Stripersist.getEntityManager();
        List services = em.createQuery("from GeoService", GeoService.class).getResultList();
        for (GeoService service : services) {
            AuthorizationsHelper.getLayerAuthorizations((Layer)service.getTopLayer(), (EntityManager)em);
        }
        HashSet<String> roles = new HashSet<String>();
        if (this.user != null) {
            for (Group group : this.user.getGroups()) {
                if (group == null) continue;
                roles.add(group.getName());
            }
        }
        if (!roles.isEmpty()) {
            this.authorizedLayers = new HashSet();
            this.authorizedEditableLayers = new HashSet();
            for (Map.Entry entry : AuthorizationsHelper.serviceCache.entrySet()) {
                for (Map.Entry e2 : ((AuthorizationsHelper.GeoServiceCache)entry.getValue()).getProtectedLayers().entrySet()) {
                    Layer l = (Layer)Stripersist.getEntityManager().find(Layer.class, e2.getKey());
                    Set readers = ((AuthorizationsHelper.ReadWrite)e2.getValue()).getReaders();
                    Set writers = ((AuthorizationsHelper.ReadWrite)e2.getValue()).getWriters();
                    if (readers.equals(AuthorizationsHelper.EVERYBODY) || !Collections.disjoint(readers, roles)) {
                        this.authorizedLayers.add(l);
                    }
                    if (!writers.equals(AuthorizationsHelper.EVERYBODY) && Collections.disjoint(writers, roles)) continue;
                    this.authorizedEditableLayers.add(l);
                }
            }
        }
        this.applications = em.createQuery("from Application order by name, version", Application.class).getResultList();
        if (this.application != null) {
            this.applicationCache = AuthorizationsHelper.getApplicationCache((Application)this.application, (EntityManager)em);
            if (!roles.isEmpty()) {
                Set readers;
                this.authorizedLevels = new HashSet();
                for (Map.Entry entry : this.applicationCache.getProtectedLevels().entrySet()) {
                    Level l = (Level)Stripersist.getEntityManager().find(Level.class, entry.getKey());
                    readers = ((AuthorizationsHelper.Read)entry.getValue()).getReaders();
                    if (!readers.equals(AuthorizationsHelper.EVERYBODY) && Collections.disjoint(readers, roles)) continue;
                    this.authorizedLevels.add(l);
                }
                this.authorizedAppLayers = new HashSet();
                this.authorizedEditableAppLayers = new HashSet();
                for (Map.Entry entry : this.applicationCache.getProtectedAppLayers().entrySet()) {
                    ApplicationLayer al = (ApplicationLayer)Stripersist.getEntityManager().find(ApplicationLayer.class, entry.getKey());
                    readers = ((AuthorizationsHelper.ReadWrite)entry.getValue()).getReaders();
                    Set writers = ((AuthorizationsHelper.ReadWrite)entry.getValue()).getWriters();
                    if (readers.equals(AuthorizationsHelper.EVERYBODY) || !Collections.disjoint(readers, roles)) {
                        this.authorizedAppLayers.add(al);
                    }
                    if (!writers.equals(AuthorizationsHelper.EVERYBODY) && Collections.disjoint(writers, roles)) continue;
                    this.authorizedEditableAppLayers.add(al);
                }
                this.authorizedComponents = new HashSet();
                for (ConfiguredComponent configuredComponent : this.application.getComponents()) {
                    if (!configuredComponent.getReaders().equals(AuthorizationsHelper.EVERYBODY) && Collections.disjoint(configuredComponent.getReaders(), roles)) continue;
                    this.authorizedComponents.add(configuredComponent);
                }
            }
        }
        return new ForwardResolution("/WEB-INF/jsp/security/authorizations.jsp");
    }
}

