/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.admin.stripes.plugin;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.config.ConfigurableComponent;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.ExecutionContext;
import net.sourceforge.stripes.controller.FlashScope;
import net.sourceforge.stripes.controller.Interceptor;
import net.sourceforge.stripes.controller.Intercepts;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.util.CryptoUtil;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.UrlBuilder;
import nl.tailormap.viewer.admin.stripes.plugin.ReverseProxyAwareWaitPageInterceptor;
import org.stripesstuff.plugin.waitpage.Context;
import org.stripesstuff.plugin.waitpage.WaitPage;

@Intercepts(value={LifecycleStage.ActionBeanResolution, LifecycleStage.HandlerResolution, LifecycleStage.BindingAndValidation, LifecycleStage.CustomValidation, LifecycleStage.EventHandling, LifecycleStage.ResolutionExecution})
public class ReverseProxyAwareWaitPageInterceptor
implements Interceptor,
ConfigurableComponent {
    private static final Log log = Log.getInstance(ReverseProxyAwareWaitPageInterceptor.class);
    public static final String CONTEXT_TIMEOUT_NAME = "WaitPageInterceptor.ContextTimeout";
    public static final String SELF_URL = "WaitPageInterceptor.SelfUrl";
    private static final String ID_PARAMETER = "__WPI__";
    private static final String THREAD_URL = "/__WPI_THREAD__.wait";
    private static final String AJAX = "ajax";
    private static final int DEFAULT_REFRESH_TIMEOUT = 60000;
    private static final int DEFAULT_CONTEXT_TIMEOUT = 300000;
    private final Map<Integer, Context> contexts = new ConcurrentHashMap();
    private long contextTimeout = 300000L;
    private URL selfUrl = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution intercept(ExecutionContext executionContext) throws Exception {
        WaitPage annotation;
        this.removeExpired(this.contexts);
        Context context = this.getContext(executionContext);
        LifecycleStage stage = executionContext.getLifecycleStage();
        if (executionContext.getActionBeanContext().getRequest().getRequestURI().contains(THREAD_URL)) {
            switch (2.$SwitchMap$net$sourceforge$stripes$controller$LifecycleStage[executionContext.getLifecycleStage().ordinal()]) {
                case 1: {
                    log.trace(new Object[]{"injecting ActionBean"});
                    context.actionBean.setContext(executionContext.getActionBeanContext());
                    executionContext.setActionBean(context.actionBean);
                    return null;
                }
                case 2: {
                    log.trace(new Object[]{"injecting event handler"});
                    executionContext.setHandler(context.eventHandler);
                    return null;
                }
                case 3: 
                case 4: {
                    log.trace(new Object[]{"skipping binding and validation"});
                    return null;
                }
                case 5: {
                    log.trace(new Object[]{"executing event handler"});
                    try {
                        return executionContext.proceed();
                    }
                    catch (Exception e) {
                        ActionBean actionBean = context.actionBean;
                        synchronized (actionBean) {
                            log.trace(new Object[]{"setting exception in context"});
                            context.throwable = e;
                            context.status = Context.Status.COMPLETE;
                            context.completeMoment = System.currentTimeMillis();
                            context.actionBean.notifyAll();
                            context.eventFlashScope = FlashScope.getCurrent((HttpServletRequest)context.actionBean.getContext().getRequest(), (boolean)false);
                        }
                        throw e;
                    }
                }
                case 6: {
                    ActionBean e = context.actionBean;
                    synchronized (e) {
                        log.trace(new Object[]{"setting resolution in context"});
                        context.resolution = executionContext.getResolution();
                        context.status = Context.Status.COMPLETE;
                        context.completeMoment = System.currentTimeMillis();
                        context.actionBean.notifyAll();
                        context.eventFlashScope = FlashScope.getCurrent((HttpServletRequest)context.actionBean.getContext().getRequest(), (boolean)false);
                    }
                    executionContext.setResolution((Resolution)new StreamingResolution("text/plain", "thread complete"));
                    return executionContext.proceed();
                }
                case 7: 
                case 8: {
                    return executionContext.proceed();
                }
            }
        } else if (LifecycleStage.ActionBeanResolution.equals((Object)stage)) {
            if (context != null) {
                return this.checkStatus(executionContext, context);
            }
        } else if (LifecycleStage.EventHandling.equals((Object)stage) && (annotation = executionContext.getHandler().getAnnotation(WaitPage.class)) != null) {
            return this.createContextAndRedirect(executionContext, annotation);
        }
        return executionContext.proceed();
    }

    private Context getContext(ExecutionContext executionContext) {
        HttpServletRequest request = executionContext.getActionBeanContext().getRequest();
        String parameter = request.getParameter(ID_PARAMETER);
        if (parameter != null) {
            int id = Integer.parseInt(parameter, 16);
            return (Context)this.contexts.get(id);
        }
        return null;
    }

    private Resolution createContextAndRedirect(ExecutionContext executionContext, WaitPage annotation) throws IOException {
        Context context = this.createContext(executionContext);
        context.actionBean = executionContext.getActionBean();
        context.eventHandler = executionContext.getHandler();
        context.annotation = annotation;
        context.resolution = new ForwardResolution(annotation.path());
        context.bindingFlashScope = FlashScope.getCurrent((HttpServletRequest)context.actionBean.getContext().getRequest(), (boolean)false);
        int id = context.hashCode();
        String ids = Integer.toHexString(id);
        HttpServletRequest request = executionContext.getActionBeanContext().getRequest();
        UrlBuilder urlBuilder = new UrlBuilder(executionContext.getActionBeanContext().getLocale(), THREAD_URL, false);
        Set paramSet = request.getParameterMap().entrySet();
        for (Map.Entry param : paramSet) {
            for (String value : (String[])param.getValue()) {
                urlBuilder.addParameter((String)param.getKey(), new Object[]{value});
            }
        }
        urlBuilder.addParameter(ID_PARAMETER, new Object[]{ids});
        if (context.bindingFlashScope != null) {
            urlBuilder.addParameter("__fsk", new Object[]{String.valueOf(context.bindingFlashScope.key())});
        }
        urlBuilder.addParameter("_sourcePage", new Object[]{CryptoUtil.encrypt((String)executionContext.getActionBeanContext().getSourcePage())});
        context.url = this.selfUrl != null ? new URL(this.selfUrl, request.getContextPath() + urlBuilder) : new URL(request.getScheme(), request.getServerName(), request.getServerPort(), request.getContextPath() + urlBuilder);
        context.cookies = request.getHeader("Cookie");
        this.contexts.put(id, context);
        context.thread = new Thread((Runnable)context);
        context.thread.start();
        return new /* Unavailable Anonymous Inner Class!! */.addParameter(ID_PARAMETER, new Object[]{ids});
    }

    protected Context createContext(ExecutionContext executionContext) {
        return new Context();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resolution checkStatus(ExecutionContext executionContext, Context context) throws Exception {
        ActionBean actionBean = context.actionBean;
        synchronized (actionBean) {
            if (context.status == Context.Status.INIT) {
                if (context.annotation.delay() > 0) {
                    context.actionBean.wait(context.annotation.delay());
                }
                if (context.status == Context.Status.INIT) {
                    context.status = Context.Status.WAITING;
                }
            } else if (context.status == Context.Status.WAITING) {
                log.trace(new Object[]{"waiting to be signaled"});
                context.actionBean.wait(context.annotation.refresh() > 0 ? (long)context.annotation.refresh() : 60000L);
            }
            Resolution resolution = context.resolution;
            executionContext.setActionBean(context.actionBean);
            executionContext.getActionBeanContext().getRequest().setAttribute("actionBean", (Object)context.actionBean);
            executionContext.getActionBeanContext().getRequest().setAttribute(StripesFilter.getConfiguration().getActionResolver().getUrlBinding(context.actionBean.getClass()), (Object)context.actionBean);
            if (context.bindingFlashScope != null) {
                this.copyFlashScope(context.bindingFlashScope, FlashScope.getCurrent((HttpServletRequest)executionContext.getActionBeanContext().getRequest(), (boolean)true));
            }
            if (context.eventFlashScope != null) {
                this.copyFlashScope(context.eventFlashScope, FlashScope.getCurrent((HttpServletRequest)executionContext.getActionBeanContext().getRequest(), (boolean)true));
            }
            if (executionContext.getActionBeanContext().getRequest().getParameter(AJAX) != null) {
                resolution = new ForwardResolution(context.annotation.ajax().length() > 0 ? context.annotation.ajax() : context.annotation.path());
            } else if (context.status == Context.Status.COMPLETE) {
                log.trace(new Object[]{"the processor is finished so we'll remove it from the map"});
                this.contexts.remove(context.hashCode());
                this.copyErrors(context.actionBean.getContext(), executionContext.getActionBeanContext());
                context.actionBean.setContext(executionContext.getActionBeanContext());
                if (context.throwable != null) {
                    if ("".equals(context.annotation.error()) && context.throwable instanceof Exception) {
                        throw (Exception)context.throwable;
                    }
                    executionContext.getActionBeanContext().getRequest().setAttribute("exception", (Object)context.throwable);
                    resolution = new ForwardResolution(context.annotation.error());
                }
                executionContext.setResolution(resolution);
            }
            return resolution;
        }
    }

    protected void copyErrors(ActionBeanContext source, ActionBeanContext destination) {
        destination.getValidationErrors().putAll((Map)source.getValidationErrors());
    }

    protected void copyFlashScope(FlashScope source, FlashScope destination) {
        destination.putAll((Map)source);
    }

    protected void removeExpired(Map<Integer, Context> contexts) {
        contexts.values().removeIf(context -> context.completeMoment != null && System.currentTimeMillis() - context.completeMoment > this.contextTimeout);
    }

    public void init(Configuration configuration) throws Exception {
        if (configuration.getBootstrapPropertyResolver().getProperty(CONTEXT_TIMEOUT_NAME) != null) {
            log.debug(new Object[]{"Configuring context timeout with value ", configuration.getBootstrapPropertyResolver().getProperty(CONTEXT_TIMEOUT_NAME)});
            try {
                this.contextTimeout = Long.parseLong(configuration.getBootstrapPropertyResolver().getProperty(CONTEXT_TIMEOUT_NAME));
            }
            catch (NumberFormatException e) {
                log.warn(new Object[]{"Init parameter ", CONTEXT_TIMEOUT_NAME, " is not a parsable long, timeout will be ", " instead"});
                this.contextTimeout = 300000L;
            }
        }
        if (configuration.getBootstrapPropertyResolver().getProperty(SELF_URL) != null) {
            log.debug(new Object[]{"Configuring self URL with value ", configuration.getBootstrapPropertyResolver().getProperty(SELF_URL)});
            try {
                this.selfUrl = new URL(configuration.getBootstrapPropertyResolver().getProperty(SELF_URL));
            }
            catch (MalformedURLException e) {
                log.warn(new Object[]{"Init parameter ", SELF_URL, " is not a parsable URL, self URL will be based on request instead"});
            }
        }
    }
}

