/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.admin.jaas;

import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import nl.tailormap.viewer.admin.jaas.Group;
import nl.tailormap.viewer.config.security.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;

public class TailormapLoginModule
implements LoginModule {
    private static final Log log = LogFactory.getLog(TailormapLoginModule.class);
    private Subject subject;
    private CallbackHandler handler;
    private User user;
    private Set<Group> groups;
    private static EntityManagerFactory emf;
    private static final PasswordEncoder passwordEncoder;

    public static PasswordEncoder getPasswordEncoder() {
        return passwordEncoder;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.handler = callbackHandler;
    }

    private synchronized void initializeEntityManagerFactory() {
        if (emf == null) {
            emf = Persistence.createEntityManagerFactory((String)"viewer-config-postgresql");
        }
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("login"), new PasswordCallback("password", true)};
        try (EntityManager em = null;){
            this.handler.handle(callbacks);
            String username = ((NameCallback)callbacks[0]).getName();
            String password = String.valueOf(((PasswordCallback)callbacks[1]).getPassword());
            this.initializeEntityManagerFactory();
            em = emf.createEntityManager();
            this.user = (User)em.createQuery("from User u left join fetch u.groups where u.username = :username").setParameter("username", (Object)username).getSingleResult();
            if (!passwordEncoder.matches((CharSequence)password, this.user.getPassword())) {
                throw new FailedLoginException("Authorization failed");
            }
            this.groups = this.user.getGroups().stream().map(g -> new Group(g.getName())).collect(Collectors.toSet());
            log.info((Object)("User " + this.user.getUsername() + " authorized with groups: " + this.groups));
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        this.subject.getPrincipals().add((Principal)this.user);
        this.subject.getPrincipals().addAll(this.groups);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.user);
        this.subject.getPrincipals().removeAll(this.groups);
        return false;
    }

    static {
        passwordEncoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();
    }
}

