/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.admin.monitoring;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import nl.tailormap.mail.Mailer;
import nl.tailormap.viewer.config.security.User;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.helpers.services.GeoserviceFactoryHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.stripesstuff.stripersist.Stripersist;

public class MonitorJob
implements Job,
InterruptableJob {
    private static final Log log = LogFactory.getLog(MonitorJob.class);
    private boolean interrupted = false;

    public void interrupt() {
        log.info((Object)"Setting interrupt flag");
        this.interrupted = true;
    }

    private boolean isInterrupted() {
        return this.interrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jec) throws JobExecutionException {
        try {
            Stripersist.requestInit();
            EntityManager em = Stripersist.getEntityManager();
            StringBuilder monitoringFailures = new StringBuilder();
            int online = 0;
            int offline = 0;
            for (Object gs : em.createQuery("from GeoService", GeoService.class).getResultList()) {
                String debugMsg;
                block15: {
                    debugMsg = String.format("%s service %s (#%d) with URL: %s", gs.getProtocol(), gs.getName(), gs.getId(), gs.getUrl());
                    if (!this.isInterrupted()) break block15;
                    log.info((Object)"Interrupted, ending monitoring job");
                    return;
                }
                try {
                    GeoserviceFactoryHelper.checkServiceOnline((EntityManager)em, (GeoService)gs);
                    ++online;
                    gs.setMonitoringStatusok(true);
                    log.debug((Object)("ONLINE: " + debugMsg));
                }
                catch (Exception e) {
                    gs.setMonitoringStatusok(false);
                    ++offline;
                    log.debug((Object)("OFFLINE: " + debugMsg));
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Exception", (Throwable)e);
                    }
                    StringBuilder message = new StringBuilder(e.toString());
                    for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                        message.append("; ").append(cause);
                    }
                    monitoringFailures.append(String.format("%s service %s (#%d)\nURL: %s\nFout: %s\n\n", gs.getProtocol(), gs.getName(), gs.getId(), gs.getUrl(), message));
                }
            }
            em.getTransaction().commit();
            log.info((Object)String.format("Total services %d, online: %d, offline: %d, runtime: %d s", online + offline, online, offline, jec.getJobRunTime() / 1000L));
            if (offline > 0) {
                HashSet<String> emails = new HashSet<String>();
                for (User admin : em.createQuery("select u from User u join u.groups g where g.name = 'ServiceAdmin' ", User.class).getResultList()) {
                    emails.add((String)admin.getDetails().get("email"));
                }
                emails.remove(null);
                if (!emails.isEmpty()) {
                    SimpleDateFormat f = new SimpleDateFormat("dd-MM-yyy HH:mm:ss");
                    String mail = String.format("Bij een controle op %s zijn in het gegevensregister %d services gevonden waarbij fouten zijn geconstateerd.\n\nDe volgende controle zal worden uitgevoerd op %s.\nHieronder staat de lijst met probleemservices:\n\n", f.format(jec.getFireTime()), offline, f.format(jec.getNextFireTime())) + monitoringFailures;
                    this.mail(jec, emails, offline + " services zijn offline bij controle", mail);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error", (Throwable)e);
        }
        finally {
            Stripersist.requestComplete();
        }
    }

    private void mail(JobExecutionContext jec, Set<String> emails, String subject, String mail) {
        try {
            log.info((Object)("Sending mail to service admins: " + Arrays.toString(emails.toArray())));
            for (String email : emails) {
                if (this.isInterrupted()) {
                    log.info((Object)"Interrupted, ending monitoring job");
                    return;
                }
                try {
                    Mailer.sendMail((String)((String)jec.getJobDetail().getJobDataMap().get((Object)"from.name")), (String)((String)jec.getJobDetail().getJobDataMap().get((Object)"from.email")), (String)email, (String)subject, (String)mail);
                }
                catch (Exception e) {
                    log.error((Object)("Error sending mail to service admin " + email), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error sending mail to service admins", (Throwable)e);
        }
    }
}

