/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.admin.stripes;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLException;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import nl.tailormap.viewer.admin.UpgradeCheck;

@UrlBinding(value="/action/admin/upgradecheck/{$event}")
@StrictBinding
public class AfterUpgradeActionBean
implements ActionBean {
    private ActionBeanContext context;
    private static final String JSP = "/WEB-INF/jsp/admin/afterupgrade.jsp";
    private List<UpgradeCheck> checks = new ArrayList();

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public List<UpgradeCheck> getChecks() {
        return this.checks;
    }

    public void setChecks(List<UpgradeCheck> checks) {
        this.checks = checks;
    }

    @DefaultHandler
    public Resolution view() {
        this.checks.add(new UpgradeCheck("PDOK WMS", "https://geodata.nationaalgeoregister.nl/inspire/au/wms?&request=GetCapabilities&service=WMS"));
        this.checks.add(new UpgradeCheck("Openbasiskaart", "https://openbasiskaart.nl/mapcache/wmts/?SERVICE=WMTS&REQUEST=GetCapabilities&VERSION=1.0.0"));
        this.checks.add(new UpgradeCheck("Some Geoserver", "https://flamingo5.b3p.nl/geoserver/Test_omgeving/ows?service=wms&version=1.1.1&request=GetCapabilities"));
        Object selfUrl = this.context.getRequest().getRequestURL().toString();
        selfUrl = (String)selfUrl + "ping";
        this.checks.add(new UpgradeCheck("Zichzelf aanroepen", (String)selfUrl));
        this.runtests();
        return new ForwardResolution(JSP);
    }

    public Resolution ping() {
        return new StreamingResolution("application/json", "{success:true}");
    }

    private void runtests() {
        for (UpgradeCheck check : this.checks) {
            this.runTest(check);
        }
    }

    private void runTest(UpgradeCheck check) {
        try {
            String url = check.getUrl();
            URL u = new URL(url);
            URLConnection con = u.openConnection();
            con.connect();
            Object obj = con.getContent();
            check.setSuccess(Boolean.valueOf(true));
        }
        catch (MalformedURLException ex) {
            check.setSuccess(Boolean.valueOf(false));
            check.setLog("URL malformed: " + ex.getLocalizedMessage());
            check.setRemedy("URL goedzetten.");
        }
        catch (SSLException ex) {
            check.setSuccess(Boolean.valueOf(false));
            check.setLog("Cerficaat problemen: " + ex.getLocalizedMessage());
            check.setRemedy("Is het certificaat wel toegevoegd aan java keystore?");
        }
        catch (IOException ex) {
            check.setSuccess(Boolean.valueOf(false));
            check.setLog("Error connecting: " + ex.getLocalizedMessage());
        }
    }
}

