/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.admin.stripes;

import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.tailormap.i18n.LocalizableActionBean;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.security.Group;
import org.stripesstuff.plugin.session.Session;
import org.stripesstuff.stripersist.Stripersist;

@StrictBinding
@RolesAllowed(value={"Admin", "ApplicationAdmin"})
public abstract class ApplicationActionBean
extends LocalizableActionBean {
    protected ActionBeanContext context;
    @Validate
    protected Application application;
    @Session(key="applicationId")
    protected Long applicationId;
    @Session(key="applicationName")
    private String applicationName;
    protected List<Group> allGroups;

    public void setContext(ActionBeanContext abc) {
        this.context = abc;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public Application getApplication() {
        return this.application;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public List<Group> getAllGroups() {
        return this.allGroups;
    }

    public void setAllGroups(List<Group> allGroups) {
        this.allGroups = allGroups;
    }

    public void setApplication(Application application) {
        this.application = application;
        if (application != null) {
            this.applicationId = application.getId();
            this.applicationName = application.getName();
            if (application.getVersion() != null) {
                this.applicationName = this.applicationName + " v" + application.getVersion();
            }
        } else {
            this.applicationId = null;
            this.applicationName = null;
        }
    }

    @After(stages={LifecycleStage.BindingAndValidation})
    public void initApplication() {
        EntityManager em = Stripersist.getEntityManager();
        if (this.applicationId != null && this.applicationId != -1L) {
            this.application = (Application)em.find(Application.class, (Object)this.applicationId);
            this.setApplication(this.application);
        }
        this.allGroups = em.createQuery("from Group", Group.class).getResultList();
    }
}

