/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.admin.stripes;

import javax.annotation.security.RolesAllowed;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.tailormap.viewer.admin.stripes.ApplicationActionBean;
import nl.tailormap.viewer.config.ClobElement;
import org.apache.commons.lang3.StringUtils;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/applicationdetail")
@StrictBinding
@RolesAllowed(value={"Admin", "ApplicationAdmin"})
public class ApplicationDetailActionBean
extends ApplicationActionBean {
    @Validate(required=true)
    private String key;
    @Validate
    private String value;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @DefaultHandler
    public Resolution handle() {
        if (this.application == null) {
            return new ErrorResolution(404, "Application #" + this.applicationId + " not found");
        }
        String method = this.getContext().getRequest().getMethod();
        if ("GET".equals(method)) {
            ClobElement detail = (ClobElement)this.application.getDetails().get(this.key);
            return new StreamingResolution("application/octet-stream", detail == null ? "" : detail.getValue());
        }
        if ("POST".equals(method)) {
            if (StringUtils.isBlank((CharSequence)this.value)) {
                this.application.getDetails().remove(this.key);
            } else {
                this.application.getDetails().put(this.key, new ClobElement(this.value));
            }
            Stripersist.getEntityManager().persist((Object)this.application);
            Stripersist.getEntityManager().getTransaction().commit();
            return new ErrorResolution(200, "OK");
        }
        return new ErrorResolution(400, "Bad Request");
    }
}

