/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.admin.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import nl.tailormap.viewer.admin.stripes.ApplicationActionBean;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.Level;
import nl.tailormap.viewer.config.app.StartLayer;
import nl.tailormap.viewer.config.app.StartLevel;
import nl.tailormap.web.stripes.ErrorMessageResolution;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

/*
 * Exception performing whole class analysis ignored.
 */
@UrlBinding(value="/action/applicationstartmap/{$event}")
@StrictBinding
@RolesAllowed(value={"Admin", "ApplicationAdmin"})
public class ApplicationStartMapActionBean
extends ApplicationActionBean {
    private static final String JSP = "/WEB-INF/jsp/application/applicationStartMap.jsp";
    @Validate
    private String selectedContent;
    private JSONArray jsonContent;
    @Validate
    private String contentToBeSelected;
    @Validate
    private String checkedLayersString;
    private JSONArray jsonCheckedLayers;
    private JSONArray allCheckedLayers = new JSONArray();
    @Validate
    private String readdedLayersString;
    private JSONArray readdedLayers;
    @Validate
    private String nodeId;
    @Validate
    private String levelId;
    private Level rootlevel;
    @Validate
    private String removedRecordsString = new String();
    private Set<Long> levelsToBeRemoved = new HashSet();
    private Set<Long> layersToBeRemoved = new HashSet();

    @DefaultHandler
    @DontValidate
    public Resolution view() throws JSONException {
        if (this.application == null) {
            this.getContext().getMessages().add(new SimpleError(this.getBundle().getString("viewer_admin.applicationstartmapactionbean.actfirst"), new Object[0]));
            return new ForwardResolution("/WEB-INF/jsp/application/chooseApplication.jsp");
        }
        this.rootlevel = this.application.getRoot();
        ApplicationStartMapActionBean.getCheckedLayerList((JSONArray)this.allCheckedLayers, (Level)this.rootlevel, (Application)this.application);
        return new ForwardResolution("/WEB-INF/jsp/application/applicationStartMap.jsp");
    }

    public Resolution save() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        this.saveStartMap(em);
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.applicationstartmapactionbean.skbsaved"), new Object[0]));
        ApplicationStartMapActionBean.getCheckedLayerList((JSONArray)this.allCheckedLayers, (Level)this.rootlevel, (Application)this.application);
        return new ForwardResolution("/WEB-INF/jsp/application/applicationStartMap.jsp");
    }

    protected void saveStartMap(EntityManager em) {
        this.rootlevel = this.application.getRoot();
        this.jsonContent = new JSONArray(this.selectedContent);
        this.jsonCheckedLayers = new JSONArray(this.checkedLayersString);
        this.readdedLayers = new JSONArray(this.readdedLayersString);
        JSONArray objToRemove = new JSONArray();
        if (this.removedRecordsString != null) {
            objToRemove = new JSONArray(this.removedRecordsString);
        }
        for (Object obj : objToRemove) {
            JSONObject o = (JSONObject)obj;
            String type = o.getString("type");
            if (type.equals("layer")) {
                this.layersToBeRemoved.add(o.getLong("id"));
                continue;
            }
            if (!type.equals("level")) continue;
            this.levelsToBeRemoved.add(o.getLong("id"));
        }
        this.walkAppTreeForSave(this.rootlevel, em, false);
        em.getTransaction().commit();
    }

    public Resolution canContentBeSelected() {
        try {
            this.jsonContent = new JSONArray(this.selectedContent);
            if (this.jsonContent.length() == 0) {
                JSONObject obj = new JSONObject();
                obj.put("result", true);
                return new StreamingResolution("application/json", (Reader)new StringReader(obj.toString()));
            }
            JSONObject o = new JSONObject(this.contentToBeSelected);
            Boolean result = true;
            String message = null;
            String id = o.getString("id");
            if (!o.get("type").equals("layer")) {
                Level level = (Level)Stripersist.getEntityManager().find(Level.class, (Object)Long.valueOf(id));
                if (level == null) {
                    result = false;
                    message = MessageFormat.format(this.getBundle().getString("viewer_admin.applicationstartmapactionbean.unknown"), id);
                } else if (!level.hasLayerInSubtree()) {
                    message = this.getBundle().getString("viewer_admin.applicationstartmapactionbean.nomap");
                    result = false;
                } else {
                    for (int i = 0; i < this.jsonContent.length(); ++i) {
                        JSONObject content = this.jsonContent.getJSONObject(i);
                        if (content.getString("type").equals("level")) {
                            if (id.equals(content.getString("id"))) {
                                result = false;
                                message = this.getBundle().getString("viewer_admin.applicationstartmapactionbean.alreadyselected0");
                                break;
                            }
                            Level l = (Level)Stripersist.getEntityManager().find(Level.class, (Object)Long.valueOf(content.getString("id")));
                            if (l == null || !l.isInSubtreeOf(level)) continue;
                            result = false;
                            message = this.getBundle().getString("viewer_admin.applicationstartmapactionbean.alreadyselected1");
                            break;
                        }
                        ApplicationLayer appLayer = (ApplicationLayer)Stripersist.getEntityManager().find(ApplicationLayer.class, (Object)Long.valueOf(content.getString("id")));
                        if (!level.containsLayerInSubtree(appLayer)) continue;
                        result = false;
                        message = this.getBundle().getString("viewer_admin.applicationstartmapactionbean.alreadyselected2");
                        break;
                    }
                }
            }
            JSONObject obj = new JSONObject();
            obj.put("result", (Object)result);
            obj.put("message", message);
            return new StreamingResolution("application/json", (Reader)new StringReader(obj.toString()));
        }
        catch (NumberFormatException | JSONException e) {
            return new ErrorMessageResolution("Exception " + e.getClass() + ": " + e.getMessage());
        }
    }

    protected void walkAppTreeForSave(Level l, EntityManager em, boolean unremove) throws JSONException {
        if (this.shouldBeRemoved((Object)l)) {
            this.removeStartLevel(l, em);
        } else {
            boolean unremoveChilds;
            boolean wasNew = false;
            StartLevel sl = (StartLevel)l.getStartLevels().get(this.application);
            if (sl == null) {
                wasNew = true;
                sl = new StartLevel();
                sl.setApplication(this.application);
                sl.setLevel(l);
                l.getStartLevels().put(this.application, sl);
            }
            sl.setSelectedIndex(this.getSelectedContentIndex(l));
            boolean bl = unremoveChilds = sl.isRemoved() && sl.getSelectedIndex() != null || unremove;
            if (unremoveChilds) {
                sl.setRemoved(false);
            }
            for (ApplicationLayer al : l.getLayers()) {
                StartLayer startLayer = (StartLayer)al.getStartLayers().get(this.application);
                if (this.shouldBeRemoved((Object)al)) {
                    if (startLayer == null) {
                        startLayer = new StartLayer();
                        startLayer.setApplication(this.application);
                        startLayer.setApplicationLayer(al);
                        startLayer.setRemoved(true);
                        al.getStartLayers().put(this.application, startLayer);
                        continue;
                    }
                    startLayer.setRemoved(true);
                    continue;
                }
                if (!wasNew && !unremoveChilds && startLayer == null && !this.layerExistsInJSONArray(al)) continue;
                if (startLayer == null) {
                    startLayer = new StartLayer();
                    startLayer.setApplication(this.application);
                    startLayer.setApplicationLayer(al);
                    al.getStartLayers().put(this.application, startLayer);
                }
                startLayer.setSelectedIndex(this.getSelectedContentIndex(al));
                startLayer.setChecked(this.getCheckedForLayerId(al.getId()));
                if (!unremoveChilds && startLayer.getSelectedIndex() == null) continue;
                startLayer.setRemoved(false);
            }
            for (Level child : l.getChildren()) {
                this.walkAppTreeForSave(child, em, unremoveChilds);
            }
        }
    }

    private boolean shouldBeRemoved(Object l) {
        if (l instanceof Level) {
            Level level = (Level)l;
            return this.levelsToBeRemoved.contains(level.getId());
        }
        if (l instanceof ApplicationLayer) {
            ApplicationLayer al = (ApplicationLayer)l;
            return this.layersToBeRemoved.contains(al.getId());
        }
        return false;
    }

    private boolean getCheckedForLayerId(Long levelid) throws JSONException {
        for (int i = 0; i < this.jsonCheckedLayers.length(); ++i) {
            if (!levelid.equals(this.jsonCheckedLayers.getInt(i))) continue;
            return true;
        }
        return false;
    }

    private Integer getSelectedContentIndex(Level l) throws JSONException {
        Integer index = null;
        for (int i = 0; i < this.jsonContent.length(); ++i) {
            JSONObject js = this.jsonContent.getJSONObject(i);
            String id = js.get("id").toString();
            String type = js.get("type").toString();
            if (!id.equals(l.getId().toString()) || !type.equals("level")) continue;
            index = i;
        }
        return index;
    }

    private Integer getSelectedContentIndex(ApplicationLayer al) throws JSONException {
        Integer index = null;
        for (int i = 0; i < this.jsonContent.length(); ++i) {
            JSONObject js = this.jsonContent.getJSONObject(i);
            String id = js.get("id").toString();
            String type = js.get("type").toString();
            if (!id.equals(al.getId().toString()) || !type.equals("layer")) continue;
            index = i;
        }
        return index;
    }

    public Resolution loadApplicationTree() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        JSONArray children = new JSONArray();
        if (!this.nodeId.equals("n")) {
            String type = this.nodeId.substring(0, 1);
            int id = Integer.parseInt(this.nodeId.substring(1));
            if (type.equals("n")) {
                JSONObject j;
                Level l = (Level)em.find(Level.class, (Object)id);
                List levels = l.getChildren();
                Collections.sort(levels);
                for (Level sub : levels) {
                    j = new JSONObject();
                    j.put("id", (Object)("n" + sub.getId()));
                    j.put("name", (Object)sub.getName());
                    j.put("type", (Object)"level");
                    j.put("isLeaf", sub.getChildren().isEmpty() && sub.getLayers().isEmpty());
                    if (sub.getParent() != null) {
                        j.put("parentid", (Object)sub.getParent().getId());
                    }
                    children.put((Object)j);
                }
                for (ApplicationLayer layer : l.getLayers()) {
                    j = new JSONObject();
                    j.put("id", (Object)("s" + layer.getId()));
                    j.put("name", (Object)layer.getDisplayName(em));
                    j.put("type", (Object)"layer");
                    j.put("isLeaf", true);
                    j.put("parentid", (Object)this.nodeId);
                    children.put((Object)j);
                }
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution loadSelectedLayers() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        JSONArray children = this.loadSelectedLayers(em);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected JSONArray loadSelectedLayers(EntityManager em) {
        JSONArray children;
        block9: {
            block8: {
                children = new JSONArray();
                this.rootlevel = this.application.getRoot();
                this.readdedLayers = new JSONArray(this.readdedLayersString);
                if (this.levelId == null || !this.levelId.substring(1).equals(this.rootlevel.getId().toString())) break block8;
                ArrayList selectedObjects = new ArrayList();
                ApplicationStartMapActionBean.walkAppTreeForStartMap(selectedObjects, (Level)this.rootlevel, (Application)this.application);
                Collections.sort(selectedObjects, (lhs, rhs) -> {
                    Integer lhsIndex = lhs instanceof StartLevel ? ((StartLevel)lhs).getSelectedIndex() : ((StartLayer)lhs).getSelectedIndex();
                    Integer rhsIndex = rhs instanceof StartLevel ? ((StartLevel)rhs).getSelectedIndex() : ((StartLayer)rhs).getSelectedIndex();
                    return lhsIndex.compareTo(rhsIndex);
                });
                if (selectedObjects == null) break block9;
                for (Object map : selectedObjects) {
                    if (map instanceof StartLayer) {
                        StartLayer startLayer = (StartLayer)map;
                        ApplicationLayer layer = startLayer.getApplicationLayer();
                        JSONObject j = new JSONObject();
                        j.put("id", (Object)("s" + layer.getId()));
                        j.put("name", (Object)layer.getDisplayName(em));
                        j.put("type", (Object)"layer");
                        j.put("isLeaf", true);
                        j.put("parentid", (Object)"");
                        j.put("checked", startLayer.isChecked());
                        children.put((Object)j);
                        continue;
                    }
                    if (!(map instanceof StartLevel)) continue;
                    StartLevel startLevel = (StartLevel)map;
                    Level level = startLevel.getLevel();
                    JSONArray checked = new JSONArray();
                    ApplicationStartMapActionBean.getCheckedLayerList((JSONArray)checked, (Level)level, (Application)this.application);
                    JSONObject j = new JSONObject();
                    j.put("id", (Object)("n" + level.getId()));
                    j.put("name", (Object)startLevel.getLevel().getName());
                    j.put("type", (Object)"level");
                    j.put("isLeaf", level.getChildren().isEmpty() && level.getLayers().isEmpty());
                    j.put("parentid", (Object)"");
                    j.put("checkedlayers", (Object)checked);
                    children.put((Object)j);
                }
                break block9;
            }
            assert (this.levelId != null);
            String type = this.levelId.substring(0, 1);
            int id = Integer.parseInt(this.levelId.substring(1));
            if (type.equals("n")) {
                JSONObject j;
                Level l = (Level)em.find(Level.class, (Object)id);
                for (Level sub : l.getChildren()) {
                    StartLevel sl = (StartLevel)sub.getStartLevels().get(this.application);
                    if (sl == null && l.getStartLevels().containsKey(this.application) || sl != null && sl.isRemoved()) continue;
                    j = new JSONObject();
                    j.put("id", (Object)("n" + sub.getId()));
                    j.put("name", (Object)sub.getName());
                    j.put("type", (Object)"level");
                    j.put("isLeaf", sub.getChildren().isEmpty() && sub.getLayers().isEmpty());
                    if (sub.getParent() != null) {
                        j.put("parentid", (Object)sub.getParent().getId());
                    }
                    children.put((Object)j);
                }
                for (ApplicationLayer layer : l.getLayers()) {
                    StartLayer startLayer = (StartLayer)layer.getStartLayers().get(this.application);
                    if (startLayer != null) {
                        if (startLayer.isRemoved()) continue;
                        j = new JSONObject();
                        j.put("id", (Object)("s" + layer.getId()));
                        j.put("name", (Object)layer.getDisplayName(em));
                        j.put("type", (Object)"layer");
                        j.put("isLeaf", true);
                        j.put("parentid", (Object)this.levelId);
                        j.put("checked", startLayer.isChecked());
                        children.put((Object)j);
                        continue;
                    }
                    if (!this.layerExistsInJSONArray(layer)) continue;
                    j = new JSONObject();
                    j.put("id", (Object)("s" + layer.getId()));
                    j.put("name", (Object)layer.getDisplayName(em));
                    j.put("type", (Object)"layer");
                    j.put("isLeaf", true);
                    j.put("parentid", (Object)this.levelId);
                    j.put("checked", false);
                    children.put((Object)j);
                }
            }
        }
        return children;
    }

    private boolean layerExistsInJSONArray(ApplicationLayer layer) {
        for (Object l : this.readdedLayers) {
            JSONObject obj = (JSONObject)l;
            int id = obj.getInt("id");
            if (layer.getId() != (long)id) continue;
            return true;
        }
        return false;
    }

    protected static void walkAppTreeForStartMap(List<Object> selectedContent, Level l, Application app) {
        StartLevel sl = (StartLevel)l.getStartLevels().get(app);
        boolean selected = false;
        if (sl != null && sl.getSelectedIndex() != null && !sl.isRemoved()) {
            selected = true;
            selectedContent.add(sl);
        }
        if (!selected) {
            for (ApplicationLayer al : l.getLayers()) {
                StartLayer startLayer = (StartLayer)al.getStartLayers().get(app);
                if (startLayer == null || startLayer.getSelectedIndex() == null || startLayer.isRemoved()) continue;
                selectedContent.add(startLayer);
            }
        }
        if (!selected) {
            for (Level child : l.getChildren()) {
                ApplicationStartMapActionBean.walkAppTreeForStartMap(selectedContent, (Level)child, (Application)app);
            }
        }
    }

    private static void getCheckedLayerList(JSONArray layers, Level l, Application app) throws JSONException {
        for (ApplicationLayer al : l.getLayers()) {
            StartLayer startLayer = (StartLayer)al.getStartLayers().get(app);
            if (startLayer == null || !startLayer.isChecked()) continue;
            layers.put((Object)al.getId());
        }
        for (Level child : l.getChildren()) {
            ApplicationStartMapActionBean.getCheckedLayerList((JSONArray)layers, (Level)child, (Application)app);
        }
    }

    protected void removeStartLevel(Level l, EntityManager em) {
        StartLevel sl = (StartLevel)l.getStartLevels().get(this.application);
        if (sl != null) {
            List als = l.getLayers();
            for (ApplicationLayer al : als) {
                StartLayer startLayer = (StartLayer)al.getStartLayers().get(this.application);
                if (startLayer == null) continue;
                startLayer.setRemoved(true);
            }
            sl.setRemoved(true);
            List children = l.getChildren();
            for (Level child : children) {
                this.removeStartLevel(child, em);
            }
        }
    }

    public String getCheckedLayersString() {
        return this.checkedLayersString;
    }

    public void setCheckedLayersString(String checkedLayersString) {
        this.checkedLayersString = checkedLayersString;
    }

    public String getSelectedContent() {
        return this.selectedContent;
    }

    public void setSelectedContent(String selectedContent) {
        this.selectedContent = selectedContent;
    }

    public Level getRootlevel() {
        return this.rootlevel;
    }

    public void setRootlevel(Level rootlevel) {
        this.rootlevel = rootlevel;
    }

    public String getLevelId() {
        return this.levelId;
    }

    public void setLevelId(String levelId) {
        this.levelId = levelId;
    }

    public JSONArray getAllCheckedLayers() {
        return this.allCheckedLayers;
    }

    public void setAllCheckedLayers(JSONArray allCheckedLayers) {
        this.allCheckedLayers = allCheckedLayers;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getContentToBeSelected() {
        return this.contentToBeSelected;
    }

    public void setContentToBeSelected(String contentToBeSelected) {
        this.contentToBeSelected = contentToBeSelected;
    }

    public String getRemovedRecordsString() {
        return this.removedRecordsString;
    }

    public void setRemovedRecordsString(String removedRecordsString) {
        this.removedRecordsString = removedRecordsString;
    }

    public String getReaddedLayersString() {
        return this.readdedLayersString;
    }

    public void setReaddedLayersString(String readdedLayersString) {
        this.readdedLayersString = readdedLayersString;
    }
}

